/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.internal.IlvLineSegment;
import ilog.views.graphic.composite.internal.IlvPolyPoints;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class IlvPolyline2D
extends IlvPolyPoints
implements Shape,
Cloneable {
    protected IlvPoint _from;
    protected IlvPoint _to;
    static final long serialVersionUID = 2064567278333172392L;

    public IlvPoint getFrom() {
        return this._from;
    }

    public IlvPoint getTo() {
        return this._to;
    }

    public IlvPolyline2D(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        this._from = ilvPoint;
        this._to = ilvPoint2;
    }

    public void setNumberOfSegments(int n2) {
        if (n2 == 0 && !this._from.equals(this._to)) {
            throw new Error("start and end point of an IlvPolyline2D are different");
        }
        if (n2 == this._numsegments && this._points != null) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                this._segments[n3] = null;
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                this._points[n3] = null;
            }
        } else {
            this._segments = new IlvLineSegment[n2];
            this._points = new IlvPoint[n2 + 1];
            this._numsegments = n2;
        }
        if (n2 == 0) {
            this._points[0] = this._from;
        }
    }

    public void setSegment(int n2, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        IlvLineSegment ilvLineSegment;
        this._segments[n2] = ilvLineSegment = new IlvLineSegment(ilvPoint, ilvPoint2);
        if (!(n2 != 0 ? this._segments[n2 - 1] == null || ilvPoint == this._segments[n2 - 1].getTo() : ilvPoint == this._from)) {
            throw new Error("starting point of new segment not the same as last point");
        }
        if (!(n2 != this._numsegments - 1 ? this._segments[n2 + 1] == null || ilvPoint2 == this._segments[n2 + 1].getFrom() : ilvPoint2 == this._to)) {
            throw new Error("end point of new segment not the same as next point");
        }
        this._points[n2] = ilvPoint;
        this._points[n2 + 1] = ilvPoint2;
    }

    public Object clone() {
        return new IlvPolyline2D(this._points, false);
    }

    public IlvPolyline2D(IlvPolyline2D ilvPolyline2D) {
        this(ilvPolyline2D._points, false);
    }

    public IlvPolyline2D(IlvPoint[] ilvPointArray, boolean bl) {
        int n2 = ilvPointArray.length;
        this._from = ilvPointArray[0];
        this._to = ilvPointArray[n2 - 1];
        this.setNumberOfSegments(n2 - 1);
        for (int i2 = 0; i2 < this._numsegments; ++i2) {
            this._segments[i2] = new IlvLineSegment(ilvPointArray[i2], ilvPointArray[i2 + 1]);
        }
        System.arraycopy(ilvPointArray, 0, this._points, 0, n2);
        if (bl) {
            this.removeRedundantPoints();
        }
    }

    public IlvPolyline2D(IlvPoint[] ilvPointArray) {
        this(ilvPointArray, true);
    }

    public int getNumberOfSegments() {
        return super.getNumberOfSegments();
    }

    public IlvLineSegment getSegment(int n2) {
        return super.getSegment(n2);
    }

    public IlvLineSegment[] getSegments() {
        return super.getSegments();
    }

    public int getNumberOfPoints() {
        return this._numsegments + 1;
    }

    public IlvPoint getPoint(int n2) {
        return super.getPoint(n2);
    }

    public IlvPoint[] getPoints() {
        return super.getPoints();
    }

    public int getClosestSegment(IlvPoint ilvPoint) {
        return super.getClosestSegment(ilvPoint);
    }

    public Rectangle getBounds() {
        return super.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return super.getBounds2D();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2;
        byte by = objectInputStream.readByte();
        if (by == 1) {
            int n3;
            n2 = this._points.length;
            this._numsegments = n3 = n2 - 1;
            if (n3 > 0) {
                this._segments = new IlvLineSegment[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this._segments[i2] = new IlvLineSegment(this._points[i2], this._points[i2 + 1]);
                }
            }
        } else {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
        this._from = this._points[0];
        this._to = this._points[n2 - 1];
    }

    public boolean contains(double d2, double d3) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        double d6 = d2 + d4;
        double d7 = d3 + d5;
        for (int i2 = 0; i2 < this._numsegments; ++i2) {
            if (!this._segments[i2].intersects(d2, d3, d6, d7)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int a = 0;

            public int currentSegment(double[] dArray) {
                dArray[0] = IlvPolyline2D.this._points[this.a].x;
                dArray[1] = IlvPolyline2D.this._points[this.a].x;
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                return this.a == 0 ? 0 : 1;
            }

            public int currentSegment(float[] fArray) {
                fArray[0] = IlvPolyline2D.this._points[this.a].x;
                fArray[1] = IlvPolyline2D.this._points[this.a].x;
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 1);
                }
                return this.a == 0 ? 0 : 1;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.a >= IlvPolyline2D.this._numsegments;
            }

            public void next() {
                ++this.a;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }

    public IlvPolyPoints.PointAndDirection getMedian() {
        return this.getMedian(1.0E-6f);
    }

    protected IlvPolyPoints.PointAndDirection getMedian(float f2) {
        int n2;
        int n3 = this._numsegments;
        if (n3 == 0) {
            return new IlvPolyPoints.PointAndDirection(this._from, 224, Float.NaN);
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n3; ++i2) {
            f3 += this._segments[i2].length();
        }
        if (f2 > 0.0f && n3 > 1) {
            float f4 = f3 * f2;
            boolean bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!(this._segments[n2].length() < f4)) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n4;
                boolean[] blArray = new boolean[n3 + 1];
                for (n4 = 1; n4 < n3 - 1; ++n4) {
                    if (!(this._segments[n4].length() < f4) || !this._segments[n4 - 1].isParallelVectorTo(this._segments[n4 + 1]) || blArray[n4] || blArray[n4 + 1]) continue;
                    blArray[n4 + 1] = true;
                    blArray[n4] = true;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    if (!(this._segments[n4].length() < f4)) continue;
                    if (n4 == 0) {
                        blArray[1] = true;
                        continue;
                    }
                    if (n4 == n3 - 1) {
                        blArray[n3 - 1] = true;
                        continue;
                    }
                    if (blArray[n4] || blArray[n4 + 1]) continue;
                    blArray[n4] = true;
                }
                n4 = n3 + 1;
                for (int i3 = 0; i3 <= n3; ++i3) {
                    if (!blArray[i3]) continue;
                    --n4;
                }
                IlvPoint[] ilvPointArray = new IlvPoint[n4];
                int n5 = 0;
                for (int i4 = 0; i4 <= n3; ++i4) {
                    if (blArray[i4]) continue;
                    ilvPointArray[n5++] = this._points[i4];
                }
                IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(ilvPointArray, true);
                return ilvPolyline2D.getMedian(0.0f);
            }
        }
        float f5 = f3 * 0.5f;
        float f6 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!((f6 += this._segments[n2].length()) >= f5)) continue;
            IlvLineSegment ilvLineSegment = this._segments[n2];
            float f7 = f6 - this._segments[n2].length() * 0.5f;
            if (f5 >= f7) {
                if (n2 + 1 < n3 && f5 > f7 + (this._segments[n2].length() + this._segments[n2 + 1].length()) * 0.25f) {
                    ilvLineSegment = this._segments[n2 + 1];
                }
            } else if (n2 > 0 && f5 < f7 - (this._segments[n2].length() + this._segments[n2 - 1].length()) * 0.25f) {
                ilvLineSegment = this._segments[n2 - 1];
            }
            IlvPoint ilvPoint = ilvLineSegment.getFrom();
            IlvPoint ilvPoint2 = ilvLineSegment.getTo();
            return new IlvPolyPoints.PointAndDirection(new IlvPoint((ilvPoint.x + ilvPoint2.x) * 0.5f, (ilvPoint.y + ilvPoint2.y) * 0.5f), ilvLineSegment.getOrientation(), (ilvPoint.y - ilvPoint2.y) / (ilvPoint.x - ilvPoint2.x));
        }
        return null;
    }

    public IlvPolyline2D computeParallel(float f2) {
        float f3;
        int n2;
        if (f2 == 0.0f) {
            return this;
        }
        int n3 = this._numsegments;
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            ilvLineSegmentArray[n4] = this._segments[n2];
            if (ilvLineSegmentArray[n4].getFrom().equals(ilvLineSegmentArray[n4].getTo())) continue;
            ++n4;
        }
        n3 = n4;
        if (n3 == 0) {
            IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(this._from, this._to);
            ilvPolyline2D.setNumberOfSegments(0);
            return ilvPolyline2D;
        }
        float[] fArray = new float[2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            IlvPoint ilvPoint = ilvLineSegmentArray[n2].getFrom();
            IlvPoint ilvPoint2 = ilvLineSegmentArray[n2].getTo();
            fArray[2 * n2] = ilvPoint2.x - ilvPoint.x;
            fArray[2 * n2 + 1] = ilvPoint2.y - ilvPoint.y;
        }
        float[] fArray2 = new float[2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            float f4 = fArray[2 * i2];
            float f5 = fArray[2 * i2 + 1];
            if (f4 == 0.0f) {
                fArray2[2 * i2] = 0.0f;
                fArray2[2 * i2 + 1] = f5 > 0.0f ? 1.0f : (f5 < 0.0f ? -1.0f : 0.0f);
                continue;
            }
            if (f5 == 0.0f) {
                fArray2[2 * i2] = f4 > 0.0f ? 1.0f : (f4 < 0.0f ? -1.0f : 0.0f);
                fArray2[2 * i2 + 1] = 0.0f;
                continue;
            }
            f3 = 1.0f / (float)Math.sqrt(f4 * f4 + f5 * f5);
            fArray2[2 * i2] = f3 * f4;
            fArray2[2 * i2 + 1] = f3 * f5;
        }
        IlvPoint[] ilvPointArray = new IlvPoint[n3 + 1];
        int n5 = 0;
        IlvPoint ilvPoint = this._from;
        f3 = fArray2[0];
        float f6 = fArray2[1];
        ilvPointArray[0] = new IlvPoint(ilvPoint.x - f2 * f6, ilvPoint.y + f2 * f3);
        for (int i3 = 1; i3 < n3; ++i3) {
            IlvPoint ilvPoint3 = ilvLineSegmentArray[i3].getFrom();
            f6 = fArray2[2 * i3 - 2];
            float f7 = fArray2[2 * i3 - 1];
            float f8 = fArray2[2 * i3];
            float f9 = fArray2[2 * i3 + 1];
            float f10 = f6 + f8;
            float f11 = f7 + f9;
            if (f10 != 0.0f || f11 != 0.0f) {
                float f12 = 1.0f / (1.0f + f6 * f8 + f7 * f9);
                float f13 = f12 * f10;
                float f14 = f12 * f11;
                ilvPointArray[++n5] = new IlvPoint(ilvPoint3.x - f2 * f14, ilvPoint3.y + f2 * f13);
                continue;
            }
            ilvPointArray[n5++] = ilvPoint3;
        }
        IlvPoint ilvPoint4 = this._to;
        float f15 = fArray2[2 * n3 - 2];
        f6 = fArray2[2 * n3 - 1];
        ilvPointArray[++n5] = new IlvPoint(ilvPoint4.x - f2 * f6, ilvPoint4.y + f2 * f15);
        return new IlvPolyline2D(ilvPointArray);
    }

    public IlvPolyline2D computeParallel(float f2, boolean bl) {
        IlvPolyline2D ilvPolyline2D = this.computeParallel(f2);
        if (bl) {
            if (ilvPolyline2D == this) {
                ilvPolyline2D = (IlvPolyline2D)ilvPolyline2D.clone();
            }
            ilvPolyline2D.reverse();
        }
        return ilvPolyline2D;
    }

    public IlvPolyPoints.TwoPolylines computeThickLinkShape(float f2) {
        float f3;
        int n2;
        if (f2 == 0.0f) {
            return new IlvPolyPoints.TwoPolylines(this, this);
        }
        float f4 = f2 * 0.5f;
        int n3 = this._numsegments;
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            ilvLineSegmentArray[n4] = this._segments[n2];
            if (ilvLineSegmentArray[n4].getFrom().equals(ilvLineSegmentArray[n4].getTo())) continue;
            ++n4;
        }
        n3 = n4;
        if (n3 == 0) {
            IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(this._from, this._to);
            ilvPolyline2D.setNumberOfSegments(0);
            return new IlvPolyPoints.TwoPolylines(ilvPolyline2D, ilvPolyline2D);
        }
        float[] fArray = new float[2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            IlvPoint ilvPoint = ilvLineSegmentArray[n2].getFrom();
            IlvPoint ilvPoint2 = ilvLineSegmentArray[n2].getTo();
            fArray[2 * n2] = ilvPoint2.x - ilvPoint.x;
            fArray[2 * n2 + 1] = ilvPoint2.y - ilvPoint.y;
        }
        float[] fArray2 = new float[2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            float f5 = fArray[2 * i2];
            f3 = fArray[2 * i2 + 1];
            if (f5 == 0.0f) {
                fArray2[2 * i2] = 0.0f;
                fArray2[2 * i2 + 1] = f3 > 0.0f ? 1.0f : (f3 < 0.0f ? -1.0f : 0.0f);
                continue;
            }
            if (f3 == 0.0f) {
                fArray2[2 * i2] = f5 > 0.0f ? 1.0f : (f5 < 0.0f ? -1.0f : 0.0f);
                fArray2[2 * i2 + 1] = 0.0f;
                continue;
            }
            float f6 = 1.0f / (float)Math.sqrt(f5 * f5 + f3 * f3);
            fArray2[2 * i2] = f6 * f5;
            fArray2[2 * i2 + 1] = f6 * f3;
        }
        int[] nArray = new int[n3 + 1];
        nArray[0] = 0;
        for (int i3 = 1; i3 < n3; ++i3) {
            f3 = fArray[2 * i3 - 2] * fArray[2 * i3 + 1] - fArray[2 * i3 - 1] * fArray[2 * i3];
            nArray[i3] = f3 > 0.0f ? 1 : (f3 < 0.0f ? 2 : 0);
        }
        nArray[n3] = 0;
        IlvPoint[] ilvPointArray = new IlvPoint[n3 + 1];
        IlvPoint[] ilvPointArray2 = new IlvPoint[n3 + 1];
        int n5 = 0;
        int n6 = 0;
        IlvPoint ilvPoint = this._from;
        float f7 = fArray2[0];
        float f8 = fArray2[1];
        ilvPointArray[0] = new IlvPoint(ilvPoint.x - f4 * f8, ilvPoint.y + f4 * f7);
        ilvPointArray2[0] = new IlvPoint(ilvPoint.x + f4 * f8, ilvPoint.y - f4 * f7);
        for (int i4 = 1; i4 < n3; ++i4) {
            IlvPoint ilvPoint3 = ilvLineSegmentArray[i4].getFrom();
            f8 = fArray2[2 * i4 - 2];
            float f9 = fArray2[2 * i4 - 1];
            float f10 = fArray2[2 * i4];
            float f11 = fArray2[2 * i4 + 1];
            float f12 = f8 + f10;
            float f13 = f9 + f11;
            if (f12 != 0.0f || f13 != 0.0f) {
                float f14 = 1.0f / (1.0f + f8 * f10 + f9 * f11);
                float f15 = f14 * f12;
                float f16 = f14 * f13;
                ilvPointArray[++n5] = new IlvPoint(ilvPoint3.x - f4 * f16, ilvPoint3.y + f4 * f15);
                ilvPointArray2[++n6] = new IlvPoint(ilvPoint3.x + f4 * f16, ilvPoint3.y - f4 * f15);
                continue;
            }
            ilvPointArray[n5++] = ilvPoint3;
            ilvPointArray2[n6++] = ilvPoint3;
        }
        IlvPoint ilvPoint4 = this._to;
        f7 = fArray2[2 * n3 - 2];
        f8 = fArray2[2 * n3 - 1];
        ilvPointArray[++n5] = new IlvPoint(ilvPoint4.x - f4 * f8, ilvPoint4.y + f4 * f7);
        ilvPointArray2[++n6] = new IlvPoint(ilvPoint4.x + f4 * f8, ilvPoint4.y - f4 * f7);
        return new IlvPolyPoints.TwoPolylines(new IlvPolyline2D(ilvPointArray2), new IlvPolyline2D(ilvPointArray));
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null) {
            int n2;
            for (n2 = 0; n2 <= this._numsegments; ++n2) {
                IlvPoint ilvPoint = this._points[n2];
                ilvPoint = (IlvPoint)ilvPoint.clone();
                ilvTransformer.apply(ilvPoint);
                this._points[n2] = ilvPoint;
            }
            for (n2 = 0; n2 < this._numsegments; ++n2) {
                this._segments[n2] = new IlvLineSegment(this._points[n2], this._points[n2 + 1]);
            }
            this._from = this._points[0];
            this._to = this._points[this._numsegments];
        }
    }

    public void reverse() {
        int n2;
        for (n2 = this._numsegments - 1 >> 1; n2 >= 0; --n2) {
            IlvPoint ilvPoint = this._points[n2];
            this._points[n2] = this._points[this._numsegments - n2];
            this._points[this._numsegments - n2] = ilvPoint;
        }
        for (n2 = 0; n2 < this._numsegments; ++n2) {
            this._segments[n2] = new IlvLineSegment(this._points[n2], this._points[n2 + 1]);
        }
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    public void insertPoint(int n2, IlvPoint ilvPoint) {
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[this._numsegments + 1];
        IlvPoint[] ilvPointArray = new IlvPoint[this._numsegments + 2];
        System.arraycopy(this._points, 0, ilvPointArray, 0, n2 + 1);
        ilvPointArray[n2 + 1] = ilvPoint;
        System.arraycopy(this._points, n2 + 1, ilvPointArray, n2 + 2, this._numsegments - n2);
        if (n2 == -1) {
            ilvLineSegmentArray[0] = new IlvLineSegment(ilvPoint, ilvPointArray[1]);
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 1, this._numsegments);
        } else if (n2 == this._numsegments) {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, this._numsegments);
            ilvLineSegmentArray[this._numsegments] = new IlvLineSegment(ilvPointArray[this._numsegments], ilvPoint);
        } else {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n2);
            ilvLineSegmentArray[n2] = new IlvLineSegment(ilvPointArray[n2], ilvPoint);
            ilvLineSegmentArray[n2 + 1] = new IlvLineSegment(ilvPoint, ilvPointArray[n2 + 2]);
            System.arraycopy(this._segments, n2 + 1, ilvLineSegmentArray, n2 + 2, this._numsegments - n2 - 1);
        }
        this._segments = ilvLineSegmentArray;
        this._points = ilvPointArray;
        ++this._numsegments;
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    public void insertPoint(IlvPoint ilvPoint) {
        if (this._numsegments == 0) {
            IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[2];
            IlvPoint[] ilvPointArray = new IlvPoint[]{this._from, ilvPoint, this._to};
            ilvLineSegmentArray[0] = new IlvLineSegment(this._from, ilvPoint);
            ilvLineSegmentArray[1] = new IlvLineSegment(ilvPoint, this._to);
            this._segments = ilvLineSegmentArray;
            this._points = ilvPointArray;
            this._numsegments = 2;
        } else {
            int n2 = this.getClosestSegment(ilvPoint);
            this.insertPoint(n2, ilvPoint);
        }
    }

    public void movePoint(int n2, IlvPoint ilvPoint) {
        if (this._points != null) {
            this._points[n2] = ilvPoint;
        }
        if (n2 == 0) {
            this._from = ilvPoint;
        }
        if (n2 == this._numsegments) {
            this._to = ilvPoint;
        }
        if (this._segments != null) {
            if (n2 > 0) {
                this._segments[n2 - 1] = new IlvLineSegment(this._points[n2 - 1], ilvPoint);
            }
            if (n2 < this._numsegments) {
                this._segments[n2] = new IlvLineSegment(ilvPoint, this._points[n2 + 1]);
            }
        }
    }

    public void removePoint(int n2) {
        if (n2 < 0 || n2 > this._numsegments) {
            throw new Error("IlvPolyline2D.removePoint index out of range");
        }
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[this._numsegments - 1];
        IlvPoint[] ilvPointArray = new IlvPoint[this._numsegments];
        if (n2 > 0) {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n2 - 1);
            System.arraycopy(this._points, 0, ilvPointArray, 0, n2);
            if (n2 < this._numsegments) {
                ilvLineSegmentArray[n2 - 1] = new IlvLineSegment(this._points[n2 - 1], this._points[n2 + 1]);
            }
        }
        if (n2 < this._numsegments) {
            System.arraycopy(this._segments, n2 + 1, ilvLineSegmentArray, n2, this._numsegments - n2 - 1);
            System.arraycopy(this._points, n2 + 1, ilvPointArray, n2, this._numsegments - n2);
        }
        this._segments = ilvLineSegmentArray;
        this._points = ilvPointArray;
        --this._numsegments;
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    public void removeRedundantPoints() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 < this._numsegments && IlvPolyPoints.a(this._points[n2], this._points[n3], this._points[n3 + 1])) {
                ++n3;
                continue;
            }
            if (n3 - n2 == 0) break;
            if (n3 - n2 == 1) {
                if (n4 < n2) {
                    this._points[n4 + 1] = this._points[n3];
                    this._segments[n4] = this._segments[n2];
                }
            } else {
                this._points[n4 + 1] = this._points[n3];
                this._segments[n4] = new IlvLineSegment(this._points[n4], this._points[n4 + 1]);
            }
            n2 = n3;
            ++n4;
        }
        if (n4 < this._numsegments) {
            IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n4];
            IlvPoint[] ilvPointArray = new IlvPoint[n4 + 1];
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n4);
            System.arraycopy(this._points, 0, ilvPointArray, 0, n4 + 1);
            this._segments = ilvLineSegmentArray;
            this._points = ilvPointArray;
            this._numsegments = n4;
        }
    }

    public void adjustForFromArrow(float f2, float f3) {
        IlvPoint[] ilvPointArray = this.adjustForArrow(new IlvLineSegment(this.getSegment(0).getTo(), this.getSegment(0).getFrom()), f2, f3);
        if (ilvPointArray.length == 2) {
            if (this.getSegment(0).getTo() != this.getTo()) {
                this.movePoint(1, ilvPointArray[1]);
            } else {
                this.insertPoint(0, ilvPointArray[1]);
            }
        }
        this.insertPoint(0, ilvPointArray[0]);
    }

    public void adjustForToArrow(float f2, float f3) {
        IlvPoint[] ilvPointArray = this.adjustForArrow(this.getSegment(this.getNumberOfSegments() - 1), f2, f3);
        if (ilvPointArray.length == 2) {
            if (this.getSegment(this.getNumberOfSegments() - 1).getFrom() != this.getFrom()) {
                this.movePoint(this.getNumberOfPoints() - 2, ilvPointArray[1]);
            } else {
                this.insertPoint(this.getNumberOfSegments() - 1, ilvPointArray[1]);
            }
        }
        this.insertPoint(this.getNumberOfSegments() - 1, ilvPointArray[0]);
    }

    public IlvPoint[] adjustForArrow(IlvLineSegment ilvLineSegment, float f2, float f3) {
        float f4;
        IlvPoint[] ilvPointArray;
        float f5 = ilvLineSegment.length();
        int n2 = ilvLineSegment.getDirection();
        if ((double)f5 <= 1.0E-10 && n2 == 0) {
            n2 = 1;
        }
        if (f2 + f3 / 2.0f > f5) {
            ilvPointArray = new IlvPoint[2];
            if (n2 == 0) {
                f4 = (f2 + f3 / 2.0f) / f5;
                ilvPointArray[1] = new IlvPoint(ilvLineSegment.getTo().x + f4 * (ilvLineSegment.getTo().x - ilvLineSegment.getFrom().x), ilvLineSegment.getTo().y + f4 * (ilvLineSegment.getTo().y - ilvLineSegment.getFrom().y));
            } else {
                f4 = f2 + f3 / 2.0f;
                ilvPointArray[1] = new IlvPoint(ilvLineSegment.getTo().x + (n2 == 1 ? f4 : (n2 == 2 ? -f4 : 0.0f)), ilvLineSegment.getTo().y + (n2 == 4 ? f4 : (n2 == 8 ? -f4 : 0.0f)));
            }
        } else {
            ilvPointArray = new IlvPoint[1];
        }
        if (n2 == 0) {
            f4 = f2 / f5;
            ilvPointArray[0] = new IlvPoint(ilvLineSegment.getTo().x - f4 * (ilvLineSegment.getTo().x - ilvLineSegment.getFrom().x), ilvLineSegment.getTo().y - f4 * (ilvLineSegment.getTo().y - ilvLineSegment.getFrom().y));
        } else {
            ilvPointArray[0] = new IlvPoint(ilvLineSegment.getTo().x + (n2 == 1 ? f2 : (n2 == 2 ? -f2 : 0.0f)), ilvLineSegment.getTo().y + (n2 == 4 ? f2 : (n2 == 8 ? -f2 : 0.0f)));
        }
        return ilvPointArray;
    }
}

