/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.layout;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvChildSize;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class IlvAttachmentLayout
implements IlvLayoutManager {
    public static final String ANCHOR = "Anchor";
    private IlvAttachable a;
    private Map b = new LinkedHashMap();

    public IlvAttachmentLayout() {
    }

    public IlvAttachmentLayout(IlvInputStream ilvInputStream) throws IlvReadFileException {
    }

    public void setConstraints(IlvAttachable ilvAttachable, Object object) {
        if (object == null || object instanceof String) {
            this.a(ilvAttachable, (String)object);
        } else if (object instanceof IlvAttachmentConstraint) {
            this.a(ilvAttachable, (IlvAttachmentConstraint)object);
        } else {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
    }

    private void a(IlvAttachable ilvAttachable, String string) {
        if (string == null) {
            string = ANCHOR;
        }
        if (!ANCHOR.equals(string)) {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
        }
        this.a = ilvAttachable;
    }

    private void a(IlvAttachable ilvAttachable, IlvAttachmentConstraint ilvAttachmentConstraint) {
        this.b.put(ilvAttachable, ilvAttachmentConstraint);
    }

    public void removeConstraints(IlvAttachable ilvAttachable) {
        this.b.remove(ilvAttachable);
    }

    public void layoutGroup(IlvAttachable ilvAttachable) {
        if (this.getAnchor() == null) {
            return;
        }
        IlvRect ilvRect = this.getAnchor().getAttachmentBounds();
        for (Map.Entry entry : this.b.entrySet()) {
            IlvPoint ilvPoint;
            IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)entry.getValue();
            IlvAttachable ilvAttachable2 = (IlvAttachable)entry.getKey();
            if (ilvAttachable2 != this.a && ilvAttachmentConstraint.a() != 0.0) {
                ilvAttachable2.rotate(new IlvPoint(0.0f, 0.0f), -ilvAttachmentConstraint.a());
            }
            IlvRect ilvRect2 = ilvAttachable2.getAttachmentBounds();
            IlvChildSize ilvChildSize = ilvAttachmentConstraint.getChildSize();
            if (ilvChildSize != null) {
                ilvPoint = ilvChildSize.getSize(ilvRect, ilvRect2);
                ilvAttachable2.resize(ilvPoint);
            } else {
                ilvPoint = ilvAttachmentConstraint.getSize();
                if (ilvPoint != null && (ilvPoint.x > 0.0f || ilvPoint.y > 0.0f)) {
                    if (ilvPoint.x <= 0.0f) {
                        ilvPoint.x = ilvRect2.width;
                    } else {
                        float f2 = ilvPoint.x = ilvAttachmentConstraint.isRelativeSize() ? ilvRect.width * ilvPoint.x : ilvPoint.x;
                    }
                    ilvPoint.y = ilvPoint.y <= 0.0f ? ilvRect2.height : (ilvAttachmentConstraint.isRelativeSize() ? ilvRect.height * ilvPoint.y : ilvPoint.y);
                    ilvAttachable2.resize(ilvPoint);
                }
            }
            if (ilvAttachable2 == this.a) {
                ilvRect = this.getAnchor().getAttachmentBounds();
                continue;
            }
            ilvAttachmentConstraint.getHotSpot().setValue(ilvAttachable2, ilvAttachmentConstraint.compute(this.a, ilvRect));
            if (ilvAttachmentConstraint.getRotationAngle() != 0.0) {
                ilvRect2 = ilvAttachable2.getAttachmentBounds();
                ilvPoint = ilvAttachmentConstraint.getRotationCenter() == null ? (!ilvAttachmentConstraint.isRotationCenterRelativeToBase() ? new IlvPoint((float)ilvRect2.getCenterX(), (float)ilvRect2.getCenterY()) : new IlvPoint((float)ilvRect.getCenterX(), (float)ilvRect.getCenterY())) : ilvAttachmentConstraint.getRotationCenter().getValue(ilvAttachmentConstraint.isRotationCenterRelativeToBase() ? this.a : ilvAttachable2);
                ilvAttachable2.rotate(ilvPoint, ilvAttachmentConstraint.getRotationAngle());
            }
            ilvAttachmentConstraint.a(ilvAttachmentConstraint.getRotationAngle());
        }
    }

    public void attach(IlvAttachable ilvAttachable) {
        IlvAttachable[] ilvAttachableArray = ilvAttachable.getAttachables();
        Object[] objectArray = ilvAttachable.getConstraints();
        if (objectArray != null) {
            for (int i2 = 0; i2 < ilvAttachableArray.length && i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || ilvAttachableArray[i2] == null) continue;
                this.setConstraints(ilvAttachableArray[i2], objectArray[i2]);
            }
        }
        if (this.a == null) {
            this.a = ilvAttachableArray[0];
        }
    }

    public void setAnchor(IlvAttachable ilvAttachable) {
        this.a = ilvAttachable;
    }

    public IlvAttachable getAnchor() {
        return this.a;
    }

    public void reset() {
        this.b = new LinkedHashMap();
        this.a = null;
    }

    public Object clone() {
        try {
            IlvAttachmentLayout ilvAttachmentLayout = (IlvAttachmentLayout)super.clone();
            ilvAttachmentLayout.a = null;
            ilvAttachmentLayout.reset();
            return ilvAttachmentLayout;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    public boolean resizeFirstChildOnly() {
        return true;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
    }
}

