/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.circular;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.circular.ClusterLayoutAlgo;
import ilog.views.graphlayout.circular.IlvAbstractGraph;
import ilog.views.graphlayout.circular.IlvAbstractGraphicNode;
import ilog.views.graphlayout.circular.IlvCircularLayoutGrapherProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutNodeProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutOfSubTrees;
import ilog.views.graphlayout.circular.IlvClusterId;
import ilog.views.graphlayout.circular.IlvClusterIdCollection;
import ilog.views.graphlayout.circular.IlvClusterInfoProperty;
import ilog.views.graphlayout.circular.IlvClustersConnexion;
import ilog.views.graphlayout.circular.IlvGraphOfClusters;
import ilog.views.graphlayout.circular.IlvGrapherCluster;
import ilog.views.graphlayout.internalutil.IlvArrayStableSort;
import ilog.views.graphlayout.internalutil.IlvUnsyncVector;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IlvCircularLayout
extends IlvGraphLayout {
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;
    public static final int NO_INDEX = -1;
    public static final int BY_CLUSTER_IDS = 0;
    public static final int BY_SUBGRAPHS = 1;
    static final double a = 1.2566370614359172;
    private IlvGraphOfClusters b;
    private IlvUnsyncVector c;
    private IlvUnsyncVector d;
    private Hashtable e;
    private static final String f = "ClusterId";
    private static final String g = "StarCenter";
    private float h;
    private float i;
    static final float j = 10.0f;
    static final float k = 0.0f;
    static final float l = 10.0f;
    static final boolean m = false;
    static final int n = 1;
    static final int o = 0;
    static final int p = 200;
    private float q;
    private float r;
    private float s;
    private boolean t;
    private int u;
    private int v;
    private int w;
    private boolean x = false;
    private boolean y = false;
    static final int z = 9;
    private IlvArrayStableSort aa;
    private transient ClusterLayoutAlgo ab;
    private static final String ac = "No cluster found. You must provide clustering information.";

    public IlvCircularLayout() {
    }

    public IlvCircularLayout(IlvCircularLayout ilvCircularLayout) {
        super(ilvCircularLayout);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvCircularLayout) {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)ilvGraphLayout;
            this.setOffset(ilvCircularLayout.getOffset());
            this.setLevelOffset(ilvCircularLayout.getLevelOffset());
            this.setDisconnectedGraphOffset(ilvCircularLayout.getDisconnectedGraphOffset());
            this.setAreaMinimizationEnabled(ilvCircularLayout.isAreaMinimizationEnabled());
            this.setLinkStyle(ilvCircularLayout.getLinkStyle());
            this.setClusteringMode(ilvCircularLayout.getClusteringMode());
            this.setMaxNumberOfPermutations(ilvCircularLayout.getMaxNumberOfPermutations());
        }
    }

    protected void init() {
        super.init();
        this.q = 10.0f;
        this.r = 0.0f;
        this.s = 10.0f;
        this.t = false;
        this.u = 1;
        this.v = 0;
        this.w = 200;
        this.aa = new SortNodesByIndex();
    }

    public IlvGraphLayout copy() {
        return new IlvCircularLayout(this);
    }

    public synchronized void detach() {
        this.e();
        this.c(false);
        super.detach();
    }

    private void e() {
        this.e = null;
        this.f();
    }

    private void f() {
        if (this.ab != null) {
            this.ab.cleanData();
        }
        this.ab = null;
    }

    private void a(IlvRect ilvRect) {
        this.h = ilvRect.x + ilvRect.width * 0.5f;
        this.i = ilvRect.y + ilvRect.height * 0.5f;
    }

    private void g() {
        this.d = null;
        this.b = null;
        this.c = null;
    }

    protected void layout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        IlvRect ilvRect = this.getCalcLayoutRegion();
        this.a(ilvRect);
        if (this.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, false);
            this.clipAllLinks(true, bl);
        }
        switch (this.getClusteringMode()) {
            case 0: {
                this.a(ilvRect, bl);
                break;
            }
            case 1: {
                this.b(bl);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported clustering mode: " + this.getClusteringMode());
            }
        }
        ilvGraphLayoutReport.setCode(5);
    }

    private void b(boolean bl) throws IlvGraphLayoutException {
        this.ab = new ClusterLayoutAlgo(this);
        this.ab.layout(bl);
    }

    private void a(IlvRect ilvRect, boolean bl) throws IlvGraphLayoutException {
        this.c(false);
        if (!this.clusterize()) {
            throw new IlvGraphLayoutException(ac);
        }
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphOfClusters ilvGraphOfClusters = (IlvGraphOfClusters)this.c.elementAt(i2);
            this.a(ilvGraphOfClusters, bl);
            if (n2 <= 1) continue;
            ilvGraphOfClusters.i();
        }
        if (n2 > 1) {
            IlvCircularLayoutOfSubTrees ilvCircularLayoutOfSubTrees = new IlvCircularLayoutOfSubTrees(this.c, this, ilvRect);
            ilvCircularLayoutOfSubTrees.a(bl);
        }
        this.c(true);
    }

    private void a(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
            int n2 = this.getClusterIdsCount(ilvGraphic);
            if (n2 > 0) continue;
            IlvClusterInfoProperty ilvClusterInfoProperty = (IlvClusterInfoProperty)ilvGraphic.getNamedProperty("ClusterInfoPropertyName");
            this.a(ilvGraphic, ilvClusterInfoProperty);
        }
    }

    final void a(IlvGraphic ilvGraphic, IlvClusterInfoProperty ilvClusterInfoProperty) {
        if (ilvGraphic == null) {
            return;
        }
        if (ilvClusterInfoProperty == null) {
            return;
        }
        IlvClusterId[] ilvClusterIdArray = ilvClusterInfoProperty.getClusterIds();
        int[] nArray = ilvClusterInfoProperty.getIndexes();
        for (int i2 = 0; i2 < ilvClusterIdArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 >= 0) {
                this.addClusterId(ilvGraphic, ilvClusterIdArray[i2], n2);
                continue;
            }
            this.addClusterId(ilvGraphic, ilvClusterIdArray[i2]);
        }
        this.setStarCenter(ilvGraphic, ilvClusterInfoProperty.isStarCenter());
    }

    public synchronized void setRootClusterId(IlvClusterId ilvClusterId) {
        this.b(ilvClusterId);
    }

    private void b(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("clusterId cannot be null");
        }
        if (this.e == null) {
            this.e = new Hashtable(100, 100.0f);
        } else if (this.e.containsKey(ilvClusterId)) {
            return;
        }
        this.e.put(ilvClusterId, ilvClusterId);
        this.c(false);
        this.onParameterChanged("Clustering");
    }

    public synchronized void removeRootClusterId(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("clusterId cannot be null");
        }
        if (this.e != null) {
            this.e.remove(ilvClusterId);
            this.c(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void removeAllRootClusterIds() {
        if (this.e != null) {
            this.e = null;
            this.c(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void setRootClusterIds(IlvClusterId[] ilvClusterIdArray) {
        this.removeAllRootClusterIds();
        if (ilvClusterIdArray != null) {
            int n2 = ilvClusterIdArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b(ilvClusterIdArray[i2]);
            }
        }
    }

    public IlvClusterId[] getRootClusterIds() {
        if (this.e == null) {
            return null;
        }
        int n2 = this.e.size();
        if (n2 == 0) {
            return null;
        }
        Enumeration enumeration = this.e.keys();
        IlvClusterId[] ilvClusterIdArray = new IlvClusterId[n2];
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            ilvClusterIdArray[n3++] = (IlvClusterId)enumeration.nextElement();
        }
        return ilvClusterIdArray;
    }

    private IlvGrapherCluster a(IlvGraphOfClusters ilvGraphOfClusters) {
        IlvClusterId ilvClusterId;
        if (this.e == null) {
            return ilvGraphOfClusters.f();
        }
        IlvGrapherCluster ilvGrapherCluster = null;
        Enumeration enumeration = this.e.keys();
        while (enumeration.hasMoreElements() && (ilvGrapherCluster = ilvGraphOfClusters.getCluster(ilvClusterId = (IlvClusterId)enumeration.nextElement())) == null) {
        }
        if (ilvGrapherCluster == null) {
            return ilvGraphOfClusters.f();
        }
        ilvGraphOfClusters.a(ilvGrapherCluster);
        return ilvGrapherCluster;
    }

    private final void a(IlvGraphOfClusters ilvGraphOfClusters, boolean bl) throws IlvGraphLayoutException {
        Level level;
        IlvGrapherCluster ilvGrapherCluster;
        Enumeration enumeration = ilvGraphOfClusters.getNodes();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            ilvGrapherCluster = (IlvGrapherCluster)enumeration.nextElement();
            ilvGrapherCluster.a(this.getOffset(), this);
        }
        ilvGrapherCluster = this.a(ilvGraphOfClusters);
        float f2 = this.getOffset();
        ilvGrapherCluster.a(this.h, this.i);
        this.layoutStepPerformed();
        ilvGrapherCluster.a(true, this, this.h, this.i, 0.0f, f2, bl);
        IlvUnsyncVector ilvUnsyncVector = new IlvUnsyncVector(10, 10);
        IlvUnsyncVector ilvUnsyncVector2 = ilvGrapherCluster.e();
        float f3 = ilvGrapherCluster.m();
        int n2 = 0;
        float f4 = 0.0f;
        double d2 = 0.0;
        float f5 = 0.0f;
        double d3 = 0.0;
        float f6 = 0.0f;
        double d4 = 0.0;
        float f7 = 0.0f;
        float f8 = 0.0f;
        Level level2 = level = this.isAreaMinimizationEnabled() ? new Level(50) : null;
        if (ilvUnsyncVector2.size() > 1) {
            float f9;
            int n3;
            IlvAbstractGraphicNode ilvAbstractGraphicNode;
            int n4;
            for (n4 = 0; n4 < ilvUnsyncVector2.size(); ++n4) {
                ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(n4);
                IlvUnsyncVector ilvUnsyncVector3 = ilvAbstractGraphicNode.e();
                if (ilvUnsyncVector3 == null || ilvUnsyncVector3.size() < 1) continue;
                int n5 = ilvUnsyncVector3.size();
                for (n3 = 0; n3 < n5; ++n3) {
                    IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector3.elementAt(n3);
                    if (ilvGrapherCluster2 == null) continue;
                    ilvUnsyncVector.addElement(ilvGrapherCluster2);
                    float f10 = ilvGrapherCluster2.m();
                    f3 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, ilvGrapherCluster.m(), f3, f2);
                    if (!(f10 > f7)) continue;
                    f7 = f10;
                }
                f8 = f3 - f7;
                double d5 = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.h, this.i);
                f9 = 0.0f;
                if (this.isAreaMinimizationEnabled() && ilvUnsyncVector.size() > 0) {
                    Interval interval = new Interval();
                    level.a(interval);
                    interval.a(ilvGrapherCluster);
                    interval.a(ilvGraphOfClusters, ilvUnsyncVector3);
                    interval.a(d5);
                    f9 = IlvCircularLayout.a(ilvUnsyncVector3, f8, f2);
                }
                f9 = IlvCircularLayout.a(ilvAbstractGraphicNode, f8, f2);
                if (n2 == 0) {
                    f4 = f9;
                    d2 = d5;
                }
                f5 = f9;
                d3 = d5;
                if (n2 > 0) {
                    double d6 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d5), LayoutUtil.CorrectAngle(d4));
                    f8 = (float)Math.max((double)f8, (double)((f6 + f9) * 0.5f + f2) / d6);
                    f3 = Math.max(f3, f8 + f7);
                }
                f6 = f9;
                d4 = d5;
                ++n2;
            }
            if (n2 > 1) {
                f8 = (float)Math.max((double)f8, (double)((f4 + f5) * 0.5f + f2) / LayoutUtil.GetDeltaAlpha(d2, d3));
                f3 = Math.max(f3, f8 + f7);
            }
            f3 += this.getLevelOffset();
            if (this.isAreaMinimizationEnabled() && ilvUnsyncVector.size() > 0) {
                float f11 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f12 = f3 - f11;
                for (int i2 = 0; i2 < level.b(); ++i2) {
                    Interval interval = level.b(i2);
                    f9 = IlvCircularLayout.a(interval.c(), f12, f2);
                    interval.b(f12);
                    interval.a(f9, ilvGrapherCluster.m(), f3);
                    interval.a(interval.c().size());
                }
                level.a(f2);
                this.a(level, f3, f2, bl);
            } else {
                f8 = f3 - f7;
                n4 = ilvUnsyncVector2.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(n3);
                    this.a(ilvAbstractGraphicNode, f3, f8, f2, bl);
                }
            }
            this.a(ilvUnsyncVector, ilvGraphOfClusters, this.h, this.i, f3, f2, bl);
        } else {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(0);
            float f13 = LayoutUtil.getDiagonal(ilvAbstractGraphicNode.getGraphicObject(), this.getGraphModel());
            IlvUnsyncVector ilvUnsyncVector4 = ilvAbstractGraphicNode.e();
            float[] fArray = new float[1];
            if (ilvUnsyncVector4 == null || ilvUnsyncVector4.size() < 1) {
                return;
            }
            f3 = this.a(ilvUnsyncVector4, ilvGrapherCluster, fArray, f2, f13) + this.getLevelOffset();
            this.a(ilvUnsyncVector4, ilvGrapherCluster, fArray[0], ilvGraphOfClusters, this.h, this.i, f3, f2, bl);
        }
    }

    private final float a(IlvUnsyncVector ilvUnsyncVector, IlvGrapherCluster ilvGrapherCluster, float[] fArray, float f2, float f3) {
        if (ilvUnsyncVector.size() == 1) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(0);
            fArray[0] = ilvGrapherCluster2.m();
            return f3 * 0.5f + f2 + ilvGrapherCluster2.o();
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i2 = 0; i2 < ilvUnsyncVector.size(); ++i2) {
            IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i2);
            float f8 = ilvGrapherCluster3.m();
            float f9 = ilvGrapherCluster3.o();
            f5 += 2.0f * f8 + f2;
            if (f9 > f6) {
                f6 = f9;
            }
            if (!(f8 > f7)) continue;
            f7 = f8;
        }
        f4 = (float)((double)f5 / (Math.PI * 2));
        f4 = Math.max(f4, f3 * 0.5f + f2 + f6);
        if (ilvUnsyncVector.size() > 1) {
            ilvGrapherCluster.a(f5);
        } else {
            ilvGrapherCluster.a(0.0f);
        }
        fArray[0] = f7;
        return f4;
    }

    private final void a(IlvUnsyncVector ilvUnsyncVector, IlvGrapherCluster ilvGrapherCluster, float f2, IlvGraphOfClusters ilvGraphOfClusters, float f3, float f4, float f5, float f6, boolean bl) throws IlvGraphLayoutException {
        switch (ilvUnsyncVector.size()) {
            case 0: {
                return;
            }
            case 2: {
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(0);
                IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(1);
                double d2 = 0.0;
                double d3 = Math.PI;
                ilvGrapherCluster2.a(d2);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(this, d2, f3, f4, f5, f6, bl);
                ilvGrapherCluster3.a(d3);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster3.a(this, d3, f3, f4, f5, f6, bl);
                break;
            }
            default: {
                double d4 = 0.0;
                float f7 = f5 - f2;
                float f8 = (float)(Math.PI * 2 * (double)f7 - (ilvGrapherCluster.s() - (double)(f6 * (float)(ilvUnsyncVector.size() - 1)))) / (float)ilvUnsyncVector.size();
                double d5 = LayoutUtil.getEqualSidesTriangleAngle(f7, f8);
                int n2 = ilvUnsyncVector.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    IlvGrapherCluster ilvGrapherCluster4 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i2);
                    float f9 = ilvGrapherCluster4.m();
                    if (i2 != 0) {
                        d4 += LayoutUtil.getEqualSidesTriangleAngle(f7, f9);
                    }
                    ilvGrapherCluster4.a(d4);
                    this.callLayoutStepPerformedIfNeeded();
                    ilvGrapherCluster4.a(this, d4, f3, f4, f5, f6, bl);
                    d4 += LayoutUtil.getEqualSidesTriangleAngle(f7, f9) + d5;
                }
            }
        }
        if (ilvUnsyncVector.size() > 0) {
            this.a(ilvUnsyncVector, ilvGraphOfClusters, f3, f4, f5, f6, bl);
        }
    }

    private final void a(IlvUnsyncVector ilvUnsyncVector, IlvGraphOfClusters ilvGraphOfClusters, float f2, float f3, float f4, float f5, boolean bl) throws IlvGraphLayoutException {
        IlvGrapherCluster ilvGrapherCluster;
        int n2;
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return;
        }
        IlvUnsyncVector ilvUnsyncVector2 = new IlvUnsyncVector(ilvUnsyncVector.size(), ilvUnsyncVector.size());
        float f6 = f4;
        int n3 = 0;
        float f7 = 0.0f;
        double d2 = 0.0;
        float f8 = 0.0f;
        double d3 = 0.0;
        float f9 = 0.0f;
        double d4 = 0.0;
        float[] fArray = new float[]{0.0f};
        float f10 = 0.0f;
        boolean bl2 = this.isAreaMinimizationEnabled();
        Level level = bl2 ? new Level(ilvUnsyncVector.size()) : null;
        int n4 = ilvUnsyncVector.size();
        for (n2 = 0; n2 < n4; ++n2) {
            ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(n2);
            IlvUnsyncVector ilvUnsyncVector3 = new IlvUnsyncVector(15);
            f6 = this.a(ilvGrapherCluster, ilvUnsyncVector3, f4, f6, fArray, f5);
            int n5 = ilvUnsyncVector3.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                ilvUnsyncVector2.addElement(ilvUnsyncVector3.elementAt(i2));
            }
            if (f6 <= 0.0f || n5 < 1) {
                f6 = Math.abs(f6);
                f10 = f6 - fArray[0];
                continue;
            }
            f10 = f6 - fArray[0];
            float f11 = 0.0f;
            double d5 = ilvGrapherCluster.r();
            if (bl2 && ilvUnsyncVector2.size() > 0) {
                Interval interval = new Interval();
                level.a(interval);
                interval.a(ilvGrapherCluster);
                interval.a(ilvGraphOfClusters, ilvUnsyncVector3);
                interval.a(d5);
                f11 = IlvCircularLayout.a(ilvUnsyncVector3, f10, f5);
            } else {
                f11 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f10, f5);
            }
            if (n3 == 0) {
                f7 = f11;
                d2 = d5;
            }
            f8 = f11;
            d3 = d5;
            if (n3 > 0) {
                double d6 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d5), LayoutUtil.CorrectAngle(d4));
                f10 = (float)Math.max((double)f10, (double)((f9 + f11) * 0.5f + f5) / d6);
                f6 = Math.max(f6, f10 + fArray[0]);
            }
            f9 = f11;
            d4 = d5;
            ++n3;
        }
        if (n3 > 1) {
            f10 = (float)Math.max((double)f10, (double)((f7 + f8) * 0.5f + f5) / LayoutUtil.GetDeltaAlpha(d2, d3));
            f6 = Math.max(f6, f10 + fArray[0]);
        }
        f6 += this.getLevelOffset();
        if (bl2 && ilvUnsyncVector2.size() > 0) {
            int n6 = level.b();
            for (int i3 = 0; i3 < n6; ++i3) {
                Interval interval = level.b(i3);
                ilvGrapherCluster = interval.a();
                float f12 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f13 = f6 - f12;
                float f14 = IlvCircularLayout.a(interval.c(), f13, f5);
                interval.b(f13);
                interval.a(f14, f4, f6);
                interval.a(interval.c().size());
            }
            level.a(f5);
            this.a(level, f6, f5, bl);
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(n2);
                this.a(ilvGrapherCluster, ilvGraphOfClusters, f6, f5, bl);
            }
        }
        if (ilvUnsyncVector2.size() > 0) {
            this.a(ilvUnsyncVector2, ilvGraphOfClusters, f2, f3, f6, f5, bl);
        }
    }

    private final void a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f2, float f3, float f4, boolean bl) throws IlvGraphLayoutException {
        double d2 = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.h, this.i);
        IlvUnsyncVector ilvUnsyncVector = ilvAbstractGraphicNode.e();
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return;
        }
        float f5 = IlvCircularLayout.a(ilvUnsyncVector, f3, f4);
        d2 -= (double)(f5 / (2.0f * f3));
        float f6 = IlvCircularLayout.a(f4, f3);
        int n2 = ilvUnsyncVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                d2 += (double)(f6 / f3);
            }
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i2);
            float f7 = IlvCircularLayout.a(ilvGrapherCluster.m(), f3);
            this.callLayoutStepPerformedIfNeeded();
            ilvGrapherCluster.a(false, this, d2 += (double)(f7 / f3), this.h, this.i, f2, f4, bl);
            d2 += (double)(f7 / f3);
        }
    }

    private final void a(Level level, float f2, float f3, boolean bl) throws IlvGraphLayoutException {
        if (level.b() < 1) {
            return;
        }
        float f4 = level.b(0).i();
        for (int i2 = 0; i2 < level.b(); ++i2) {
            Interval interval = level.b(i2);
            double d2 = interval.j();
            double d3 = interval.k();
            double d4 = interval.l();
            double d5 = interval.m();
            double d6 = 0.0;
            if (interval.e() > 1) {
                d6 = (LayoutUtil.GetOrientedDeltaAlpha(d3, d2) - LayoutUtil.GetOrientedDeltaAlpha(d5, d4)) / (double)interval.e();
            }
            double d7 = interval.j();
            float f5 = IlvCircularLayout.a(f3, f4);
            IlvUnsyncVector ilvUnsyncVector = interval.c();
            d7 += d6 * 0.5;
            int n2 = ilvUnsyncVector.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i3 > 0) {
                    d7 += d6 + (double)(f5 / f4);
                }
                IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i3);
                float f6 = IlvCircularLayout.a(ilvGrapherCluster.m(), f4);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster.a(false, this, d7 += (double)(f6 / f4), this.h, this.i, f2, f3, bl);
                ilvGrapherCluster.a(d7);
                d7 += (double)(f6 / f4);
            }
        }
    }

    private final void a(IlvGrapherCluster ilvGrapherCluster, IlvGraphOfClusters ilvGraphOfClusters, float f2, float f3, boolean bl) throws IlvGraphLayoutException {
        IlvUnsyncVector ilvUnsyncVector = ilvGrapherCluster.e();
        if (ilvUnsyncVector.size() < 1) {
            return;
        }
        double d2 = IlvCircularLayout.a(ilvGrapherCluster, this.h, this.i);
        float f4 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
        float f5 = f2 - f4;
        float f6 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f5, f3);
        d2 -= (double)(f6 / (2.0f * f5));
        int n2 = 0;
        int n3 = ilvUnsyncVector.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector.elementAt(i2);
            IlvUnsyncVector ilvUnsyncVector2 = ilvAbstractGraphicNode.e();
            if (ilvUnsyncVector2 == null || ilvUnsyncVector2.size() < 1) continue;
            float f7 = IlvCircularLayout.a(f3, f5);
            float f8 = f7 / f5;
            int n4 = ilvUnsyncVector2.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                if (n2 > 0) {
                    d2 += (double)f8;
                }
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector2.elementAt(i3);
                float f9 = IlvCircularLayout.a(ilvGrapherCluster2.m(), f5);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(false, this, d2 += (double)(f9 / f5), this.h, this.i, f2, f3, bl);
                ilvGrapherCluster2.a(d2);
                d2 += (double)(f9 / f5);
                ++n2;
            }
        }
    }

    private final boolean h() {
        return this.x;
    }

    private final void c(boolean bl) {
        if (this.x != bl) {
            if (!bl) {
                this.g();
            }
            this.x = bl;
        }
    }

    public void setStructureUpToDate(boolean bl) {
        super.setStructureUpToDate(bl);
        if (!bl) {
            this.c(false);
        }
    }

    private static final double a(IlvGrapherCluster ilvGrapherCluster, float f2, float f3) {
        return Math.atan2(f3 - ilvGrapherCluster.u(), ilvGrapherCluster.t() - f2);
    }

    private final float a(IlvGrapherCluster ilvGrapherCluster, IlvUnsyncVector ilvUnsyncVector, float f2, float f3, float[] fArray, float f4) {
        float f5;
        IlvCircularLayout.a(ilvGrapherCluster, ilvUnsyncVector);
        IlvUnsyncVector ilvUnsyncVector2 = ilvUnsyncVector;
        if (ilvUnsyncVector2.size() < 1) {
            ilvGrapherCluster.a(0.0f);
            return -f3;
        }
        float f6 = f3;
        float f7 = 0.0f;
        for (int i2 = 0; i2 < ilvUnsyncVector2.size(); ++i2) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector2.elementAt(i2);
            float f8 = ilvGrapherCluster2.m();
            if (i2 > 0) {
                f7 += f4;
            }
            f7 += 2.0f * ilvGrapherCluster2.m();
            f6 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, f2, f6, f4);
            if (!(f8 > fArray[0])) continue;
            fArray[0] = f8;
        }
        ilvGrapherCluster.a(f7);
        float f9 = f5 = f6 - fArray[0];
        float f10 = 1.2f * f7;
        if ((double)f5 > 1.0E-4 && f7 > 0.0f && ((double)(f10 / (2.0f * f5)) > Math.PI || Math.cos(f10 / (2.0f * f5)) <= (double)(f2 / f5))) {
            int n2 = 0;
            while (((double)(f10 / (2.0f * (f5 += f9))) > Math.PI || Math.cos(f10 / (2.0f * f5)) <= (double)(f2 / f5)) && ++n2 < 1000) {
            }
            n2 = 0;
            while ((double)(f10 / (2.0f * (f5 -= f9 / 10.0f))) <= Math.PI && Math.cos(f10 / (2.0f * f5)) > (double)(f2 / f5) && ++n2 < 1000) {
            }
            f6 = f5 + f6 / 10.0f + fArray[0];
        }
        return f6;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvGrapherCluster ilvGrapherCluster2, float f2, float f3, float f4) {
        float f5 = ilvGrapherCluster.h().getType() == 0 ? -ilvGrapherCluster2.n() : f4;
        return Math.max(f3, f2 + ilvGrapherCluster.o() + f5);
    }

    private void i() {
        if (!this.clusterize()) {
            throw new RuntimeException(ac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clusterize() {
        if (this.y || this.h()) {
            return true;
        }
        this.y = true;
        boolean bl = false;
        try {
            Serializable serializable;
            bl = this.j();
            if (!bl && (serializable = this.getGrapher()) != null) {
                this.a(this.getGraphModel().getNodes());
                bl = this.j();
            }
            if (bl) {
                this.a(this.b);
                this.c = this.b.g();
                if (this.d == null) {
                    this.d = new IlvUnsyncVector(this.b.e().size());
                } else {
                    this.d.removeAllElements();
                }
                int n2 = this.c.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    serializable = (IlvGraphOfClusters)this.c.elementAt(i2);
                    IlvUnsyncVector ilvUnsyncVector = ((IlvAbstractGraph)serializable).e();
                    int n3 = ilvUnsyncVector.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        this.d.addElement(ilvUnsyncVector.elementAt(i3));
                    }
                }
                this.c(true);
            }
            this.b = null;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            this.y = false;
        }
        return bl;
    }

    private boolean j() {
        Object object;
        this.b = new IlvGraphOfClusters();
        Enumeration enumeration = this.getGraphModel().getNodes();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Enumeration enumeration2 = this.getClusterIds(object);
            while (enumeration2.hasMoreElements()) {
                IlvClusterId ilvClusterId = (IlvClusterId)enumeration2.nextElement();
                this.a(object, ilvClusterId);
            }
        }
        object = this.b.getNodes();
        if (!object.hasMoreElements()) {
            return false;
        }
        this.b.a(this);
        return true;
    }

    public final synchronized void setStarCenter(Object object, boolean bl) {
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, g, bl, false);
    }

    public boolean isStarCenter(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, g, false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId);
            this.onParameterChanged(object, f);
        }
        this.c(false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId, int n2) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("index must not be negative");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId, n2));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId, n2);
            this.onParameterChanged(object, f);
        }
        this.c(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId);
            this.onParameterChanged(object, f);
        }
        this.c(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId, int n2) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("index must not be negative");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId, n2));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId, n2);
            this.onParameterChanged(object, f);
        }
        this.c(false);
    }

    public final synchronized void removeClusterId(Object object, IlvClusterId ilvClusterId) {
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection != null && ilvClusterIdCollection.remove(ilvClusterId)) {
            this.onParameterChanged(object, f);
            this.c(false);
        }
    }

    public final synchronized void removeAllClusterIds(Object object) {
        LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, null);
        this.c(false);
    }

    public Vector getClusterIds() {
        this.i();
        if (this.d.size() < 1) {
            return null;
        }
        Vector<IlvClusterId> vector = new Vector<IlvClusterId>(this.d.size());
        int n2 = this.d.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(i2);
            vector.addElement(ilvGrapherCluster.getId());
        }
        return vector;
    }

    public float getClusterRadius(int n2) {
        this.i();
        if (n2 < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n2 >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n2 + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n2);
        return ilvGrapherCluster.l();
    }

    public IlvPoint getClusterCenter(int n2) {
        this.i();
        if (n2 < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n2 >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n2 + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n2);
        return new IlvPoint(ilvGrapherCluster.t(), ilvGrapherCluster.u());
    }

    public Vector getClusterNodes(int n2) {
        this.i();
        if (n2 < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n2 >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n2 + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n2);
        return ilvGrapherCluster.g();
    }

    public Enumeration getClusterIds(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        return ilvClusterIdCollection == null ? LayoutUtil.GetVoidEnumeration() : ilvClusterIdCollection.getClusterIds();
    }

    public int getClusterIdsCount(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        return ilvClusterIdCollection == null ? 0 : ilvClusterIdCollection.size();
    }

    public int getIndex(Object object, IlvClusterId ilvClusterId) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null || !ilvClusterIdCollection.contains(ilvClusterId)) {
            throw new IllegalArgumentException("node is not contained in the cluster " + ilvClusterId);
        }
        return ilvClusterIdCollection.getIndex(ilvClusterId);
    }

    public final void setClusteringMode(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Unsupported clustering mode: " + n2);
        }
        if (n2 != this.v) {
            this.v = n2;
            this.onParameterChanged("ClusteringMode");
        }
    }

    public final int getClusteringMode() {
        return this.isUseDefaultParameters() ? 0 : this.v;
    }

    public final void setMaxNumberOfPermutations(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative number of permutaions: " + n2);
        }
        if (n2 != this.w) {
            this.w = n2;
            this.onParameterChanged("MaxNumberOfPermutations");
        }
    }

    public final int getMaxNumberOfPermutations() {
        if (this.isUseDefaultParameters()) {
            return 200;
        }
        return this.w;
    }

    private final void a(Object object, IlvClusterId ilvClusterId) {
        int n2;
        IlvGrapherCluster ilvGrapherCluster;
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        if (this.b == null) {
            this.b = new IlvGraphOfClusters();
        }
        if ((ilvGrapherCluster = this.b.getCluster(ilvClusterId)) == null) {
            ilvGrapherCluster = new IlvGrapherCluster(ilvClusterId);
            ilvGrapherCluster.attach(this.getGraphModel());
            this.b.addNode(ilvGrapherCluster);
        }
        if ((n2 = this.getIndex(object, ilvClusterId)) >= 0) {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object, n2), this.isStarCenter(object));
        } else {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object), this.isStarCenter(object));
        }
        this.c(false);
    }

    final void a(IlvClustersConnexion ilvClustersConnexion) {
        this.b.addLink(ilvClustersConnexion);
        this.c(false);
    }

    final IlvGrapherCluster a(IlvClusterId ilvClusterId) {
        this.i();
        return this.b.getCluster(ilvClusterId);
    }

    final IlvGraphOfClusters c() {
        return this.b;
    }

    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    public boolean supportsLayoutOfConnectedComponents() {
        return true;
    }

    public final boolean supportsLayoutRegion() {
        return true;
    }

    public final boolean supportsLinkConnectionBox() {
        return true;
    }

    public final boolean supportsLinkClipping() {
        return true;
    }

    public final boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    public synchronized void setAreaMinimizationEnabled(boolean bl) {
        if (bl != this.t) {
            this.t = bl;
            this.onParameterChanged("AreaMinimizationEnabled");
        }
    }

    public boolean isAreaMinimizationEnabled() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.t;
    }

    public void setLinkStyle(int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("unsupported style option: " + n2);
        }
        if (n2 != this.u) {
            this.u = n2;
            this.onParameterChanged("LinkStyle");
        }
    }

    public int getLinkStyle() {
        if (this.isUseDefaultParameters()) {
            return 1;
        }
        return this.u;
    }

    public synchronized void setOffset(float f2) {
        if (f2 != this.q) {
            this.q = f2;
            this.onParameterChanged("Offset");
        }
    }

    public float getOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.q;
    }

    public synchronized void setLevelOffset(float f2) {
        if (f2 != this.r) {
            this.r = f2;
            this.onParameterChanged("LevelOffset");
        }
    }

    public float getLevelOffset() {
        if (this.isUseDefaultParameters()) {
            return 0.0f;
        }
        return this.r;
    }

    public synchronized void setDisconnectedGraphOffset(float f2) {
        if (f2 != this.s) {
            this.s = f2;
            this.onParameterChanged("DisconnectedGraphOffset");
        }
    }

    public float getDisconnectedGraphOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.s;
    }

    private static final void a(IlvGrapherCluster ilvGrapherCluster, IlvUnsyncVector ilvUnsyncVector) {
        IlvUnsyncVector ilvUnsyncVector2 = ilvGrapherCluster.e();
        if (ilvUnsyncVector2.size() < 1) {
            return;
        }
        int n2 = ilvUnsyncVector2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(i2);
            IlvUnsyncVector ilvUnsyncVector3 = ilvAbstractGraphicNode.e();
            if (ilvUnsyncVector3 == null || ilvUnsyncVector3.size() < 1) continue;
            for (int i3 = 0; i3 < ilvUnsyncVector3.size(); ++i3) {
                ilvUnsyncVector.addElement(ilvUnsyncVector3.elementAt(i3));
            }
        }
    }

    private static final IlvUnsyncVector a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        Enumeration enumeration = ilvAbstractGraph.getLinksFrom(ilvGrapherCluster);
        IlvUnsyncVector ilvUnsyncVector = new IlvUnsyncVector(10, 10);
        while (enumeration.hasMoreElements()) {
            IlvClustersConnexion ilvClustersConnexion = (IlvClustersConnexion)enumeration.nextElement();
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvAbstractGraph.getOpposite(ilvClustersConnexion, ilvGrapherCluster);
            if (ilvGrapherCluster2.k()) continue;
            ilvUnsyncVector.addElement(ilvGrapherCluster2);
        }
        return ilvUnsyncVector;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph, float f2, float f3) {
        IlvUnsyncVector ilvUnsyncVector = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        return IlvCircularLayout.a(ilvUnsyncVector, f2, f3);
    }

    private static final float a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f2, float f3) {
        IlvUnsyncVector ilvUnsyncVector = ilvAbstractGraphicNode.e();
        return ilvUnsyncVector == null || ilvUnsyncVector.size() < 1 ? 0.0f : IlvCircularLayout.a(ilvUnsyncVector, f2, f3);
    }

    private static final float a(IlvUnsyncVector ilvUnsyncVector, float f2, float f3) {
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return 0.0f;
        }
        float f4 = 0.0f;
        float f5 = IlvCircularLayout.a(f3, f2);
        int n2 = ilvUnsyncVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i2);
            if (i2 > 0) {
                f4 += f5;
            }
            f4 += IlvCircularLayout.a(2.0f * ilvGrapherCluster.m(), f2);
        }
        return f4;
    }

    private static final float b(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        IlvUnsyncVector ilvUnsyncVector = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return 0.0f;
        }
        float f2 = 0.0f;
        int n2 = ilvUnsyncVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i2);
            float f3 = ilvGrapherCluster2.m();
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    static float a(float f2, float f3) {
        if (f3 == 0.0f) {
            throw new IllegalArgumentException("radius cannot be zero (internal error)");
        }
        return 2.0f * f3 * (float)Math.asin(f2 / (2.0f * f3));
    }

    final IlvArrayStableSort d() {
        return this.aa;
    }

    public int checkAppropriateLink(Object object) {
        if (this.getLinkStyle() == 0) {
            return 0;
        }
        int n2 = 0;
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel.isLinkCheckEnabled() && !ilvGraphModel.isReshapeableLink(object, true)) {
            n2 |= 1;
        }
        if (this.getLinkClipInterface() != null) {
            n2 |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
        }
        return n2;
    }

    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvCircularLayoutGrapherProperty(string, this, bl);
    }

    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvCircularLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    static String b(int n2) {
        switch (n2) {
            case 0: {
                return "BY_CLUSTER_IDS";
            }
            case 1: {
                return "BY_SUBGRAPHS";
            }
        }
        throw new IllegalArgumentException("Wrong clustering mode " + n2);
    }

    static int a(String string) {
        if (string.equals("BY_CLUSTER_IDS")) {
            return 0;
        }
        if (string.equals("BY_SUBGRAPHS")) {
            return 1;
        }
        throw new IllegalArgumentException("Wrong clustering mode " + string);
    }

    private final class Interval {
        private IlvGrapherCluster a;
        private IlvUnsyncVector b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private float j = -1.0f;
        private double k;
        private float l;
        private int m;
        private float n;
        private boolean o = true;

        private Interval() {
        }

        void a(IlvGrapherCluster ilvGrapherCluster) {
            this.a = ilvGrapherCluster;
        }

        IlvGrapherCluster a() {
            return this.a;
        }

        void a(double d2) {
            this.c = d2;
        }

        double b() {
            return this.c;
        }

        void a(IlvGraphOfClusters ilvGraphOfClusters, IlvUnsyncVector ilvUnsyncVector) {
            this.b = ilvUnsyncVector;
            this.o = true;
            if (this.b != null) {
                int n2 = this.b.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.b.elementAt(i2);
                    if (ilvGraphOfClusters.getLinksCount(ilvGrapherCluster) <= 1) continue;
                    this.o = false;
                    break;
                }
            }
        }

        IlvUnsyncVector c() {
            return this.b;
        }

        boolean d() {
            return this.o;
        }

        void a(int n2) {
            this.m = n2;
        }

        int e() {
            return this.m;
        }

        void a(float f2) {
            this.n = f2;
        }

        float f() {
            return this.n;
        }

        private void a(float f2, float f3, float f4) {
            this.j = f2;
            if (this.l == 0.0f) {
                throw new RuntimeException("radius cannot be 0");
            }
            this.k = this.j / this.l;
            this.a(f3, f4);
            this.d = LayoutUtil.CorrectAngle(this.c - this.k * 0.5);
            this.e = LayoutUtil.CorrectAngle(this.c + this.k * 0.5);
            this.f = this.d;
            this.g = this.e;
        }

        float g() {
            return this.j;
        }

        double h() {
            return this.k;
        }

        void b(float f2) {
            this.l = f2;
        }

        float i() {
            return this.l;
        }

        void b(double d2) {
            this.d = d2;
        }

        double j() {
            return this.d;
        }

        void c(double d2) {
            this.e = d2;
        }

        double k() {
            return this.e;
        }

        double l() {
            return this.f;
        }

        double m() {
            return this.g;
        }

        private void a(float f2, float f3) {
            if (this.j < 0.0f) {
                throw new RuntimeException("computeMinMax not allowed before setting minCurvLength");
            }
            double d2 = LayoutUtil.CorrectAngle(Math.min((double)0.8f * Math.abs(Math.acos(f2 / f3)), 1.2566370614359172));
            this.h = LayoutUtil.CorrectAngle(this.c - d2);
            this.i = LayoutUtil.CorrectAngle(this.c + d2);
        }

        double n() {
            return this.h;
        }

        double o() {
            return this.i;
        }
    }

    private final class Level {
        private IlvUnsyncVector a = null;

        Level(int n2) {
            this.a = new IlvUnsyncVector(n2);
        }

        void a() {
            this.a = null;
        }

        void a(int n2) {
            this.a.removeAllElements();
            if (n2 > this.a.capacity()) {
                this.a.ensureCapacity(n2);
            }
        }

        void a(float f2) {
            Interval interval;
            if (this.a.size() == 0) {
                return;
            }
            if (this.a.size() == 1) {
                int n2;
                Interval interval2 = (Interval)this.a.elementAt(0);
                if (!interval2.d() && (n2 = interval2.e()) > 1) {
                    double d2;
                    double d3 = interval2.n();
                    if (d3 <= (d2 = interval2.o())) {
                        if (d2 - d3 <= Math.PI) {
                            interval2.b(LayoutUtil.CorrectAngle(d3));
                            interval2.c(LayoutUtil.CorrectAngle(d2));
                        } else {
                            interval2.b(LayoutUtil.CorrectAngle(d2));
                            interval2.c(LayoutUtil.CorrectAngle(d3));
                        }
                    } else if (d3 - d2 <= Math.PI) {
                        interval2.b(LayoutUtil.CorrectAngle(d2));
                        interval2.c(LayoutUtil.CorrectAngle(d3));
                    } else {
                        interval2.b(LayoutUtil.CorrectAngle(d3));
                        interval2.c(LayoutUtil.CorrectAngle(d2));
                    }
                }
                return;
            }
            int n3 = this.a.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                interval = (Interval)this.a.elementAt(i2);
                interval.a((float)(interval.e() - 1));
            }
            for (int i3 = 0; i3 < 9; ++i3) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    interval = (Interval)this.a.elementAt(i4);
                    float f3 = interval.f();
                    if (f3 == 0.0f || interval.d()) continue;
                    Interval interval3 = null;
                    Interval interval4 = null;
                    if (i4 == 0) {
                        interval3 = (Interval)this.a.elementAt(n3 - 1);
                        interval4 = (Interval)this.a.elementAt(i4 + 1);
                    } else if (i4 == n3 - 1) {
                        interval3 = (Interval)this.a.elementAt(i4 - 1);
                        interval4 = (Interval)this.a.elementAt(0);
                    } else {
                        interval3 = (Interval)this.a.elementAt(i4 - 1);
                        interval4 = (Interval)this.a.elementAt(i4 + 1);
                    }
                    float f4 = interval3.f();
                    float f5 = interval4.f();
                    if (f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) continue;
                    double d4 = interval3.k();
                    double d5 = interval4.j();
                    double d6 = interval.j();
                    double d7 = interval.k();
                    double d8 = interval.n();
                    double d9 = interval.o();
                    double d10 = d4 < d5 ? d4 : d5;
                    d10 = d6 < d10 ? d6 : d10;
                    d10 = d7 < d10 ? d7 : d10;
                    double d11 = LayoutUtil.GetOrientedDeltaAlpha1(d6 -= d10, d4 -= d10);
                    double d12 = LayoutUtil.GetOrientedDeltaAlpha1(d5 -= d10, d7 -= d10);
                    double d13 = (double)(f4 + f3) > 1.0E-4 ? d11 * (double)f3 / (double)(f4 + f3) : 0.0;
                    double d14 = (double)(f5 + f3) > 1.0E-4 ? d12 * (double)f3 / (double)(f5 + f3) : 0.0;
                    d6 = LayoutUtil.CorrectAngle(d10 + d6 - d13);
                    d7 = LayoutUtil.CorrectAngle(d10 + d7 + d14);
                    if (d8 <= d9) {
                        if (d6 < d8 || d6 > d9) {
                            d6 = d8;
                        }
                        if (d7 < d8 || d7 > d9) {
                            d7 = d9;
                        }
                    } else {
                        if (d6 < d8 && d6 > d9) {
                            d6 = d8;
                        }
                        if (d7 < d8 && d7 > d9) {
                            d7 = d9;
                        }
                    }
                    interval.b(LayoutUtil.CorrectAngle(d6));
                    interval.c(LayoutUtil.CorrectAngle(d7));
                }
            }
        }

        int b() {
            return this.a.size();
        }

        void a(Interval interval) {
            this.a.addElement(interval);
        }

        Interval b(int n2) {
            return (Interval)this.a.elementAt(n2);
        }
    }

    private final class SortNodesByIndex
    extends IlvArrayStableSort {
        private SortNodesByIndex() {
        }

        protected final boolean compare(Object object, Object object2) {
            int n2 = ((IlvAbstractGraphicNode)object).getIndex();
            int n3 = ((IlvAbstractGraphicNode)object2).getIndex();
            if (n2 < 0) {
                return n3 < 0;
            }
            if (n3 < 0) {
                return false;
            }
            return n2 <= n3;
        }
    }
}

