/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.grid;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.IlvNodeBoxInterface;
import ilog.views.graphlayout.grid.IlvGridLayoutGrapherProperty;
import ilog.views.graphlayout.grid.IlvGridLayoutNodeProperty;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.rowcolumngrid.Graph;
import ilog.views.graphlayout.internalutil.rowcolumngrid.GraphOnMatrix;
import ilog.views.graphlayout.internalutil.rowcolumngrid.GraphOnRowsOrColumns;
import ilog.views.graphlayout.internalutil.rowcolumngrid.IlvPredefinedNodeComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Comparator;

public class IlvGridLayout
extends IlvGraphLayout {
    private static final String a = "HorizontalAlignment";
    private static final String b = "VerticalAlignment";
    private static final String c = "Index";
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int MIXED = 99;
    public static final int TILE_TO_ROWS = 0;
    public static final int TILE_TO_COLUMNS = 1;
    public static final int TILE_TO_GRID_FIXED_WIDTH = 2;
    public static final int TILE_TO_GRID_FIXED_HEIGHT = 3;
    public static final Comparator AUTOMATIC_ORDERING = Graph.AUTOMATIC_ORDERING;
    public static final Comparator NO_ORDERING = Graph.NO_ORDERING;
    public static final Comparator DESCENDING_HEIGHT = Graph.DESCENDING_HEIGHT;
    public static final Comparator ASCENDING_HEIGHT = Graph.ASCENDING_HEIGHT;
    public static final Comparator ASCENDING_WIDTH = Graph.ASCENDING_WIDTH;
    public static final Comparator DESCENDING_WIDTH = Graph.DESCENDING_WIDTH;
    public static final Comparator ASCENDING_AREA = Graph.ASCENDING_AREA;
    public static final Comparator DESCENDING_AREA = Graph.DESCENDING_AREA;
    public static final Comparator ASCENDING_INDEX = Graph.ASCENDING_INDEX;
    public static final Comparator DESCENDING_INDEX = Graph.DESCENDING_INDEX;
    public static final int NO_INDEX = -1;
    static final int d = 0;
    private int e;
    static final int f = 0;
    private int g;
    static final int h = 2;
    private int i;
    static final boolean j = false;
    private boolean k;
    static final float l = 40.0f;
    private float m;
    static final float n = 40.0f;
    private float o;
    static final float p = 5.0f;
    private float q;
    static final float r = 5.0f;
    private float s;
    static final float t = 5.0f;
    private float u;
    static final float v = 5.0f;
    private float w;
    static final Comparator x = AUTOMATIC_ORDERING;
    private Comparator y;
    static final int z = Integer.MAX_VALUE;
    private int aa;
    static final IlvNodeBoxInterface ab = null;
    private IlvNodeBoxInterface ac;
    private boolean ad;
    private boolean ae;
    private boolean af;
    private IlvRect ag;
    private Graph ah;

    public IlvGridLayout() {
    }

    public IlvGridLayout(IlvGridLayout ilvGridLayout) {
        super(ilvGridLayout);
    }

    protected void init() {
        super.init();
        this.y = x;
        this.e = 0;
        this.g = 0;
        this.i = 2;
        this.k = false;
        this.m = 40.0f;
        this.o = 40.0f;
        this.q = 5.0f;
        this.s = 5.0f;
        this.u = 5.0f;
        this.w = 5.0f;
        this.aa = Integer.MAX_VALUE;
        this.ac = ab;
        this.ag = new IlvRect();
    }

    public IlvGraphLayout copy() {
        return new IlvGridLayout(this);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvGridLayout) {
            IlvGridLayout ilvGridLayout = (IlvGridLayout)ilvGraphLayout;
            this.setNodeComparator(ilvGridLayout.getNodeComparator());
            this.setGlobalHorizontalAlignment(ilvGridLayout.getGlobalHorizontalAlignment());
            this.setGlobalVerticalAlignment(ilvGridLayout.getGlobalVerticalAlignment());
            this.setLayoutMode(ilvGridLayout.getLayoutMode());
            this.setIncrementalMode(ilvGridLayout.isIncrementalMode());
            this.setHorizontalGridOffset(ilvGridLayout.getHorizontalGridOffset());
            this.setVerticalGridOffset(ilvGridLayout.getVerticalGridOffset());
            this.setTopMargin(ilvGridLayout.getTopMargin());
            this.setBottomMargin(ilvGridLayout.getBottomMargin());
            this.setLeftMargin(ilvGridLayout.getLeftMargin());
            this.setRightMargin(ilvGridLayout.getRightMargin());
            this.setMaxNumberOfNodesPerRowOrColumn(ilvGridLayout.getMaxNumberOfNodesPerRowOrColumn());
            this.setNodeBoxInterface(ilvGridLayout.getNodeBoxInterface());
        }
    }

    protected void layout(boolean bl) throws IlvGraphLayoutException {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        IlvRect ilvRect = this.getCalcLayoutRegion();
        this.ad = false;
        if (this.ah == null || this.ah.getGraphModel() != ilvGraphModel || !this.isIncrementalMode() || !this.a(ilvRect)) {
            this.ah = this.e();
            this.ah.attach(ilvGraphModel);
        }
        this.ag.reshape(0.0f, 0.0f, 0.0f, 0.0f);
        this.callLayoutStepPerformedIfNeeded();
        this.a(this.ah, ilvRect);
        this.ah.layout(bl);
        this.layoutStepPerformed();
        this.ag.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        if (this.ad) {
            ilvGraphLayoutReport.setCode(7);
        } else {
            ilvGraphLayoutReport.setCode(5);
            switch (this.getLayoutMode()) {
                case 2: 
                case 3: {
                    this.b(null, true);
                    break;
                }
                case 0: 
                case 1: {
                    this.b(true);
                    break;
                }
                default: {
                    throw new RuntimeException("unsuported layout mode: " + this.getLayoutMode());
                }
            }
        }
    }

    private Graph e() {
        switch (this.getLayoutMode()) {
            case 2: 
            case 3: {
                return new GraphOnMatrixImpl(this);
            }
            case 0: 
            case 1: {
                return new GraphOnRowsOrColumnsImp(this);
            }
        }
        throw new RuntimeException("unsuported layout mode: " + this.getLayoutMode());
    }

    public synchronized void detach() {
        this.f();
        super.detach();
    }

    private void f() {
        if (this.ah != null) {
            this.ah.detach();
            this.ah.dispose();
            this.ah = null;
        }
    }

    public final boolean supportsLayoutRegion() {
        return true;
    }

    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    public final boolean supportsAllowedTime() {
        return true;
    }

    public boolean supportsStopImmediately() {
        return true;
    }

    public boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    public void setLayoutMode(int n2) {
        if (n2 != 1 && n2 != 0 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("unsupported layout mode: " + n2);
        }
        if (n2 != this.i) {
            this.i = n2;
            this.a("LayoutMode", false);
        }
    }

    public int getLayoutMode() {
        return this.isUseDefaultParameters() ? 2 : this.i;
    }

    public void setIncrementalMode(boolean bl) {
        if (bl != this.k) {
            this.k = bl;
            this.onParameterChanged("IncrementalMode");
        }
    }

    public boolean isIncrementalMode() {
        return this.isUseDefaultParameters() ? false : this.k;
    }

    public void setGlobalHorizontalAlignment(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 99) {
            throw new IllegalArgumentException("unsupported global horizontal alignment option: " + n2);
        }
        if (n2 != this.e) {
            this.e = n2;
            this.onParameterChanged("GlobalHorizontalAlignment");
        }
    }

    public int getGlobalHorizontalAlignment() {
        return this.isUseDefaultParameters() ? 0 : this.e;
    }

    public void setHorizontalAlignment(Object object, int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("unsupported horizontal alignment option: " + n2);
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, a, n2, 0);
    }

    public int getHorizontalAlignment(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, a, 0);
    }

    public void setGlobalVerticalAlignment(int n2) {
        if (n2 != 0 && n2 != 3 && n2 != 4 && n2 != 99) {
            throw new IllegalArgumentException("unsupported global vertical alignment option: " + n2);
        }
        if (n2 != this.g) {
            this.g = n2;
            this.onParameterChanged("GlobalVerticalAlignment");
        }
    }

    public int getGlobalVerticalAlignment() {
        return this.isUseDefaultParameters() ? 0 : this.g;
    }

    public void setVerticalAlignment(Object object, int n2) {
        if (n2 != 0 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("unsupported vertical alignment option: " + n2);
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, b, n2, 0);
    }

    public int getVerticalAlignment(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, b, 0);
    }

    public final void setNodeComparator(Comparator comparator) {
        if (comparator != this.y) {
            this.y = comparator;
            this.a("NodeComparator", false);
        }
    }

    public Comparator getNodeComparator() {
        return this.isUseDefaultParameters() ? x : this.y;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.y instanceof IlvPredefinedNodeComparator) {
            this.y = ((IlvPredefinedNodeComparator)this.y).getReadComparator();
        }
    }

    public void setIndex(Object object, int n2) {
        if (n2 < 0 && n2 != -1) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, c, n2, -1);
    }

    public int getIndex(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, c, -1);
    }

    public void setHorizontalGridOffset(float f2) {
        if (f2 < 0.01f) {
            throw new IllegalArgumentException("too small horizontal grid offset: " + f2);
        }
        if (f2 != this.m) {
            this.m = f2;
            this.b("HorizontalGridOffset", false);
        }
    }

    public float getHorizontalGridOffset() {
        return this.isUseDefaultParameters() ? 40.0f : this.m;
    }

    public void setVerticalGridOffset(float f2) {
        if (f2 < 0.01f) {
            throw new IllegalArgumentException("too small vertical grid offset: " + f2);
        }
        if (f2 != this.o) {
            this.o = f2;
            this.b("VerticalGridOffset", false);
        }
    }

    public float getVerticalGridOffset() {
        return this.isUseDefaultParameters() ? 40.0f : this.o;
    }

    public void setTopMargin(float f2) {
        if (f2 != this.q) {
            this.q = f2;
            this.a("TopMargin", false);
        }
    }

    public float getTopMargin() {
        return this.isUseDefaultParameters() ? 5.0f : this.q;
    }

    public void setBottomMargin(float f2) {
        if (f2 != this.s) {
            this.s = f2;
            this.a("BottomMargin", false);
        }
    }

    public float getBottomMargin() {
        return this.isUseDefaultParameters() ? 5.0f : this.s;
    }

    public void setLeftMargin(float f2) {
        if (f2 != this.u) {
            this.u = f2;
            this.a("LeftMargin", false);
        }
    }

    public float getLeftMargin() {
        return this.isUseDefaultParameters() ? 5.0f : this.u;
    }

    public void setRightMargin(float f2) {
        if (f2 != this.w) {
            this.w = f2;
            this.a("RightMargin", false);
        }
    }

    public float getRightMargin() {
        return this.isUseDefaultParameters() ? 5.0f : this.w;
    }

    public void setMaxNumberOfNodesPerRowOrColumn(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("maximum number of nodes must be at least 1");
        }
        if (n2 != this.aa) {
            this.aa = n2;
            this.a("MaxNumberOfNodesPerRowOrColumn", false);
        }
    }

    public int getMaxNumberOfNodesPerRowOrColumn() {
        return this.isUseDefaultParameters() ? Integer.MAX_VALUE : this.aa;
    }

    public void setNodeBoxInterface(IlvNodeBoxInterface ilvNodeBoxInterface) {
        if (this.ac != ilvNodeBoxInterface) {
            this.ac = ilvNodeBoxInterface;
            this.onParameterChanged("NodeBoxInterface");
        }
    }

    public IlvNodeBoxInterface getNodeBoxInterface() {
        return this.ac;
    }

    public void checkAppropriateLinks() throws IlvInappropriateLinkException {
    }

    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvGridLayoutGrapherProperty(string, this, bl);
    }

    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvGridLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    private void a(String string, boolean bl) {
        if (!bl) {
            this.f();
        }
        this.b(string, bl);
        this.b(bl);
    }

    private boolean a(IlvRect ilvRect) {
        switch (this.getLayoutMode()) {
            case 2: 
            case 3: {
                return this.g() && this.b(ilvRect);
            }
            case 0: 
            case 1: {
                return this.h() && this.b(ilvRect);
            }
        }
        return false;
    }

    private boolean b(IlvRect ilvRect) {
        return this.ag != null && ilvRect.equals(this.ag);
    }

    private void b(String string, boolean bl) {
        this.ae = bl;
        if (!bl && string != null) {
            this.onParameterChanged(string);
        } else {
            this.setParametersUpToDate(bl);
        }
    }

    private final boolean g() {
        return this.ae;
    }

    private void b(boolean bl) {
        this.af = bl;
        this.setParametersUpToDate(bl);
    }

    private final boolean h() {
        return this.af;
    }

    private final void a(Graph graph, IlvRect ilvRect) {
        graph.transferLayoutOptions(ilvRect);
    }

    final void c() {
        if (this.ad) {
            return;
        }
        this.callLayoutStepPerformedIfNeeded();
        this.ad = this.isLayoutTimeElapsed() || this.isStoppedImmediately();
    }

    final boolean d() {
        return !this.ad;
    }

    static String b(int n2) {
        switch (n2) {
            case 0: {
                return "TILE_TO_ROWS";
            }
            case 1: {
                return "TILE_TO_COLUMNS";
            }
            case 2: {
                return "TILE_TO_GRID_FIXED_WIDTH";
            }
            case 3: {
                return "TILE_TO_GRID_FIXED_HEIGHT";
            }
        }
        throw new IllegalArgumentException("Wrong layout mode " + n2);
    }

    static int a(String string) {
        if (string.equals("TILE_TO_ROWS")) {
            return 0;
        }
        if (string.equals("TILE_TO_COLUMNS")) {
            return 1;
        }
        if (string.equals("TILE_TO_GRID_FIXED_WIDTH")) {
            return 2;
        }
        if (string.equals("TILE_TO_GRID_FIXED_HEIGHT")) {
            return 3;
        }
        throw new IllegalArgumentException("Wrong layout mode " + string);
    }

    private static class GraphOnMatrixImpl
    extends GraphOnMatrix {
        IlvGridLayout a = null;

        GraphOnMatrixImpl(IlvGridLayout ilvGridLayout) {
            super(ilvGridLayout);
            this.a = ilvGridLayout;
        }

        protected int getNodeIndex(Object object) {
            return this.a.getIndex(object);
        }

        protected int getHorizontalIndividualAlignment(Object object) {
            return this.a.getHorizontalAlignment(object);
        }

        protected int getVerticalIndividualAlignment(Object object) {
            return this.a.getVerticalAlignment(object);
        }

        protected boolean mayContinue() {
            return this.a.d();
        }

        protected void layoutStepPerformed() {
            this.a.c();
        }

        public void transferLayoutOptions(IlvRect ilvRect) {
            super.transferLayoutOptions(ilvRect);
            this.setIncrementalMode(this.a.isIncrementalMode());
            this.setGlobalHorizontalAlignment(this.a.getGlobalHorizontalAlignment());
            this.setGlobalVerticalAlignment(this.a.getGlobalVerticalAlignment());
            this.setNodeBoxInterface(this.a.getNodeBoxInterface());
            this.setHorizontalGridOffset(this.a.getHorizontalGridOffset());
            this.setVerticalGridOffset(this.a.getVerticalGridOffset());
            this.setTopMargin(this.a.getTopMargin());
            this.setBottomMargin(this.a.getBottomMargin());
            this.setRightMargin(this.a.getRightMargin());
            this.setLeftMargin(this.a.getLeftMargin());
            this.setLayoutMode(this.a.getLayoutMode());
            this.setNodeComparator(this.a.getNodeComparator());
            switch (this.a.getLayoutMode()) {
                case 2: {
                    this.setInvertedCoords(false);
                    this.setMaxDimension(ilvRect.width);
                    break;
                }
                case 3: {
                    this.setInvertedCoords(true);
                    this.setMaxDimension(ilvRect.height);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported layout mode: " + this.a.getLayoutMode());
                }
            }
        }
    }

    private class GraphOnRowsOrColumnsImp
    extends GraphOnRowsOrColumns {
        IlvGridLayout a;

        GraphOnRowsOrColumnsImp(IlvGridLayout ilvGridLayout2) {
            super(ilvGridLayout2);
            this.a = null;
            this.a = ilvGridLayout2;
        }

        protected int getNodeIndex(Object object) {
            return IlvGridLayout.this.getIndex(object);
        }

        protected int getHorizontalIndividualAlignment(Object object) {
            return this.a.getHorizontalAlignment(object);
        }

        protected int getVerticalIndividualAlignment(Object object) {
            return this.a.getVerticalAlignment(object);
        }

        public boolean isPreserveNodesOrder() {
            return this.a.getNodeComparator() != NO_ORDERING;
        }

        protected boolean mayContinue() {
            return this.a.d();
        }

        protected void layoutStepPerformed() {
            this.a.c();
        }

        public void transferLayoutOptions(IlvRect ilvRect) {
            super.transferLayoutOptions(ilvRect);
            this.setIncrementalMode(this.a.isIncrementalMode());
            this.setGlobalHorizontalAlignment(this.a.getGlobalHorizontalAlignment());
            this.setGlobalVerticalAlignment(this.a.getGlobalVerticalAlignment());
            this.setNodeBoxInterface(this.a.getNodeBoxInterface());
            this.setHGap(this.a.getLeftMargin() + this.a.getRightMargin());
            this.setVGap(this.a.getTopMargin() + this.a.getBottomMargin());
            this.setLayoutMode(this.a.getLayoutMode());
            this.setNodeComparator(this.a.getNodeComparator());
            switch (this.a.getLayoutMode()) {
                case 0: {
                    this.setInvertedCoords(false);
                    this.setMaxDimension(ilvRect.width);
                    break;
                }
                case 1: {
                    this.setInvertedCoords(true);
                    this.setMaxDimension(ilvRect.height);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported layout mode: " + this.a.getLayoutMode());
                }
            }
            this.setMaxNumberOfNodesPerRowOrColumn(this.a.getMaxNumberOfNodesPerRowOrColumn());
        }
    }
}

