/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerExpansionEvent;
import ilog.views.event.ManagerExpansionListener;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectLayerChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphlayout.internalutil.GenericLayoutUtil;
import ilog.views.graphlayout.internalutil.IlvLayerGraphicEnumeration;
import ilog.views.graphlayout.internalutil.IlvLayoutInterface;
import ilog.views.graphlayout.internalutil.IlvLayoutParamControlBlock;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IlvManagerAdapter
implements ManagerContentChangedListener,
ManagerLayerListener,
ManagerViewsChangedListener,
TransformerListener,
ManagerExpansionListener {
    public static final int DONT_FIRE_EVENT = -1;
    private static final String a = "This object has been disposed and cannot be used";
    private IlvManager b;
    private int c = 0;
    private IlvManagerView d;
    private IlvManagerView e;
    private IlvTransformer f;
    private IlvTransformer g;
    private IlvTransformer h = new IlvTransformer();
    private boolean i;
    private ObjectTranslator j = new ObjectTranslator();
    private int k;
    private IlvManagerView l;
    private IlvTransformer m;
    private IlvTransformer n;
    private int o;
    private static final Boolean p = Boolean.TRUE;
    private Vector q;
    private boolean r = true;
    private String s;
    private String t;

    public IlvManagerAdapter(IlvManager ilvManager, String string, String string2) {
        if (ilvManager == null) {
            throw new IllegalArgumentException("the manager argument cannot be null");
        }
        this.b = ilvManager;
        this.s = string;
        this.t = string2;
        this.a();
    }

    public IlvManager getManager() {
        return this.b;
    }

    protected abstract boolean isDefaultModelClass(Object var1);

    private void a() {
        this.b.removeManagerContentChangedListener(this);
        this.b.addManagerContentChangedListener(this);
        this.b.removeManagerLayerListener(this);
        this.b.addManagerLayerListener(this);
        this.b.removeManagerViewsListener(this);
        this.b.addManagerViewsListener(this);
        this.b.removeManagerExpansionListener(this);
        this.b.addManagerExpansionListener(this);
        Enumeration enumeration = this.b.getViews();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                ilvManagerView.removeTransformerListener(this);
                ilvManagerView.addTransformerListener(this);
            }
        }
    }

    private void b() {
        this.b.removeManagerContentChangedListener(this);
        this.b.removeManagerLayerListener(this);
        this.b.removeManagerViewsListener(this);
        this.b.removeManagerExpansionListener(this);
        Enumeration enumeration = this.b.getViews();
        while (enumeration.hasMoreElements()) {
            IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
            ilvManagerView.removeTransformerListener(this);
        }
    }

    public final void dispose() {
        if (this.q != null) {
            for (int i2 = 0; i2 < this.q.size(); ++i2) {
                ((IlvManagerLayer)this.q.elementAt(i2)).setProperty(this.t, null);
            }
            this.q = null;
        }
        if (this.b != null) {
            this.b();
            this.b = null;
        }
        this.e = null;
        this.f = null;
        this.g = null;
        this.d = null;
        this.l = null;
        this.m = null;
        this.n = null;
    }

    public final void clean(IlvLayoutInterface ilvLayoutInterface) {
        this.c(ilvLayoutInterface);
    }

    public void moveObject(Object object, float f2, float f3, boolean bl) {
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        IlvGraphic ilvGraphic = (IlvGraphic)object;
        switch (this.getCoordinatesMode()) {
            case 0: {
                IlvTransformer ilvTransformer = this.getReferenceTransformer();
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    IlvRect ilvRect = ilvGraphic.boundingBox(null);
                    IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
                    ilvTransformer.inverse(ilvRect2);
                    f2 -= ilvRect2.x - ilvRect.x;
                    f3 -= ilvRect2.y - ilvRect.y;
                }
                this.b.moveObject(ilvGraphic, f2, f3, bl);
                break;
            }
            case 1: {
                this.b.moveObject(ilvGraphic, f2, f3, bl);
                break;
            }
            case 2: {
                IlvTransformer ilvTransformer = this.getReferenceTransformer();
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
                    float f4 = (float)((double)(f2 - ilvRect.x) / ilvTransformer.zoomXFactor());
                    float f5 = (float)((double)(f3 - ilvRect.y) / ilvTransformer.zoomYFactor());
                    this.j.a(ilvGraphic, f4, f5, bl);
                    break;
                }
                this.b.moveObject(ilvGraphic, f2, f3, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
            }
        }
    }

    public IlvRect boundingBox(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (!(object instanceof IlvGraphic)) {
            throw new IllegalArgumentException("Unexpected object type: " + object.getClass());
        }
        IlvGraphic ilvGraphic = (IlvGraphic)object;
        switch (this.getCoordinatesMode()) {
            case 0: {
                return GenericLayoutUtil.BoundingBox(ilvGraphic, this.getReferenceTransformer());
            }
            case 1: {
                return ilvGraphic.boundingBox(null);
            }
            case 2: {
                return ilvGraphic.boundingBox(this.getReferenceTransformer());
            }
        }
        throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
    }

    public boolean isLayoutNeeded(IlvLayoutInterface ilvLayoutInterface) {
        StateDescription stateDescription = this.a(this.b(ilvLayoutInterface));
        if (stateDescription == null) {
            return true;
        }
        int n2 = ilvLayoutInterface.getCoordinatesMode();
        if (n2 != stateDescription.b()) {
            return true;
        }
        if (n2 == 1) {
            return false;
        }
        IlvTransformer ilvTransformer = this.getReferenceTransformer();
        IlvTransformer ilvTransformer2 = stateDescription.a();
        if (ilvTransformer == null) {
            return ilvTransformer2 != null;
        }
        if (ilvTransformer2 == null) {
            return true;
        }
        return ilvTransformer.getx11() != ilvTransformer2.getx11() || ilvTransformer.getx12() != ilvTransformer2.getx12() || ilvTransformer.getx21() != ilvTransformer2.getx21() || ilvTransformer.getx22() != ilvTransformer2.getx22();
    }

    public void beforeLayout(IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        ilvLayoutInterface.setOriginalCoordModeOfModel(this.getCoordinatesMode());
        this.c = ilvLayoutInterface.getCoordinatesMode();
        this.g = null;
        this.i = true;
        if (this.b != null) {
            this.b.setContentsAdjusting(true);
            if (this.o < 0) {
                throw new RuntimeException("negative layout start counter: " + this.o);
            }
            if (this.o == 0) {
                this.prepareManager(this.b, ilvLayoutInterface, bl);
            }
            ++this.o;
        }
    }

    protected void prepareManager(IlvManager ilvManager, IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (bl && ilvManager != null && ilvLayoutInterface != null && ilvLayoutInterface.getLayout() != null) {
            ilvManager.initReDraws();
        }
    }

    public void afterLayout(IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (this.b != null) {
            this.b.setContentsAdjusting(false);
            --this.o;
            if (this.o < 0) {
                throw new RuntimeException("negative start layout count");
            }
            if (this.o == 0) {
                this.redrawAfterLayout(this.b, ilvLayoutInterface, bl);
            }
            this.a(ilvLayoutInterface);
        }
        this.c = ilvLayoutInterface.getOriginalCoordModeOfModel();
        this.g = null;
        this.i = false;
    }

    protected void redrawAfterLayout(IlvManager ilvManager, IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (ilvManager != null && bl) {
            ilvManager.reDrawViews();
        }
    }

    private void a(IlvLayoutInterface ilvLayoutInterface) {
        String string = this.b(ilvLayoutInterface);
        StateDescription stateDescription = this.a(string);
        if (stateDescription == null) {
            stateDescription = new StateDescription();
            this.a(string, stateDescription);
        }
        stateDescription.a(this.getReferenceTransformer(), ilvLayoutInterface.getCoordinatesMode());
    }

    private StateDescription a(String string) {
        return (StateDescription)this.b(string);
    }

    private void a(String string, StateDescription stateDescription) {
        this.a(string, (Object)stateDescription);
    }

    private String b(IlvLayoutInterface ilvLayoutInterface) {
        return this.s + "L" + ilvLayoutInterface.getInstanceId();
    }

    private void c(IlvLayoutInterface ilvLayoutInterface) {
        String string = this.b(ilvLayoutInterface);
        this.a(string, (Object)null);
    }

    public final void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 4: {
                IlvGraphic ilvGraphic = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectGeometryChanged(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 1: {
                IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectAdded(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 2: {
                IlvGraphic ilvGraphic = ((ObjectRemovedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectRemoved(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 16: {
                boolean bl;
                ObjectLayerChangedEvent objectLayerChangedEvent;
                IlvGraphic ilvGraphic;
                if (this.q == null || (ilvGraphic = (objectLayerChangedEvent = (ObjectLayerChangedEvent)managerContentChangedEvent).getGraphicObject()) == null) break;
                boolean bl2 = objectLayerChangedEvent.getOldLayer().getProperty(this.t) != null;
                boolean bl3 = bl = objectLayerChangedEvent.getNewLayer().getProperty(this.t) != null;
                if (bl2 == bl) break;
                if (bl) {
                    this.objectMovedFromNonUsedToUsedLayer(ilvGraphic, managerContentChangedEvent.isAdjusting());
                    break;
                }
                this.objectMovedFromUsedToNonUsedLayer(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 32: {
                this.adjustmentEnd();
            }
        }
    }

    public final void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
    }

    private void a(IlvManagerView ilvManagerView) {
        if (this.b == null || ilvManagerView == null) {
            return;
        }
        ilvManagerView.addTransformerListener(this);
        if (this.f != null || this.e != null) {
            return;
        }
        this.d = this.a(this.b);
        if (this.d != null && this.d != ilvManagerView) {
            return;
        }
        this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
    }

    private void b(IlvManagerView ilvManagerView) {
        if (ilvManagerView == null) {
            return;
        }
        ilvManagerView.removeTransformerListener(this);
        if (this.b == null) {
            return;
        }
        if (this.f != null || this.e != null) {
            return;
        }
        if (this.d == ilvManagerView || this.d == null) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
        }
        this.d = this.a(this.b);
    }

    public final void viewChanged(ManagerViewsChangedEvent managerViewsChangedEvent) {
        if (managerViewsChangedEvent.getType() == 1) {
            this.a(managerViewsChangedEvent.getManagerView());
        } else if (managerViewsChangedEvent.getType() == 2) {
            this.b(managerViewsChangedEvent.getManagerView());
        }
    }

    public final void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
    }

    public final void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
        IlvManagerLayer ilvManagerLayer = managerLayerRemovedEvent.getLayer();
        this.a(ilvManagerLayer, false);
    }

    public final void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
    }

    public final void layerChanged(ManagerLayerEvent managerLayerEvent) {
    }

    public void managerCollapsed(ManagerExpansionEvent managerExpansionEvent) {
    }

    public void managerExpanded(ManagerExpansionEvent managerExpansionEvent) {
    }

    private void a(String string, Object object) {
        this.b.setProperty(string, object);
    }

    private Object b(String string) {
        return this.b.getProperty(string);
    }

    protected abstract int getCoordinatesMode();

    public void setCoordinatesModeInternal(int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("Unsupported coordinates mode: " + n2);
        }
        if (this.c != n2) {
            this.c = n2;
            this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
        }
    }

    public int getCoordinatesModeInternal() {
        return this.c;
    }

    protected abstract IlvTransformer getReferenceTransformer();

    public void setReferenceTransformerInternal(IlvTransformer ilvTransformer) {
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        IlvTransformer ilvTransformer2 = this.f;
        this.f = ilvTransformer;
        this.e = null;
        this.g = null;
        if (ilvTransformer2 != ilvTransformer) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
        }
    }

    public IlvTransformer getReferenceTransformerInternal() {
        if (this.f != null) {
            return this.f;
        }
        if (this.i && this.g != null) {
            return this.g;
        }
        if (this.e == null) {
            if (this.b == null) {
                throw new RuntimeException(a);
            }
            this.d = this.a(this.b);
            if (this.d == null) {
                this.h.setValues(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                this.g = this.h;
            } else {
                this.g = this.b.getDrawingTransformer(this.d);
            }
        } else {
            this.g = this.b.getDrawingTransformer(this.e);
        }
        return this.g;
    }

    public void setReferenceView(IlvManagerView ilvManagerView) {
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        IlvManagerView ilvManagerView2 = this.e;
        this.e = ilvManagerView;
        this.f = null;
        this.g = this.b.getDrawingTransformer(ilvManagerView);
        if (ilvManagerView2 != ilvManagerView) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), this.b.isContentsAdjusting());
        }
    }

    public IlvManagerView getReferenceView() {
        return this.e;
    }

    private final IlvManagerView a(IlvManager ilvManager) {
        if (ilvManager == null) {
            return null;
        }
        Enumeration enumeration = ilvManager.getViews();
        if (enumeration.hasMoreElements()) {
            return (IlvManagerView)enumeration.nextElement();
        }
        return this.a(ilvManager.getParent());
    }

    public final void saveAndEnableViewCoordinates(IlvManager ilvManager, IlvManagerView ilvManagerView) {
        this.k = this.c;
        this.l = this.e;
        this.m = this.f;
        this.n = this.g;
        if (ilvManagerView == null) {
            ilvManagerView = this.a(ilvManager);
        }
        if (ilvManagerView == null) {
            this.e = null;
            this.f = this.getManager().getTopLevelTransformer();
            this.g = null;
        } else {
            this.e = ilvManagerView;
            this.f = null;
            this.g = null;
        }
        this.c = 2;
    }

    public final void restoreAndDisableViewCoordinates() {
        this.c = this.k;
        this.e = this.l;
        this.f = this.m;
        this.g = this.n;
    }

    public void addLayer(IlvManagerLayer ilvManagerLayer) {
        if (ilvManagerLayer == null) {
            throw new IllegalArgumentException("layer cannot be null");
        }
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        if (ilvManagerLayer.getManager() != this.b) {
            throw new IllegalArgumentException("the layer " + ilvManagerLayer.getIndex() + " is not in the encapsulated IlvManager: " + this.b + " but in " + ilvManagerLayer.getManager());
        }
        boolean bl = false;
        if (this.q == null) {
            this.q = new Vector(20, 20);
            bl = true;
        } else if (this.q.contains(ilvManagerLayer)) {
            return;
        }
        this.q.addElement(ilvManagerLayer);
        ilvManagerLayer.setProperty(this.t, p);
        if (bl) {
            if (this.r) {
                int n2 = this.b.getLayersCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    IlvManagerLayer ilvManagerLayer2 = this.b.getManagerLayer(i2);
                    if (ilvManagerLayer2 == ilvManagerLayer) continue;
                    this.b(ilvManagerLayer2, false);
                }
            }
        } else {
            this.b(ilvManagerLayer, true);
        }
    }

    public final boolean removeLayer(IlvManagerLayer ilvManagerLayer) {
        return this.a(ilvManagerLayer, true);
    }

    private boolean a(IlvManagerLayer ilvManagerLayer, boolean bl) {
        if (ilvManagerLayer == null) {
            throw new IllegalArgumentException("layer cannot be null");
        }
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        if (this.q == null || this.q.size() == 0) {
            return false;
        }
        if (bl && ilvManagerLayer.getManager() != this.b) {
            throw new IllegalArgumentException("the layer " + ilvManagerLayer.getIndex() + " is not in the encapsulated IlvManager: " + this.b + " but in " + ilvManagerLayer.getManager());
        }
        ilvManagerLayer.setProperty(this.t, null);
        if (this.q.size() == 1 && this.q.contains(ilvManagerLayer)) {
            this.removeAllLayers();
            return true;
        }
        if (this.q.remove(ilvManagerLayer)) {
            this.b(ilvManagerLayer, false);
            return true;
        }
        return false;
    }

    public boolean removeAllLayers() {
        IlvManagerLayer ilvManagerLayer;
        if (this.b == null) {
            throw new RuntimeException(a);
        }
        if (this.q == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.q.size(); ++i2) {
            ilvManagerLayer = (IlvManagerLayer)this.q.elementAt(i2);
            ilvManagerLayer.setProperty(this.t, null);
        }
        Vector vector = this.q;
        this.q = null;
        if (this.r) {
            int n2 = this.b.getLayersCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                ilvManagerLayer = this.b.getManagerLayer(i3);
                if (vector.contains(ilvManagerLayer)) continue;
                this.b(ilvManagerLayer, true);
            }
        } else {
            this.fireModelEvent(null, this.getStructureChangedEventType(), this.b.isContentsAdjusting());
        }
        return true;
    }

    public final Enumeration getLayers() {
        return this.q != null ? this.q.elements() : null;
    }

    public final int getLayersCount() {
        return this.q != null ? this.q.size() : 0;
    }

    public final boolean isLayerAdded(IlvManagerLayer ilvManagerLayer) {
        if (this.getLayersCount() == 0) {
            return false;
        }
        return this.q.contains(ilvManagerLayer);
    }

    public final IlvGraphicEnumeration getObjectsOnLayers() {
        return this.getLayersCount() > 0 ? new IlvLayerGraphicEnumeration(this.b, this.q) : null;
    }

    public final boolean isManaged(IlvGraphic ilvGraphic) {
        if (ilvGraphic.getGraphicBag() != this.b) {
            return false;
        }
        return this.isOnLayers(ilvGraphic);
    }

    public final boolean isOnLayers(IlvGraphic ilvGraphic) {
        if (this.getLayersCount() > 0) {
            IlvManagerLayer ilvManagerLayer = this.b.getManagerLayer(ilvGraphic);
            if (ilvManagerLayer == null) {
                throw new RuntimeException("graphic object " + ilvGraphic + " is not contained in a layer of " + this.b);
            }
            if (ilvManagerLayer.getProperty(this.t) == null) {
                return false;
            }
        }
        return true;
    }

    private void b(IlvManagerLayer ilvManagerLayer, boolean bl) {
        if (this.r) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManagerLayer.getElements();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (ilvGraphic == null) continue;
                if (bl) {
                    this.objectAdded(ilvGraphic, true);
                    continue;
                }
                this.objectRemoved(ilvGraphic, true);
            }
            if (!this.b.isContentsAdjusting()) {
                this.adjustmentEnd();
            }
        } else {
            this.fireModelEvent(null, this.getStructureChangedEventType(), this.b.isContentsAdjusting());
        }
    }

    public void setFullLayerNotification(boolean bl) {
        this.r = bl;
    }

    public final boolean isFullLayerNotification() {
        return this.r;
    }

    protected void objectAdded(Object object, boolean bl) {
        int n2 = this.getEventTypeWhenAdding(object);
        if (n2 != -1) {
            this.fireModelEvent(object, n2, bl);
        }
    }

    protected void objectRemoved(Object object, boolean bl) {
        int n2 = this.getEventTypeWhenRemoving(object);
        if (n2 != -1) {
            this.fireModelEvent(object, n2, bl);
        }
    }

    protected final void objectMovedFromNonUsedToUsedLayer(Object object, boolean bl) {
        this.objectAdded(object, bl);
    }

    protected final void objectMovedFromUsedToNonUsedLayer(Object object, boolean bl) {
        this.objectRemoved(object, bl);
    }

    protected final void objectGeometryChanged(Object object, boolean bl) {
        int n2 = this.getEventTypeWhenChangingGeometry(object);
        if (n2 != -1) {
            this.fireModelEvent(object, n2, bl);
        }
    }

    protected abstract int getStructureChangedEventType();

    protected abstract int getGeometryChangedEventType();

    protected abstract int getEventTypeWhenAdding(Object var1);

    protected abstract int getEventTypeWhenRemoving(Object var1);

    protected abstract int getEventTypeWhenChangingGeometry(Object var1);

    protected abstract void fireModelEvent(Object var1, int var2, boolean var3);

    protected abstract void adjustmentEnd();

    protected abstract Object allocateLayoutClass(String var1);

    protected abstract void attachIfNotAlreadyAttached(Object var1);

    protected abstract void createLayoutProperties(Object var1, String var2, boolean var3);

    public String saveParametersToNamedProperties(IlvLayoutInterface ilvLayoutInterface, String string, boolean bl) {
        if (!ilvLayoutInterface.supportsSaveParametersToNamedProperties()) {
            throw new RuntimeException("this layout class does not support saving parameters to named properties");
        }
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.GetOrCreate(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        Object object = ilvLayoutInterface.getLayout();
        String string2 = ilvLayoutParamControlBlock.push(string, object);
        Object object2 = ilvLayoutInterface.getModel();
        ilvManager.setNamedProperty(ilvLayoutInterface.createLayoutManagerProperty(string2, bl));
        if (!this.isDefaultModelClass(object2)) {
            return string2;
        }
        this.createLayoutProperties(object, string2, bl);
        return string2;
    }

    public Object loadParametersInternal(IlvLayoutInterface ilvLayoutInterface, String string) {
        String string2;
        Object object;
        Object object2 = object = ilvLayoutInterface != null ? ilvLayoutInterface.getLayout() : null;
        if (string == null && object == null) {
            throw new IllegalArgumentException("layout and propertyPrefix cannot be both null");
        }
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        String string3 = string2 = string != null && string.length() > 0 ? ilvLayoutParamControlBlock.searchLayoutId(string) : ilvLayoutParamControlBlock.searchLayoutId(object.getClass());
        if (string2 != null) {
            if (object == null) {
                object = this.allocateLayoutClass(ilvLayoutParamControlBlock.getLayoutName(string2));
            }
            if (object == null) {
                return null;
            }
            this.attachIfNotAlreadyAttached(object);
            this.transferNamedPropertyToLayout(string2, ilvManager, object);
            ilvLayoutParamControlBlock.remove(string2);
            if (ilvLayoutParamControlBlock.isEmpty()) {
                IlvLayoutParamControlBlock.Remove(ilvManager);
            }
            return object;
        }
        return null;
    }

    public void removeParametersFromNamedProperties() {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String[] stringArray = ilvLayoutParamControlBlock.getAllLayoutIds();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.removeNamedPropertyFromManager(stringArray[i2])) continue;
            ilvLayoutParamControlBlock.remove(stringArray[i2]);
        }
        if (ilvLayoutParamControlBlock.isEmpty()) {
            IlvLayoutParamControlBlock.Remove(ilvManager);
        }
    }

    public void removeParametersFromNamedProperties(String string) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String string2 = ilvLayoutParamControlBlock.searchLayoutId(string);
        if (string2 != null) {
            if (this.removeNamedPropertyFromManager(string2)) {
                ilvLayoutParamControlBlock.remove(string2);
            }
            if (ilvLayoutParamControlBlock.isEmpty()) {
                IlvLayoutParamControlBlock.Remove(ilvManager);
            }
        }
    }

    public void removeParametersFromNamedProperties(Class clazz) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String string = ilvLayoutParamControlBlock.searchLayoutId(clazz);
        while (string != null) {
            if (this.removeNamedPropertyFromManager(string)) {
                ilvLayoutParamControlBlock.remove(string);
            }
            string = ilvLayoutParamControlBlock.searchLayoutId(clazz);
        }
        if (ilvLayoutParamControlBlock.isEmpty()) {
            IlvLayoutParamControlBlock.Remove(ilvManager);
        }
    }

    protected abstract void transferNamedPropertyToLayout(String var1, IlvManager var2, Object var3);

    protected abstract boolean removeNamedPropertyFromManager(String var1);

    public String toString() {
        return super.toString() + " [" + this.getManager() + "]";
    }

    private class ObjectTranslator
    implements IlvApplyObject {
        private float a;
        private float b;

        private ObjectTranslator() {
        }

        public final void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.translate(this.a, this.b);
        }

        final void a(IlvGraphic ilvGraphic, float f2, float f3, boolean bl) {
            this.a = f2;
            this.b = f3;
            IlvManagerAdapter.this.b.applyToObject(ilvGraphic, this, null, bl);
        }
    }

    private static class StateDescription {
        private IlvTransformer a;
        private int b;

        private StateDescription() {
        }

        void a(IlvTransformer ilvTransformer, int n2) {
            this.a = ilvTransformer;
            this.b = n2;
        }

        IlvTransformer a() {
            return this.a;
        }

        int b() {
            return this.b;
        }
    }
}

