/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.internalutil.IlvUnsyncVector;
import ilog.views.graphlayout.internalutil.SubgraphData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class LayoutUtil
implements Serializable {
    public static final String ONLY_FOR_GRAPHER_METHOD = "This method can be called only if the attached graph is " + LayoutUtil.getText("an IlvGrapher or IlvGrapherAdapter", "a GraphicContainer or GraphicContainerAdapter");
    public static final String NO_ATTACHED_GRAPH_MODEL_OR_NULL = "no attached graph model or graph model is null";
    public static final String NODE_NOT_IN_GRAPHER = "node must be a node in the attached " + LayoutUtil.getText("grapher", "graphic container");
    public static final String NODE_REJECTED_BY_FILTER = "node must be a node which is accepted by the filtering mechanism";
    public static final String MUST_BE_CALLED_AFTER_LAYOUT = "you must call this method after the layout is performed on the current graph";
    private static final double a = Math.PI;
    private static final double b = Math.PI * 2;
    private static final float c = Float.MAX_VALUE;
    private static final float d = Float.POSITIVE_INFINITY;
    private static final float e = Float.NEGATIVE_INFINITY;
    private static final Enumeration f = new IlvVoidEnumeration();
    private static final IlvGraphicEnumeration g = new IlvVoidGraphicEnumeration();

    public static final boolean IsValidNumber(float f2, float f3) {
        return f2 < Float.MAX_VALUE && -f2 < Float.MAX_VALUE && f3 < Float.MAX_VALUE && -f3 < Float.MAX_VALUE && f2 != Float.POSITIVE_INFINITY && f2 != Float.NEGATIVE_INFINITY && f3 != Float.POSITIVE_INFINITY && f3 != Float.NEGATIVE_INFINITY && !Float.isNaN(f2) && !Float.isNaN(f3);
    }

    public static void CheckAppropriateLinks(IlvGraphLayout ilvGraphLayout, Enumeration enumeration) throws IlvInappropriateLinkException {
        LayoutUtil.CheckAppropriateLinks(ilvGraphLayout, enumeration, null);
    }

    public static void CheckAppropriateLinks(IlvGraphLayout ilvGraphLayout, Enumeration enumeration, Enumeration enumeration2) throws IlvInappropriateLinkException {
        boolean bl;
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            throw new RuntimeException(NO_ATTACHED_GRAPH_MODEL_OR_NULL);
        }
        boolean bl2 = ilvGraphModel.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel.isConnectionPointCheckEnabled();
        boolean bl4 = bl = ilvGraphLayout.supportsPreserveFixedLinks() && ilvGraphLayout.isPreserveFixedLinks();
        if (bl2 || bl3) {
            Object e2;
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (bl && ilvGraphLayout.isFixed(e2)) continue;
                n2 |= ilvGraphLayout.checkAppropriateLink(e2);
            }
            if (enumeration2 != null) {
                while (enumeration2.hasMoreElements()) {
                    e2 = enumeration2.nextElement();
                    if (bl && ilvGraphLayout.isFixed(e2)) continue;
                    n2 |= ilvGraphLayout.checkAppropriateLink(e2);
                }
            }
            if (n2 != 0) {
                throw new IlvInappropriateLinkException(ilvGraphModel instanceof SubgraphData ? ((SubgraphData)ilvGraphModel).getOriginalModel() : ilvGraphModel, ilvGraphLayout, n2);
            }
        }
    }

    public static int CheckAppropriateLinkConnection(Object object, IlvGraphModel ilvGraphModel) {
        int n2 = 0;
        if (ilvGraphModel.isConnectionPointCheckEnabled()) {
            if (!ilvGraphModel.hasMoveableConnectionPoint(object, true)) {
                n2 |= 4;
                n2 |= 0x20;
            }
            if (!ilvGraphModel.hasMoveableConnectionPoint(object, false)) {
                n2 |= 4;
                n2 |= 0x20;
            }
        }
        return n2;
    }

    public static IlvGraphicVector getDefaultMovingNodes(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
            IlvGrapher ilvGrapher = ilvGraphModel.getGrapher();
            Enumeration enumeration = ilvGraphModel.getNodes();
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic;
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof IlvGraphic) || (ilvGraphic = (IlvGraphic)e2).getGraphicBag() != ilvGrapher) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
            return ilvGraphicVector.size() > 0 ? ilvGraphicVector : null;
        }
        return null;
    }

    public static Object ElementAt(IlvUnsyncVector ilvUnsyncVector, int n2, int n3, boolean bl) {
        return bl ? ilvUnsyncVector.elementAt(n3 - n2 - 1) : ilvUnsyncVector.elementAt(n2);
    }

    public static final float getValueInManagerCoordinates(float f2, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            return f2;
        }
        double d2 = ilvTransformer.zoomFactor();
        if (d2 == 0.0) {
            throw new RuntimeException("Zoom factor is not allowed to be zero. Transformer on reference view: " + ilvTransformer);
        }
        return (float)((double)f2 / d2);
    }

    public static final boolean IsEmpty(IlvGraphModel ilvGraphModel) {
        Enumeration enumeration = ilvGraphModel.getNodes();
        return enumeration == null ? true : !enumeration.hasMoreElements();
    }

    public static final IlvRect BoundingBox(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            return ilvGraphic.boundingBox(null);
        }
        IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
        ilvTransformer.inverse(ilvRect);
        return ilvRect;
    }

    public static final IlvRect BoundingBox(IlvGraphModel ilvGraphModel, Enumeration enumeration, IlvRect ilvRect) {
        ilvRect.reshape(0.0f, 0.0f, 0.0f, 0.0f);
        if (!enumeration.hasMoreElements()) {
            return ilvRect;
        }
        Object e2 = enumeration.nextElement();
        IlvRect ilvRect2 = ilvGraphModel.boundingBox(e2);
        ilvRect.reshape(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height);
        while (enumeration.hasMoreElements()) {
            LayoutUtil.a(ilvRect, ilvGraphModel.boundingBox(enumeration.nextElement()));
        }
        return ilvRect;
    }

    private static void a(IlvRect ilvRect, IlvRect ilvRect2) {
        double d2 = ilvRect.x;
        double d3 = ilvRect2.x;
        double d4 = d2 < d3 ? d2 : d3;
        double d5 = d2 > d3 ? (d2 += (double)ilvRect.width) : (d3 += (double)ilvRect2.width);
        d2 = ilvRect.y;
        d3 = ilvRect2.y;
        double d6 = d2 < d3 ? d2 : d3;
        double d7 = d2 > d3 ? (d2 += (double)ilvRect.height) : (d3 += (double)ilvRect2.height);
        ilvRect.x = (float)d4;
        ilvRect.y = (float)d6;
        ilvRect.width = (float)(d5 - d4);
        ilvRect.height = (float)(d7 - d6);
    }

    public static final double getDistance(double d2, double d3) {
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public static final float getDiagonal(Object object, IlvGraphModel ilvGraphModel) {
        IlvRect ilvRect = ilvGraphModel.boundingBox(object);
        return (float)Math.sqrt(ilvRect.width * ilvRect.width + ilvRect.height * ilvRect.height);
    }

    public static final double getEqualSidesTriangleAngle(float f2, float f3) {
        return f2 == 0.0f ? 0.0 : (f3 <= 2.0f * f2 ? 2.0 * Math.asin(f3 / (2.0f * f2)) : 0.0);
    }

    public static final double Angle(float f2, float f3, float f4, float f5) {
        double d2;
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        if (f6 == 0.0f && f7 == 0.0f) {
            return 0.0;
        }
        if (f6 >= 0.0f && f7 >= 0.0f) {
            d2 = 0.0;
        } else if (f6 < 0.0f && f7 < 0.0f) {
            d2 = Math.PI;
        } else if (f6 < 0.0f) {
            float f8 = f6;
            f6 = f7;
            f7 = -f8;
            d2 = 1.5707963267948966;
        } else {
            float f9 = f6;
            f6 = -f7;
            f7 = f9;
            d2 = 4.71238898038469;
        }
        d2 = f6 == 0.0f ? (d2 += 1.5707963267948966) : (f7 == 0.0f ? (d2 += 0.0) : (f6 < f7 ? (d2 += Math.atan((double)f7 / (double)f6)) : (d2 += 1.5707963267948966 - Math.atan((double)f6 / (double)f7))));
        LayoutUtil.CorrectAngle(d2);
        return d2;
    }

    public static final double CorrectAngle(double d2) {
        if (d2 < 0.0) {
            while ((d2 += Math.PI * 2) < 0.0) {
            }
            return d2;
        }
        if (d2 > Math.PI * 2) {
            while ((d2 -= Math.PI * 2) > Math.PI * 2) {
            }
            return d2;
        }
        return d2;
    }

    public static final double GetOrientedDeltaAlpha(double d2, double d3) {
        if (d3 < 0.0 || d2 < 0.0 || d3 > Math.PI * 2 || d2 > Math.PI * 2) {
            throw new IllegalArgumentException("angle must be from zero to 2pi");
        }
        return d3 <= d2 ? d2 - d3 : Math.PI * 2 - d3 + d2;
    }

    public static final double GetOrientedDeltaAlpha1(double d2, double d3) {
        double d4;
        double d5 = d4 = d3 <= d2 ? d2 - d3 : Math.PI * 2 - d3 + d2;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        return d4 < Math.PI ? d4 : Math.PI;
    }

    public static final double GetDeltaAlpha(double d2, double d3) {
        double d4;
        double d5 = d2 - d3;
        if (d5 < 0.0) {
            d5 = -d5;
        }
        double d6 = d5 < (d4 = Math.PI * 2 - d5) ? d5 : d4;
        return d6 > 0.0 ? d6 : -d6;
    }

    public static final boolean Intersects(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4) {
        return LayoutUtil.Intersects(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, ilvPoint4.x, ilvPoint4.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean Intersects(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n2 = LayoutUtil.GetTripletOrientation(f2, f3, f4, f5, f6, f7);
        int n3 = LayoutUtil.GetTripletOrientation(f2, f3, f4, f5, f8, f9);
        int n4 = LayoutUtil.GetTripletOrientation(f6, f7, f8, f9, f2, f3);
        int n5 = LayoutUtil.GetTripletOrientation(f6, f7, f8, f9, f4, f5);
        if (n2 * n3 == -1) {
            if (n4 * n5 == -1) return true;
        }
        if (n2 != 0) return false;
        if (n3 != 0) return false;
        if (n4 != 0) return false;
        if (n5 != 0) return false;
        if (!(f2 > (f6 < f8 ? f6 : f8)) || !(f2 < (f6 > f8 ? f6 : f8))) {
            float f10 = f2 < f4 ? f2 : f4;
            if (!(f6 > f10)) return false;
            float f11 = f2 > f4 ? f2 : f4;
            if (!(f6 < f11)) return false;
        }
        float f12 = f7 < f9 ? f7 : f9;
        if (f3 > f12) {
            if (f3 < (f7 > f9 ? f7 : f9)) return true;
        }
        float f13 = f3 < f5 ? f3 : f5;
        if (!(f7 > f13)) return false;
        float f14 = f3 > f5 ? f3 : f5;
        if (!(f7 < f14)) return false;
        return true;
    }

    public static boolean IntersectsOrthogonal(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4) {
        return LayoutUtil.IntersectsOrthogonal(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, ilvPoint4.x, ilvPoint4.y);
    }

    public static boolean IntersectsOrthogonal(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        boolean bl;
        boolean bl2 = f3 == f5;
        boolean bl3 = bl = f7 == f9;
        if (bl2) {
            if (!bl) {
                float f10 = f7 <= f9 ? f7 : f9;
                if (f10 < f3) {
                    float f11 = f7 >= f9 ? f7 : f9;
                    if (f11 > f3) {
                        float f12 = f2 <= f4 ? f2 : f4;
                        if (f12 < f6) {
                            float f13 = f2 >= f4 ? f2 : f4;
                            if (f13 > f6) {
                                return true;
                            }
                        }
                    }
                }
            }
            if (f3 == f7) {
                return LayoutUtil.OverlappingCoords(f2, f4, f6, f8, 0.0f, 0.0f);
            }
        } else {
            if (bl) {
                float f14 = f6 <= f8 ? f6 : f8;
                if (f14 < f2) {
                    float f15 = f6 >= f8 ? f6 : f8;
                    if (f15 > f2) {
                        float f16 = f3 <= f5 ? f3 : f5;
                        if (f16 < f7) {
                            float f17 = f3 >= f5 ? f3 : f5;
                            if (f17 > f7) {
                                return true;
                            }
                        }
                    }
                }
            }
            if (f2 == f6) {
                return LayoutUtil.OverlappingCoords(f3, f5, f7, f9, 0.0f, 0.0f);
            }
        }
        return false;
    }

    public static boolean OverlappingCoords(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9;
        float f10;
        float f11;
        if (f2 < f3) {
            f11 = f2;
            f10 = f3;
        } else {
            f11 = f3;
            f10 = f2;
        }
        if (f6 != 0.0f) {
            f11 -= f6;
            f10 += f6;
        }
        if (f4 < f5) {
            f9 = f4;
            f8 = f5;
        } else {
            f9 = f5;
            f8 = f4;
        }
        if (f7 != 0.0f) {
            f9 -= f7;
            f8 += f7;
        }
        return f11 >= f9 && f11 < f8 || f10 > f9 && f10 < f8 || f9 >= f11 && f9 < f10 || f8 > f11 && f8 < f10;
    }

    public static final int GetTripletOrientation(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2 * f5 - f4 * f3 + f6 * f3 - f2 * f7 + f4 * f7 - f6 * f5;
        if (f8 > 0.0f) {
            return -1;
        }
        if (f8 < 0.0f) {
            return 1;
        }
        return 0;
    }

    public static final String GetExceptionMessage(IlvGraphic ilvGraphic, String string) {
        return ilvGraphic != null ? "Object " + ilvGraphic + " " + string : "Object cannot be null";
    }

    public static final IlvRect GetEstimatedLayoutRegion(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        Enumeration enumeration = ilvGraphModel.getNodes();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (enumeration.hasMoreElements()) {
            IlvRect ilvRect = ilvGraphModel.boundingBox(enumeration.nextElement());
            d2 += (double)ilvRect.width;
            d3 += (double)ilvRect.height;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        double d4 = 2.0 / Math.sqrt(n2);
        float f2 = (float)(d2 * d4);
        float f3 = (float)(d3 * d4);
        float f4 = 0.0f;
        float f5 = 0.0f;
        return new IlvRect(f4, f5, f2, f3);
    }

    public static final void Clip(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        dArray[0] = ilvPoint.x;
        dArray[1] = ilvPoint.y;
        dArray2[0] = ilvPoint2.x;
        dArray2[1] = ilvPoint2.y;
        dArray3[0] = ilvRect.x;
        dArray3[1] = ilvRect.x + ilvRect.width;
        dArray3[2] = ilvRect.y;
        dArray3[3] = ilvRect.y + ilvRect.height;
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        ilvPoint.x = (float)dArray[0];
        ilvPoint.y = (float)dArray[1];
    }

    public static final void Clip(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = LayoutUtil.RayAtX(dArray, dArray2, dArray3[0]);
        if (d2 != Double.MAX_VALUE && LayoutUtil.a(dArray3[2], dArray3[3], d2)) {
            dArray[0] = dArray3[0];
            dArray[1] = d2;
            return;
        }
        d2 = LayoutUtil.RayAtX(dArray, dArray2, dArray3[1]);
        if (d2 != Double.MAX_VALUE && LayoutUtil.a(dArray3[2], dArray3[3], d2)) {
            dArray[0] = dArray3[1];
            dArray[1] = d2;
            return;
        }
        d2 = LayoutUtil.RayAtY(dArray, dArray2, dArray3[2]);
        if (d2 != Double.MAX_VALUE && LayoutUtil.a(dArray3[0], dArray3[1], d2)) {
            dArray[0] = d2;
            dArray[1] = dArray3[2];
            return;
        }
        d2 = LayoutUtil.RayAtY(dArray, dArray2, dArray3[3]);
        if (d2 != Double.MAX_VALUE && LayoutUtil.a(dArray3[0], dArray3[1], d2)) {
            dArray[0] = d2;
            dArray[1] = dArray3[3];
            return;
        }
    }

    static boolean a(double d2, double d3, double d4) {
        return d2 <= d4 && d3 >= d4 || d2 >= d4 && d3 <= d4;
    }

    static boolean b(double d2, double d3, double d4) {
        return d2 < d3 && d2 < d4 || d2 > d3 && d2 > d4;
    }

    public static final double RayAtX(double[] dArray, double[] dArray2, double d2) {
        if (dArray[0] == d2) {
            return dArray[1];
        }
        if (dArray2[0] == d2) {
            return dArray2[1];
        }
        if (LayoutUtil.b(dArray[0], dArray2[0], d2)) {
            double d3 = dArray[1] - dArray2[1];
            double d4 = dArray[0] - dArray2[0];
            return d3 * (d2 - dArray[0]) / d4 + dArray[1];
        }
        return Double.MAX_VALUE;
    }

    public static final double RayAtY(double[] dArray, double[] dArray2, double d2) {
        if (dArray[1] == d2) {
            return dArray[0];
        }
        if (dArray2[1] == d2) {
            return dArray2[0];
        }
        if (LayoutUtil.b(dArray[1], dArray2[1], d2)) {
            double d3 = dArray[0] - dArray2[0];
            double d4 = dArray[1] - dArray2[1];
            return d3 * (d2 - dArray[1]) / d4 + dArray[0];
        }
        return Double.MAX_VALUE;
    }

    public static final String LayoutName(Class clazz) {
        String string = clazz.getName();
        int n2 = -1;
        if (string.startsWith("ilog.views.graphlayout.")) {
            n2 = string.lastIndexOf(46);
        }
        if (n2 >= 0) {
            return string.substring(n2 + 1, string.length());
        }
        return string;
    }

    public static final IlvGraphLayout AllocateLayoutClass(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.equals("IlvBusLayout") ? "ilog.views.graphlayout.bus." : (string.equals("IlvCircularLayout") ? "ilog.views.graphlayout.circular." : (string.equals("IlvGridLayout") ? "ilog.views.graphlayout.grid." : (string.equals("IlvHierarchicalLayout") ? "ilog.views.graphlayout.hierarchical." : (string.equals("IlvLinkLayout") ? "ilog.views.graphlayout.link." : (string.equals("IlvLongLinkLayout") ? "ilog.views.graphlayout.link.longlink." : (string.equals("IlvShortLinkLayout") ? "ilog.views.graphlayout.link.shortlink." : (string.equals("IlvMultipleLayout") ? "ilog.views.graphlayout.multiple." : (string.equals("IlvRandomLayout") ? "ilog.views.graphlayout.random." : (string.equals("IlvRecursiveLayout") ? "ilog.views.graphlayout.recursive." : (string.equals("IlvSpringEmbedderLayout") ? "ilog.views.graphlayout.springembedder." : (string.equals("IlvTopologicalMeshLayout") ? "ilog.views.graphlayout.topologicalmesh." : (string.equals("IlvTreeLayout") ? "ilog.views.graphlayout.tree." : (string.equals("IlvUniformLengthEdgesLayout") ? "ilog.views.graphlayout.uniformlengthedges." : "")))))))))))));
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string2 + string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage() + " [couldn't load class " + string2 + string + "]", exception);
        }
        if (!IlvGraphLayout.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("Wrong layout class: the class " + string2 + string + " is not a subclass of " + IlvGraphLayout.class);
        }
        IlvGraphLayout ilvGraphLayout = null;
        try {
            ilvGraphLayout = (IlvGraphLayout)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage() + " [couldn't instanciate class " + string2 + string + "]", exception);
        }
        return ilvGraphLayout;
    }

    public static String getText(String string, String string2) {
        return string;
    }

    public static final Enumeration GetVoidEnumeration() {
        return f;
    }

    public static final IlvGraphicEnumeration GetVoidGraphicEnumeration() {
        return g;
    }

    public static final int GetEnumerationCount(Enumeration enumeration) {
        if (enumeration == null) {
            return 0;
        }
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n2;
        }
        return n2;
    }

    public static final class IlvDoubleEnumerator
    implements Enumeration {
        private Enumeration a;
        private Enumeration b;

        public IlvDoubleEnumerator(Enumeration enumeration, Enumeration enumeration2) {
            if (enumeration == null || enumeration2 == null) {
                throw new IllegalArgumentException("null enumeration");
            }
            this.a = enumeration;
            this.b = enumeration2;
        }

        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        public Object nextElement() {
            if (this.a.hasMoreElements()) {
                return this.a.nextElement();
            }
            return this.b.nextElement();
        }
    }

    public static final class IlvDoubleIlvUnsyncVectorEnumerator
    implements Enumeration {
        private IlvUnsyncVector a;
        private IlvUnsyncVector b;
        private int c;

        public IlvDoubleIlvUnsyncVectorEnumerator(IlvUnsyncVector ilvUnsyncVector, IlvUnsyncVector ilvUnsyncVector2) {
            this.a = ilvUnsyncVector;
            this.b = ilvUnsyncVector2;
            this.c = 0;
        }

        public boolean hasMoreElements() {
            if (this.a == null && this.b == null) {
                return false;
            }
            if (this.a == null) {
                return this.c < this.b.size();
            }
            if (this.b == null) {
                return this.c < this.a.size();
            }
            return this.c < this.a.size() + this.b.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            int n2 = 0;
            int n3 = 0;
            if (this.a != null) {
                n2 = this.a.size();
            }
            if (this.b != null) {
                n3 = this.b.size();
            }
            if (n2 > 0) {
                if (this.c < n2) {
                    IlvUnsyncVector ilvUnsyncVector = this.a;
                    synchronized (ilvUnsyncVector) {
                        return this.a.elementAt(this.c++);
                    }
                }
                if (n3 > 0) {
                    if (this.c - n2 < n3) {
                        IlvUnsyncVector ilvUnsyncVector = this.b;
                        synchronized (ilvUnsyncVector) {
                            return this.b.elementAt(this.c++ - n2);
                        }
                    }
                    throw new NoSuchElementException("IlvDoubleIlvUnsyncVectorEnumerator");
                }
            } else if (n3 > 0 && this.c < n3) {
                IlvUnsyncVector ilvUnsyncVector = this.b;
                synchronized (ilvUnsyncVector) {
                    return this.b.elementAt(this.c++);
                }
            }
            throw new NoSuchElementException("IlvDoubleIlvUnsyncVectorEnumerator");
        }
    }

    public static final class IlvDoubleVectorEnumerator
    implements Enumeration {
        private Vector a;
        private Vector b;
        private int c;

        public IlvDoubleVectorEnumerator(Vector vector, Vector vector2) {
            this.a = vector;
            this.b = vector2;
            this.c = 0;
        }

        public boolean hasMoreElements() {
            if (this.a == null && this.b == null) {
                return false;
            }
            if (this.a == null) {
                return this.c < this.b.size();
            }
            if (this.b == null) {
                return this.c < this.a.size();
            }
            return this.c < this.a.size() + this.b.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            int n2 = 0;
            int n3 = 0;
            if (this.a != null) {
                n2 = this.a.size();
            }
            if (this.b != null) {
                n3 = this.b.size();
            }
            if (n2 > 0) {
                if (this.c < n2) {
                    Vector vector = this.a;
                    synchronized (vector) {
                        return this.a.elementAt(this.c++);
                    }
                }
                if (n3 > 0) {
                    if (this.c - n2 < n3) {
                        Vector vector = this.b;
                        synchronized (vector) {
                            return this.b.elementAt(this.c++ - n2);
                        }
                    }
                    throw new NoSuchElementException("IlvDoubleVectorEnumerator");
                }
            } else if (n3 > 0 && this.c < n3) {
                Vector vector = this.b;
                synchronized (vector) {
                    return this.b.elementAt(this.c++);
                }
            }
            throw new NoSuchElementException("IlvDoubleVectorEnumerator");
        }
    }

    public static final class IlvModelNeighborsEnumeration
    implements Enumeration {
        private Enumeration a;
        private IlvGraphModel b;
        private Object c;
        private Object d;

        public IlvModelNeighborsEnumeration(IlvGraphModel ilvGraphModel, Object object) {
            if (object == null) {
                throw new IllegalArgumentException("node cannot be null");
            }
            this.c = object;
            this.b = ilvGraphModel;
            this.a = ilvGraphModel.getLinks(object);
        }

        public boolean hasMoreElements() {
            if (this.d != null) {
                return true;
            }
            if (this.a != null) {
                while (this.a.hasMoreElements()) {
                    Object e2 = this.a.nextElement();
                    if (e2 == null) continue;
                    this.d = this.b.getOpposite(e2, this.c);
                    if (this.d == null || this.d == this.c) continue;
                    return true;
                }
                this.d = null;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object object = this.d;
                this.d = null;
                return object;
            }
            throw new NoSuchElementException("no next element");
        }
    }

    private static class IlvVoidEnumeration
    implements Enumeration {
        private IlvVoidEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("IlvVoidEnumeration");
        }
    }

    private static class IlvVoidGraphicEnumeration
    implements IlvGraphicEnumeration {
        private IlvVoidGraphicEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public IlvGraphic nextElement() {
            throw new NoSuchElementException("IlvVoidGraphicEnumeration");
        }
    }
}

