/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.labellayout;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvLabel;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.graphlayout.internalutil.IlvLayoutInterface;
import ilog.views.graphlayout.internalutil.IlvManagerAdapter;
import ilog.views.graphlayout.labellayout.IlvLabelLayout;
import ilog.views.graphlayout.labellayout.IlvLabelLayoutLabelProperty;
import ilog.views.graphlayout.labellayout.IlvLabelLayoutManagerProperty;
import ilog.views.graphlayout.labellayout.IlvLabelLayoutReport;
import ilog.views.graphlayout.labellayout.IlvLabelingModel;
import ilog.views.graphlayout.labellayout.IlvLabelingModelWithRotation;
import ilog.views.graphlayout.labellayout.internalutil.LabelingUtil;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class IlvDefaultLabelingModel
extends IlvLabelingModel
implements IlvLabelingModelWithRotation {
    private static final double a = 1.0;
    private IlvManagerAdapter b;
    private LabelLayout c = new LabelLayout();
    private IlvManager d;
    private static final String e = "No encapsulated manager. You cannot use the IlvDefaultLabelingModel after a call to the dispose method";
    private final String f = this.a("_IlvDefaultLabelingModelIsLabel");
    private final String g = this.a("_IlvDefaultLabelingModelIsObstacle");
    private final String h = this.a("__LabelLayoutStateDescription");
    private final String i = this.a("__IlvDefaultLabelingModelLayerToUse");
    private Vector j;
    private boolean k = false;
    private boolean l = false;
    private static final Boolean m = Boolean.TRUE;
    private static final Boolean n = Boolean.FALSE;

    public IlvDefaultLabelingModel(IlvManager ilvManager) {
        if (ilvManager == null) {
            throw new IllegalArgumentException("the manager argument cannot be null");
        }
        this.d = ilvManager;
        this.b = new LabelingManagerAdapter(ilvManager, this.h, this.i);
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.j != null) {
            Enumeration enumeration = this.j.elements();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                this.setProperty(e2, this.f, null);
                this.setProperty(e2, this.g, null);
            }
            this.j = null;
        }
        if (this.b != null) {
            this.b.dispose();
            this.b = null;
        }
        if (this.c != null) {
            this.c.a(null);
            this.c = null;
        }
        this.k = false;
        this.l = false;
    }

    final void a(IlvLabelLayout ilvLabelLayout) {
        this.c.a(ilvLabelLayout);
        this.b.clean(this.c);
        this.c.a(null);
    }

    public IlvLabelingModel createLabelingModel(Object object) {
        return new IlvDefaultLabelingModel((IlvManager)object);
    }

    public Enumeration getLabels() {
        return new IlvLabelEnumeration(this.d);
    }

    protected boolean isDefaultLabelClass(Object object) {
        return object instanceof IlvLabel || object instanceof IlvZoomableLabel || object instanceof IlvText;
    }

    public boolean isLabel(Object object) {
        if (!this.b.isManaged((IlvGraphic)object)) {
            return false;
        }
        return this.a(object);
    }

    private boolean a(Object object) {
        Boolean bl;
        if (this.k && (bl = (Boolean)this.getProperty(object, this.f)) != null) {
            return bl;
        }
        if (this.l && (bl = (Boolean)this.getProperty(object, this.g)) != null && bl.booleanValue()) {
            return false;
        }
        return this.isDefaultLabelClass(object);
    }

    public void setLabel(Object object, boolean bl) {
        boolean bl2 = this.isLabel(object);
        boolean bl3 = this.isObstacle(object);
        this.setProperty(object, this.f, bl ? m : n);
        this.c(object);
        this.k = true;
        if (bl2 != this.isLabel(object)) {
            this.a(object, this.d.isContentsAdjusting(), !bl2);
        }
        if (bl3 != this.isObstacle(object)) {
            this.b(object, this.d.isContentsAdjusting(), !bl3);
        }
    }

    public void moveLabel(Object object, float f2, float f3, boolean bl) {
        if (this.d == null) {
            throw new RuntimeException(e);
        }
        this.b.moveObject(object, f2, f3, bl);
    }

    public double getLabelOverlap(Object object, IlvRect ilvRect, Object object2, IlvRect ilvRect2, float f2) {
        float f3 = Math.max(ilvRect.x, ilvRect2.x) - 0.5f * f2;
        float f4 = Math.min(ilvRect.x + ilvRect.width, ilvRect2.x + ilvRect2.width) + 0.5f * f2;
        float f5 = Math.max(ilvRect.y, ilvRect2.y) - 0.5f * f2;
        float f6 = Math.min(ilvRect.y + ilvRect.height, ilvRect2.y + ilvRect2.height) + 0.5f * f2;
        if (f3 < f4 && f5 < f6) {
            return (double)(f4 - f3) * (double)(f6 - f5);
        }
        return 0.0;
    }

    public Enumeration getObstacles() {
        return new IlvObstacleEnumeration(this.d);
    }

    protected boolean isDefaultObstacleClass(Object object) {
        return object instanceof IlvGraphic && !this.isDefaultLabelClass(object);
    }

    public boolean isObstacle(Object object) {
        if (!this.b.isManaged((IlvGraphic)object)) {
            return false;
        }
        return this.b(object);
    }

    private boolean b(Object object) {
        Boolean bl;
        if (this.k && (bl = (Boolean)this.getProperty(object, this.f)) != null && bl.booleanValue()) {
            return false;
        }
        if (this.l && (bl = (Boolean)this.getProperty(object, this.g)) != null) {
            return bl;
        }
        return this.isDefaultObstacleClass(object);
    }

    public void setObstacle(Object object, boolean bl) {
        boolean bl2 = this.isLabel(object);
        boolean bl3 = this.isObstacle(object);
        this.setProperty(object, this.g, bl ? m : n);
        this.c(object);
        this.l = true;
        if (bl2 != this.isLabel(object)) {
            this.a(object, this.d.isContentsAdjusting(), !bl2);
        }
        if (bl3 != this.isObstacle(object)) {
            this.b(object, this.d.isContentsAdjusting(), !bl3);
        }
    }

    public double getObstacleOverlap(Object object, IlvRect ilvRect, Object object2, IlvRect ilvRect2, float f2) {
        float f3 = Math.max(ilvRect.x - f2, ilvRect2.x);
        float f4 = Math.min(ilvRect.x + ilvRect.width + f2, ilvRect2.x + ilvRect2.width);
        float f5 = Math.max(ilvRect.y - f2, ilvRect2.y);
        float f6 = Math.min(ilvRect.y + ilvRect.height + f2, ilvRect2.y + ilvRect2.height);
        if (f3 < f4 && f5 < f6) {
            return (double)(f4 - f3) * (double)(f6 - f5);
        }
        return 0.0;
    }

    public boolean isPolylineObstacle(Object object) {
        return this.isObstacle(object) && (object instanceof IlvLinkImage || object instanceof IlvPolyline || object instanceof IlvLine);
    }

    public float getPolylineWidth(Object object) {
        double d2;
        IlvTransformer ilvTransformer;
        switch (this.getCoordinatesMode()) {
            case 0: {
                ilvTransformer = this.getReferenceTransformer();
                double d3 = d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
                if (d2 != 0.0) break;
                throw new RuntimeException("Zoom factor is not allowed to be zero. Reference transformer: " + ilvTransformer);
            }
            case 1: {
                ilvTransformer = null;
                d2 = 1.0;
                break;
            }
            case 2: {
                ilvTransformer = this.getReferenceTransformer();
                d2 = 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
            }
        }
        if (object instanceof IlvLinkImage) {
            return (float)((double)((IlvLinkImage)object).getLineWidth(ilvTransformer) / d2);
        }
        if (object instanceof IlvLine) {
            return (float)((double)((IlvLine)object).getLineWidth(ilvTransformer) / d2);
        }
        if (object instanceof IlvPolyline) {
            return (float)((double)((IlvPolyline)object).getLineWidth(ilvTransformer) / d2);
        }
        return 1.0f;
    }

    public IlvPoint[] getPolylinePoints(Object object) {
        IlvPoint[] ilvPointArray = null;
        if (object instanceof IlvPolyPointsInterface) {
            IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)object;
            int n2 = ilvPolyPointsInterface.getPointsCardinal();
            ilvPointArray = new IlvPoint[n2];
            switch (this.getCoordinatesMode()) {
                case 0: {
                    IlvTransformer ilvTransformer = this.getReferenceTransformer();
                    if (ilvTransformer != null && ilvTransformer.isIdentity()) {
                        ilvTransformer = null;
                    }
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ilvPointArray[i2] = ilvPolyPointsInterface.getPointAt(i2, ilvTransformer);
                        if (ilvTransformer == null) continue;
                        ilvTransformer.inverse(ilvPointArray[i2]);
                    }
                    break;
                }
                case 1: {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        ilvPointArray[i3] = ilvPolyPointsInterface.getPointAt(i3, null);
                    }
                    break;
                }
                case 2: {
                    IlvTransformer ilvTransformer = this.getReferenceTransformer();
                    for (int i4 = 0; i4 < n2; ++i4) {
                        ilvPointArray[i4] = ilvPolyPointsInterface.getPointAt(i4, ilvTransformer);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
                }
            }
        }
        return ilvPointArray;
    }

    public double getPolylineObstacleOverlap(Object object, IlvRect ilvRect, Object object2, IlvPoint[] ilvPointArray, float f2, float f3) {
        if (ilvPointArray.length < 2) {
            return 0.0;
        }
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        ilvRect2.x -= f3;
        ilvRect2.y -= f3;
        ilvRect2.width += 2.0f * f3;
        ilvRect2.height += 2.0f * f3;
        double d2 = 0.0;
        for (int i2 = 1; i2 < ilvPointArray.length; ++i2) {
            d2 += LabelingUtil.GetOverlapWithLine(ilvRect2, ilvPointArray[i2 - 1], ilvPointArray[i2], f2);
        }
        return d2;
    }

    public IlvManager getManager() {
        return this.d;
    }

    private final void c(Object object) {
        if (this.j == null) {
            this.j = new Vector(2, 2);
        }
        if (!this.j.contains(object)) {
            this.j.addElement(object);
        }
    }

    public IlvRect boundingBox(Object object) {
        return this.b.boundingBox(object);
    }

    public boolean isBoundingBoxDependent() {
        return true;
    }

    public boolean isLayoutNeeded(IlvLabelLayout ilvLabelLayout) {
        if (super.isLayoutNeeded(ilvLabelLayout)) {
            return true;
        }
        this.c.a(ilvLabelLayout);
        return this.b.isLayoutNeeded(this.c);
    }

    public void beforeLayout(IlvLabelLayout ilvLabelLayout, boolean bl) {
        super.beforeLayout(ilvLabelLayout, bl);
        this.c.a(ilvLabelLayout);
        this.b.beforeLayout(this.c, bl);
    }

    public void afterLayout(IlvLabelLayout ilvLabelLayout, IlvLabelLayoutReport ilvLabelLayoutReport, boolean bl) {
        this.c.a(ilvLabelLayout);
        this.b.afterLayout(this.c, bl);
        super.afterLayout(ilvLabelLayout, ilvLabelLayoutReport, bl);
    }

    public void setProperty(Object object, String string, Object object2) {
        ((IlvGraphic)object).setProperty(string, object2);
    }

    public Object getProperty(Object object, String string) {
        return ((IlvGraphic)object).getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.d.setProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.d.getProperty(string);
    }

    public void setCoordinatesMode(int n2) {
        this.b.setCoordinatesModeInternal(n2);
    }

    public int getCoordinatesMode() {
        return this.b.getCoordinatesModeInternal();
    }

    public void setReferenceTransformer(IlvTransformer ilvTransformer) {
        this.b.setReferenceTransformerInternal(ilvTransformer);
    }

    public IlvTransformer getReferenceTransformer() {
        return this.b.getReferenceTransformerInternal();
    }

    public void setReferenceView(IlvManagerView ilvManagerView) {
        this.b.setReferenceView(ilvManagerView);
    }

    public IlvManagerView getReferenceView() {
        return this.b.getReferenceView();
    }

    public final synchronized void addLayer(IlvManagerLayer ilvManagerLayer) {
        this.b.addLayer(ilvManagerLayer);
    }

    public final synchronized boolean removeLayer(IlvManagerLayer ilvManagerLayer) {
        return this.b.removeLayer(ilvManagerLayer);
    }

    public final synchronized boolean removeAllLayers() {
        return this.b.removeAllLayers();
    }

    public final Enumeration getLayers() {
        return this.b.getLayers();
    }

    public final int getLayersCount() {
        return this.b.getLayersCount();
    }

    public final boolean isLayerAdded(IlvManagerLayer ilvManagerLayer) {
        return this.b.isLayerAdded(ilvManagerLayer);
    }

    public void setFullLayerNotification(boolean bl) {
        this.b.setFullLayerNotification(bl);
    }

    public final boolean isFullLayerNotification() {
        return this.b.isFullLayerNotification();
    }

    private void a(Object object, boolean bl, boolean bl2) {
        int n2 = 1;
        n2 = bl2 ? (n2 |= 4) : (n2 |= 8);
        this.fireLabelingModelEvent(object, n2, bl);
    }

    private void b(Object object, boolean bl, boolean bl2) {
        int n2 = 1;
        n2 = bl2 ? (n2 |= 0x10) : (n2 |= 0x20);
        this.fireLabelingModelEvent(object, n2, bl);
    }

    public String saveParametersToNamedProperties(IlvLabelLayout ilvLabelLayout, boolean bl) {
        return this.saveParametersToNamedProperties(ilvLabelLayout, "", bl);
    }

    public String saveParametersToNamedProperties(IlvLabelLayout ilvLabelLayout, String string, boolean bl) {
        this.c.a(ilvLabelLayout);
        return this.b.saveParametersToNamedProperties(this.c, string, bl);
    }

    public boolean loadParametersFromNamedProperties(IlvLabelLayout ilvLabelLayout) {
        return this.a(ilvLabelLayout, null) != null;
    }

    public boolean loadParametersFromNamedProperties(IlvLabelLayout ilvLabelLayout, String string) {
        return this.a(ilvLabelLayout, string) != null;
    }

    public IlvLabelLayout loadParametersFromNamedProperties(String string) {
        if (string == null) {
            throw new IllegalArgumentException("propertyPrefix cannot be null");
        }
        return this.a(null, string);
    }

    private IlvLabelLayout a(IlvLabelLayout ilvLabelLayout, String string) {
        this.c.a(ilvLabelLayout);
        return (IlvLabelLayout)this.b.loadParametersInternal(this.c, string);
    }

    public void removeParametersFromNamedProperties() {
        this.b.removeParametersFromNamedProperties();
    }

    public void removeParametersFromNamedProperties(String string) {
        this.b.removeParametersFromNamedProperties(string);
    }

    public void removeParametersFromNamedProperties(Class clazz) {
        this.b.removeParametersFromNamedProperties(clazz);
    }

    public String toString() {
        return super.toString() + " [" + this.getManager() + "]";
    }

    public double getLabelOverlap(Object object, IlvRect ilvRect, double d2, Object object2, IlvRect ilvRect2, double d3, float f2) {
        IlvRect ilvRect3 = this.a(d2, ilvRect);
        IlvRect ilvRect4 = this.a(d3, ilvRect2);
        if (ilvRect3 != null && ilvRect4 != null) {
            return this.getLabelOverlap(object, ilvRect3, object2, ilvRect4, f2);
        }
        float f3 = 0.5f * f2;
        return LabelingUtil.GetIntersectionArea(new IlvRect(ilvRect.x - f3, ilvRect.y - f3, ilvRect.width + f2, ilvRect.height + f2), d2, new IlvRect(ilvRect2.x - f3, ilvRect2.y - f3, ilvRect2.width + f2, ilvRect2.height + f2), d3);
    }

    public double getObstacleOverlap(Object object, IlvRect ilvRect, double d2, Object object2, IlvRect ilvRect2, float f2) {
        IlvRect ilvRect3 = this.a(d2, ilvRect);
        if (ilvRect3 != null) {
            return this.getObstacleOverlap(object, ilvRect3, object2, ilvRect2, f2);
        }
        IlvRect ilvRect4 = new IlvRect(ilvRect.x - f2, ilvRect.y - f2, ilvRect.width + 2.0f * f2, ilvRect.height + 2.0f * f2);
        return LabelingUtil.GetIntersectionArea(ilvRect4, d2, ilvRect2, 0.0);
    }

    public double getPolylineObstacleOverlap(Object object, IlvRect ilvRect, double d2, Object object2, IlvPoint[] ilvPointArray, float f2, float f3) {
        IlvRect ilvRect2 = this.a(d2, ilvRect);
        if (ilvRect2 != null) {
            return this.getPolylineObstacleOverlap(object, ilvRect2, object2, ilvPointArray, f2, f3);
        }
        IlvPoint[] ilvPointArray2 = new IlvPoint[ilvPointArray.length];
        for (int i2 = 0; i2 < ilvPointArray.length; ++i2) {
            ilvPointArray2[i2] = new IlvPoint(ilvPointArray[i2]);
        }
        d2 = IlvUtil.degreesToRadians(-d2);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = (double)ilvRect.x + 0.5 * (double)ilvRect.width;
        double d6 = (double)ilvRect.y + 0.5 * (double)ilvRect.height;
        IlvTransformer ilvTransformer = new IlvTransformer(d3, -d4, d4, d3, d5 * (1.0 - d3) + d4 * d6, -(d5 * d4) + d6 * (1.0 - d3));
        for (int i3 = 0; i3 < ilvPointArray2.length; ++i3) {
            ilvTransformer.apply(ilvPointArray2[i3]);
        }
        double d7 = this.getPolylineObstacleOverlap(object, ilvRect, object2, ilvPointArray2, f2, f3);
        return d7;
    }

    private IlvRect a(double d2, IlvRect ilvRect) {
        boolean bl = false;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        if (Math.abs(d2) < 1.0 || Math.abs(d2 - 360.0) < 1.0 || Math.abs(d2 - 180.0) < 1.0) {
            return ilvRect;
        }
        if (Math.abs(d2 - 90.0) < 1.0 || Math.abs(d2 - 270.0) < 1.0) {
            float f2 = ilvRect.x + 0.5f * ilvRect.width;
            float f3 = ilvRect.y + 0.5f * ilvRect.height;
            float f4 = ilvRect.height;
            float f5 = ilvRect.width;
            float f6 = f2 - 0.5f * f4;
            float f7 = f3 - 0.5f * f5;
            IlvRect ilvRect2 = new IlvRect(f6, f7, f4, f5);
            return ilvRect2;
        }
        return null;
    }

    public double getRotation(Object object, IlvRect ilvRect) {
        return 0.0;
    }

    public void setRotation(Object object, double d2) {
    }

    private final class IlvLabelEnumeration
    implements Enumeration {
        private IlvGraphicEnumeration a;
        private IlvGraphic b = null;

        IlvLabelEnumeration(IlvManager ilvManager) {
            this.a = ilvManager.getObjects();
            this.a();
        }

        public boolean hasMoreElements() {
            return this.b != null;
        }

        public Object nextElement() {
            if (this.b == null) {
                throw new NoSuchElementException("IlvLabelEnumeration");
            }
            IlvGraphic ilvGraphic = this.b;
            this.a();
            return ilvGraphic;
        }

        private void a() {
            while (this.a.hasMoreElements()) {
                this.b = this.a.nextElement();
                if (this.b == null || !IlvDefaultLabelingModel.this.isLabel(this.b)) continue;
                return;
            }
            this.b = null;
        }
    }

    private final class IlvObstacleEnumeration
    implements Enumeration {
        private IlvGraphicEnumeration a;
        private IlvGraphic b = null;

        IlvObstacleEnumeration(IlvManager ilvManager) {
            this.a = ilvManager.getObjects();
            this.a();
        }

        public boolean hasMoreElements() {
            return this.b != null;
        }

        public Object nextElement() {
            if (this.b == null) {
                throw new NoSuchElementException("IlvObstacleEnumeration");
            }
            IlvGraphic ilvGraphic = this.b;
            this.a();
            return ilvGraphic;
        }

        private void a() {
            while (this.a.hasMoreElements()) {
                this.b = this.a.nextElement();
                if (this.b == null || !IlvDefaultLabelingModel.this.isObstacle(this.b)) continue;
                return;
            }
            this.b = null;
        }
    }

    private static class LabelLayout
    implements IlvLayoutInterface {
        private IlvLabelLayout a;

        private LabelLayout() {
        }

        void a(IlvLabelLayout ilvLabelLayout) {
            this.a = ilvLabelLayout;
        }

        public Object getLayout() {
            return this.a;
        }

        public int getInstanceId() {
            return this.a.getInstanceId();
        }

        public Object getModel() {
            return this.a.getLabelingModel();
        }

        public void setCoordinatesMode(int n2) {
            this.a.setCoordinatesMode(n2);
        }

        public int getCoordinatesMode() {
            return this.a.getCoordinatesMode();
        }

        public void setOriginalCoordModeOfModel(int n2) {
            this.a.a(n2);
        }

        public int getOriginalCoordModeOfModel() {
            return this.a.a();
        }

        public boolean supportsSaveParametersToNamedProperties() {
            return this.a.supportsSaveParametersToNamedProperties();
        }

        public IlvNamedProperty createLayoutManagerProperty(String string, boolean bl) {
            return this.a.createLayoutManagerProperty(string, bl);
        }
    }

    private class LabelingManagerAdapter
    extends IlvManagerAdapter {
        LabelingManagerAdapter(IlvManager ilvManager, String string, String string2) {
            super(ilvManager, string, string2);
        }

        protected boolean isDefaultModelClass(Object object) {
            return object instanceof IlvDefaultLabelingModel;
        }

        protected IlvTransformer getReferenceTransformer() {
            return IlvDefaultLabelingModel.this.getReferenceTransformer();
        }

        protected int getCoordinatesMode() {
            return IlvDefaultLabelingModel.this.getCoordinatesMode();
        }

        protected int getStructureChangedEventType() {
            return 1;
        }

        protected int getGeometryChangedEventType() {
            return 2;
        }

        protected int getEventTypeWhenAdding(Object object) {
            boolean bl = false;
            int n2 = 1;
            if (IlvDefaultLabelingModel.this.isLabel(object)) {
                n2 |= 4;
                bl = true;
            }
            if (IlvDefaultLabelingModel.this.isObstacle(object)) {
                n2 |= 0x10;
                bl = true;
            }
            return bl ? n2 : -1;
        }

        protected int getEventTypeWhenRemoving(Object object) {
            boolean bl = false;
            int n2 = 1;
            if (IlvDefaultLabelingModel.this.a(object)) {
                n2 |= 8;
                bl = true;
            }
            if (IlvDefaultLabelingModel.this.b(object)) {
                n2 |= 0x20;
                bl = true;
            }
            return bl ? n2 : -1;
        }

        protected int getEventTypeWhenChangingGeometry(Object object) {
            boolean bl = false;
            int n2 = 2;
            if (IlvDefaultLabelingModel.this.isLabel(object)) {
                n2 |= 0x40;
                bl = true;
            }
            if (IlvDefaultLabelingModel.this.isObstacle(object)) {
                n2 |= 0x80;
                bl = true;
            }
            return bl ? n2 : -1;
        }

        protected void fireModelEvent(Object object, int n2, boolean bl) {
            IlvDefaultLabelingModel.this.fireLabelingModelEvent(object, n2, bl);
        }

        protected void adjustmentEnd() {
            IlvDefaultLabelingModel.this.adjustmentEnd();
        }

        protected Object allocateLayoutClass(String string) {
            return LabelingUtil.AllocateLayoutClass(string);
        }

        protected void transferNamedPropertyToLayout(String string, IlvManager ilvManager, Object object) {
            IlvLabelLayout ilvLabelLayout = (IlvLabelLayout)object;
            IlvLabelLayoutManagerProperty ilvLabelLayoutManagerProperty = (IlvLabelLayoutManagerProperty)ilvManager.getNamedProperty(string);
            if (ilvLabelLayoutManagerProperty != null) {
                ilvLabelLayoutManagerProperty.transfer(ilvLabelLayout);
            }
            String string2 = string + "X";
            Enumeration enumeration = IlvDefaultLabelingModel.this.getLabels();
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                IlvNamedProperty ilvNamedProperty = ilvGraphic.getNamedProperty(string2);
                if (ilvNamedProperty == null || !(ilvNamedProperty instanceof IlvLabelLayoutLabelProperty)) continue;
                IlvLabelLayoutLabelProperty ilvLabelLayoutLabelProperty = (IlvLabelLayoutLabelProperty)ilvNamedProperty;
                ilvLabelLayoutLabelProperty.transfer(ilvLabelLayout, ilvGraphic);
            }
            this.removeNamedPropertyFromManager(string);
        }

        protected void attachIfNotAlreadyAttached(Object object) {
            IlvLabelLayout ilvLabelLayout = (IlvLabelLayout)object;
            if (ilvLabelLayout.getLabelingModel() != IlvDefaultLabelingModel.this) {
                ilvLabelLayout.attach(IlvDefaultLabelingModel.this);
            }
        }

        protected void createLayoutProperties(Object object, String string, boolean bl) {
            IlvLabelLayout ilvLabelLayout = (IlvLabelLayout)object;
            String string2 = string + "X";
            Enumeration enumeration = IlvDefaultLabelingModel.this.getLabels();
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                ilvGraphic.setNamedProperty(ilvLabelLayout.createLayoutLabelProperty(string2, ilvGraphic, bl));
            }
        }

        protected boolean removeNamedPropertyFromManager(String string) {
            boolean bl = true;
            IlvManager ilvManager = this.getManager();
            IlvNamedProperty ilvNamedProperty = ilvManager.getNamedProperty(string);
            if (ilvNamedProperty != null) {
                if (ilvNamedProperty instanceof IlvLabelLayoutManagerProperty) {
                    ((IlvLabelLayoutManagerProperty)ilvNamedProperty).dispose(IlvDefaultLabelingModel.this);
                    ilvManager.removeNamedProperty(string);
                } else {
                    bl = false;
                }
            }
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects();
            String string2 = string + "X";
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                ilvNamedProperty = ilvGraphic.getNamedProperty(string2);
                if (ilvNamedProperty == null) continue;
                if (ilvNamedProperty instanceof IlvLabelLayoutLabelProperty) {
                    ((IlvLabelLayoutLabelProperty)ilvNamedProperty).dispose(IlvDefaultLabelingModel.this);
                    ilvGraphic.removeNamedProperty(string2);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
    }
}

