/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.labellayout.annealing;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.labellayout.IlvLabelingModel;
import ilog.views.graphlayout.labellayout.annealing.IlvAnnealingLabelDescriptor;
import ilog.views.graphlayout.labellayout.internalutil.LabelingUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvAnnealingPolylineLabelDescriptor
extends IlvAnnealingLabelDescriptor
implements IlvPersistentObject {
    private Object a;
    private Object b = null;
    private Object c = null;
    private IlvPoint[] d;
    private float e;
    private float f;
    private float g;
    private float h;
    private float i;
    private float j;
    private float k;
    private float l;
    private double m;
    private float n;
    private int o;
    private int p;
    private int q;
    private IlvPoint[] r;
    private float s;
    private float t;
    private float u;
    private float v;
    private float w;
    private float x;
    private boolean y = true;
    private float[] z;
    private float[] aa;
    private float[] ab;
    private float[] ac;
    private double[] ad;
    private double[] ae;
    private double[] af;
    private double[] ag;
    private double ah;
    private int ai = 0;
    private boolean aj = false;
    static final double ak = 1.5707963267948966;
    static final double al = Math.PI;
    static final double am = 4.71238898038469;
    static final double an = Math.PI * 2;
    static final double ao = 1000.0;
    public static final int LOCAL = 0;
    public static final int GLOBAL = 1;
    public static final int CENTER = 0;
    public static final int START = 1;
    public static final int END = 2;
    public static final int FREE = 3;

    public IlvAnnealingPolylineLabelDescriptor() {
        super(null);
        this.setLineWidth(-1.0f);
        this.setMinPercentageFromStart(0.0f);
        this.setMaxPercentageFromStart(100.0f);
        this.setPreferredPercentageFromStart(50.0f);
        this.setMaxDistFromPath(0.0f);
        this.setPreferredDistFromPath(0.0f);
        this.setPreferredSide(1);
        this.setAllowedSide(0);
        this.setSideAssociation(0);
        this.setTopOverlap(0.0f);
        this.setBottomOverlap(0.0f);
        this.setLeftOverlap(0.0f);
        this.setRightOverlap(0.0f);
    }

    public IlvAnnealingPolylineLabelDescriptor(Object object, Object object2, int n2, int n3, int n4, int n5) {
        this(object, object2, null, -1.0f, 0.0f, 100.0f, 50.0f, 0.0f, 0.0f, n3, n4, n5, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setAnchor(n2);
    }

    public IlvAnnealingPolylineLabelDescriptor(Object object, IlvLinkImage ilvLinkImage, int n2) {
        this(object, ilvLinkImage, ilvLinkImage.getFrom(), ilvLinkImage.getTo(), n2, 0.0f, 0.0f, 1, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public IlvAnnealingPolylineLabelDescriptor(Object object, Object object2, Object object3, Object object4, int n2, float f2, float f3, int n3, int n4, int n5, float f4, float f5, float f6, float f7) {
        this(object, object2, null, -1.0f, 0.0f, 100.0f, 50.0f, f2, f3, n3, n4, n5, f4, f5, f6, f7);
        this.setAnchor(n2);
        this.b = object3;
        this.c = object4;
    }

    public IlvAnnealingPolylineLabelDescriptor(Object object, Object object2, IlvPoint[] ilvPointArray, float f2, float f3, float f4, float f5, float f6, int n2, int n3, int n4, float f7, float f8, float f9, float f10) {
        this(object, object2, ilvPointArray, f2, f3, f4, 0.5f * (f3 + f4), f5, f6, n2, n3, n4, f7, f8, f9, f10);
    }

    public IlvAnnealingPolylineLabelDescriptor(Object object, Object object2, IlvPoint[] ilvPointArray, float f2, float f3, float f4, float f5, float f6, float f7, int n2, int n3, int n4, float f8, float f9, float f10, float f11) {
        super(object);
        this.setRelatedObstacle(object2);
        this.setReferencePoints(ilvPointArray);
        this.setLineWidth(f2);
        this.setMinPercentageFromStart(f3);
        this.setMaxPercentageFromStart(f4);
        this.setPreferredPercentageFromStart(f5);
        this.setMaxDistFromPath(f6);
        this.setPreferredDistFromPath(f7);
        this.setPreferredSide(n2);
        this.setAllowedSide(n3);
        this.setSideAssociation(n4);
        this.setTopOverlap(f8);
        this.setBottomOverlap(f9);
        this.setLeftOverlap(f10);
        this.setRightOverlap(f11);
        this.c();
    }

    private final void c() {
        if (this.getPreferredDistFromPath() > this.getMaxDistFromPath()) {
            throw new IllegalArgumentException("The preferred distance must be smaller than the maximal distance");
        }
        if (this.getReferencePoints() == null && this.getRelatedObstacle() == null) {
            throw new IllegalArgumentException("You must specify polyline points or a related obstacle");
        }
        if (this.getMinPercentageFromStart() >= this.getMaxPercentageFromStart()) {
            throw new IllegalArgumentException("The minimal percentage must be smaller than the maximal percentage");
        }
        if (this.getPreferredPercentageFromStart() >= 0.0f && (this.getPreferredPercentageFromStart() < this.getMinPercentageFromStart() || this.getPreferredPercentageFromStart() > this.getMaxPercentageFromStart())) {
            throw new IllegalArgumentException("The preferred percentage must be between the minimal and the maximal percentage");
        }
        int n2 = this.getPreferredSide();
        int n3 = this.getAllowedSide();
        switch (this.getSideAssociation()) {
            case 0: {
                if (n2 != 1 && n2 != 2) {
                    throw new IllegalArgumentException("Illegal preferred side: " + n2);
                }
                if (n3 == 1 || n3 == 2 || n3 == 0) break;
                throw new IllegalArgumentException("Illegal allowed side: " + n3);
            }
            case 1: {
                if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 6 && n2 != 10 && n2 != 5 && n2 != 9) {
                    throw new IllegalArgumentException("Illegal preferred side: " + n2);
                }
                if (n3 == 1 || n3 == 2 || n3 == 4 || n3 == 8 || n3 == 6 || n3 == 10 || n3 == 5 || n3 == 9 || n3 == 0) break;
                throw new IllegalArgumentException("Illegal allowed side: " + n3);
            }
            default: {
                throw new IllegalArgumentException("Illegal side association: " + this.getSideAssociation());
            }
        }
    }

    public void initialize(IlvLabelingModel ilvLabelingModel) {
        float f2;
        int n2;
        double d2 = this.maxPathLocation;
        double d3 = this.actPathLocation;
        this.c();
        this.s = this.e;
        if (this.s < 0.0f) {
            this.s = ilvLabelingModel.getPolylineWidth(this.a);
        }
        this.r = this.d;
        if (this.d == null) {
            this.r = ilvLabelingModel.getPolylinePoints(this.a);
        }
        if (this.r == null || this.r.length < 2) {
            throw new RuntimeException("Require at least two intermediate points for a polyline label descriptor");
        }
        boolean bl = false;
        for (n2 = 1; n2 < this.r.length; ++n2) {
            if (this.r[0].equals(this.r[n2])) continue;
            bl = true;
        }
        if (!bl) {
            this.r[0].x += 0.001f;
            this.r[0].y += 0.001f;
        }
        if (this.s < 0.0f) {
            this.s = 0.0f;
        }
        this.t = 0.0f;
        for (n2 = 1; n2 < this.r.length; ++n2) {
            this.t = (float)((double)this.t + IlvAnnealingPolylineLabelDescriptor.a(this.r[n2 - 1], this.r[n2]));
        }
        this.u = this.f;
        this.v = this.g;
        this.w = this.h;
        this.x = this.i;
        IlvRect ilvRect = ilvLabelingModel.boundingBox(this.getObject());
        this.setBoundingBox(ilvRect);
        float f3 = ilvRect.width - this.w - this.x;
        float f4 = ilvRect.height - this.u - this.v;
        if (f3 < 0.0f) {
            f2 = this.w + this.x;
            this.w += this.w / f2 * f3;
            this.x += this.x / f2 * f3;
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f2 = this.u + this.v;
            this.u += this.u / f2 * f4;
            this.v += this.v / f2 * f4;
            f4 = 0.0f;
        }
        this.a(this.r, this.s, f3, f4);
        this.d();
        if (this.q == 1 && this.l >= 0.0f) {
            this.b(this.r, this.s, f3, f4);
        }
        this.e();
        if (!this.aj) {
            this.actPathLocation = this.m;
            this.actDistFromPath = this.n;
        } else if (d2 > 0.0) {
            this.actPathLocation = this.maxPathLocation * d3 / d2;
        }
        this.aj = true;
    }

    private void a(IlvPoint[] ilvPointArray, float f2, float f3, float f4) {
        double d2;
        int n2;
        int n3;
        int n4 = 6 * ilvPointArray.length - 8;
        this.z = new float[n4];
        this.aa = new float[n4];
        this.ad = new double[n4];
        this.ab = new float[4];
        this.ac = new float[4];
        for (n3 = 0; n3 < 4; ++n3) {
            this.ab[n3] = Float.MAX_VALUE;
            this.ac[n3] = Float.MAX_VALUE;
        }
        n3 = 0;
        if (this.q == 1) {
            double d3;
            n3 = this.a(true, ilvPointArray, f2, f3, f4, 0);
            n2 = n3 = this.a(false, ilvPointArray, f2, f3, f4, n3);
            this.a(n3);
            if (this.p != 0) {
                boolean bl = false;
                double d4 = Double.MAX_VALUE;
                double d5 = 0.0;
                int n5 = -1;
                for (int i2 = 0; i2 < n2 - 1; ++i2) {
                    d3 = this.ad[i2];
                    if (d3 == 1000.0) continue;
                    if (!this.a(this.p, d3)) {
                        d2 = this.b(this.p, d3);
                        if (d2 < d4) {
                            d4 = d2;
                            d5 = this.ad[i2];
                            n5 = i2;
                        }
                        this.ad[i2] = 1000.0;
                        continue;
                    }
                    bl = true;
                }
                if (n5 >= 0 && !bl) {
                    this.ad[n5] = d5;
                }
            }
            double d6 = 1000.0;
            n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                d3 = d6;
                d6 = this.ad[i3];
                if (d6 == 1000.0) {
                    if (d3 == 1000.0) continue;
                    ++n3;
                    continue;
                }
                ++n3;
            }
        } else {
            if (this.p == 0 || this.p == 1) {
                n3 = this.a(true, ilvPointArray, f2, f3, f4, 0);
            }
            int n6 = n3;
            if (this.p == 0 || this.p == 2) {
                n3 = this.a(false, ilvPointArray, f2, f3, f4, n3);
            }
            n2 = n3;
            this.a(n3);
            if (this.l < 0.0f) {
                this.a(n6, n3);
            } else {
                this.a(ilvPointArray, f2, f3, f3, n6, n3);
            }
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        double[] dArray = new double[n3];
        int n7 = 0;
        d2 = 1000.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            double d7 = d2;
            d2 = this.ad[i4];
            if (d2 == 1000.0) {
                if (d7 == 1000.0) continue;
                fArray[n7] = this.z[i4];
                fArray2[n7] = this.aa[i4];
                dArray[n7++] = 1000.0;
                continue;
            }
            fArray[n7] = this.z[i4];
            fArray2[n7] = this.aa[i4];
            dArray[n7++] = d2;
        }
        this.z = fArray;
        this.aa = fArray2;
        this.ad = dArray;
        if (this.q == 1 && this.l < 0.0f) {
            this.b(n3);
        }
    }

    private int a(boolean bl, IlvPoint[] ilvPointArray, float f2, float f3, float f4, int n2) {
        float f5;
        float f6;
        int n3;
        int n4;
        int n5;
        int n6;
        float f7 = f2 / 2.0f;
        int n7 = n2;
        if (bl) {
            n6 = 0;
            n5 = 1;
            n4 = ilvPointArray.length - 1;
            n3 = 1;
            f6 = this.t * this.j / 100.0f;
            f5 = this.t * this.k / 100.0f;
        } else {
            n6 = 2;
            n5 = ilvPointArray.length - 2;
            n4 = 0;
            n3 = -1;
            f6 = this.t * (100.0f - this.k) / 100.0f;
            f5 = this.t * (100.0f - this.j) / 100.0f;
        }
        boolean bl2 = true;
        double d2 = 0.0;
        int n8 = 0;
        float f8 = 0.0f;
        for (int i2 = n5; i2 != n4 + n3; i2 += n3) {
            double d3 = d2;
            int n9 = n8;
            double d4 = f5 - f8;
            double d5 = f6 - f8;
            IlvPoint ilvPoint = ilvPointArray[i2];
            IlvPoint ilvPoint2 = ilvPointArray[i2 - n3];
            float f9 = ilvPoint.x - ilvPoint2.x;
            float f10 = ilvPoint.y - ilvPoint2.y;
            double d6 = Math.sqrt(f9 * f9 + f10 * f10);
            if (0.0 < d4 && d4 < d6) {
                ilvPoint = new IlvPoint((float)((double)ilvPoint2.x + (double)f9 * d4 / d6), (float)((double)ilvPoint2.y + (double)f10 * d4 / d6));
            }
            if (0.0 < d5 && d5 < d6) {
                ilvPoint2 = new IlvPoint((float)((double)ilvPoint2.x + (double)f9 * d5 / d6), (float)((double)ilvPoint2.y + (double)f10 * d5 / d6));
                bl2 = true;
            }
            f8 = (float)((double)f8 + d6);
            if (!(d5 < d6) || !(d4 > 0.0) || !(d6 > 0.0)) continue;
            d2 = Math.atan2(f10, f9);
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            n8 = this.a(d2);
            if (bl2) {
                n9 = n8 - 1;
            }
            if (n9 == n8) {
                this.a(n8, n7, ilvPoint, f3, f4);
                this.a(n7++, d2, f7);
            } else if ((n9 + 1) % 4 == n8) {
                this.a(n8, n7, ilvPoint2, f3, f4);
                this.a(n7++, d2, f7);
                this.a(n8, n7, ilvPoint, f3, f4);
                this.a(n7++, d2, f7);
                if (n6 == 0 || n6 == 2) {
                    this.ab[n6] = this.z[n7 - 2];
                    this.ac[n6] = this.aa[n7 - 2];
                    ++n6;
                }
            } else if ((n8 + 1) % 4 == n9) {
                this.ad[n7 - 1] = 1000.0;
                this.a(n8, n7, ilvPoint2, f3, f4);
                this.a(n7++, d2, f7);
                this.a(n8, n7, ilvPoint, f3, f4);
                this.a(n7++, d2, f7);
            } else {
                double d7;
                double d8;
                if (n9 < 2) {
                    d8 = Math.PI - d3 + d2;
                    d7 = 0.5 * (d3 + d2 - Math.PI);
                } else {
                    d8 = Math.PI * 3 - d3 + d2;
                    d7 = 0.5 * (d3 + d2 + Math.PI);
                }
                if (d8 > Math.PI * 2) {
                    this.ad[n7 - 1] = 1000.0;
                } else {
                    this.a((n9 + 1) % 4, n7, ilvPoint2, f3, f4);
                    this.a(n7++, d7, f7);
                }
                this.a(n8, n7, ilvPoint2, f3, f4);
                this.a(n7++, d2, f7);
                this.a(n8, n7, ilvPoint, f3, f4);
                this.a(n7++, d2, f7);
            }
            bl2 = false;
        }
        if (n7 > 0) {
            this.ab[n6] = this.z[n7 - 1];
            this.ac[n6] = this.aa[n7 - 1];
            this.ad[n7 - 1] = 1000.0;
        }
        return n7;
    }

    private void a(int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            if (this.ad[i2 - 1] == 1000.0) continue;
            double d2 = Math.atan2(this.aa[i2] - this.aa[i2 - 1], this.z[i2] - this.z[i2 - 1]);
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            this.ad[i2 - 1] = d2;
        }
    }

    private void a(int n2, int n3, IlvPoint ilvPoint, float f2, float f3) {
        switch (n2) {
            case 0: {
                this.z[n3] = ilvPoint.x;
                this.aa[n3] = ilvPoint.y - f3;
                break;
            }
            case 1: {
                this.z[n3] = ilvPoint.x;
                this.aa[n3] = ilvPoint.y;
                break;
            }
            case 2: {
                this.z[n3] = ilvPoint.x - f2;
                this.aa[n3] = ilvPoint.y;
                break;
            }
            case 3: {
                this.z[n3] = ilvPoint.x - f2;
                this.aa[n3] = ilvPoint.y - f3;
            }
        }
    }

    private void a(int n2, double d2, float f2) {
        if (f2 > 0.0f) {
            int n3 = n2;
            this.z[n3] = (float)((double)this.z[n3] + (double)f2 * Math.cos(1.5707963267948966 - d2));
            int n4 = n2;
            this.aa[n4] = (float)((double)this.aa[n4] - (double)f2 * Math.sin(1.5707963267948966 - d2));
        }
    }

    private void d() {
        int n2;
        int n3 = this.z.length;
        if (n3 == 0) {
            return;
        }
        this.af = new double[n3];
        this.ag = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.af[n2] = Math.sin(1.5707963267948966 - this.ad[n2]);
            this.ag[n2] = Math.cos(1.5707963267948966 - this.ad[n2]);
        }
        this.maxPathLocation = 0.0;
        this.ae = new double[n3 - 1];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            if (this.ad[n2] != 1000.0) {
                this.ae[n2] = IlvAnnealingPolylineLabelDescriptor.a(this.z[n2], this.aa[n2], this.z[n2 + 1], this.aa[n2 + 1]);
                if (this.l < 0.0f && n2 == this.ai) {
                    this.m = this.maxPathLocation + 0.5 * this.ae[n2];
                }
                this.maxPathLocation += this.ae[n2];
                continue;
            }
            this.ae[n2] = 0.0;
        }
        this.ah = 0.0;
        for (n2 = 1; n2 < n3; ++n2) {
            if (this.ad[n2] == 1000.0 || this.ad[n2 - 1] == 1000.0) continue;
            double d2 = this.ad[n2] - this.ad[n2 - 1];
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            if (!(d2 < Math.PI)) continue;
            this.ah += d2;
        }
    }

    private boolean a(int n2, double d2) {
        if (d2 < 0.5235987755982988) {
            return (n2 & 4) != 0;
        }
        if (d2 < 1.0471975511965976) {
            return (n2 & 6) != 0;
        }
        if (d2 < 2.0943951023931953) {
            return (n2 & 2) != 0;
        }
        if (d2 < 2.617993877991494) {
            return (n2 & 0xA) != 0;
        }
        if (d2 < 3.6651914291880923) {
            return (n2 & 8) != 0;
        }
        if (d2 < 4.1887902047863905) {
            return (n2 & 9) != 0;
        }
        if (d2 < 5.235987755982988) {
            return (n2 & 1) != 0;
        }
        if (d2 < 5.759586531581288) {
            return (n2 & 5) != 0;
        }
        return (n2 & 4) != 0;
    }

    private double b(int n2, double d2) {
        double d3;
        double d4 = Double.MAX_VALUE;
        if ((n2 & 4) != 0 && (d3 = d2 < Math.PI ? d2 : Math.PI * 2 - d2) < d4) {
            d4 = d3;
        }
        if ((n2 & 8) != 0 && (d3 = d2 < Math.PI ? Math.PI - d2 : d2 - Math.PI) < d4) {
            d4 = d3;
        }
        if ((n2 & 1) != 0 && (d3 = d2 < 1.5707963267948966 ? 1.5707963267948966 + d2 : (d2 < 4.71238898038469 ? 4.71238898038469 - d2 : d2 - 4.71238898038469)) < d4) {
            d4 = d3;
        }
        if ((n2 & 2) != 0 && (d3 = d2 < 1.5707963267948966 ? 1.5707963267948966 - d2 : (d2 < 4.71238898038469 ? d2 - 1.5707963267948966 : 7.853981633974483 - d2)) < d4) {
            d4 = d3;
        }
        return d4;
    }

    private int a(double d2) {
        if (d2 == 0.0) {
            return 3;
        }
        if (d2 <= 1.5707963267948966) {
            return 0;
        }
        if (d2 <= Math.PI) {
            return 1;
        }
        if (d2 <= 4.71238898038469) {
            return 2;
        }
        return 3;
    }

    private void a(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        this.ai = 0;
        if (this.o == 1 && n2 > 0 || n2 == n3) {
            n6 = 0;
            n5 = n2;
        } else {
            n6 = n2;
            n5 = n3;
        }
        int n7 = 0;
        for (n4 = n6; n4 < n5; ++n4) {
            if (this.ad[n4] == 1000.0) continue;
            ++n7;
        }
        int n8 = 0;
        int n9 = n7 / 2;
        for (n4 = n6; n4 < n5; ++n4) {
            if (this.ad[n4] == 1000.0 || ++n8 != n9) continue;
            this.ai = n4;
        }
    }

    private void b(int n2) {
        this.ai = 0;
        int n3 = -1;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        int n4 = -1;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            double d4;
            double d5;
            if (this.ad[i2] == 1000.0) continue;
            if (this.a(this.o, this.ad[i2]) && (d5 = IlvAnnealingPolylineLabelDescriptor.a(this.z[i2], this.aa[i2], this.z[i2 + 1], this.aa[i2 + 1])) > d2) {
                n3 = i2;
                d2 = d5;
            }
            if (!((d4 = this.b(this.o, this.ad[i2])) < d3)) continue;
            d3 = d4;
            n4 = i2;
        }
        if (n3 >= 0) {
            this.ai = n3;
        } else if (n4 >= 0) {
            this.ai = n4;
        }
    }

    private void a(IlvPoint[] ilvPointArray, float f2, float f3, float f4, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        IlvPoint[] ilvPointArray2 = this.a(ilvPointArray, f2, this.l, f3, f4);
        if (this.o == 1) {
            n6 = 0;
            n5 = 0;
            n4 = n2;
        } else {
            n6 = 1;
            n5 = n2;
            n4 = n3;
        }
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = -1.0;
        double d6 = 0.0;
        for (int i2 = 0; i2 < this.z.length - 1; ++i2) {
            float f5;
            float f6;
            if (this.ad[i2] == 1000.0) continue;
            double d7 = this.aa[i2 + 1] - this.aa[i2];
            double d8 = this.z[i2 + 1] - this.z[i2];
            double d9 = (d7 * (double)(ilvPointArray2[n6].y - this.aa[i2]) + d8 * (double)(ilvPointArray2[n6].x - this.z[i2])) / (d8 * d8 + d7 * d7);
            if (d9 < 0.0) {
                f6 = this.z[i2];
                f5 = this.aa[i2];
            } else if (d9 > 1.0) {
                f6 = this.z[i2 + 1];
                f5 = this.aa[i2 + 1];
            } else {
                f6 = (float)((double)this.z[i2] + d9 * d8);
                f5 = (float)((double)this.aa[i2] + d9 * d7);
            }
            double d10 = IlvAnnealingPolylineLabelDescriptor.a(f6, f5, ilvPointArray2[n6].x, ilvPointArray2[n6].y);
            if (n5 <= i2 && i2 < n4) {
                if (d10 < d3) {
                    d3 = d10;
                    d5 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
                }
            } else if (d10 < d4) {
                d4 = d10;
                d6 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
            }
            d2 += Math.sqrt(d8 * d8 + d7 * d7);
        }
        this.m = d5 >= 0.0 ? d5 : d6;
    }

    private void b(IlvPoint[] ilvPointArray, float f2, float f3, float f4) {
        IlvPoint[] ilvPointArray2 = this.a(ilvPointArray, f2, this.l, f3, f4);
        double d2 = 0.0;
        double d3 = -1.0;
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MAX_VALUE;
        this.m = -1.0;
        for (int i2 = 0; i2 < this.z.length - 1; ++i2) {
            double d7;
            float f5;
            float f6;
            if (this.ad[i2] == 1000.0) continue;
            double d8 = this.aa[i2 + 1] - this.aa[i2];
            double d9 = this.z[i2 + 1] - this.z[i2];
            double d10 = (d8 * (double)(ilvPointArray2[0].y - this.aa[i2]) + d9 * (double)(ilvPointArray2[0].x - this.z[i2])) / (d9 * d9 + d8 * d8);
            if (d10 < 0.0) {
                f6 = this.z[i2];
                f5 = this.aa[i2];
            } else if (d10 > 1.0) {
                f6 = this.z[i2 + 1];
                f5 = this.aa[i2 + 1];
            } else {
                f6 = (float)((double)this.z[i2] + d10 * d9);
                f5 = (float)((double)this.aa[i2] + d10 * d8);
            }
            double d11 = IlvAnnealingPolylineLabelDescriptor.a(f6, f5, ilvPointArray2[0].x, ilvPointArray2[0].y);
            if (d11 < 0.01) {
                if (this.a(this.o, this.ad[i2])) {
                    this.m = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
                    break;
                }
                d7 = this.b(this.o, this.ad[i2]);
                if (d7 < d5) {
                    d5 = d7;
                    d3 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
                }
            } else if (d11 < d6) {
                d6 = d11;
                d4 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
            }
            if ((d10 = (d8 * (double)(ilvPointArray2[1].y - this.aa[i2]) + d9 * (double)(ilvPointArray2[1].x - this.z[i2])) / (d9 * d9 + d8 * d8)) < 0.0) {
                f6 = this.z[i2];
                f5 = this.aa[i2];
            } else if (d10 > 1.0) {
                f6 = this.z[i2 + 1];
                f5 = this.aa[i2 + 1];
            } else {
                f6 = (float)((double)this.z[i2] + d10 * d9);
                f5 = (float)((double)this.aa[i2] + d10 * d8);
            }
            d11 = IlvAnnealingPolylineLabelDescriptor.a(f6, f5, ilvPointArray2[1].x, ilvPointArray2[1].y);
            if (d11 < 0.01) {
                if (this.a(this.o, this.ad[i2])) {
                    this.m = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
                    break;
                }
                d7 = this.b(this.o, this.ad[i2]);
                if (d7 < d5) {
                    d5 = d7;
                    d3 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
                }
            } else if (d11 < d6) {
                d6 = d11;
                d4 = d2 + IlvAnnealingPolylineLabelDescriptor.a(f6, f5, this.z[i2], this.aa[i2]);
            }
            d2 += Math.sqrt(d9 * d9 + d8 * d8);
        }
        if (this.m < 0.0) {
            this.m = d3 >= 0.0 ? d3 : d4;
        }
    }

    private void e() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.l < 1.0f) {
            bl = this.a(this.ab[0], this.ac[0]);
            bl2 = this.b(this.ab[3], this.ac[3]);
        } else if (this.l > 99.0f) {
            bl2 = this.b(this.ab[1], this.ac[1]);
            bl = this.a(this.ab[2], this.ac[2]);
        } else {
            bl2 = true;
            bl = true;
        }
        this.y = bl && bl2;
    }

    private boolean a(float f2, float f3) {
        for (int i2 = 0; i2 < this.z.length; ++i2) {
            if (this.z[i2] != f2 || this.aa[i2] != f3 || this.ad[i2] == 1000.0) continue;
            return true;
        }
        return false;
    }

    private boolean b(float f2, float f3) {
        for (int i2 = 1; i2 < this.z.length; ++i2) {
            if (this.z[i2] != f2 || this.aa[i2] != f3 || this.ad[i2 - 1] == 1000.0) continue;
            return true;
        }
        return false;
    }

    private static double a(float f2, float f3, float f4, float f5) {
        double d2 = f4 - f2;
        double d3 = f5 - f3;
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    private static double a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        double d2 = ilvPoint.x - ilvPoint2.x;
        double d3 = ilvPoint.y - ilvPoint2.y;
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    private IlvPoint[] a(IlvPoint[] ilvPointArray, float f2, float f3, float f4, float f5) {
        double d2;
        int n2;
        IlvPoint[] ilvPointArray2 = new IlvPoint[2];
        double d3 = f3 / 100.0f * this.t;
        for (n2 = 0; n2 < ilvPointArray.length - 1; ++n2) {
            d2 = IlvAnnealingPolylineLabelDescriptor.a(ilvPointArray[n2], ilvPointArray[n2 + 1]);
            if (d3 <= d2) {
                ilvPointArray2[0] = this.a(n2, ilvPointArray, f2, (float)d3, f4, f5, true);
                ilvPointArray2[1] = this.a(n2, ilvPointArray, f2, (float)d3, f4, f5, false);
                return ilvPointArray2;
            }
            d3 -= d2;
        }
        n2 = ilvPointArray.length - 2;
        d2 = IlvAnnealingPolylineLabelDescriptor.a(ilvPointArray[n2], ilvPointArray[n2 + 1]);
        ilvPointArray2[0] = this.a(n2, ilvPointArray, f2, (float)d2, f4, f5, true);
        ilvPointArray2[1] = this.a(n2, ilvPointArray, f2, (float)d2, f4, f5, false);
        return ilvPointArray2;
    }

    private IlvPoint a(int n2, IlvPoint[] ilvPointArray, float f2, float f3, float f4, float f5, boolean bl) {
        IlvPoint ilvPoint;
        IlvPoint ilvPoint2;
        IlvPoint ilvPoint3;
        int n3;
        double d2 = ilvPointArray[n2].x - ilvPointArray[n2 + 1].x;
        double d3 = ilvPointArray[n2].y - ilvPointArray[n2 + 1].y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        int n4 = n3 = bl ? 1 : -1;
        if (d4 <= 1.0E-4) {
            ilvPoint3 = ilvPointArray[n2];
            ilvPoint2 = ilvPointArray[n2 + 1];
            ilvPoint = ilvPointArray[n2];
        } else {
            double d5 = (double)f2 / (2.0 * d4);
            double d6 = (double)f3 / d4;
            ilvPoint3 = new IlvPoint((float)((double)ilvPointArray[n2].x - (double)n3 * d5 * d3), (float)((double)ilvPointArray[n2].y + (double)n3 * d5 * d2));
            ilvPoint2 = new IlvPoint((float)((double)ilvPointArray[n2 + 1].x - (double)n3 * d5 * d3), (float)((double)ilvPointArray[n2 + 1].y + (double)n3 * d5 * d2));
            ilvPoint = new IlvPoint((float)((double)ilvPointArray[n2].x - d6 * d2), (float)((double)ilvPointArray[n2].y - d6 * d3));
        }
        return this.a(this.a(d2, d3, f4, f5, n3), ilvPoint3, ilvPoint2, ilvPoint, f4, f5, n3);
    }

    private IlvPoint a(double d2, double d3, float f2, float f3, int n2) {
        double d4;
        if (-1.0E-4 <= d2 && d2 <= 1.0E-4 && -1.0E-4 <= d3 && d3 <= 1.0E-4) {
            return new IlvPoint(0.0f, 0.0f);
        }
        for (d4 = Math.atan2(d3, d2); d4 < Math.PI * 2; d4 += Math.PI * 2) {
        }
        while (d4 > 1.5707963267948966) {
            d4 -= 1.5707963267948966;
        }
        float f4 = 0.5f * f2;
        float f5 = 0.5f * f3;
        double d5 = d4 > 0.7853981633974483 ? d4 - 0.7853981633974483 : 0.7853981633974483 - d4;
        double d6 = d3 > 0.0 ? n2 : -n2;
        double d7 = d2 < 0.0 ? n2 : -n2;
        d5 = 1.0 - d5 / 0.7853981633974483;
        return new IlvPoint((float)(d5 * d6 * (double)f4), (float)(d5 * d7 * (double)f5));
    }

    private IlvPoint a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, float f3, int n2) {
        double d2 = ilvPoint2.x - ilvPoint3.x;
        double d3 = ilvPoint2.y - ilvPoint3.y;
        IlvPoint ilvPoint5 = new IlvPoint();
        float f4 = (double)n2 * d3 < 0.0 ? -ilvPoint.x - 0.5f * f2 : 0.5f * f2 - ilvPoint.x;
        float f5 = (double)n2 * d2 > 0.0 ? -ilvPoint.y - 0.5f * f3 : 0.5f * f3 - ilvPoint.y;
        if (-1.0E-4 <= d2 && d2 <= 1.0E-4) {
            ilvPoint5.x = ilvPoint2.x - f4;
            ilvPoint5.y = ilvPoint4.y;
        } else if (-1.0E-4 <= d3 && d3 <= 1.0E-4) {
            ilvPoint5.x = ilvPoint4.x;
            ilvPoint5.y = ilvPoint2.y - f5;
        } else {
            double d4 = ((double)(ilvPoint4.y - ilvPoint2.y + f5) * d3 + (double)(ilvPoint4.x - ilvPoint2.x + f4) * d2) / (d2 * d2 + d3 * d3);
            ilvPoint5.x = (float)((double)ilvPoint2.x + d4 * d2 - (double)f4);
            ilvPoint5.y = (float)((double)ilvPoint2.y + d4 * d3 - (double)f5);
            float f6 = ilvPoint5.x + f4;
            float f7 = ilvPoint5.y + f5;
            if (d4 > 0.0) {
                if (f4 < 0.0f && ilvPoint2.x < f6 || f4 > 0.0f && ilvPoint2.x > f6) {
                    ilvPoint5.x = ilvPoint2.x - f4;
                } else {
                    ilvPoint5.y = ilvPoint2.y - f5;
                }
            } else if (d4 < -1.0) {
                if (f4 < 0.0f && ilvPoint3.x < f6 || f4 > 0.0f && ilvPoint3.x > f6) {
                    ilvPoint5.x = ilvPoint3.x - f4;
                } else {
                    ilvPoint5.y = ilvPoint3.y - f5;
                }
            }
        }
        ilvPoint5.x += -ilvPoint.x - 0.5f * f2;
        ilvPoint5.y += -ilvPoint.y - 0.5f * f3;
        return ilvPoint5;
    }

    public void setPosition(double d2, float f2) {
        int n2;
        if (this.maxPathLocation <= 0.0) {
            d2 = 0.0;
        }
        if (this.maxDistFromPath <= 0.0f) {
            f2 = 0.0f;
        }
        while (d2 > this.maxPathLocation) {
            d2 -= this.maxPathLocation;
        }
        while (d2 < 0.0) {
            d2 += this.maxPathLocation;
        }
        while (f2 < 0.0f) {
            f2 += this.maxDistFromPath;
        }
        this.actPathLocation = d2;
        this.actDistFromPath = f2;
        double d3 = f2 > 0.0f && this.maxPathLocation > 0.0 ? (this.maxPathLocation + this.ah * (double)f2) / this.maxPathLocation : 1.0;
        d2 = d3 * d2;
        for (n2 = 0; n2 < this.z.length - 1; ++n2) {
            double d4;
            if (this.ad[n2] == 1000.0) continue;
            if (f2 > 0.0f && n2 > 0 && (d4 = this.ad[n2] - this.ad[n2 - 1]) > 0.0) {
                double d5 = (double)f2 * d4;
                if (d2 < d5) {
                    d4 = d2 / (double)f2 - this.ad[n2 - 1];
                    this.updatePosition((float)((double)this.z[n2] + (double)f2 * Math.cos(d4) - (double)this.w), (float)((double)this.aa[n2] - (double)f2 * Math.sin(d4) - (double)this.u));
                    return;
                }
                d2 -= d5;
            }
            if (d2 == this.ae[n2]) {
                this.updatePosition((float)((double)this.z[n2 + 1] + (double)f2 * this.ag[n2] - (double)this.w), (float)((double)this.aa[n2 + 1] - (double)f2 * this.af[n2] - (double)this.u));
                return;
            }
            if (d2 < this.ae[n2]) {
                this.updatePosition((float)((double)this.z[n2] + d2 / this.ae[n2] * (double)(this.z[n2 + 1] - this.z[n2]) + (double)f2 * this.ag[n2] - (double)this.w), (float)((double)this.aa[n2] + d2 / this.ae[n2] * (double)(this.aa[n2 + 1] - this.aa[n2]) - (double)f2 * this.af[n2] - (double)this.u));
                return;
            }
            d2 -= this.ae[n2];
        }
        n2 = this.z.length - 1;
        if (n2 > 0) {
            this.updatePosition((float)((double)this.z[n2] + (double)f2 * this.ag[n2 - 1] - (double)this.w), (float)((double)this.aa[n2] - (double)f2 * this.af[n2 - 1] - (double)this.u));
        }
    }

    public void setTowardsPreferredPosition(double d2, float f2, int n2, int n3) {
        double d3;
        while (d2 < 0.0) {
            d2 += this.maxPathLocation;
        }
        while (d2 > this.maxPathLocation) {
            d2 -= this.maxPathLocation;
        }
        while (f2 < 0.0f) {
            f2 += this.maxDistFromPath;
        }
        float f3 = f2 - (float)(n2 + 1) / (float)n3 * (f2 - this.n);
        if (this.y) {
            double d4;
            int n4;
            int n5 = n2 % 2 == 0 ? n4 - n2 / 2 : -(n3 - 1) / 2 + n2 / 2;
            d3 = this.m + (double)n5 * (d4 = d2 - this.m) / (double)((n4 = n3 / 2) + 1);
            if (d3 < 0.0) {
                d3 += this.maxPathLocation;
            }
        } else if (d2 > this.m) {
            double d5 = d2 - this.m;
            d3 = d2 - (double)(n2 + 1) * d5 / (double)n3;
        } else {
            double d6 = this.m - d2;
            d3 = d2 + (double)(n2 + 1) * d6 / (double)n3;
        }
        this.setPosition(d3, f3);
    }

    public double getPreferredPathLocation() {
        return this.m;
    }

    public boolean considerObstacle(Object object) {
        return object != this.a;
    }

    final double b() {
        if (this.r == null || this.r.length < 2) {
            return 0.0;
        }
        IlvRect ilvRect = new IlvRect(this.getBoundingBox());
        ilvRect.x += this.w;
        ilvRect.y += this.u;
        ilvRect.width -= this.w + this.x;
        ilvRect.height -= this.u + this.v;
        if (ilvRect.width < 0.0f) {
            ilvRect.width = 0.0f;
        }
        if (ilvRect.height < 0.0f) {
            ilvRect.height = 0.0f;
        }
        double d2 = 0.0;
        for (int i2 = 1; i2 < this.r.length; ++i2) {
            d2 += LabelingUtil.GetOverlapWithLine(ilvRect, this.r[i2 - 1], this.r[i2], this.s);
        }
        return d2;
    }

    protected float getMinDist(Object object, float f2) {
        if (object == this.b) {
            return 0.0f;
        }
        if (object == this.c) {
            return 0.0f;
        }
        return f2;
    }

    public void setRelatedObstacle(Object object) {
        this.a = object;
    }

    public final Object getRelatedObstacle() {
        return this.a;
    }

    public void setRelatedObstacleSource(Object object) {
        this.b = object;
    }

    public final Object getRelatedObstacleSource() {
        return this.b;
    }

    public void setRelatedObstacleTarget(Object object) {
        this.c = object;
    }

    public final Object getRelatedObstacleTarget() {
        return this.c;
    }

    public void setReferencePoints(IlvPoint[] ilvPointArray) {
        if (ilvPointArray != null && ilvPointArray.length < 2) {
            throw new IllegalArgumentException("At least 2 polyline points are required");
        }
        this.d = this.a(ilvPointArray);
    }

    public final IlvPoint[] getReferencePoints() {
        return this.a(this.d);
    }

    private IlvPoint[] a(IlvPoint[] ilvPointArray) {
        if (ilvPointArray == null) {
            return null;
        }
        IlvPoint[] ilvPointArray2 = new IlvPoint[ilvPointArray.length];
        for (int i2 = 0; i2 < ilvPointArray.length; ++i2) {
            ilvPointArray2[i2] = ilvPointArray[i2] == null ? null : new IlvPoint(ilvPointArray[i2]);
        }
        return ilvPointArray2;
    }

    public void setLineWidth(float f2) {
        this.e = f2;
    }

    public final float getLineWidth() {
        return this.e;
    }

    public void setAnchor(int n2) {
        switch (n2) {
            case 0: {
                this.setMinPercentageFromStart(33.0f);
                this.setMaxPercentageFromStart(66.0f);
                this.setPreferredPercentageFromStart(50.0f);
                break;
            }
            case 1: {
                this.setMinPercentageFromStart(0.0f);
                this.setMaxPercentageFromStart(33.0f);
                this.setPreferredPercentageFromStart(0.0f);
                break;
            }
            case 2: {
                this.setMinPercentageFromStart(66.0f);
                this.setMaxPercentageFromStart(100.0f);
                this.setPreferredPercentageFromStart(100.0f);
                break;
            }
            case 3: {
                this.setMinPercentageFromStart(0.0f);
                this.setMaxPercentageFromStart(100.0f);
                this.setPreferredPercentageFromStart(50.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal anchor " + n2);
            }
        }
    }

    public final int getAnchor() {
        float f2 = this.getMinPercentageFromStart();
        float f3 = this.getMaxPercentageFromStart();
        float f4 = this.getPreferredPercentageFromStart();
        if (f2 == 33.0f && f3 == 66.0f && f4 == 50.0f) {
            return 0;
        }
        if (f2 == 0.0f && f3 == 33.0f && f4 == 0.0f) {
            return 1;
        }
        if (f2 == 66.0f && f3 == 100.0f && f4 == 100.0f) {
            return 2;
        }
        return 3;
    }

    public void setMinPercentageFromStart(float f2) {
        if (f2 < 0.0f || f2 > 100.0f) {
            throw new IllegalArgumentException("The minimal percentage must be between 0 and 100");
        }
        this.j = f2;
    }

    public final float getMinPercentageFromStart() {
        return this.j;
    }

    public void setMaxPercentageFromStart(float f2) {
        if (f2 < 0.0f || f2 > 100.0f) {
            throw new IllegalArgumentException("The maximal percentage must be between 0 and 100");
        }
        this.k = f2;
    }

    public final float getMaxPercentageFromStart() {
        return this.k;
    }

    public void setPreferredPercentageFromStart(float f2) {
        if (f2 > 100.0f) {
            throw new IllegalArgumentException("The preferred percentage must be between 0 and 100");
        }
        this.l = f2;
    }

    public final float getPreferredPercentageFromStart() {
        return this.l;
    }

    public void setTopOverlap(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The top overlap value must be positive");
        }
        this.f = f2;
    }

    public final float getTopOverlap() {
        return this.f;
    }

    public void setBottomOverlap(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The bottom overlap value must be positive");
        }
        this.g = f2;
    }

    public final float getBottomOverlap() {
        return this.g;
    }

    public void setLeftOverlap(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The left overlap value must be positive");
        }
        this.h = f2;
    }

    public final float getLeftOverlap() {
        return this.h;
    }

    public void setRightOverlap(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The right overlap value must be positive");
        }
        this.i = f2;
    }

    public final float getRightOverlap() {
        return this.i;
    }

    public void setPreferredSide(int n2) {
        this.o = n2;
    }

    public final int getPreferredSide() {
        return this.o;
    }

    public void setAllowedSide(int n2) {
        this.p = n2;
    }

    public final int getAllowedSide() {
        return this.p;
    }

    public void setSideAssociation(int n2) {
        this.q = n2;
    }

    public final int getSideAssociation() {
        return this.q;
    }

    public void setPreferredDistFromPath(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The preferred distance must be positive");
        }
        this.n = f2;
    }

    public final float getPreferredDistFromPath() {
        return this.n;
    }

    public void setMaxDistFromPath(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The maximal distance must be positive");
        }
        this.maxDistFromPath = f2;
    }

    public final float getMaxDistFromPath() {
        return this.maxDistFromPath;
    }

    public IlvAnnealingPolylineLabelDescriptor(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(null);
        try {
            this.a = ilvInputStream.readObject("relatedObstacle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = null;
        }
        try {
            this.b = ilvInputStream.readObject("source");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = null;
        }
        try {
            this.c = ilvInputStream.readObject("target");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.c = null;
        }
        try {
            this.d = ilvInputStream.readPointArray("referencePoints");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.d = null;
        }
        try {
            this.e = ilvInputStream.readFloat("lineWidth");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.e = -1.0f;
        }
        try {
            this.setAnchor(ilvInputStream.readInt("anchor"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.j = ilvInputStream.readFloat("minPercentageFromStart");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.j = 0.0f;
        }
        try {
            this.k = ilvInputStream.readFloat("maxPercentageFromStart");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.k = 100.0f;
        }
        try {
            this.l = ilvInputStream.readFloat("prefPercentageFromStart");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.l = -1.0f;
        }
        this.maxDistFromPath = ilvInputStream.readFloat("maxDistFromPath");
        this.n = ilvInputStream.readFloat("preferredDistFromPath");
        this.o = ilvInputStream.readInt("preferredSide");
        this.p = ilvInputStream.readInt("allowedSide");
        this.q = ilvInputStream.readInt("sideAssociation");
        this.f = ilvInputStream.readFloat("topOverlap");
        this.g = ilvInputStream.readFloat("bottomOverlap");
        this.h = ilvInputStream.readFloat("leftOverlap");
        this.i = ilvInputStream.readFloat("rightOverlap");
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.a != null && this.a instanceof IlvGraphic) {
            ilvOutputStream.write("relatedObstacle", (IlvGraphic)this.a);
        }
        if (this.b != null && this.b instanceof IlvGraphic) {
            ilvOutputStream.write("source", (IlvGraphic)this.b);
        }
        if (this.c != null && this.c instanceof IlvGraphic) {
            ilvOutputStream.write("target", (IlvGraphic)this.c);
        }
        if (this.d != null) {
            ilvOutputStream.write("referencePoints", this.d);
        }
        if (this.e >= 0.0f) {
            ilvOutputStream.write("lineWidth", this.e);
        }
        ilvOutputStream.write("minPercentageFromStart", this.j);
        ilvOutputStream.write("maxPercentageFromStart", this.k);
        ilvOutputStream.write("prefPercentageFromStart", this.l);
        ilvOutputStream.write("maxDistFromPath", this.maxDistFromPath);
        ilvOutputStream.write("preferredDistFromPath", this.n);
        ilvOutputStream.write("preferredSide", this.o);
        ilvOutputStream.write("allowedSide", this.p);
        ilvOutputStream.write("sideAssociation", this.q);
        ilvOutputStream.write("topOverlap", this.f);
        ilvOutputStream.write("bottomOverlap", this.g);
        ilvOutputStream.write("leftOverlap", this.h);
        ilvOutputStream.write("rightOverlap", this.i);
    }
}

