/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.tree;

import ilog.views.IlvGraphic;
import ilog.views.IlvNamedProperty;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.internalutil.AlignmentOptions;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvTreeLayoutNodeProperty
extends IlvGraphLayoutNodeProperty {
    static final long serialVersionUID = 4461764449158199120L;
    private int a;
    private int b;
    private boolean c;
    private IlvGraphic d;
    private IlvGraphic e;

    public IlvTreeLayoutNodeProperty(String string, IlvTreeLayout ilvTreeLayout, IlvGraphic ilvGraphic, boolean bl) {
        super(string, ilvTreeLayout, ilvGraphic, bl);
        try {
            this.a = ilvTreeLayout.getRootPreference(ilvGraphic);
        }
        catch (Exception exception) {
            this.a = -1;
        }
        try {
            this.b = ilvTreeLayout.getAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.b = 0;
        }
        try {
            this.c = ilvTreeLayout.au.contains(ilvGraphic);
        }
        catch (Exception exception) {
            this.c = false;
        }
        Object object = ilvTreeLayout.getEastNeighbor(ilvGraphic);
        this.d = object instanceof IlvGraphic ? (IlvGraphic)object : null;
        object = ilvTreeLayout.getWestNeighbor(ilvGraphic);
        this.e = object instanceof IlvGraphic ? (IlvGraphic)object : null;
    }

    public IlvTreeLayoutNodeProperty(IlvTreeLayoutNodeProperty ilvTreeLayoutNodeProperty) {
        super(ilvTreeLayoutNodeProperty);
        this.a = ilvTreeLayoutNodeProperty.a;
        this.b = ilvTreeLayoutNodeProperty.b;
        this.c = ilvTreeLayoutNodeProperty.c;
        this.d = ilvTreeLayoutNodeProperty.d;
        this.e = ilvTreeLayoutNodeProperty.e;
    }

    public IlvTreeLayoutNodeProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = ilvInputStream.readInt("rootPreference");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = -1;
        }
        try {
            this.b = AlignmentOptions.valueOf(ilvInputStream.readString("alignment"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = 0;
        }
        try {
            this.c = ilvInputStream.readBoolean("isRoot");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.c = false;
        }
        try {
            this.d = ilvInputStream.readObject("eastNeighbor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.d = null;
        }
        try {
            this.e = ilvInputStream.readObject("westNeighbor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.e = null;
        }
    }

    public IlvNamedProperty copy() {
        return new IlvTreeLayoutNodeProperty(this);
    }

    public boolean isPersistent() {
        if (super.isPersistent()) {
            return true;
        }
        if (this.a != -1) {
            return true;
        }
        if (this.b != 0) {
            return true;
        }
        if (this.c) {
            return true;
        }
        if (this.d != null) {
            return true;
        }
        return this.e != null;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.a != -1 || !this.omitDefaults()) {
            ilvOutputStream.write("rootPreference", this.a);
        }
        if (this.b != 0 || !this.omitDefaults()) {
            ilvOutputStream.write("alignment", AlignmentOptions.toString(this.b));
        }
        if (this.c || !this.omitDefaults()) {
            ilvOutputStream.write("isRoot", this.c);
        }
        if (this.d != null && this.isWritten(this.d)) {
            ilvOutputStream.write("eastNeighbor", this.d);
        }
        if (this.e != null && this.isWritten(this.e)) {
            ilvOutputStream.write("westNeighbor", this.e);
        }
    }

    public void transfer(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        if (ilvGraphLayout == null) {
            return;
        }
        super.transfer(ilvGraphLayout, ilvGraphic);
        IlvTreeLayout ilvTreeLayout = (IlvTreeLayout)ilvGraphLayout;
        try {
            if (this.c) {
                ilvTreeLayout.setRoot(ilvGraphic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setRootPreference(ilvGraphic, this.a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setAlignment(ilvGraphic, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.d != null) {
            ilvTreeLayout.setEastWestNeighboring(this.d, ilvGraphic);
        }
        if (this.e != null) {
            ilvTreeLayout.setWestEastNeighboring(this.e, ilvGraphic);
        }
    }

    public void dispose(IlvGrapherAdapter ilvGrapherAdapter) {
        super.dispose(ilvGrapherAdapter);
    }
}

