/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public abstract class IlvMoveRectangleInteractor
extends IlvManagerViewInteractor {
    private boolean a = false;
    private boolean b = false;
    private final IlvPoint c = new IlvPoint();
    private final IlvPoint d = new IlvPoint();
    final IlvRect e = new IlvRect();
    private static IlvPoint f = new IlvPoint();
    private float[] g;
    private transient IlvPoint[] h;
    private Cursor i = null;
    private Cursor j = null;
    private int k = 0;
    private transient boolean l;
    private boolean m = false;

    public IlvMoveRectangleInteractor(IlvRect ilvRect) {
        this.setRectangle(ilvRect);
        this.enableEvents(48L);
    }

    public final boolean isGridMode() {
        return this.b;
    }

    public final void setGridMode(boolean bl) {
        this.b = bl;
    }

    public int getMoveThreshold() {
        return this.k;
    }

    public void setMoveThreshold(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("value must be >= 0");
        }
        this.k = n2;
    }

    public void setOpaqueMode(boolean bl) {
        this.m = bl;
    }

    public boolean isOpaqueMode() {
        return this.m;
    }

    public boolean isXORGhost() {
        return !this.isOpaqueMode();
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        this.j = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
        ilvManagerView.setCursor(this.getCursor());
    }

    protected void detach() {
        this.b();
        this.getManagerView().setCursor(this.j);
        this.j = null;
        this.a = false;
        this.l = false;
        super.detach();
    }

    public Cursor getCursor() {
        if (this.i != null) {
            return this.i;
        }
        if (this.getManagerView() != null) {
            return this.getManagerView().getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    public void setCursor(Cursor cursor) {
        this.i = cursor;
    }

    public final IlvRect getRectangle() {
        return new IlvRect(this.e);
    }

    public final void setRectangle(IlvRect ilvRect) {
        float f2 = this.e.x;
        float f3 = this.e.y;
        float f4 = this.e.width;
        float f5 = this.e.height;
        this.e.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        if (this.a) {
            if (this.e.width == f4 && this.e.height == f5) {
                this.c.move(this.d.x + this.e.x - f2, this.d.y + this.e.y - f3);
                this.d.move(this.c.x, this.c.y);
            } else {
                this.c.move(this.d.x, this.d.y);
            }
        }
    }

    public void setLineStyle(float[] fArray) {
        this.g = fArray;
    }

    public float[] getLineStyle() {
        return this.g;
    }

    final void a() {
        if (!this.b) {
            return;
        }
        this.snapRectangleToGrid(this.e);
    }

    protected void snapRectangleToGrid(IlvRect ilvRect) {
        IlvMoveRectangleInteractor.f.x = ilvRect.x;
        IlvMoveRectangleInteractor.f.y = ilvRect.y;
        if (this.getManagerView() != null) {
            this.getManagerView().snapToGrid(f);
        }
        ilvRect.x = IlvMoveRectangleInteractor.f.x;
        ilvRect.y = IlvMoveRectangleInteractor.f.y;
    }

    protected boolean isDragging() {
        return this.a && this.l;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.handleButtonDown(mouseEvent);
                break;
            }
            case 502: {
                this.handleButtonUp(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected boolean handleButtonDown(MouseEvent mouseEvent) {
        if (this.a) {
            return false;
        }
        this.l = false;
        if ((mouseEvent.getModifiers() & 8) != 0 || (mouseEvent.getModifiers() & 4) != 0) {
            return false;
        }
        this.a = true;
        IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
        this.c.move(ilvPoint.x, ilvPoint.y);
        this.d.move(ilvPoint.x, ilvPoint.y);
        return true;
    }

    protected boolean handleButtonUp(MouseEvent mouseEvent) {
        if (!this.a) {
            return false;
        }
        IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
        if (this.l) {
            this.b();
            this.a = false;
            this.l = false;
            float f2 = this.e.x;
            float f3 = this.e.y;
            this.e.x += ilvPoint.x - this.d.x;
            this.e.y += ilvPoint.y - this.d.y;
            this.a();
            this.d.x += this.e.x - f2;
            this.d.y += this.e.y - f3;
            this.trigger(mouseEvent, this.d.x - this.c.x, this.d.y - this.c.y);
        } else {
            this.a = false;
            this.l = false;
            this.trigger(mouseEvent, 0.0f, 0.0f);
        }
        return true;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.handleButtonDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected boolean handleButtonDragged(MouseEvent mouseEvent) {
        if (!this.a) {
            return false;
        }
        IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
        if (this.l || Math.sqrt((ilvPoint.x - this.c.x) * (ilvPoint.x - this.c.x) + (ilvPoint.y - this.c.y) * (ilvPoint.y - this.c.y)) > (double)this.k) {
            IlvTransformer ilvTransformer;
            if (this.l) {
                this.c();
            } else {
                this.l = true;
            }
            float f2 = this.e.x;
            float f3 = this.e.y;
            this.e.x += ilvPoint.x - this.d.x;
            this.e.y += ilvPoint.y - this.d.y;
            this.a();
            this.d.x += this.e.x - f2;
            this.d.y += this.e.y - f3;
            IlvTransformer ilvTransformer2 = this.getTransformer();
            boolean bl = this.getManagerView().isOptimizedTranslation();
            if (!bl) {
                this.b();
            }
            this.ensureVisible(ilvPoint);
            if (!bl) {
                this.drawGhost();
            }
            if (!ilvTransformer2.equals(ilvTransformer = this.getTransformer())) {
                ilvPoint.move(this.e.x, this.e.y);
                ilvTransformer2.inverse(ilvPoint);
                ilvTransformer.apply(ilvPoint);
                this.e.x = ilvPoint.x;
                this.e.y = ilvPoint.y;
                ilvTransformer2.inverse(this.d);
                ilvTransformer.apply(this.d);
                ilvTransformer2.inverse(this.c);
                ilvTransformer.apply(this.c);
            }
            this.c();
            this.rectangleDragged(mouseEvent, this.d.x - this.c.x, this.d.y - this.c.y);
        }
        return true;
    }

    public void drawGhost(Graphics graphics) {
        if (this.isDragging()) {
            if (this.g == null) {
                graphics.drawRect((int)Math.floor(this.e.x), (int)Math.floor(this.e.y), (int)Math.floor(this.e.width), (int)Math.floor(this.e.height));
            } else {
                if (this.h == null) {
                    this.h = new IlvPoint[5];
                    for (int i2 = 0; i2 < 5; ++i2) {
                        this.h[i2] = new IlvPoint();
                    }
                }
                this.h[0].move(this.e.x, this.e.y);
                this.h[1].move(this.e.x + this.e.width, this.e.y);
                this.h[2].move(this.e.x + this.e.width, this.e.y + this.e.height);
                this.h[3].move(this.e.x, this.e.y + this.e.height);
                this.h[4].move(this.e.x, this.e.y);
                IlvGraphicUtil.DrawPolyline(graphics, this.h, 5, 1.0f, 1, 0, this.g, null);
            }
        }
    }

    private void b() {
        this.c();
    }

    private void c() {
        if (this.isOpaqueMode()) {
            IlvManagerView ilvManagerView = this.getManagerView();
            if (ilvManagerView == null) {
                return;
            }
            if (this.e.width > 0.0f && this.e.height > 0.0f) {
                IlvRect ilvRect = new IlvRect(this.e);
                ilvManagerView.invalidateRect(ilvRect);
                ilvManagerView.reDrawViews();
            }
        } else {
            this.drawGhost();
        }
    }

    protected boolean trigger(AWTEvent aWTEvent, float f2, float f3) {
        return true;
    }

    protected void rectangleDragged(AWTEvent aWTEvent, float f2, float f3) {
    }
}

