/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.awt.IlvScrollManagerView;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Adjustable;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;

public final class IlvUtility {
    public static final float NEAR_ZERO_FLOAT = 1.0E-20f;
    public static final String ClipProperty = "__ClipProperty";
    public static IlvSwingUtil.Version JDK14 = new IlvSwingUtil.Version(1, 4, 0);

    private IlvUtility() {
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        String string = "ILOG JViews Component Suite Version " + IlvUtil.GetVersion() + "." + IlvUtil.GetMinorVersion();
        if (IlvUtil.GetSubMinorVersion() != 0) {
            string = string + "." + IlvUtil.GetSubMinorVersion();
        }
        if (IlvUtil.GetPatchLevel() != 0) {
            string = string + " Patch Level " + IlvUtil.GetPatchLevel();
        }
        printStream.println(string);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Package[] packageArray;
                if (!"-packageinfo".equals(stringArray[i2]) || (packageArray = Package.getPackages()) == null) continue;
                for (int i3 = 0; i3 < packageArray.length; ++i3) {
                    IlvUtility.a(packageArray[i3], "ilog.views", printStream);
                }
            }
        }
    }

    private static void a(Package package_, String string, PrintStream printStream) {
        if (package_ != null && (string == null || package_.getName().equals(string))) {
            printStream.println("Name: " + package_.getName());
            printStream.println("Specification-Title: " + package_.getSpecificationTitle());
            printStream.println("Specification-Version: " + package_.getSpecificationVersion());
            printStream.println("Specification-Vendor: " + package_.getSpecificationVendor());
            printStream.println("Implementation-Title: " + package_.getImplementationTitle());
            printStream.println("Implementation-Version: " + package_.getImplementationVersion());
            printStream.println("Implementation-Vendor: " + package_.getImplementationVendor());
        }
    }

    public static boolean IntersectHorizontal(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        return IlvUtility.IntersectHorizontal(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y);
    }

    public static boolean IntersectHorizontal(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d7 - d5) * (d4 - d2) + (d3 - d5) * (d6 - d4);
        if (d7 > d5) {
            return d3 >= d5 && d3 < d7 && d8 >= 0.0;
        }
        return d3 >= d7 && d3 < d5 && d8 < 0.0;
    }

    public static IlvGraphic getRealVisibleObject(IlvGraphicBag ilvGraphicBag, IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getGraphicBag();
        IlvGraphic ilvGraphic2 = ilvGraphic;
        while (ilvGraphicBag2 != null && ilvGraphicBag2 != ilvGraphicBag) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag2;
            if (ilvManager.isCollapsed()) {
                ilvGraphic2 = ilvManager;
            }
            ilvGraphicBag2 = ilvManager.getGraphicBag();
        }
        return ilvGraphic2;
    }

    public static float arrowSize(float f2, IlvTransformer ilvTransformer) {
        double d2;
        double d3 = d2 = ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor();
        if (f2 == 0.0f) {
            if (d2 >= 1.0) {
                return 4.0f;
            }
            return (float)(4.0 * d2);
        }
        if (f2 <= 1.0f) {
            if ((double)f2 * d2 >= 1.0) {
                return (float)(3.25 + (double)(0.75f * f2) * d2);
            }
            return (float)((double)(4.0f * f2) * d2);
        }
        if (d2 <= 1.0) {
            return (float)((double)(0.75f * f2 + 3.25f) * d2);
        }
        return (float)(3.25 + (double)(0.75f * f2) * d2);
    }

    public static void ComputeArrow(float f2, float f3, float f4, float f5, float f6, IlvPoint[] ilvPointArray, float f7) {
        double d2 = f4 - f2;
        double d3 = f5 - f3;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 >= (double)1.0E-20f) {
            d5 = d2 / d4;
            d6 = d3 / d4;
        }
        double d7 = 2.0f * f7;
        d7 = Math.min(d7, (double)f6 * d4);
        double d8 = (double)f7 * d6;
        double d9 = (double)f7 * d5;
        double d10 = (double)f4 - d7 * d5;
        double d11 = (double)f5 - d7 * d6;
        ilvPointArray[0].move(f4, f5);
        ilvPointArray[1].move((float)(d10 + d8), (float)(d11 - d9));
        ilvPointArray[2].move((float)(d10 - d8), (float)(d11 + d9));
        if (f6 != 1.0f) {
            float f8 = (float)((double)(f6 - 1.0f) * d2);
            float f9 = (float)((double)(f6 - 1.0f) * d3);
            ilvPointArray[0].translate(f8, f9);
            ilvPointArray[1].translate(f8, f9);
            ilvPointArray[2].translate(f8, f9);
        }
    }

    public static void drawArrow(Graphics graphics, float f2, float f3, float f4, float f5, float f6, float f7) {
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint()};
        IlvUtility.ComputeArrow(f2, f3, f4, f5, f6, ilvPointArray, f7);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = (int)Math.floor(ilvPointArray[0].x);
        nArray[1] = Math.round(ilvPointArray[1].x);
        nArray[2] = Math.round(ilvPointArray[2].x);
        nArray2[0] = (int)Math.floor(ilvPointArray[0].y);
        nArray2[1] = Math.round(ilvPointArray[1].y);
        nArray2[2] = Math.round(ilvPointArray[2].y);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public static AffineTransform IlvToJava2DTransformer(IlvTransformer ilvTransformer, AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        } else {
            affineTransform.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        }
        return affineTransform;
    }

    public static IlvRect Java2DToIlvRect(Rectangle2D rectangle2D, IlvRect ilvRect) {
        if (ilvRect == null) {
            ilvRect = new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        } else {
            ilvRect.setRect(rectangle2D);
        }
        return ilvRect;
    }

    public static void scrollByBlock(Adjustable adjustable, int n2) {
        int n3 = adjustable.getValue();
        int n4 = adjustable.getBlockIncrement();
        int n5 = n4 * (n2 > 0 ? 1 : -1);
        adjustable.setValue(n3 + n5);
    }

    public static void scrollByUnits(Adjustable adjustable, int n2, int n3) {
        int n4 = n3;
        n4 = n2 > 0 ? (n4 *= adjustable.getUnitIncrement()) : (n4 *= -adjustable.getUnitIncrement());
        int n5 = adjustable.getValue();
        int n6 = n5 + n4;
        if (n4 > 0 && n6 < n5) {
            n6 = adjustable.getMaximum();
        } else if (n4 < 0 && n6 > n5) {
            n6 = adjustable.getMinimum();
        }
        adjustable.setValue(n6);
    }

    public static boolean isOutside(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag;
        for (ilvGraphicBag = ilvGraphic.getGraphicBag(); ilvGraphicBag != ilvGrapher && ilvGraphicBag != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
        }
        return ilvGraphicBag == null;
    }

    public static void correctMoveResizeNonzoomableGraphic(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl, boolean bl2) {
        IlvRect ilvRect2 = ilvGraphic.boundingBox(null);
        float f2 = 0.0f;
        if (bl) {
            f2 = Math.max(f2, Math.abs(ilvRect2.x - ilvRect.x));
            f2 = Math.max(f2, Math.abs(ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width));
            f2 = Math.max(f2, Math.abs(ilvRect2.width - ilvRect.width));
            ilvRect2.x = ilvRect.x;
            ilvRect2.width = ilvRect.width;
        }
        if (bl2) {
            f2 = Math.max(f2, Math.abs(ilvRect2.y - ilvRect.y));
            f2 = Math.max(f2, Math.abs(ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height));
            f2 = Math.max(f2, Math.abs(ilvRect2.height - ilvRect.height));
            ilvRect2.y = ilvRect.y;
            ilvRect2.height = ilvRect.height;
        }
        if (f2 > 0.5f) {
            IlvUtility.a(ilvGraphic, ilvRect2);
        }
    }

    private static void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        IlvUtility.adjustToAvoidZeroSize(ilvRect2);
        for (int i2 = 0; i2 < 4; ++i2) {
            IlvRect ilvRect3 = ilvGraphic.boundingBox(null);
            if (ilvRect3.equals(ilvRect2)) {
                return;
            }
            IlvUtility.adjustToAvoidZeroSize(ilvRect3);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect3, ilvRect2, ilvTransformer);
            if (ilvTransformer.isBad()) {
                return;
            }
            ilvGraphic.applyTransform(ilvTransformer);
        }
    }

    public static void adjustToAvoidZeroSize(IlvRect ilvRect) {
        if (ilvRect.width < 0.1f) {
            ilvRect.width = 0.1f;
        }
        if (ilvRect.height < 0.1f) {
            ilvRect.height = 0.1f;
        }
    }

    public static class MouseWheelAdapter
    implements MouseWheelListener {
        private IlvJScrollManagerView a;
        private IlvScrollManagerView b;

        public MouseWheelAdapter(IlvJScrollManagerView ilvJScrollManagerView) {
            this.a = ilvJScrollManagerView;
        }

        public MouseWheelAdapter(IlvScrollManagerView ilvScrollManagerView) {
            this.b = ilvScrollManagerView;
        }

        public Adjustable getVerticalScrollBar() {
            if (this.a != null) {
                return this.a.getVerticalScrollBar();
            }
            return this.b.getVerticalAdjustable();
        }

        public boolean isVerticalScrollBarVisible() {
            if (this.a != null) {
                return this.a.isVerticalScrollBarVisible();
            }
            return this.b.isVerticalScrollbarVisible();
        }

        public Adjustable getHorizontalScrollBar() {
            if (this.a != null) {
                return this.a.getHorizontalScrollBar();
            }
            return this.b.getHorizontalAdjustable();
        }

        public boolean isHorizontalScrollBarVisible() {
            if (this.a != null) {
                return this.a.isHorizontalScrollBarVisible();
            }
            return this.b.isHorizontalScrollbarVisible();
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollAmount() != 0) {
                int n2;
                Adjustable adjustable = this.getVerticalScrollBar();
                if (!(adjustable != null && adjustable.getVisibleAmount() != adjustable.getMaximum() && this.isVerticalScrollBarVisible() || (adjustable = this.getHorizontalScrollBar()) != null && this.isHorizontalScrollBarVisible())) {
                    return;
                }
                int n3 = n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    IlvUtility.scrollByUnits(adjustable, n2, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    IlvUtility.scrollByBlock(adjustable, n2);
                }
            }
        }
    }
}

