/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.java2d;

import ilog.views.IlvPoint;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.java2d.IlvMultipleGradientPaint;
import ilog.views.util.java2d.internal.IlvLinearGradientPaintContext;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;

public class IlvLinearGradientPaint
extends IlvMultipleGradientPaint
implements IlvPersistentObject {
    private Point2D.Float a;
    private Point2D.Float b;

    public IlvLinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray, boolean bl) {
        this(f2, f3, f4, f5, fArray, colorArray, 1, bl);
    }

    public IlvLinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray, short s2, boolean bl) {
        this(new Point2D.Float(f2, f3), new Point2D.Float(f4, f5), fArray, colorArray, s2, bl);
    }

    public IlvLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, boolean bl) {
        this(point2D, point2D2, fArray, colorArray, 1, bl);
    }

    public IlvLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, short s2, boolean bl) {
        this(point2D, point2D2, fArray, colorArray, s2, 0, null, bl);
    }

    public IlvLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, short s2, short s3, AffineTransform affineTransform, boolean bl) {
        super(fArray, colorArray, s2, s3, affineTransform, bl);
        if (point2D == null || point2D2 == null || point2D.equals(point2D2)) {
            throw new IllegalArgumentException("Invalid start and/or end point: " + point2D + " " + point2D2);
        }
        this.a = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        this.b = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
    }

    void a(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        this.a = ilvInputStream.readPoint("start");
        this.b = ilvInputStream.readPoint("end");
        super.a(ilvInputStream);
    }

    public IlvLinearGradientPaint(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.g || this.d != null) {
            affineTransform = new AffineTransform(affineTransform);
        }
        if (this.g) {
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (this.d != null) {
            affineTransform.concatenate(this.d);
        }
        try {
            return new IlvLinearGradientPaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, this.a, this.b, ((IlvMultipleGradientPaint)this).b, this.c, this.e, this.f);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return Color.black.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
        }
    }

    public Point2D getStart() {
        return (Point2D)this.a.clone();
    }

    public Point2D getEnd() {
        return (Point2D)this.b.clone();
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("start", new IlvPoint(this.a.x, this.a.y));
        ilvOutputStream.write("end", new IlvPoint(this.b.x, this.b.y));
        super.write(ilvOutputStream);
    }
}

