/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.beans.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTexture;
import ilog.views.io.IlvOutputStream;
import ilog.views.sdm.beans.editor.EnumPropertyEditor;
import ilog.views.sdm.graphic.IlvGeneralLink;
import ilog.views.util.beans.editor.IlvArrayPropertyEditor;
import ilog.views.util.beans.editor.IlvTaggedIntValueEditor;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GeneralLinkEditors {

    public static class ArrowModePropertyEditor
    extends EnumPropertyEditor {
        public ArrowModePropertyEditor() {
            super(IlvGeneralLink.class, new String[]{"ARROW_FILL", "ARROW_OPEN", "ARROW_GRADIENT", "ARROW_DECORATION"});
        }
    }

    public static class DecoAttArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public DecoAttArrayPropertyEditor() {
            this.setPropertyEditorClass(DecoAttEditor.class);
        }

        public String getJavaInitializationString() {
            return "new int[] {" + this.getAsText() + "}";
        }

        protected Object objectArrayFrom(String[] stringArray) {
            int[] nArray = new int[stringArray.length];
            block2: for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    nArray[i2] = Integer.parseInt(stringArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    while (true) {
                        if (stringArray[i2].startsWith("DECORATION_ANIMATE")) {
                            int n2 = i2;
                            nArray[n2] = nArray[n2] | 1;
                        } else if (stringArray[i2].startsWith("DECORATION_ROTATE")) {
                            int n3 = i2;
                            nArray[n3] = nArray[n3] | 2;
                        } else if (stringArray[i2].startsWith("DECORATION_FIXED_SIZE")) {
                            int n4 = i2;
                            nArray[n4] = nArray[n4] | 4;
                        } else if (stringArray[i2].startsWith("DECORATION_ANCHOR_TOP")) {
                            int n5 = i2;
                            nArray[n5] = nArray[n5] | 8;
                        } else if (stringArray[i2].startsWith("DECORATION_ANCHOR_BOTTOM")) {
                            int n6 = i2;
                            nArray[n6] = nArray[n6] | 0x10;
                        } else if (stringArray[i2].startsWith("DECORATION_ANCHOR_LEFT")) {
                            int n7 = i2;
                            nArray[n7] = nArray[n7] | 0x20;
                        } else if (stringArray[i2].startsWith("DECORATION_ANCHOR_RIGHT")) {
                            int n8 = i2;
                            nArray[n8] = nArray[n8] | 0x40;
                        } else if (stringArray[i2].startsWith("DECORATION_OVER")) {
                            int n9 = i2;
                            nArray[n9] = nArray[n9] | 0x80;
                        } else if (stringArray[i2].startsWith("DECORATION_ABSOLUTE")) {
                            int n10 = i2;
                            nArray[n10] = nArray[n10] | 0x100;
                        } else if (stringArray[i2].startsWith("DECORATION_FULL_RETRACT_AT_END")) {
                            int n11 = i2;
                            nArray[n11] = nArray[n11] | 0x200;
                        } else if (stringArray[i2].startsWith("DECORATION_HALF_RETRACT_AT_END")) {
                            int n12 = i2;
                            nArray[n12] = nArray[n12] | 0x400;
                        } else {
                            if (!stringArray[i2].startsWith("DECORATION_NO_RETRACT_AT_END")) continue block2;
                            int n13 = i2;
                            nArray[n13] = nArray[n13] | 0x800;
                        }
                        int n14 = stringArray[i2].indexOf("|");
                        if (n14 == -1) continue block2;
                        stringArray[i2] = stringArray[i2].substring(n14 + 1).trim();
                    }
                }
            }
            return nArray;
        }
    }

    static class DecoAttChooser
    extends JPanel
    implements ActionListener {
        DecoAttEditor a;
        JCheckBox b;
        JCheckBox c;
        JCheckBox d;
        JCheckBox e;
        JCheckBox f;
        JCheckBox g;
        JCheckBox h;
        JCheckBox i;
        int j;

        public DecoAttChooser(DecoAttEditor decoAttEditor) {
            this.setLayout(new GridLayout(5, 5, 4, 4));
            this.a = decoAttEditor;
            this.b = new JCheckBox("Animate");
            this.b.setActionCommand(String.valueOf(1));
            this.b.addActionListener(this);
            this.add(this.b);
            this.c = new JCheckBox("Rotate");
            this.c.setActionCommand(String.valueOf(2));
            this.c.addActionListener(this);
            this.add(this.c);
            this.d = new JCheckBox("Fixed Size");
            this.d.setActionCommand(String.valueOf(4));
            this.d.addActionListener(this);
            this.add(this.d);
            this.e = new JCheckBox("Anchor Top");
            this.e.setActionCommand(String.valueOf(8));
            this.e.addActionListener(this);
            this.add(this.e);
            this.f = new JCheckBox("Anchor Bottom");
            this.f.setActionCommand(String.valueOf(16));
            this.f.addActionListener(this);
            this.add(this.f);
            this.g = new JCheckBox("Anchor Left");
            this.g.setActionCommand(String.valueOf(32));
            this.g.addActionListener(this);
            this.add(this.g);
            this.h = new JCheckBox("Anchor Right");
            this.h.setActionCommand(String.valueOf(64));
            this.h.addActionListener(this);
            this.add(this.h);
            this.i = new JCheckBox("Over");
            this.i.setActionCommand(String.valueOf(128));
            this.i.addActionListener(this);
            this.add(this.i);
        }

        public void updateValue(int n2) {
            this.b.setSelected((n2 & 1) != 0);
            this.c.setSelected((n2 & 2) != 0);
            this.g.setSelected((n2 & 0x20) != 0);
            this.d.setSelected((n2 & 4) != 0);
            this.e.setSelected((n2 & 8) != 0);
            this.i.setSelected((n2 & 0x80) != 0);
            this.h.setSelected((n2 & 0x40) != 0);
            this.f.setSelected((n2 & 0x10) != 0);
            this.j = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            int n2 = Integer.parseInt(actionEvent.getActionCommand());
            this.j = bl ? this.j | n2 : this.j & ~n2;
            this.a.firePropertyChange();
        }
    }

    public static class DecoAttEditor
    extends PropertyEditorSupport {
        private DecoAttChooser a = null;

        int a() {
            return super.getValue() != null ? (Integer)super.getValue() : 0;
        }

        public String getAsText() {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.a();
            if ((n2 & 1) != 0) {
                stringBuffer.append("|DECORATION_ANIMATE");
            }
            if ((n2 & 2) != 0) {
                stringBuffer.append("|DECORATION_ROTATE");
            }
            if ((n2 & 0x20) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_LEFT");
            }
            if ((n2 & 4) != 0) {
                stringBuffer.append("|DECORATION_FIXED_SIZE");
            }
            if ((n2 & 8) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_TOP");
            }
            if ((n2 & 0x10) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_BOTTOM");
            }
            if ((n2 & 0x40) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_RIGHT");
            }
            if ((n2 & 0x80) != 0) {
                stringBuffer.append("|DECORATION_OVER");
            }
            if ((n2 & 0x100) != 0) {
                stringBuffer.append("|DECORATION_ABSOLUTE");
            }
            return stringBuffer.length() > 0 ? stringBuffer.substring(1) : "";
        }

        public Object getValue() {
            if (this.a != null) {
                return new Integer(this.a.j);
            }
            return super.getValue();
        }

        public void setValue(Object object) {
            super.setValue(object);
            if (this.a != null) {
                this.a.updateValue(this.a());
            }
        }

        public Component getCustomEditor() {
            if (this.a == null) {
                this.a = new DecoAttChooser(this);
                this.a.updateValue(this.a());
            }
            return this.a;
        }

        public boolean supportsCustomEditor() {
            return true;
        }
    }

    public static class GraphicArrayPropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        public String getJavaInitializationString() {
            return "too complex";
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                IlvGraphic[] ilvGraphicArray = (IlvGraphic[])this.getValue();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IlvOutputStream ilvOutputStream = new IlvOutputStream(byteArrayOutputStream);
                IlvManager ilvManager = new IlvManager();
                for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                    ilvManager.addObject(ilvGraphicArray[i2], false);
                }
                ilvManager.write(ilvOutputStream);
                ilvOutputStream.flush();
                return byteArrayOutputStream.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Error";
            }
        }

        public void setAsText(String string) throws IllegalArgumentException {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                IlvManager ilvManager = new IlvManager();
                ilvManager.read(byteArrayInputStream);
                IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects();
                int n2 = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ++n2;
                    ilvGraphicEnumeration.nextElement();
                }
                IlvGraphic[] ilvGraphicArray = new IlvGraphic[n2];
                ilvGraphicEnumeration = ilvManager.getObjects();
                n2 = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvGraphicArray[n2++] = ilvGraphicEnumeration.nextElement();
                }
                this.setValue(ilvGraphicArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public static class LineJoinPropertyEditor
    extends IlvTaggedIntValueEditor {
        protected String[] createTags() {
            return new String[]{"JOIN_BEVEL", "JOIN_MITER", "JOIN_ROUND"};
        }

        protected String[] createStringValues() {
            return new String[]{"ilog.views.IlvStroke.JOIN_BEVEL", "ilog.views.IlvStroke.JOIN_MITER", "ilog.views.IlvStroke.JOIN_ROUND"};
        }

        protected int[] createIntValues() {
            return new int[]{0, 1, 2};
        }
    }

    public static class ModePropertyEditor
    extends EnumPropertyEditor {
        public ModePropertyEditor() {
            super(IlvGeneralLink.class, new String[]{"MODE_TEXTURE", "MODE_UNICOLOR", "MODE_GRADIENT", "MODE_NEON"});
        }
    }

    public static class PointArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public String getJavaInitializationString() {
            StringBuffer stringBuffer = new StringBuffer("new IlvPoint[] {");
            IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
            for (int i2 = 0; i2 < ilvPointArray.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("new IlvPoint(").append(ilvPointArray[i2].x).append(",").append(ilvPointArray[i2].y).append(")");
            }
            stringBuffer.append("};");
            return stringBuffer.toString();
        }

        protected Object objectArrayFrom(String[] stringArray) {
            if (stringArray.length % 2 == 1) {
                throw new IllegalArgumentException("odd number of float");
            }
            IlvPoint[] ilvPointArray = new IlvPoint[stringArray.length / 2];
            for (int i2 = 0; i2 < ilvPointArray.length; ++i2) {
                ilvPointArray[i2] = new IlvPoint(Float.parseFloat(stringArray[2 * i2]), Float.parseFloat(stringArray[2 * i2 + 1]));
            }
            return ilvPointArray;
        }
    }

    public static class TexturePropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        public String getJavaInitializationString() {
            return "new ilog.views.IlvTexture(new java.net.URL(\"" + this.getAsText() + "\"))";
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                return ((IlvTexture)this.getValue()).getImageURL().toString();
            }
            catch (Exception exception) {
                return "Error";
            }
        }

        public void setAsText(String string) throws IllegalArgumentException {
            try {
                this.setValue(new IlvTexture(new URL(string)));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }
}

