/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import ilog.views.util.collections.IlvUnaryPredicate;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IlvCollections {
    private static ListIterator a;
    private static IlvUnaryPredicate b;
    private static IlvUnaryPredicate c;

    private IlvCollections() {
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        return iterator == null ? null : new ReadOnlyIterator(iterator);
    }

    public static ListIterator unmodifiableIterator(ListIterator listIterator) {
        return listIterator == null ? null : new ReadOnlyListIterator(listIterator);
    }

    public static ListIterator reversedIterator(ListIterator listIterator) {
        return listIterator == null ? null : new ReversedListIterator(listIterator);
    }

    public static ListIterator reversedIterator(List list) {
        return IlvCollections.reversedIterator(list.listIterator(list.size()));
    }

    public static Iterator emptyIterator() {
        return IlvCollections.emptyListIterator();
    }

    public static ListIterator emptyListIterator() {
        if (a == null) {
            a = new ListIterator(){

                public boolean hasNext() {
                    return false;
                }

                public boolean hasPrevious() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public Object previous() {
                    throw new NoSuchElementException();
                }

                public int nextIndex() {
                    return 0;
                }

                public int previousIndex() {
                    return -1;
                }

                public void remove() {
                    throw new IllegalStateException();
                }

                public void set(Object object) {
                    throw new IllegalStateException();
                }

                public void add(Object object) {
                    throw new IllegalStateException();
                }
            };
        }
        return a;
    }

    public static Iterator oneElementIterator(Object object) {
        return new OneElementIterator(object);
    }

    public static ListIterator oneElementListIterator(Object object) {
        return new OneElementIterator(object);
    }

    public static IlvUnaryPredicate trueUnaryPredicate() {
        if (b == null) {
            b = new IlvUnaryPredicate(){

                public boolean evaluate(Object object) {
                    return true;
                }
            };
        }
        return b;
    }

    public static IlvUnaryPredicate falseUnaryPredicate() {
        if (c == null) {
            c = new IlvUnaryPredicate(){

                public boolean evaluate(Object object) {
                    return false;
                }
            };
        }
        return c;
    }

    private static final class OneElementIterator
    implements ListIterator {
        Object a;
        boolean b;
        boolean c;

        OneElementIterator(Object object) {
            this.a = object;
            this.b = true;
            this.c = false;
        }

        public boolean hasNext() {
            return this.b;
        }

        public boolean hasPrevious() {
            return this.c;
        }

        public Object next() {
            if (!this.b) {
                throw new IllegalStateException();
            }
            this.b = false;
            this.c = true;
            return this.a;
        }

        public Object previous() {
            if (!this.c) {
                throw new IllegalStateException();
            }
            this.c = false;
            this.b = true;
            return this.a;
        }

        public int nextIndex() {
            if (this.b) {
                return 0;
            }
            return 1;
        }

        public int previousIndex() {
            if (this.c) {
                return 0;
            }
            return -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReadOnlyIterator
    implements Iterator {
        Iterator a;

        ReadOnlyIterator(Iterator iterator) {
            this.a = iterator;
        }

        public boolean hasNext() {
            return this.a.hasNext();
        }

        public Object next() {
            return this.a.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReadOnlyListIterator
    implements ListIterator {
        ListIterator a;

        ReadOnlyListIterator(ListIterator listIterator) {
            this.a = listIterator;
        }

        public boolean hasNext() {
            return this.a.hasNext();
        }

        public Object next() {
            return this.a.next();
        }

        public boolean hasPrevious() {
            return this.a.hasPrevious();
        }

        public Object previous() {
            return this.a.previous();
        }

        public int nextIndex() {
            return this.a.nextIndex();
        }

        public int previousIndex() {
            return this.a.previousIndex();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReversedListIterator
    implements ListIterator {
        ListIterator a;

        ReversedListIterator(ListIterator listIterator) {
            this.a = listIterator;
        }

        public boolean hasNext() {
            return this.a.hasPrevious();
        }

        public Object next() {
            return this.a.previous();
        }

        public boolean hasPrevious() {
            return this.a.hasNext();
        }

        public Object previous() {
            return this.a.next();
        }

        public int nextIndex() {
            return this.a.previousIndex();
        }

        public int previousIndex() {
            return this.a.nextIndex();
        }

        public void set(Object object) {
            this.a.set(object);
        }

        public void add(Object object) {
            this.a.add(object);
        }

        public void remove() {
            this.a.remove();
        }
    }
}

