/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing;

import ilog.views.util.IlvResourceUtil;
import ilog.views.util.java2d.internal.IlvPaintToggleButton;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.color.IlvColorChooserPanel;
import ilog.views.util.swing.internal.IlvTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SwingFactories
implements SwingConstants {
    protected static boolean init = false;
    protected static boolean initAvailableLocales = false;
    private static JFileChooser a = null;
    private static File b = null;
    private static Locale[] c = null;
    private static SwingFactories d = null;

    protected SwingFactories() {
    }

    public static synchronized void init() {
        if (init) {
            return;
        }
        init = true;
        a = new JFileChooser(System.getProperty("user.dir") + System.getProperty("file.separator"));
        if (!Locale.getDefault().getLanguage().equals("en")) {
            a.setPreferredSize(new Dimension(SwingFactories.a.getPreferredSize().width + 20, SwingFactories.a.getPreferredSize().height));
        }
        if (b != null) {
            a.setCurrentDirectory(b);
            b = null;
        }
    }

    public static synchronized void initAvailableLocales() {
        if (initAvailableLocales) {
            return;
        }
        initAvailableLocales = true;
        c = Locale.getAvailableLocales();
    }

    public static JTabbedPane createTabbedPane() {
        return d.a();
    }

    JTabbedPane a() {
        return new JDebugTabbedPane();
    }

    public static Document createDecimalNumberDocument() {
        return SwingFactories.createDecimalNumberDocument(0.0, Double.MAX_VALUE, true);
    }

    public static Document createDecimalNumberDocument(boolean bl, boolean bl2) {
        return SwingFactories.createDecimalNumberDocument(bl2 ? -1.7976931348623157E308 : 0.0, Double.MAX_VALUE, bl);
    }

    public static Document createDecimalNumberDocument(double d2, double d3, boolean bl) {
        return SwingFactories.createDecimalNumberDocument(d2, d3, bl, null);
    }

    public static Document createDecimalNumberDocument(double d2, double d3, boolean bl, DecimalFormat decimalFormat) {
        return new DecimalNumberDocument(d2, d3, bl, decimalFormat);
    }

    public static JTextField createTextField(String string) {
        return SwingFactories.createTextField(null, string, 0);
    }

    public static JTextField createTextField(Document document, String string, int n2) {
        return new IlvTextField(document, string, n2);
    }

    public static ComboBoxModel createFontListComboBoxModel() {
        return new FontListComboBoxModel();
    }

    public static ComboBoxModel createLnFComboBoxModel() {
        return new LnFComboBoxModel();
    }

    public static ComboBoxModel createLocaleComboBoxModel() {
        return new LocaleComboBoxModel();
    }

    public static JComboBox createColorComboBox() {
        JComboBox jComboBox = new JComboBox(new AutoAddComboBoxModel());
        jComboBox.setRenderer(new ColorCellRenderer());
        jComboBox.setEditor(new ColorComboBoxEditor());
        return jComboBox;
    }

    public static JComboBox createPaintComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setRenderer(new PaintCellRenderer());
        return jComboBox;
    }

    public static DefaultComboBoxModel createAutoAddComboBoxModel() {
        return new AutoAddComboBoxModel();
    }

    public static AbstractColorChooserPanel createColorChooserPanel() {
        return new IlvColorChooserPanel();
    }

    public static File chooseFile(String string, boolean bl, boolean bl2, String string2, final String string3, File file, Component component, String string4) {
        FileFilter[] fileFilterArray = null;
        if (string2 != null) {
            final String string5 = string2;
            fileFilterArray = new FileFilter[]{new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(string5);
                }

                public String getDescription() {
                    return string3 != null ? string3 : MessageFormat.format(SwingFactories.b().getString("file.filter"), string5);
                }

                public boolean equals(Object object) {
                    return object instanceof FileFilter && this.getDescription().equals(((FileFilter)object).getDescription());
                }
            }};
        }
        SwingFactories.setFileFilters(fileFilterArray, 0);
        return SwingFactories.chooseFile(string, bl, bl2, file, component, string4);
    }

    public static void setCurrentDirectory(File file) {
        if (a != null) {
            a.setCurrentDirectory(file);
        } else {
            b = file;
        }
    }

    public static File getCurrentDirectory() {
        if (a != null) {
            return a.getCurrentDirectory();
        }
        return b;
    }

    public static void setFileFilters(FileFilter[] fileFilterArray, int n2) {
        SwingFactories.init();
        a.setFileFilter(a.getAcceptAllFileFilter());
        a.resetChoosableFileFilters();
        if (fileFilterArray != null) {
            for (int i2 = 0; i2 < fileFilterArray.length; ++i2) {
                if (fileFilterArray[i2] == null) continue;
                a.addChoosableFileFilter(fileFilterArray[i2]);
            }
            if (fileFilterArray[n2] != null) {
                a.setFileFilter(fileFilterArray[n2]);
            } else {
                a.setFileFilter(fileFilterArray[0]);
            }
        }
    }

    public static FileFilter getSelectedFileFilter() {
        SwingFactories.init();
        return a.getFileFilter();
    }

    public static File chooseFile(String string, boolean bl, boolean bl2, File file, Component component, String string2) {
        int n2;
        SwingFactories.init();
        File file2 = null;
        a.setSelectedFile(null);
        a.setDialogTitle(string);
        a.setFileSelectionMode(bl2 ? 1 : 0);
        if (file != null) {
            try {
                a.setCurrentDirectory(file);
                a.setSelectedFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        file2 = a.getCurrentDirectory();
        if (string2 != null) {
            a.setApproveButtonText(string2);
        }
        int n3 = n2 = bl ? a.showSaveDialog(component) : a.showOpenDialog(component);
        if (n2 == 0) {
            File file3 = a.getSelectedFile();
            if (file3 != null && file3.exists() && bl) {
                int n4 = JOptionPane.showConfirmDialog(a, MessageFormat.format(SwingFactories.b().getString("file.already"), file3.getAbsolutePath()), SwingFactories.b().getString("file.save"), 1, 3);
                switch (n4) {
                    case -1: 
                    case 2: {
                        a.setCurrentDirectory(file2);
                        return null;
                    }
                    case 0: {
                        return file3;
                    }
                    case 1: {
                        return SwingFactories.chooseFile(string, bl, bl2, file3, component, string2);
                    }
                }
            }
            return file3;
        }
        a.setCurrentDirectory(file2);
        return null;
    }

    static ResourceBundle b() {
        return IlvResourceUtil.getBundle("messages", SwingFactories.class);
    }

    public static Frame getFrame(Component component) {
        if (component instanceof Frame || component == null) {
            return (Frame)component;
        }
        return SwingFactories.getFrame(component.getParent());
    }

    public static Box createHorizontalBox() {
        return d.c();
    }

    Box c() {
        return Box.createHorizontalBox();
    }

    public static Box createVerticalBox() {
        return d.d();
    }

    Box d() {
        return Box.createVerticalBox();
    }

    public static int getBoxLayoutLineAxis() {
        return d.e();
    }

    int e() {
        return 0;
    }

    public static int getBoxLayoutPageAxis() {
        return d.f();
    }

    int f() {
        return 1;
    }

    public static int getGridBagLayoutLineStart() {
        return d.g();
    }

    int g() {
        return 17;
    }

    public static int getGridBagLayoutLineEnd() {
        return d.h();
    }

    int h() {
        return 13;
    }

    public static Dimension getIconComboBoxPreferredSize(JComboBox jComboBox, Dimension dimension) {
        return d.a(jComboBox, dimension);
    }

    Dimension a(JComboBox jComboBox, Dimension dimension) {
        if (jComboBox.getItemCount() > 0 && jComboBox.getItemAt(0) instanceof Icon) {
            Insets insets = jComboBox.getInsets();
            Insets insets2 = ((JLabel)((Object)jComboBox.getRenderer())).getInsets();
            return new Dimension(dimension.width, ((Icon)jComboBox.getItemAt(0)).getIconHeight() + insets.top + insets.bottom + insets2.top + insets2.bottom);
        }
        return dimension;
    }

    static {
        if (IlvSwingUtil.getSwingVersion().compareTo(new IlvSwingUtil.Version(1, 4, 0)) >= 0) {
            try {
                d = (SwingFactories)Class.forName("ilog.views.util.swing.SwingFactories14").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (d == null) {
            d = new SwingFactories();
        }
    }

    public static class AutoAddComboBoxModel
    extends DefaultComboBoxModel {
        public void setSelectedItem(Object object) {
            if (object != null) {
                for (int i2 = 0; i2 < this.getSize(); ++i2) {
                    if (object instanceof Color && this.getElementAt(i2) instanceof Color) {
                        if (((Color)this.getElementAt(i2)).getRGB() != ((Color)object).getRGB()) continue;
                        super.setSelectedItem(object);
                        return;
                    }
                    if (!object.equals(this.getElementAt(i2))) continue;
                    super.setSelectedItem(object);
                    return;
                }
                this.addElement(object);
                super.setSelectedItem(object);
            }
        }
    }

    private static class ColorCellRenderer
    extends ColorComponent
    implements ListCellRenderer {
        ColorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            this.selectedColor = (Color)object;
            if (bl) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }
            return this;
        }
    }

    private static class ColorComboBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        private JColorChooser a;
        private ColorComponent b;
        private JDialog c;
        private boolean d = false;

        ColorComboBoxEditor() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            final AbstractColorChooserPanel abstractColorChooserPanel = SwingFactories.createColorChooserPanel();
            this.a = new JColorChooser(){

                public void setChooserPanels(AbstractColorChooserPanel[] abstractColorChooserPanelArray) {
                    super.setChooserPanels(abstractColorChooserPanelArray);
                    if (ColorComboBoxEditor.this.d && abstractColorChooserPanelArray != null && abstractColorChooserPanelArray.length > 0 && abstractColorChooserPanelArray[abstractColorChooserPanelArray.length - 1] != abstractColorChooserPanel) {
                        this.addChooserPanel(abstractColorChooserPanel);
                    }
                }
            };
            this.a.addChooserPanel(abstractColorChooserPanel);
            this.d = true;
            JButton jButton = new JButton("...");
            this.add((Component)jButton, "After");
            jButton.setPreferredSize(new Dimension(20, 16));
            this.b = new ColorComponent();
            this.add((Component)this.b, "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorComboBoxEditor.this.a.setColor(ColorComboBoxEditor.this.b.a());
                    ColorComboBoxEditor.this.c.setVisible(true);
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.c = JColorChooser.createDialog(SwingFactories.getFrame(this), SwingFactories.b().getString("color"), true, this.a, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorComboBoxEditor.this.fireActionPerformed();
                }
            }, null);
        }

        public void addActionListener(ActionListener actionListener) {
            this.listenerList.add(ActionListener.class, actionListener);
        }

        protected void fireActionPerformed() {
            this.b.a(this.a.getColor());
            Object[] objectArray = this.listenerList.getListenerList();
            ActionEvent actionEvent = null;
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != ActionListener.class) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, null, 0);
                }
                ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
            }
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return this.b.a();
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listenerList.remove(ActionListener.class, actionListener);
        }

        public void selectAll() {
        }

        public void setItem(Object object) {
            if (object != null) {
                this.b.a((Color)object);
            }
        }
    }

    private static class ColorComponent
    extends JComponent {
        protected Color selectedColor = null;
        private static Dimension a = new Dimension(60, 16);

        ColorComponent() {
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.selectedColor);
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            graphics.fillRect(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        }

        public Dimension getPreferredSize() {
            return a;
        }

        void a(Color color) {
            this.selectedColor = color;
        }

        Color a() {
            return this.selectedColor;
        }
    }

    static class DecimalNumberDocument
    extends PlainDocument {
        private double a = -1.7976931348623157E308;
        private double b = Double.MAX_VALUE;
        private boolean c = true;
        private boolean d = true;
        private DecimalFormat e;

        public DecimalNumberDocument(double d2, double d3, boolean bl) {
            this(d2, d3, bl, null);
        }

        public DecimalNumberDocument(double d2, double d3, boolean bl, DecimalFormat decimalFormat) {
            this.a = d2;
            this.b = d3;
            this.c = bl;
            this.d = d2 < 0.0;
            this.e = decimalFormat;
            if (this.e != null) {
                this.e.setParseIntegerOnly(!bl);
            }
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            String string2 = this.getText(0, this.getLength());
            string = this.a(string, n2);
            super.insertString(n2, string, attributeSet);
            String string3 = this.getText(0, this.getLength());
            if (string3 == null || string3.trim().length() == 0 || !this.d && this.f(string3) || !this.c && this.g(string3)) {
                this.c(string2);
            }
        }

        void a(String string) {
            String string2 = null;
            try {
                string2 = this.getText(0, this.getLength());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                double d2 = this.e(string2);
                if (!this.a(d2)) {
                    this.c(string);
                }
            }
            catch (Throwable throwable) {
                this.c(string);
            }
        }

        private boolean a(double d2) {
            return d2 >= this.a && d2 <= this.b;
        }

        private void c(String string) {
            this.warnInvalidNumber();
            this.d(string);
        }

        protected void warnInvalidNumber() {
            Toolkit.getDefaultToolkit().beep();
        }

        private String a(String string, int n2) {
            if (string == null || string.length() == 0) {
                return string;
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            boolean bl = false;
            if (n2 == 0 && cArray.length > 0 && cArray[0] == this.b()) {
                if (this.d) {
                    stringBuffer.append(cArray[n3++]);
                } else {
                    bl = true;
                }
            } else if (n2 == 0 && cArray.length > 0 && cArray[0] == this.c()) {
                stringBuffer.append(cArray[n3++]);
            }
            if (this.c && new String(cArray, n3, cArray.length - n3).equals(this.d())) {
                while (n3 < cArray.length) {
                    stringBuffer.append(cArray[n3]);
                    ++n3;
                }
            } else {
                while (n3 < cArray.length) {
                    if (Character.isDigit(cArray[n3]) || cArray[n3] == 'e' || cArray[n3] == 'E' || cArray[n3] == this.b() || cArray[n3] == this.c() || this.c && cArray[n3] == this.a()) {
                        if (cArray[n3] == 'e') {
                            cArray[n3] = 69;
                        }
                        stringBuffer.append(cArray[n3]);
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
            }
            if (bl) {
                this.warnInvalidNumber();
            }
            return stringBuffer.toString();
        }

        private void d(String string) {
            try {
                this.remove(0, this.getLength());
                super.insertString(0, string, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private double e(String string) throws NumberFormatException, ParseException {
            if (this.c) {
                return this.e != null ? this.e.parse(string).doubleValue() : Double.parseDouble(string);
            }
            return this.e != null ? (double)this.e.parse(string).longValue() : (double)Long.parseLong(string);
        }

        String b(String string) throws NumberFormatException, ParseException {
            if (string == null || string.length() == 0 || this.e == null) {
                return string;
            }
            double d2 = this.e(string);
            return this.c ? Double.toString(d2) : Long.toString((long)d2);
        }

        private char a() {
            return this.e instanceof DecimalFormat ? this.e.getDecimalFormatSymbols().getDecimalSeparator() : (char)'.';
        }

        private char b() {
            return this.e instanceof DecimalFormat ? this.e.getDecimalFormatSymbols().getMinusSign() : (char)'-';
        }

        private char c() {
            return '+';
        }

        private String d() {
            return this.e instanceof DecimalFormat ? this.e.getDecimalFormatSymbols().getInfinity() : "\u221e";
        }

        private boolean f(String string) {
            return string != null && string.trim().length() == 1 && string.trim().charAt(0) == this.b();
        }

        private boolean g(String string) {
            return string != null && string.trim().length() == 1 && string.trim().charAt(0) == this.a();
        }
    }

    public static class FontListComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        String[] a = this.a();
        int b = 0;

        private String[] a() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }

        public void setSelectedItem(Object object) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (!this.a[i2].equals(object)) continue;
                this.b = i2;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.a[this.b];
        }

        public int getSize() {
            return this.a.length;
        }

        public Object getElementAt(int n2) {
            if (n2 >= 0 && n2 < this.a.length) {
                return this.a[n2];
            }
            return null;
        }
    }

    static class JDebugTabbedPane
    extends JTabbedPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processFocusEvent(FocusEvent focusEvent) {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.processFocusEvent(focusEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.removeAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTabAt(int n2) {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.removeTabAt(n2);
            }
        }

        public void remove(Component component) {
            if (this.getTabCount() == 0) {
                return;
            }
            super.remove(component);
        }

        public void remove(int n2) {
            if (this.getTabCount() == 0) {
                return;
            }
            super.remove(n2);
        }
    }

    public static class LnFComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        UIManager.LookAndFeelInfo[] a = UIManager.getInstalledLookAndFeels();
        int b = this.a.length;
        String c = "System";

        LnFComboBoxModel() {
        }

        public void setSelectedItem(Object object) {
            if (object.equals(this.c)) {
                this.b = this.a.length;
            } else {
                for (int i2 = 0; i2 < this.a.length; ++i2) {
                    if (!this.a[i2].getName().equals(object)) continue;
                    this.b = i2;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            if (this.b == this.a.length) {
                return this.c;
            }
            return this.a[this.b].getName();
        }

        public String getSelectedLnFClassName() {
            if (this.b != this.a.length) {
                return this.a[this.b].getClassName();
            }
            return UIManager.getSystemLookAndFeelClassName();
        }

        public int getSize() {
            return this.a.length + 1;
        }

        public Object getElementAt(int n2) {
            if (n2 >= 0 && n2 < this.a.length) {
                return this.a[n2].getName();
            }
            return this.c;
        }
    }

    public static class LocaleComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        int a = 0;
        String b = "System";

        LocaleComboBoxModel() {
            SwingFactories.initAvailableLocales();
        }

        public void setSelectedItem(Object object) {
            if (object.equals(this.b)) {
                this.a = 0;
            } else {
                for (int i2 = 0; i2 < c.length; ++i2) {
                    if (!c[i2].getDisplayName().equals(object)) continue;
                    this.a = i2 + 1;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            if (this.a == 0) {
                return this.b;
            }
            return c[this.a - 1].getDisplayName();
        }

        public void setSelectedLocale(Locale locale) {
            for (int i2 = 0; i2 < c.length; ++i2) {
                if (!locale.equals(c[i2])) continue;
                this.a = i2 + 1;
                break;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Locale getSelectedLocale() {
            if (this.a != 0) {
                return c[this.a - 1];
            }
            return Locale.getDefault();
        }

        public int getSize() {
            return c.length + 1;
        }

        public Object getElementAt(int n2) {
            if (n2 > 0 && n2 <= c.length) {
                return c[n2 - 1].getDisplayName();
            }
            return this.b;
        }
    }

    private static class PaintCellRenderer
    extends IlvPaintToggleButton
    implements ListCellRenderer {
        public PaintCellRenderer() {
            this.setEnabled(false);
            this.setPreferredSize(new Dimension(40, 40));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            this.paint = (Paint)object;
            if (bl) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }
            return this;
        }
    }

    public static class URLStringChooser
    extends JPanel
    implements ActionListener {
        private JTextField a;

        public URLStringChooser(String string) {
            this.setLayout(new BorderLayout());
            this.a = new JTextField(20);
            this.add((Component)this.a, "Center");
            this.a.setText(string);
            JButton jButton = new JButton(SwingFactories.b().getString("choose.file"));
            this.add((Component)jButton, "After");
            jButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a();
        }

        public final JTextField getTextField() {
            return this.a;
        }

        public final void setURLString(String string) {
            this.a.setText(string);
            this.a.postActionEvent();
        }

        public final String getURLString() {
            return this.a.getText();
        }

        private void a() {
            File file = SwingFactories.chooseFile(SwingFactories.b().getString("choose.image"), false, false, null, null, new File(this.a.getText()), this, SwingFactories.b().getString("ok"));
            if (file != null) {
                String string = file.getAbsolutePath();
                if (string.length() >= 2 && string.charAt(1) == ':') {
                    this.a.setText("file:/" + string);
                } else {
                    this.a.setText("file:" + string);
                }
            }
        }
    }
}

