/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.math.BigInteger;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FloatPtType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.LongLongType;
import org.jacorb.idl.LongType;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.runtime.float_token;
import org.jacorb.idl.runtime.int_token;
import org.jacorb.idl.runtime.long_token;
import org.jacorb.idl.runtime.token;

public class Literal
extends IdlSymbol {
    private static BigInteger maximum;
    public String string;
    public boolean wide;
    public token token;
    private ConstDecl declared_in;

    public Literal(int num) {
        super(num);
    }

    public void setDeclaration(ConstDecl declared_in) {
        this.declared_in = declared_in;
    }

    public void parse() {
        if (this.declared_in != null) {
            TypeSpec ts = this.declared_in.const_type.symbol.typeSpec();
            if (ts instanceof AliasTypeSpec) {
                ts = ((AliasTypeSpec)ts).originalType();
            }
            if (ts instanceof IntType) {
                if (((IntType)ts).unsigned && ts instanceof LongLongType && this.token instanceof fixed_token) {
                    BigInteger current;
                    if (maximum == null) {
                        maximum = new BigInteger("18446744073709551615");
                    }
                    if ((current = new BigInteger(this.string)).compareTo(maximum) > 0) {
                        parser.error("Value too big for unsigned long");
                    } else {
                        this.token = new long_token(((fixed_token)this.token).sym, ((fixed_token)this.token).fixed_val.longValue());
                        this.string = Long.toString(((long_token)this.token).long_val);
                    }
                } else if (((IntType)ts).unsigned && ts instanceof LongType && this.token instanceof long_token) {
                    if (((long_token)this.token).long_val > 0xFFFFFFFFL) {
                        parser.error("Value (" + ((long_token)this.token).long_val + ") too big for unsigned long");
                    } else {
                        this.token = new int_token(((long_token)this.token).sym, (int)((long_token)this.token).long_val);
                        this.string = Integer.toString(((int_token)this.token).int_val);
                    }
                } else if (ts instanceof LongType && this.token instanceof long_token) {
                    parser.error("Value (" + ((long_token)this.token).long_val + ") too big for Java int");
                } else if (ts instanceof LongLongType && this.token instanceof fixed_token) {
                    parser.error("Value (" + ((fixed_token)this.token).fixed_val.toString() + ") too big for Java long");
                }
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Literal " + ts.getClass().getName() + " " + (this.token != null ? this.token.getClass().getName() : "<no token>"));
            }
            if (ts instanceof FloatPtType && !(this.token instanceof float_token)) {
                parser.error("Expecting float/double constant!");
            } else if (ts instanceof FixedPointConstType && !(this.token instanceof fixed_token)) {
                parser.error("Expecting fixed point constant (perhaps a missing \"d\")!");
            } else if (ts instanceof StringType) {
                if (this.wide && !((StringType)ts).isWide()) {
                    parser.error("Illegal assignment of wide string constant to string!");
                }
            } else if ((ts instanceof LongType || ts instanceof ShortType) && this.token instanceof long_token) {
                parser.error("Illegal assignment from long long");
            }
        }
    }

    public String toString() {
        String result = this.string;
        if (this.token instanceof long_token) {
            result = this.string.indexOf(46) > 0 ? this.string + 'D' : this.string + 'L';
        }
        return Literal.escapeBackslash(result);
    }

    public void print(PrintWriter ps) {
        ps.print(Literal.escapeBackslash(this.string));
    }

    public static String escapeBackslash(String name) {
        StringBuffer result = new StringBuffer();
        char[] chrs = name.toCharArray();
        if (chrs[0] == '\"') {
            return name;
        }
        block13: for (int i = 0; i < chrs.length; ++i) {
            switch (chrs[i]) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block13;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block13;
                }
                case '\u000b': {
                    result.append('\\');
                    result.append("013");
                    continue block13;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    continue block13;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block13;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block13;
                }
                case '\u0007': {
                    result.append('\\');
                    result.append("007");
                    continue block13;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    continue block13;
                }
                case '\u0000': {
                    result.append('\\');
                    result.append('0');
                    continue block13;
                }
                case '\'': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\'');
                        continue block13;
                    }
                    result.append(chrs[i]);
                    continue block13;
                }
                case '\"': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\"');
                        continue block13;
                    }
                    result.append(chrs[i]);
                    continue block13;
                }
                default: {
                    result.append(chrs[i]);
                }
            }
        }
        return result.toString();
    }
}

