/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.SimpleTypeSpec;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class ScopedName
extends SimpleTypeSpec
implements SwitchTypeSpec {
    private static Hashtable pseudoScopes = new Hashtable();
    private static Hashtable enumMap = new Hashtable();
    private static Stack recursionStack = new Stack();
    private TypeSpec resolvedSpec = null;
    private String resolvedName = null;
    private boolean resolved = false;
    private Interface resolvedInterface = null;
    boolean set = false;
    public String typeName = null;

    public static void definePseudoScope(String name) {
        pseudoScopes.put(name, "");
    }

    public static boolean isPseudoScope(String name) {
        return pseudoScopes.containsKey(name);
    }

    public static String unPseudoName(String name) {
        String n = ScopedName.unPseudo(name);
        if (n.endsWith("PackagePackage") || !n.startsWith("_") && n.endsWith("Package")) {
            n = n.substring(0, n.lastIndexOf("Package"));
        }
        return n;
    }

    private static String unPseudo(String name) {
        if (name.length() > 0 && name.charAt(0) == '.') {
            name = name.substring(1);
        }
        String head = name;
        String tail = null;
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        while (!ScopedName.isPseudoScope(head)) {
            lastDot = head.lastIndexOf(46);
            if (lastDot < 0) {
                return name;
            }
            head = name.substring(0, lastDot);
            tail = name.substring(lastDot + 1);
        }
        StringTokenizer strtok = new StringTokenizer(head, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scopes[i++] = strtok.nextToken();
        }
        StringBuffer newHead = new StringBuffer();
        int j = 1;
        newHead.append(scopes[0]);
        while (!ScopedName.isPseudoScope(newHead.toString())) {
            if (j == scopes.length) {
                return name;
            }
            newHead.append(".");
            newHead.append(scopes[j++]);
        }
        StringBuffer copy = new StringBuffer(newHead.toString());
        newHead.append("Package");
        while (j < scopes.length) {
            newHead.append("." + scopes[j]);
            copy.append("." + scopes[j]);
            if (ScopedName.isPseudoScope(copy.toString())) {
                newHead.append("Package");
            }
            ++j;
        }
        if (tail != null) {
            newHead.append("." + tail);
        }
        return newHead.toString();
    }

    public static void enumMap(String n, String m) {
        enumMap.put(n, m);
    }

    private static String unEnum(String _name) {
        String n = (String)enumMap.get(_name);
        if (n != null) {
            return n;
        }
        return _name;
    }

    public ScopedName(int num) {
        super(num);
    }

    public Object clone() {
        ScopedName sn = new ScopedName(ScopedName.new_num());
        sn.resolvedSpec = this.resolvedSpec;
        sn.resolvedName = this.resolvedName;
        sn.resolved = this.resolved;
        sn.typeName = this.typeName;
        sn.token = this.token;
        sn.set = this.set;
        sn.pack_name = this.pack_name;
        sn.name = this.name;
        sn.is_pseudo = this.is_pseudo;
        sn.included = this.included;
        sn.inhibitionFlag = this.inhibitionFlag;
        return sn;
    }

    public void setId(String _id) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScopedName.setId " + _id);
        }
        this.typeName = _id;
        this.escapeName();
    }

    public void escapeName() {
        if (!this.name.startsWith("_")) {
            if (this.typeName.indexOf(46) > 0) {
                if (lexer.strictJavaEscapeCheck(this.typeName.substring(this.typeName.lastIndexOf(46) + 1))) {
                    this.typeName = this.typeName.substring(0, this.typeName.lastIndexOf(46) + 1) + "_" + this.typeName.substring(this.typeName.lastIndexOf(46) + 1);
                }
            } else if (lexer.strictJavaEscapeCheck(this.typeName)) {
                this.typeName = "_" + this.typeName;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ScopedName.escapeName " + this.typeName);
            }
        }
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public void parse() {
    }

    public boolean resolved() {
        return this.resolved;
    }

    public boolean basic() {
        TypeSpec t = this.resolvedTypeSpec();
        return t.basic();
    }

    public boolean is_pseudo() {
        return NameTable.defined(this.resolvedName(), "pseudo interface");
    }

    public TypeSpec resolvedTypeSpec() {
        if (!this.resolved) {
            this.resolvedName = this.resolvedName();
        }
        if (this.resolvedSpec == null) {
            parser.fatal_error("Not a type: " + this.resolvedName, this.token);
        }
        return this.resolvedSpec;
    }

    public String resolvedName() {
        ConstDecl constDecl;
        if (!this.resolved) {
            this.resolvedName = this.resolvedName(this.pack_name, this.typeName);
        }
        if ((constDecl = ConstDecl.getDeclaration(this.resolvedName)) != null && !constDecl.contained()) {
            this.resolvedName = this.resolvedName + ".value";
        }
        this.resolved = true;
        return this.resolvedName;
    }

    private String resolvedName(String pack_name, String s) {
        int k;
        int i;
        String pack_replace;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Resolve " + pack_name + ":" + s);
        }
        boolean global = false;
        if (s == null) {
            throw new RuntimeException("Parser Error: null string in ScopedName (pack_name: " + pack_name + ") !");
        }
        String result = null;
        String suffix = "";
        if (s.charAt(0) == '.') {
            s = s.substring(1);
            global = true;
        }
        if (s.endsWith("[]")) {
            result = s.substring(0, s.indexOf("["));
            suffix = "[]";
        } else {
            result = s;
        }
        if (NameTable.defined((!global ? pack_name + "." : "") + result)) {
            String unmap = this.unMap((!global ? pack_name + "." : "") + result);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("resolve, " + (!global ? pack_name + "." : "") + result + " was in name table, returning " + unmap + " suffix: " + suffix);
            }
            return unmap + suffix;
        }
        StringTokenizer strtok = new StringTokenizer(s, ".");
        String[] s_scopes = new String[strtok.countTokens()];
        int i2 = 0;
        while (strtok.hasMoreTokens()) {
            s_scopes[i2] = strtok.nextToken();
            ++i2;
        }
        if (s_scopes.length > 0 && !(pack_replace = parser.pack_replace(s_scopes[0])).equals(s_scopes[0])) {
            StringBuffer t = new StringBuffer();
            t.append(pack_replace);
            for (i = 1; i < s_scopes.length; ++i) {
                t.append(".");
                t.append(s_scopes[i]);
            }
            result = t.toString();
            if (NameTable.defined(result)) {
                String unmap2 = this.unMap(result);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("resolve b, " + result + " was in name table, returning " + unmap2 + " suffix: " + suffix);
                }
                return unmap2 + suffix;
            }
        }
        StringTokenizer p_strtok = new StringTokenizer(pack_name, ".");
        String[] p_scopes = new String[p_strtok.countTokens()];
        i = 0;
        while (p_strtok.hasMoreTokens()) {
            p_scopes[i] = p_strtok.nextToken();
            ++i;
        }
        if (s_scopes.length == 0 || p_scopes.length == 0) {
            if (NameTable.defined(result)) {
                return this.unMap(result) + suffix;
            }
            parser.fatal_error("Undefined name: " + s + " .", this.token);
        }
        if (s_scopes[0].equals(p_scopes[0])) {
            int m;
            StringBuffer t = new StringBuffer();
            int n = m = s_scopes.length < p_scopes.length ? s_scopes.length : p_scopes.length;
            if (m > 1) {
                int i3;
                for (i3 = 1; i3 < m - 1 && s_scopes[i3].equals(p_scopes[i3]); ++i3) {
                }
                t.append(s_scopes[i3]);
                for (k = i3 + 1; k < s_scopes.length; ++k) {
                    t.append(".");
                    t.append(s_scopes[k]);
                }
                s = t.toString();
            }
        }
        String prefix = "";
        int start_index = 0;
        if (parser.package_prefix != null) {
            prefix = parser.package_prefix + ".";
            StringTokenizer prefix_strtok = new StringTokenizer(prefix, ".");
            String[] prefix_scopes = new String[prefix_strtok.countTokens()];
            int i4 = 0;
            while (prefix_strtok.hasMoreTokens()) {
                prefix_scopes[i4] = prefix_strtok.nextToken();
                ++i4;
            }
            while (start_index < prefix_scopes.length && prefix_scopes[start_index].equals(p_scopes[start_index])) {
                ++start_index;
            }
        }
        StringBuffer buf = new StringBuffer();
        k = p_scopes.length - start_index;
        if (k > 0) {
            buf.append(p_scopes[start_index] + ".");
        }
        for (int j = start_index + 1; j < p_scopes.length; ++j) {
            buf.append(p_scopes[j]);
            buf.append(".");
        }
        buf.append(s);
        int sub = start_index + 1;
        while (!NameTable.defined(prefix + buf.toString())) {
            if (sub > p_scopes.length) {
                parser.fatal_error("Undefined name: " + pack_name + "." + s, this.token);
                return "/* unresolved name */";
            }
            buf = new StringBuffer();
            if ((k = p_scopes.length - sub++) > 0) {
                buf.append(p_scopes[start_index] + ".");
                for (int j = start_index + 1; j < k + start_index; ++j) {
                    buf.append(p_scopes[j]);
                    buf.append(".");
                }
            }
            buf.append(s);
        }
        String res = this.unMap(prefix + buf.toString()) + suffix;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.resolve (at end) returns: " + res);
        }
        return res;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.set = true;
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    private String qualify(String str) {
        if (str.charAt(0) == '.') {
            return str.substring(1);
        }
        if (!this.pack_name.equals("")) {
            return this.pack_name + "." + str;
        }
        return str;
    }

    private String unMap(String _name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.unmap: " + _name);
        }
        Object tmp = null;
        TypeSpec y = TypeMap.map(_name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.unmap: " + _name + ", Type.map( " + _name + " ) is : " + y);
        }
        TypeSpec x = null;
        while (!(y == null || y instanceof ScopedName || y instanceof ConstrTypeSpec || (x = y).equals(y = y.typeSpec()))) {
        }
        if (y == null) {
            if (x != null) {
                this.resolvedSpec = x;
                return x.typeName();
            }
            this.resolvedSpec = y;
            return ScopedName.unEnum(_name);
        }
        if (y instanceof ConstrTypeSpec) {
            this.resolvedSpec = y;
            return y.typeName();
        }
        if (y instanceof ScopedName && y != null && x != y) {
            return this.unMap(y.typeName());
        }
        if (y == null) {
            this.resolvedSpec = x;
            return x.typeName();
        }
        this.resolvedSpec = y;
        return _name;
    }

    public String typeName() {
        String n = ScopedName.unPseudo(this.resolvedName(this.pack_name, this.typeName));
        if (n.endsWith("PackagePackage") || !n.startsWith("_") && n.endsWith("Package")) {
            n = n.substring(0, n.lastIndexOf("Package"));
        }
        return n;
    }

    public String holderName() {
        return this.resolvedTypeSpec().holderName();
    }

    public String printReadExpression(String streamname) {
        return this.resolvedTypeSpec().printReadExpression(streamname);
    }

    public String printWriteStatement(String var_name, String streamname) {
        return this.resolvedTypeSpec().printWriteStatement(var_name, streamname);
    }

    public String printInsertExpression() {
        return this.resolvedTypeSpec().printInsertExpression();
    }

    public String printExtractExpression() {
        return this.resolvedTypeSpec().printExtractExpression();
    }

    public String getTypeCodeExpression() {
        return this.resolvedTypeSpec().getTypeCodeExpression();
    }

    public String id() {
        return this.resolvedTypeSpec().id();
    }

    public String toString() {
        String n = this.typeName();
        if (this.resolvedTypeSpec() != null && !n.startsWith("org.omg")) {
            n = this.resolvedTypeSpec().omgPrefix() + n;
        }
        return n;
    }

    public void print(PrintWriter ps) {
    }

    public String IDLName() {
        String n = this.toString();
        StringBuffer sb = new StringBuffer();
        int from = 0;
        while (n.substring(from).indexOf(46) > 0) {
            int to = from + n.substring(from).indexOf(46);
            sb.append(n.substring(from, to) + "::");
            from = to + 1;
        }
        sb.append(n.substring(from));
        return sb.toString();
    }

    public static void addRecursionScope(String typeName) {
        recursionStack.push(typeName);
    }

    public static void removeRecursionScope(String typeName) {
        String check = (String)recursionStack.pop();
        if (!(typeName == null || check != null && check.equals(typeName))) {
            throw new RuntimeException("RecursionScope Error, expected " + typeName + ", got " + check);
        }
    }

    public static boolean isRecursionScope(String typeName) {
        return recursionStack.search(typeName) != -1;
    }

    public boolean isSwitchable() {
        TypeSpec t = this.resolvedTypeSpec();
        return t instanceof SwitchTypeSpec && ((SwitchTypeSpec)((Object)t)).isSwitchable();
    }
}

