/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.ValueBody;
import org.jacorb.idl.ValueInheritanceSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class ValueAbsDecl
extends Value {
    ValueBody body = null;
    ValueInheritanceSpec inheritanceSpec;

    public ValueAbsDecl(int num) {
        super(num);
        this.pack_name = "";
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.body != null) {
            this.body.setPackage(s);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
    }

    public void setInheritanceSpec(ValueInheritanceSpec spec) {
        this.inheritanceSpec = spec;
    }

    public ValueInheritanceSpec setInheritanceSpec() {
        return this.inheritanceSpec;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        return this.full_name();
    }

    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            this.logger.error("was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public boolean basic() {
        return true;
    }

    public String holderName() {
        return this.javaName() + "Holder";
    }

    public String toString() {
        String n = this.typeName();
        if (!n.startsWith("org.omg")) {
            return this.omgPrefix() + n;
        }
        return n;
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public void parse() {
        boolean justAnotherOne;
        block13: {
            justAnotherOne = false;
            this.escapeName();
            ConstrTypeSpec ctspec = new ConstrTypeSpec(ValueAbsDecl.new_num());
            try {
                ScopedName.definePseudoScope(this.full_name());
                ctspec.c_type_spec = this;
                NameTable.define(this.full_name(), "type");
                TypeMap.typedef(this.full_name(), ctspec);
            }
            catch (IllegalRedefinition ill) {
                parser.fatal_error("Illegal Redefinition of  " + ill.oldDef + " in nested scope as " + ill.newDef, this.token);
            }
            catch (NameAlreadyDefined nad) {
                if (this.body != null) {
                    justAnotherOne = true;
                }
                if (this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block13;
                TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking inheritanceSpec of " + this.full_name());
                }
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ConstrTypeSpec ts;
                    ScopedName name = (ScopedName)e.nextElement();
                    TypeSpec resolvedTSpec = name.resolvedTypeSpec();
                    if (!parser.strict_inheritance) continue;
                    while (resolvedTSpec instanceof AliasTypeSpec) {
                        resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
                    }
                    if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Illegal inheritance spec, not a constr. type but " + resolvedTSpec.getClass() + ", name " + name);
                        }
                        parser.fatal_error("Illegal inheritance spec (not a constr. type): " + this.inheritanceSpec, this.token);
                    }
                    if ((ts = (ConstrTypeSpec)resolvedTSpec).declaration() instanceof Interface || ts.declaration() instanceof ValueAbsDecl) continue;
                    parser.fatal_error("Illegal inheritance spec (not an intf. or abs. value type): " + this.inheritanceSpec, this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name());
        }
    }

    ValueBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        knownTypes.add(this);
        return "org.omg.CORBA.ORB.init().create_value_tc(\"" + this.id() + "\", \"" + this.name + "\", org.omg.CORBA.VM_ABSTRACT.value " + ", null, null)";
    }

    public String printReadExpression(String streamname) {
        return "(" + this.javaName() + ")" + "((org.omg.CORBA_2_3.portable.InputStream)" + streamname + ")" + ".read_value (\"" + this.id() + "\")";
    }

    public String printReadStatement(String var_name, String streamname) {
        return var_name + " = " + this.printReadExpression(streamname);
    }

    public String printWriteStatement(String var_name, String streamname) {
        return "((org.omg.CORBA_2_3.portable.OutputStream)" + streamname + ")" + ".write_value (" + var_name + ");";
    }

    public void print(PrintWriter unused) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            try {
                File f;
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, this.name + ".java"))) {
                    Enumeration e;
                    PrintWriter ps = new PrintWriter(new FileWriter(f));
                    if (Environment.JAVA14 && this.pack_name.equals("")) {
                        lexer.emit_warn("No package defined for " + this.name + " - illegal in JDK1.4", this.token);
                    }
                    if (!this.pack_name.equals("")) {
                        ps.println("package " + this.pack_name + ";\n");
                    }
                    if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                        e = this.inheritanceSpec.v.elements();
                        while (e.hasMoreElements()) {
                            ScopedName sn = (ScopedName)e.nextElement();
                            if (sn.resolvedName().indexOf(46) >= 0) continue;
                            ps.println("import " + sn + "Operations;");
                        }
                    }
                    this.printImport(ps);
                    this.printClassComment(this.name, ps);
                    ps.println("public interface " + this.name);
                    ps.print("\textends org.omg.CORBA.portable.ValueBase ");
                    if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                        e = this.inheritanceSpec.v.elements();
                        while (e.hasMoreElements()) {
                            ps.print(", " + (ScopedName)e.nextElement());
                        }
                    }
                    ps.println("\n{");
                    if (this.body != null) {
                        this.body.printOperationSignatures(ps);
                    }
                    ps.println("}");
                    ps.close();
                }
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    public void accept(IDLTreeVisitor visitor) {
        visitor.visitValue(this);
    }
}

