/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.ActivationMode;
import org.jacorb.imrutility.imr.Activator;
import org.jacorb.imrutility.imr.ActivatorHelper;
import org.jacorb.imrutility.imr.ActivatorOperations;
import org.jacorb.imrutility.imr.AlivenessPolicy;
import org.jacorb.imrutility.imr.AlreadyRegistered;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.EndpointProfileSeqHolder;
import org.jacorb.imrutility.imr.ImplActive;
import org.jacorb.imrutility.imr.ImplInfo;
import org.jacorb.imrutility.imr.ImplRecord;
import org.jacorb.imrutility.imr.LBPolicyRegistry;
import org.jacorb.imrutility.imr.LoadBalancingPolicy;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.POAInfo;
import org.jacorb.imrutility.imr.POANameKey;
import org.jacorb.imrutility.imr.POARecord;
import org.jacorb.imrutility.imr.Registration;
import org.jacorb.imrutility.imr.RegistrationInfo;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.RepositoryAdminPOA;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.imrutility.imr.Server;
import org.jacorb.imrutility.imr.ServerHelper;
import org.jacorb.imrutility.imr.ServerInfo;
import org.jacorb.imrutility.imr.ServerName;
import org.jacorb.imrutility.imr.ServerRecord;
import org.jacorb.imrutility.imr.ServerState;
import org.jacorb.imrutility.imr.StartupFailed;
import org.jacorb.imrutility.imr.UnknownServer;
import org.jacorb.imrutility.imr.persistence.FilePersistence;
import org.jacorb.imrutility.imr.persistence.RepositoryData;
import org.jacorb.imrutility.imr.policy.LBPolicy;
import org.jacorb.imrutility.imr.util.IMRLocator;
import org.jacorb.imrutility.imr.util.MulticastEvent;
import org.jacorb.imrutility.imr.util.MulticastListener;
import org.jacorb.imrutility.imr.util.MulticastServer;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class RepositoryImpl
extends RepositoryAdminPOA
implements MulticastListener {
    protected RepositoryData repData = null;
    protected static ORB orb;
    protected static String iorfile;
    protected static boolean newFile;
    protected HashMap activityTable = new HashMap();
    private int activeTimeout = 120000;
    private boolean allowAuto = false;
    private boolean checkAlive = false;
    private boolean checkOtherImRs = true;
    private AlivenessPolicy aliveness;
    private long id;
    private MulticastServer ms;
    private final HashMap activators = new HashMap();
    private final HashMap runningServers = new HashMap();
    private final HashMap runningPOAs = new HashMap();
    private Timer timer;
    private boolean pinging = false;
    private int heartbeat;
    private int udpPort = 0;
    private EndpointProfile[] imrEndpoints;
    private static final int maxPings = 1;
    private Write writeThread;
    private boolean writePending;
    private Shutdown shutdownThread;
    private final Logger logger;
    private final Logger stateLogger;
    private final Logger locateLogger;
    private final Random idGenerator = new Random();
    private Object imrObj;
    private final FilePersistence persistence = new FilePersistence();

    public RepositoryImpl() throws InvalidName, AdapterAlreadyExists, ServantAlreadyActive, ServantNotActive, AdapterInactive, FileNotFoundException, WrongPolicy, InvalidPolicy, ObjectAlreadyActive {
        this.logger = Debug.getNamedLogger("jacorb.imr");
        this.stateLogger = Debug.getNamedLogger("jacorb.imr.state");
        this.locateLogger = Debug.getNamedLogger("jacorb.imr.locate");
        this.init();
        String identifier = Environment.getProperty("jacorb.imr.identifier");
        Environment.isImR(true);
        org.jacorb.poa.POA rootPOA = (org.jacorb.poa.POA)POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), identifier != null && identifier.length() != 0 ? rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID) : rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID)};
        POA imrPOA = rootPOA.create_POA("IMRPOA", rootPOA.the_POAManager(), policies);
        for (int i = 0; i < policies.length; ++i) {
            policies[i].destroy();
        }
        if (identifier != null && identifier.length() != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using identifier " + identifier);
            }
            imrPOA.activate_object_with_id(identifier.getBytes(), this);
        } else {
            imrPOA.activate_object(this);
        }
        PrintWriter pw = new PrintWriter(new FileOutputStream(new File(iorfile)));
        this.imrObj = imrPOA.servant_to_reference(this);
        rootPOA.the_POAManager().activate();
        String objString = orb.object_to_string(this.imrObj);
        ((org.jacorb.orb.ORB)orb).addObjectKey("ImplementationRepository", objString);
        pw.println(objString);
        pw.flush();
        pw.close();
        this.imrEndpoints = rootPOA.getEndpoints();
        orb.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String temp = null;
        this.timer = new Timer();
        this.shutdownThread = new Shutdown();
        this.shutdownThread.setDaemon(true);
        this.shutdownThread.setName("IMR Shutdown Thread");
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        this.writeThread = new Write();
        this.writeThread.setName("IMR Write Thread");
        this.writeThread.setDaemon(true);
        AlivenessPolicy ap = AlivenessPolicy.from_int(Environment.getAlivenessPolicy());
        if (ap.value() == 0) {
            temp = Environment.getProperty("jacorb.imr.heartbeat");
            if (temp == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("AlivenessPolicy is PING but heartbeat is not set");
                }
                throw new INTERNAL("AlivenessPolicy is PING but heartbeat is not set");
            }
            this.heartbeat = Integer.parseInt(temp);
        } else if (ap.value() == 2 && (temp = Environment.getProperty("jacorb.imr.active_server_timeout")) != null && temp.length() > 0) {
            this.activeTimeout = Integer.parseInt(temp);
        }
        this.aliveness(ap);
        temp = Environment.getProperty("jacorb.imr.allow_auto_register");
        if (temp != null) {
            this.allowAuto = temp.equalsIgnoreCase("on");
        }
        this.udpPort = Environment.getIntPropertyWithDefault("jacorb.imr.udp_port", 0);
        if (this.udpPort > 0) {
            this.initMulticast();
        }
        if (!newFile) {
            this.populateData();
            this.writeThread.start();
            Write write = this.writeThread;
            synchronized (write) {
                this.writeThread.notifyAll();
            }
        } else {
            this.repData = new RepositoryData();
            this.writeThread.start();
        }
        temp = null;
        ap = null;
    }

    private void populateData() {
        this.populateServers();
        this.populatePOAs();
        this.populateActivators();
    }

    private void populateServers() {
        ArrayList<Long> alist = null;
        this.repData = this.persistence.read();
        Map servers = this.repData.getServers();
        Iterator iter = servers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Long sID = (Long)entry.getKey();
            ServerRecord srecord = (ServerRecord)entry.getValue();
            Server srv = ServerHelper.narrow(orb.string_to_object(srecord.srv));
            try {
                srv.ping(0L);
                RunningServer rserver = new RunningServer(srv, System.currentTimeMillis(), srecord.pnKey.getImplName());
                this.runningServers.put(sID, rserver);
                this.activityTable.put(sID, new Long(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                if (alist == null) {
                    alist = new ArrayList<Long>();
                }
                alist.add(sID);
                break;
            }
        }
        if (alist != null) {
            this.repData.removeServers(alist);
        }
    }

    private void populatePOAs() {
        POANameKey pnkey = null;
        ArrayList<RunningPOA> pset = null;
        ArrayList<POANameKey> alist = null;
        Map poas = this.repData.getPOAs();
        Iterator iter = poas.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            pnkey = (POANameKey)entry.getKey();
            HashSet set = (HashSet)entry.getValue();
            pset = null;
            Iterator siter = set.iterator();
            while (siter.hasNext()) {
                EndpointProfile[] endpoints;
                POARecord prec = (POARecord)siter.next();
                RunningServer rsrv = (RunningServer)this.runningServers.get(new Long(prec.id));
                if (rsrv == null || (endpoints = prec.endpoints) == null) continue;
                RegistrationInfo reg = new RegistrationInfo(pnkey.getImplName(), endpoints, rsrv.srv);
                RunningPOA rpoa = new RunningPOA(reg, prec.id);
                if (pset == null) {
                    pset = new ArrayList<RunningPOA>();
                }
                pset.add(rpoa);
            }
            if (pset != null) {
                this.runningPOAs.put(pnkey, pset);
                continue;
            }
            if (alist == null) {
                alist = new ArrayList<POANameKey>();
            }
            alist.add(pnkey);
        }
        if (alist != null) {
            this.repData.removePOAs(alist);
        }
    }

    private void populateActivators() {
        Map acts = this.repData.getActivators();
        HashMap<Long, String> map = null;
        Iterator iter = acts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Long key = (Long)entry.getKey();
            String actIOR = (String)entry.getValue();
            try {
                Activator act = ActivatorHelper.narrow(orb.string_to_object(actIOR));
                this.activators.put(key, act);
            }
            catch (Exception ex) {
                if (map == null) {
                    map = new HashMap<Long, String>();
                }
                map.put(key, actIOR);
            }
        }
        if (map != null) {
            this.repData.removeActivators(map);
        }
    }

    private void initMulticast() {
        block2: {
            try {
                this.ms = new MulticastServer(this.udpPort);
                this.ms.addMulticastListener(this);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Failed to initialise MulticastServer", ex);
            }
        }
    }

    public int activeTimeout() {
        return this.activeTimeout;
    }

    public void activeTimeout(int timeout) {
        this.activeTimeout = timeout;
    }

    public boolean allowAuto() {
        return this.allowAuto;
    }

    public void allowAuto(boolean auto) {
        this.allowAuto = auto;
    }

    public boolean checkAlive() {
        return this.checkAlive;
    }

    public void checkAlive(boolean check) {
        this.checkAlive = check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImpl(ServerName name, Activator act) throws ImplActive, NotFound {
        POANameKey[] pnKey = POANameKey.serverNameToKeys(name);
        for (int i = 0; i < pnKey.length; ++i) {
            ImplRecord irec;
            if (this.runningPOAs.containsKey(pnKey[i])) {
                throw new ImplActive();
            }
            if (name.discriminator()) {
                HashMap hashMap = this.runningServers;
                synchronized (hashMap) {
                    Iterator iter = this.runningServers.values().iterator();
                    while (iter.hasNext()) {
                        RunningServer rsrv = (RunningServer)iter.next();
                        if (!rsrv.impl.equals(name.impl())) continue;
                        throw new ImplActive();
                    }
                }
            }
            if ((irec = this.repData.removeImpl(pnKey[i])) == null) {
                this.stateLogger.error(pnKey[i].toString() + " not found");
                throw new NotFound(pnKey[i].toString() + " not found");
            }
            if (!this.stateLogger.isDebugEnabled()) continue;
            this.stateLogger.debug("IMR :: removing poa " + pnKey[i]);
        }
        this.writePending = true;
        Write write = this.writeThread;
        synchronized (write) {
            this.writeThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImpl(ImplInfo info, Activator act) throws AlreadyRegistered {
        POANameKey[] pnKeys = POANameKey.serverNameToKeys(info.name);
        ImplRecord irec = new ImplRecord(info.multiples, info.lbPolicy.value(), info.activation.value());
        for (int i = 0; i < pnKeys.length; ++i) {
            if (this.repData.getImpl(pnKeys[i]) != null) {
                throw new AlreadyRegistered(info.name);
            }
            if (act != null) {
                long aid = 0L;
                aid = act.id();
                if (aid == 0L) {
                    aid = this.nextID();
                }
                act.id(aid);
                irec.activatorID = aid;
                Long actID = new Long(aid);
                HashMap hashMap = this.activators;
                synchronized (hashMap) {
                    this.activators.put(actID, act);
                }
                this.repData.addActivator(actID, orb.object_to_string(act));
            }
            this.repData.addImpl(pnKeys[i], irec);
        }
        this.writePending = true;
        Write write = this.writeThread;
        synchronized (write) {
            this.writeThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAll(long lid) throws NotFound {
        boolean found = false;
        Iterator iter = this.runningPOAs.entrySet().iterator();
        java.lang.Object object = this.runningPOAs;
        synchronized (object) {
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                POANameKey pnkey = (POANameKey)entry.getKey();
                ArrayList activeServers = (ArrayList)((ArrayList)entry.getValue()).clone();
                Iterator siter = activeServers.iterator();
                while (siter.hasNext()) {
                    RunningPOA rpoa = (RunningPOA)siter.next();
                    if (rpoa.id != lid) continue;
                    siter.remove();
                    found = true;
                }
                if (!found) continue;
                this.runningPOAs.put(pnkey, activeServers);
            }
        }
        object = this.runningServers;
        synchronized (object) {
            if (this.runningServers.remove(new Long(lid)) != null) {
                found = true;
            }
        }
        if (found) {
            this.writePending = true;
            this.repData.removeServer(lid);
            object = this.writeThread;
            synchronized (object) {
                this.writeThread.notifyAll();
            }
        } else {
            throw new NotFound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EndpointProfile[] locate(String impl, String[] poas) {
        POANameKey pnKey;
        boolean tryStart;
        RunningPOA prec;
        boolean swap;
        EndpointProfile[] endpoints;
        block25: {
            block27: {
                ArrayList activeServers = null;
                endpoints = null;
                long oldID = 0L;
                boolean startProcess = false;
                swap = false;
                prec = null;
                tryStart = false;
                pnKey = new POANameKey(impl, poas);
                HashMap hashMap = this.runningPOAs;
                synchronized (hashMap) {
                    activeServers = (ArrayList)this.runningPOAs.get(pnKey);
                    if (activeServers == null || activeServers.size() <= 0) break block27;
                }
                if (this.locateLogger.isDebugEnabled()) {
                    this.locateLogger.debug("Found " + activeServers.size() + " servers for " + pnKey.toString());
                }
                if (activeServers.size() == 1) {
                    prec = (RunningPOA)activeServers.get(0);
                    oldID = prec.id;
                    if (this.checkAlive()) {
                        if (this.locateLogger.isDebugEnabled()) {
                            this.locateLogger.debug("Checking if server alive for " + pnKey.toString());
                        }
                        try {
                            ((RunningServer)this.runningServers.get((java.lang.Object)new Long((long)prec.id))).srv.ping(0L);
                            swap = true;
                        }
                        catch (Exception ex) {
                            block24: {
                                try {
                                    this.deregisterAll(oldID);
                                }
                                catch (NotFound nf) {
                                    if (!this.locateLogger.isDebugEnabled()) break block24;
                                    this.locateLogger.debug("Unexpected NotFound exception");
                                }
                            }
                            if (this.checkOtherImRs) {
                                tryStart = true;
                            }
                            break block25;
                        }
                    }
                    swap = true;
                    break block25;
                } else {
                    try {
                        prec = this.applyLoadBalancing(activeServers, pnKey);
                        swap = true;
                    }
                    catch (StartupFailed sf) {
                        if (this.locateLogger.isDebugEnabled()) {
                            this.locateLogger.debug(sf.reason);
                        }
                        break block25;
                    }
                    catch (Exception ex) {
                        if (this.locateLogger.isDebugEnabled()) {
                            this.locateLogger.debug("Exception locating server " + ex);
                        }
                        break block25;
                    }
                }
            }
            tryStart = true;
        }
        if (!swap && this.checkOtherImRs) {
            endpoints = this.checkOtherImRs(impl, poas);
        }
        if (!swap && (endpoints == null || endpoints.length == 0) && tryStart) {
            block26: {
                try {
                    prec = this.startProcess(pnKey);
                }
                catch (Exception ex2) {
                    if (!this.locateLogger.isDebugEnabled()) break block26;
                    this.locateLogger.debug("Exception starting " + pnKey.toString(), ex2);
                }
            }
            if (prec != null) {
                swap = true;
            }
        }
        if (swap) {
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug("Found Server id " + prec.id + " - getting endpoints");
            }
            endpoints = prec.reg.endpoints;
        }
        if (endpoints != null) return endpoints;
        return new EndpointProfile[0];
    }

    public EndpointProfile[] imrLocateRequest(String impl, String[] poas) {
        if (this.locateLogger.isDebugEnabled()) {
            this.locateLogger.debug("Received request from other IMR");
        }
        this.checkOtherImRs = false;
        EndpointProfile[] endpoints = this.locate(impl, poas);
        this.checkOtherImRs = true;
        return endpoints;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerPOA(LongHolder lid, String[] poas, Registration reg, EndpointProfileSeqHolder endpoints) throws NotFound, ImplActive, AlreadyRegistered {
        RunningPOA rpoa;
        RunningServer rsrv;
        POANameKey pnKey = null;
        RegistrationInfo regInfo = null;
        ImplRecord irec = null;
        ArrayList regServers = null;
        POANameKey ipnKey = null;
        long longID = lid.value;
        endpoints.value = this.imrEndpoints;
        if (!reg.discriminator()) {
            pnKey = new POANameKey(reg.reg().impl, poas);
            regInfo = reg.reg();
        } else if (longID != -1L && longID != 0L && (regServers = (ArrayList)this.runningPOAs.get(pnKey = (rsrv = (RunningServer)this.runningServers.get(lid)) != null ? new POANameKey(rsrv.impl, poas) : new POANameKey("", poas))) != null) {
            Iterator iter = regServers.iterator();
            while (iter.hasNext()) {
                rpoa = (RunningPOA)iter.next();
                if (rpoa.id != lid.value) continue;
                regInfo = rpoa.reg;
                break;
            }
        }
        if (regInfo == null) {
            this.stateLogger.error("Registration details not held for " + pnKey.toString());
            throw new NotFound("Registration details not held for " + pnKey.toString());
        }
        if (this.stateLogger.isDebugEnabled()) {
            this.stateLogger.debug("RegisterPOA and registering " + pnKey.toString());
        }
        if ((irec = this.repData.getImpl(ipnKey = this.getIPOANameKey(pnKey))) == null) {
            if (this.allowAuto) {
                lid.value = this.internalRegisterPOA(ipnKey, pnKey, regInfo, 0, 0, longID);
                return;
            }
            this.stateLogger.error("Implementation not found and not auto allowed: " + pnKey.toString());
            throw new NotFound("Implementation not found and not auto allowed: " + pnKey.toString());
        }
        if (regServers == null) {
            regServers = (ArrayList)this.runningPOAs.get(pnKey);
        }
        if (regServers != null && regServers.size() > 0) {
            if (irec.multiples) {
                lid.value = this.internalRegisterPOA(ipnKey, pnKey, regInfo, irec.lb_policy, irec.mode, longID);
                return;
            }
            rpoa = (RunningPOA)regServers.get(0);
            boolean remap = false;
            if (longID == rpoa.id) {
                remap = true;
            } else {
                try {
                    ((RunningPOA)regServers.get((int)0)).reg.srv.ping(0L);
                }
                catch (Exception ex) {
                    this.deregisterAll(((RunningPOA)regServers.get((int)0)).id);
                    remap = true;
                }
            }
            if (!remap) {
                this.stateLogger.error("Implementation already active: Duplicates not allowed: " + pnKey.toString());
                throw new ImplActive("Implementation already active: Duplicates not allowed: " + pnKey.toString());
            }
            lid.value = this.internalRegisterPOA(ipnKey, pnKey, regInfo, irec.lb_policy, irec.mode, longID);
            return;
        }
        lid.value = this.internalRegisterPOA(ipnKey, pnKey, regInfo, irec.lb_policy, irec.mode, longID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPOA(long lid, String[] poas) throws NotFound {
        RunningServer rsrv = (RunningServer)this.runningServers.get(new Long(lid));
        if (rsrv == null) {
            throw new NotFound();
        }
        POANameKey pnkey = new POANameKey(rsrv.impl, poas);
        ArrayList activeServers = (ArrayList)this.runningPOAs.get(pnkey);
        if (activeServers == null) {
            throw new NotFound();
        }
        Iterator iter = activeServers.iterator();
        java.lang.Object object = this.runningPOAs;
        synchronized (object) {
            while (iter.hasNext()) {
                RunningPOA rpoa = (RunningPOA)iter.next();
                if (rpoa.id != lid) continue;
                iter.remove();
            }
        }
        this.writePending = true;
        this.repData.removePOA(lid, pnkey);
        object = this.writeThread;
        synchronized (object) {
            this.writeThread.notifyAll();
        }
    }

    public long nextID() {
        return this.idGenerator.nextLong();
    }

    public AlivenessPolicy aliveness() {
        return this.aliveness;
    }

    public void aliveness(AlivenessPolicy policy) {
        this.aliveness = policy;
        if (this.aliveness.value() == 0 && this.heartbeat > 0) {
            if (!this.pinging) {
                this.timer.schedule((TimerTask)new PingTask(), 0L, (long)this.heartbeat);
                this.pinging = true;
            }
        } else if (this.aliveness.value() == 2) {
            this.timer.schedule((TimerTask)new ActivityTask(), 0L, (long)this.activeTimeout);
        } else if (this.aliveness.value() == 1) {
            this.checkAlive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        Write write = this.writeThread;
        synchronized (write) {
            this.writeThread.shutdown();
            this.writeThread.notifyAll();
        }
        this.timer.cancel();
        if (this.ms != null) {
            this.ms.removeMulticastListener(this);
            this.ms.close();
            this.ms = null;
        }
        this.persistence.backup(this.repData);
        if (orb != null) {
            orb.shutdown(wait);
        }
    }

    public void heartbeat(int beat) {
        this.heartbeat = beat;
    }

    public int heartbeat() {
        return this.heartbeat;
    }

    public long id() {
        return this.id;
    }

    public void id(long id_) {
        this.id = id_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(long sid) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got pinged by server " + sid);
        }
        HashMap hashMap = this.activityTable;
        synchronized (hashMap) {
            if (this.runningServers.containsKey(new Long(sid))) {
                this.activityTable.put(new Long(sid), new Long(System.currentTimeMillis()));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("IMR Got pinged by unknown server :: id " + sid);
            }
        }
    }

    public POAInfo[] listPOAs(long server) {
        ArrayList<POAInfo> arrayList = new ArrayList<POAInfo>();
        Iterator iter = this.runningPOAs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            POANameKey pnKey = (POANameKey)entry.getKey();
            ArrayList rpoas = (ArrayList)entry.getValue();
            Iterator poaIter = rpoas.iterator();
            while (poaIter.hasNext()) {
                RunningPOA rpoa = (RunningPOA)poaIter.next();
                if (rpoa.id != server) continue;
                POANameKey ipnKey = this.getIPOANameKey(pnKey);
                ImplRecord irec = this.repData.getImpl(ipnKey);
                if (irec != null) {
                    LoadBalancingPolicy lb_policy = LoadBalancingPolicy.from_int(irec.lb_policy);
                    POAInfo pinfo = new POAInfo(pnKey.toString(), lb_policy);
                    arrayList.add(pinfo);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.warn("Listing POAS and implementation details not  found for " + pnKey.toString());
            }
        }
        POAInfo[] pinfos = new POAInfo[arrayList.size()];
        return arrayList.toArray(pinfos);
    }

    public ServerInfo[] listServers(ServerName sname) throws NotFound {
        ServerInfo[] sinfos = null;
        java.lang.Object srv = null;
        boolean hasImpl = false;
        boolean aliveCheck = this.aliveness.value() != 3;
        POANameKey[] keys = null;
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        Iterator iter = this.runningPOAs.entrySet().iterator();
        ArrayList<Long> serverIDs = new ArrayList<Long>();
        Long serverID = null;
        if (sname.discriminator()) {
            hasImpl = true;
        } else {
            keys = POANameKey.serverNameToKeys(sname);
        }
        while (iter.hasNext()) {
            ServerInfo sinfo;
            RunningPOA rpoa;
            Iterator poaIter;
            ArrayList rpoas;
            Map.Entry map = iter.next();
            POANameKey key = (POANameKey)map.getKey();
            if (hasImpl) {
                if (!sname.impl().equals(key.getImplName())) continue;
                rpoas = (ArrayList)map.getValue();
                poaIter = rpoas.iterator();
                while (poaIter.hasNext()) {
                    rpoa = (RunningPOA)poaIter.next();
                    serverID = new Long(rpoa.id);
                    if (serverIDs.contains(serverID)) continue;
                    serverIDs.add(serverID);
                    sinfo = new ServerInfo(rpoa.id, this.getServerState(rpoa.id, aliveCheck), rpoa.reg.srv);
                    arrayList.add(sinfo);
                }
                continue;
            }
            for (int i = 0; i < keys.length; ++i) {
                rpoas = (ArrayList)this.runningPOAs.get(keys[i]);
                if (rpoas == null) continue;
                poaIter = rpoas.iterator();
                while (iter.hasNext()) {
                    rpoa = (RunningPOA)((java.lang.Object)iter.next());
                    sinfo = new ServerInfo(rpoa.id, this.getServerState(rpoa.id, aliveCheck), rpoa.reg.srv);
                    arrayList.add(sinfo);
                }
            }
        }
        sinfos = new ServerInfo[arrayList.size()];
        return arrayList.toArray(sinfos);
    }

    public void shutdownServer(long server) {
    }

    private ServerState getServerState(long id, boolean aliveCheck) {
        ServerState active = ServerState.from_int(2);
        if (this.activityTable.containsKey(new Long(id))) {
            active = ServerState.from_int(0);
        } else if (aliveCheck) {
            active = ServerState.from_int(1);
        }
        return active;
    }

    public ImplInfo[] listAllImpls() {
        ArrayList<ImplInfo> alist = new ArrayList<ImplInfo>();
        Set regImpls = this.repData.getImpls().entrySet();
        Iterator iter = regImpls.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            POANameKey pnKey = (POANameKey)entry.getKey();
            ImplRecord irec = (ImplRecord)entry.getValue();
            ImplInfo iinfo = new ImplInfo(pnKey.keyToServerName(), irec.multiples, LoadBalancingPolicy.from_int(irec.lb_policy), ActivationMode.from_int(irec.mode));
            alist.add(iinfo);
        }
        ImplInfo[] iinfos = new ImplInfo[alist.size()];
        return alist.toArray(iinfos);
    }

    public ServerInfo[] listActivators() {
        throw new RuntimeException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalRegisterPOA(POANameKey ipnKey, POANameKey pnKey, RegistrationInfo rinfo, int lb_policy, int act_mode, long sID) throws NotFound {
        ArrayList<RunningPOA> rpoas;
        LoadBalancingPolicy policy = LoadBalancingPolicy.from_int(lb_policy);
        ActivationMode mode = ActivationMode.from_int(act_mode);
        boolean replacement = false;
        long regID = 0L;
        this.writePending = true;
        if (this.repData.getImpl(ipnKey) == null) {
            ImplRecord irec = new ImplRecord(false, policy.value(), mode.value());
            this.repData.addImpl(ipnKey, irec);
        }
        regID = sID == 0L || sID == -1L ? this.nextID() : sID;
        if (this.stateLogger.isDebugEnabled()) {
            this.stateLogger.debug("Registering POA with id " + regID + " and key " + pnKey.toString());
        }
        if ((rpoas = (ArrayList<RunningPOA>)this.runningPOAs.get(pnKey)) == null) {
            POARecord precord = new POARecord(rinfo.endpoints, regID);
            RunningPOA rpoa = new RunningPOA(rinfo, regID);
            rpoas = new ArrayList<RunningPOA>();
            rpoas.add(rpoa);
            this.runningPOAs.put(pnKey, rpoas);
            this.repData.addPOA(pnKey, precord);
        } else {
            POARecord precord;
            RunningPOA rpoa;
            for (int i = 0; i < rpoas.size(); ++i) {
                rpoa = (RunningPOA)rpoas.get(i);
                if (rpoa.id != regID) continue;
                rpoa.reg = rinfo;
                precord = new POARecord(rinfo.endpoints, regID);
                this.repData.replacePOA(pnKey, precord);
                replacement = true;
                break;
            }
            if (!replacement) {
                precord = new POARecord(rinfo.endpoints, regID);
                rpoa = new RunningPOA(rinfo, regID);
                rpoas.add(rpoa);
                this.repData.addPOA(pnKey, precord);
            }
        }
        RunningServer rserver = new RunningServer(rinfo.srv, System.currentTimeMillis(), pnKey.getImplName());
        ServerRecord srecord = new ServerRecord(orb.object_to_string(rinfo.srv), ipnKey);
        java.lang.Object object = this.runningServers;
        synchronized (object) {
            this.runningServers.put(new Long(regID), rserver);
        }
        object = this.activityTable;
        synchronized (object) {
            this.activityTable.put(new Long(regID), new Long(System.currentTimeMillis()));
        }
        this.repData.addServer(regID, srecord);
        object = this.writeThread;
        synchronized (object) {
            this.writeThread.notifyAll();
        }
        return regID;
    }

    private EndpointProfile[] checkOtherImRs(String impl, String[] poas) {
        IMRLocator locator;
        String otherIMR;
        String thisIMR;
        EndpointProfile[] endpoints;
        Repository rep;
        ArrayList imrs;
        block11: {
            imrs = null;
            rep = null;
            endpoints = null;
            thisIMR = orb.object_to_string(this.imrObj);
            otherIMR = null;
            locator = null;
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug("In checkOtherImRs");
            }
            try {
                locator = new IMRLocator(orb);
                locator.findIMRs();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {}
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block11;
                this.logger.error("IMRLocator got an exception finding ImRs", ex);
            }
        }
        imrs = locator.getIMRs();
        if (this.locateLogger.isDebugEnabled()) {
            this.locateLogger.debug("Found " + imrs.size() + " other ImRs");
        }
        for (int i = 0; i < imrs.size(); ++i) {
            try {
                otherIMR = orb.object_to_string((Object)imrs.get(i));
                if (!thisIMR.equals(otherIMR)) {
                    rep = (Repository)imrs.get(i);
                    endpoints = rep.imrLocateRequest(impl, poas);
                    if (this.locateLogger.isDebugEnabled()) {
                        this.locateLogger.debug("Got " + endpoints + " endpoints from other IMR");
                    }
                }
                if (endpoints == null) continue;
                break;
            }
            catch (Exception ex) {
                this.locateLogger.warn("An exception occurred with remote ImR. ", ex);
            }
        }
        return endpoints;
    }

    private RunningPOA startProcess(POANameKey pnKey) {
        ActivatorOperations activator = null;
        RunningPOA rpoa = null;
        ServerName sname = null;
        if (this.locateLogger.isDebugEnabled()) {
            this.locateLogger.debug("IMR :: startProcess for POA " + pnKey.toString());
        }
        POANameKey ipnKey = this.getIPOANameKey(pnKey);
        try {
            ImplRecord irec = this.repData.getImpl(ipnKey);
            if (irec != null && irec.mode == 3) {
                activator = (Activator)this.activators.get(new Long(irec.activatorID));
            }
            if (activator != null) {
                sname = pnKey.keyToServerName();
                activator.startServer(sname, true);
                Thread.sleep(Environment.getIntPropertyWithDefault("jacorb.imr.activator.start_timeout", 5000));
                ArrayList activeServers = (ArrayList)this.runningPOAs.get(pnKey);
                if (activeServers.size() == 1) {
                    rpoa = (RunningPOA)activeServers.get(0);
                } else if (activeServers.size() > 1) {
                    rpoa = this.applyLoadBalancing(activeServers, pnKey);
                }
                this.updateActivator((Activator)activator, sname);
            } else if (irec != null) {
                irec.activatorID = 0L;
            }
        }
        catch (StartupFailed sf) {
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug("Activator failed to start server. ", sf);
            }
            this.updateActivator((Activator)activator, sname);
            throw new INTERNAL("Activator failed to start server " + sf.reason);
        }
        catch (UnknownServer us) {
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug(ipnKey.toString() + " not registered with Activator");
            }
            this.updateActivator((Activator)activator, sname);
            throw new INTERNAL(ipnKey.toString() + " not registered with Activator");
        }
        catch (Exception ex) {
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug(ex.getMessage());
            }
            this.updateActivator((Activator)activator, sname);
            throw new INTERNAL("Activator failed to start server " + ex);
        }
        return rpoa;
    }

    private void updateActivator(Activator activator, ServerName sname) {
        block4: {
            try {
                activator.serverStarted(sname);
            }
            catch (UnknownServer us) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("updateActivator got UnknownServer : " + sname);
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("updateActivator got Exception : " + sname + ex);
            }
        }
    }

    private RunningPOA applyLoadBalancing(ArrayList activeServers, POANameKey pnKey) throws StartupFailed {
        Iterator iter;
        boolean activeServerFound;
        Long sID;
        RunningPOA rpoa;
        block16: {
            rpoa = null;
            sID = null;
            RunningServer rsrv = null;
            HashMap selected = null;
            activeServerFound = false;
            POANameKey ipnKey = this.getIPOANameKey(pnKey);
            TreeMap<Long, Long> serverTimes = new TreeMap<Long, Long>();
            iter = activeServers.iterator();
            while (iter.hasNext()) {
                long id = ((RunningPOA)iter.next()).id;
                rsrv = (RunningServer)this.runningServers.get(new Long(id));
                serverTimes.put(new Long(rsrv.regTime), new Long(id));
            }
            LoadBalancingPolicy lbpolicy = LoadBalancingPolicy.from_int(this.repData.getImpl((POANameKey)ipnKey).lb_policy);
            LBPolicy policy = LBPolicyRegistry.lookup(lbpolicy);
            try {
                Map.Entry entry = null;
                int servers = 0;
                int initSize = serverTimes.size();
                while (!activeServerFound && servers < initSize) {
                    sID = null;
                    ++servers;
                    selected = policy.getSelectedServer(ipnKey.toString(), serverTimes);
                    if (this.locateLogger.isDebugEnabled()) {
                        this.locateLogger.debug("Applying load balancing and " + selected.size() + " servers found");
                    }
                    if (selected.size() > 0) {
                        entry = selected.entrySet().iterator().next();
                        sID = (Long)entry.getValue();
                    }
                    if (this.locateLogger.isDebugEnabled()) {
                        this.locateLogger.debug("Applying load balancing check alive is " + this.checkAlive + " server id is " + sID);
                    }
                    if (this.checkAlive() && sID != null) {
                        try {
                            ((RunningServer)this.runningServers.get((java.lang.Object)sID)).srv.ping(0L);
                            activeServerFound = true;
                            if (!this.locateLogger.isDebugEnabled()) continue;
                            this.locateLogger.debug("Apply load balancing active server found");
                        }
                        catch (Exception ex) {
                            block15: {
                                try {
                                    if (this.locateLogger.isDebugEnabled()) {
                                        this.locateLogger.debug("Apply load balancing and deregistering server id " + sID);
                                    }
                                    this.deregisterAll(sID);
                                }
                                catch (NotFound nf) {
                                    if (!this.locateLogger.isDebugEnabled()) break block15;
                                    this.locateLogger.debug("NotFound deregistering server id " + sID);
                                }
                            }
                            serverTimes.remove((Long)entry.getKey());
                        }
                        continue;
                    }
                    if (sID == null || this.runningServers.get(sID) == null) continue;
                    activeServerFound = true;
                }
            }
            catch (Exception ex) {
                if (!this.locateLogger.isDebugEnabled()) break block16;
                this.locateLogger.debug("Exception applying load balancing ", ex);
            }
        }
        if (!activeServerFound) {
            throw new StartupFailed("Selected server is not active.  AutoActivate multiples NYI");
        }
        iter = null;
        iter = activeServers.iterator();
        while (iter.hasNext()) {
            rpoa = (RunningPOA)iter.next();
            if (rpoa.id != sID) continue;
            break;
        }
        return rpoa;
    }

    public byte[] multicastEvent(MulticastEvent me) {
        byte[] returnPacket = null;
        byte[] requestPacket = null;
        if (this.locateLogger.isDebugEnabled()) {
            this.locateLogger.debug("Got the multicast event \n");
        }
        try {
            requestPacket = me.getData();
            CDRInputStream clientRequest = new CDRInputStream(orb, requestPacket);
            clientRequest.openEncapsulatedArray();
            clientRequest.close();
            CDROutputStream serverResponse = new CDROutputStream();
            serverResponse.beginEncapsulatedArray();
            serverResponse.write_string("ImplementationRepository");
            RepositoryHelper.write(serverResponse, RepositoryHelper.narrow(this.imrObj));
            returnPacket = serverResponse.getBufferCopy();
            serverResponse.close();
        }
        catch (Exception ex) {
            if (this.locateLogger.isDebugEnabled()) {
                this.locateLogger.debug("Error handling MulticastEvent: ", ex);
                this.locateLogger.debug(ex.getMessage());
            }
            returnPacket = new byte[]{};
        }
        return returnPacket;
    }

    public void registerIMR(Repository rep) {
        throw new RuntimeException("NYI");
    }

    private POANameKey getIPOANameKey(POANameKey pnKey) {
        if (pnKey.hasImpl()) {
            return new POANameKey(pnKey.getImplName());
        }
        return new POANameKey(pnKey.getPOAS());
    }

    protected void writeData() {
        this.persistence.write(this.repData);
        this.writePending = false;
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("jacorb.implname", "theImR");
        props.put("jacorb.use_imr", "off");
        RepositoryImpl.checkArgs(args, props);
        orb = ORB.init(args, props);
        try {
            new RepositoryImpl();
        }
        catch (Exception ex) {
            System.out.println("Exception starting ImR : " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void checkArgs(String[] args, Properties props) {
        String default_host = null;
        String imrPort = null;
        String udpPort = null;
        String timeOut = null;
        String policy = null;
        String dataFile = null;
        String temp = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h") || args[i].equals("--help")) {
                    RepositoryImpl.usage();
                }
                if (args[i].equals("-n") || args[i].equals("--imr_new")) {
                    if (dataFile != null) {
                        System.out.println("New file not appropriate if data file specified");
                        System.exit(0);
                        continue;
                    }
                    newFile = true;
                    continue;
                }
                if (i >= args.length - 1) continue;
                if (args[i].equals("-p") || args[i].equals("--port")) {
                    if ((imrPort = args[++i]) == null) continue;
                    props.setProperty("jacorb.imr.port_number", imrPort);
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--imr_ior")) {
                    iorfile = args[++i];
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--aliveness")) {
                    if ((policy = args[++i]) != null && RepositoryImpl.isValidPolicy(policy)) {
                        props.setProperty("jacorb.imr.aliveness_policy", policy);
                        continue;
                    }
                    policy = null;
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--timeout")) {
                    timeOut = args[++i];
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--activator_timeout")) {
                    props.setProperty("jacorb.imr.activator.start_timeout", args[++i]);
                    continue;
                }
                if (args[i].equals("-u") || args[i].equals("--udp_port")) {
                    udpPort = args[++i];
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--auto")) {
                    props.setProperty("jacorb.imr.allow_auto_register", args[++i]);
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--imr_data")) {
                    if (newFile) {
                        System.out.println("Data file name not appropriate if new file specified");
                        System.exit(0);
                        continue;
                    }
                    dataFile = args[++i];
                    props.setProperty("jacorb.imr.imr_data_file", dataFile);
                    continue;
                }
                if (!args[i].equals("-b") && !args[i].equals("--imr_backup")) continue;
                props.setProperty("jacorb.imr.imr_backup_file", args[++i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RepositoryImpl.usage();
        }
        if (timeOut != null) {
            if (policy != null) {
                int ipolicy = Integer.parseInt(policy);
                if (ipolicy == 2) {
                    props.setProperty("jacorb.imr.active_server_timeout", timeOut);
                } else if (ipolicy == 0) {
                    props.setProperty("jacorb.imr.heartbeat", timeOut);
                }
            } else if (Environment.getAlivenessPolicy() == 2) {
                props.setProperty("jacorb.imr.active_server_timeout", timeOut);
            } else if (Environment.getAlivenessPolicy() == 0) {
                props.setProperty("jacorb.imr.heartbeat", timeOut);
            }
        }
        if (iorfile == null) {
            iorfile = Environment.getProperty("jacorb.imr.ior_file");
            if (iorfile == null) {
                System.out.println("ImR IOR file location not known");
                RepositoryImpl.usage();
            }
        } else {
            props.setProperty("jacorb.imr.ior_file", iorfile);
        }
        if (udpPort != null) {
            props.setProperty("jacorb.imr.udp_port", udpPort);
        }
        if ((temp = Environment.getProperty("jacorb.imr.port_number")) != null && temp.length() > 0) {
            props.setProperty("OAPort", temp);
        }
        if ((default_host = Environment.getProperty("jacorb.imr.host")) != null && default_host.length() > 0) {
            props.setProperty("OAIAddr", default_host);
        }
    }

    private static boolean isValidPolicy(String policy) {
        String[] policies = new String[]{"0", "1", "2", "3"};
        return policies[Integer.parseInt(policy)] != null;
    }

    public static void usage() {
        String separator = "--------------------------------------------------------------";
        System.out.println();
        System.out.println(separator);
        System.out.println("Usage:                                                        ");
        System.out.println();
        System.out.println("[ -p | --port ] <port number>  The port number on which the   ");
        System.out.println("                               IMR is to listen               ");
        System.out.println(separator);
        System.out.println("[ -i | --imr_ior ] <filename>  The filename for the IOR for   ");
        System.out.println("                               this Repository                ");
        System.out.println(separator);
        System.out.println("[ -f | --imr_data ] <filename> The filename in which the      ");
        System.out.println("                               Repository data is to be       ");
        System.out.println("                               saved                          ");
        System.out.println(separator);
        System.out.println("[ -b | --imr_backup ] <filename> The filename in which the    ");
        System.out.println("                               Repository data is to be       ");
        System.out.println("                               backed up - if required        ");
        System.out.println(separator);
        System.out.println("[ -n | --imr_new ]            If set a new file will be       ");
        System.out.println("                               created for the Repository data");
        System.out.println("                               - if not set data in any       ");
        System.out.println("                               existing file will be loaded   ");
        System.out.println(separator);
        System.out.println("[ -a | --aliveness ] <policy> The aliveness policy to be      ");
        System.out.println("                              applied i.e. when/if the ImR    ");
        System.out.println("                              pings the server to see if it is");
        System.out.println("                              alive.                          ");
        System.out.println("                                                              ");
        System.out.println("                                0 = PING                      ");
        System.out.println("                                1 = ON_LOOKUP                 ");
        System.out.println("                                2 = ON_EXPIRY                 ");
        System.out.println("                                3 = NONE                      ");
        System.out.println(separator);
        System.out.println("[ -t | -- timeout ] <timeout> The time interval to be applied ");
        System.out.println("                              when the aliveness policy is    ");
        System.out.println("                              ON_EXPIRY or PING               ");
        System.out.println("                              (time in milliseconds)          ");
        System.out.println(separator);
        System.out.println("[ -u | --udp_port ]           The port number on which the    ");
        System.out.println("                              MulticastServer is to run for   ");
        System.out.println("                              this ImR.                       ");
        System.out.println(separator);
        System.out.println("[ -s | --auto ] <on/off>     Flag indicating whether automatic");
        System.out.println("                             registration of servers is       ");
        System.out.println("                             allowed                          ");
        System.out.println("                                values on or off              ");
        System.out.println(separator);
        System.out.println("[ -v | --activator_timeout ] <timeout>                        ");
        System.out.println("                              The time interval that the      ");
        System.out.println("                              Repository should wait for a    ");
        System.out.println("                              server to be autoactivated      ");
        System.out.println("                              (time in milliseconds)          ");
        System.out.println(separator);
        System.out.println("[ -h | --help ]               Displays this help              ");
        System.out.println(separator);
        System.exit(0);
    }

    static {
        newFile = false;
    }

    protected class RunningPOA {
        RegistrationInfo reg;
        long id;

        public RunningPOA(RegistrationInfo in_reg, long in_id) {
            this.reg = in_reg;
            this.id = in_id;
        }
    }

    protected class RunningServer {
        Server srv;
        long regTime;
        String impl;
        int pingCount = 0;

        public RunningServer(Server in_srv, long in_time, String in_impl) {
            this.srv = in_srv;
            this.regTime = in_time;
            this.impl = in_impl;
        }
    }

    private class Write
    extends Thread {
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    RepositoryImpl.this.writeData();
                }
                catch (Exception ex) {
                    RepositoryImpl.this.logger.warn("Exception writing data", ex);
                }
                if (this.done) break;
                if (RepositoryImpl.this.writePending) continue;
                try {
                    Write ex = this;
                    synchronized (ex) {
                        this.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void shutdown() {
            this.done = true;
        }
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (RepositoryImpl.this.logger.isWarnEnabled()) {
                RepositoryImpl.this.logger.warn("ImR: Shutting down");
            }
            Shutdown shutdown = this;
            synchronized (shutdown) {
                RepositoryImpl.this.shutdown(true);
            }
        }
    }

    private class ActivityTask
    extends TimerTask {
        private ActivityTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunningServer rsrv = null;
            HashMap hashMap = RepositoryImpl.this.activityTable;
            synchronized (hashMap) {
                Iterator iter = RepositoryImpl.this.activityTable.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Long sid = (Long)entry.getKey();
                    long time = (Long)entry.getValue();
                    if (System.currentTimeMillis() - time <= (long)RepositoryImpl.this.activeTimeout) continue;
                    try {
                        rsrv = (RunningServer)RepositoryImpl.this.runningServers.get(sid);
                        ++rsrv.pingCount;
                        rsrv.srv.ping(0L);
                        rsrv.pingCount = 0;
                    }
                    catch (Exception ex) {
                        if (rsrv.pingCount != 1) continue;
                        iter.remove();
                        try {
                            RepositoryImpl.this.deregisterAll(sid);
                        }
                        catch (NotFound nf) {
                            if (!RepositoryImpl.this.logger.isDebugEnabled()) continue;
                            RepositoryImpl.this.logger.debug("ActivityTask unable to remove " + sid);
                        }
                    }
                }
            }
        }
    }

    private class PingTask
    extends TimerTask {
        private PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunningServer rsrv = null;
            HashMap hashMap = RepositoryImpl.this.activityTable;
            synchronized (hashMap) {
                Iterator iter = RepositoryImpl.this.activityTable.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Long srvID = (Long)entry.getKey();
                    try {
                        rsrv = (RunningServer)RepositoryImpl.this.runningServers.get(srvID);
                        ++rsrv.pingCount;
                        rsrv.srv.ping(0L);
                        rsrv.pingCount = 0;
                        entry.setValue(new Long(System.currentTimeMillis()));
                    }
                    catch (Exception ex) {
                        if (rsrv != null && rsrv.pingCount != 1) continue;
                        iter.remove();
                        try {
                            RepositoryImpl.this.deregisterAll(srvID);
                        }
                        catch (NotFound nf) {
                            if (!RepositoryImpl.this.logger.isDebugEnabled()) continue;
                            RepositoryImpl.this.logger.debug("Ping - got NotFound " + srvID);
                        }
                    }
                }
            }
        }
    }
}

