/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.FixedHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class Any
extends org.omg.CORBA.Any {
    private org.omg.CORBA.TypeCode typeCode;
    private java.lang.Object value;
    private org.omg.CORBA.ORB orb;

    Any(org.omg.CORBA.ORB orb) {
        this.orb = orb;
        this.typeCode = orb.get_primitive_tc(TCKind.tk_null);
    }

    public TCKind kind() {
        return this.typeCode.kind();
    }

    public org.omg.CORBA.TypeCode type() {
        return this.typeCode;
    }

    public org.omg.CORBA.TypeCode originalType() {
        return TypeCode.originalType(this.typeCode);
    }

    public void type(org.omg.CORBA.TypeCode t) {
        this.typeCode = t;
        this.value = null;
    }

    public java.lang.Object value() {
        return this.value;
    }

    public int _get_TCKind() {
        return 11;
    }

    private void tc_error(String s) {
        throw new BAD_OPERATION(s);
    }

    private void checkExtract(int value, String s) {
        if (this.originalType().kind().value() != value) {
            throw new BAD_OPERATION(s);
        }
    }

    public boolean equal(org.omg.CORBA.Any a) {
        if (a == null) {
            throw new BAD_PARAM("Null passed to Any equal operation");
        }
        if (!this.typeCode.equal(a.type())) {
            return false;
        }
        int kind = this.originalType().kind().value();
        switch (kind) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == a.extract_short();
            }
            case 3: {
                return this.extract_long() == a.extract_long();
            }
            case 23: {
                return this.extract_longlong() == a.extract_longlong();
            }
            case 4: {
                return this.extract_ushort() == a.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == a.extract_ulong();
            }
            case 24: {
                return this.extract_ulonglong() == a.extract_ulonglong();
            }
            case 6: {
                return this.extract_float() == a.extract_float();
            }
            case 7: {
                return this.extract_double() == a.extract_double();
            }
            case 28: {
                return this.extract_fixed().equals(a.extract_fixed());
            }
            case 8: {
                return this.extract_boolean() == a.extract_boolean();
            }
            case 9: {
                return this.extract_char() == a.extract_char();
            }
            case 26: {
                return this.extract_wchar() == a.extract_wchar();
            }
            case 10: {
                return this.extract_octet() == a.extract_octet();
            }
            case 11: {
                return this.extract_any().equals(a.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(a.extract_TypeCode());
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                return this.extract_Object().equals(a.extract_Object());
            }
            case 18: {
                return this.extract_string().equals(a.extract_string());
            }
            case 27: {
                return this.extract_wstring().equals(a.extract_wstring());
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 29: 
            case 30: {
                CDROutputStream out2;
                CDROutputStream out1;
                if (!(this.orb instanceof ORB)) {
                    out1 = new CDROutputStream();
                    out2 = new CDROutputStream();
                } else {
                    out1 = new CDROutputStream(this.orb);
                    out2 = new CDROutputStream(this.orb);
                }
                this.write_value(out1);
                a.write_value(out2);
                if (out1.size() != out2.size()) {
                    return false;
                }
                return Arrays.equals(out1.getBufferCopy(), out2.getBufferCopy());
            }
        }
        throw new BAD_TYPECODE("Cannot compare anys with TypeCode kind " + kind);
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof org.omg.CORBA.Any) {
            return this.equal((org.omg.CORBA.Any)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "null";
    }

    public void insert_short(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
    }

    public short extract_short() throws BAD_OPERATION {
        this.checkExtract(2, "Cannot extract short");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_short();
        }
        return (Short)this.value;
    }

    public void insert_ushort(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ushort);
    }

    public short extract_ushort() {
        this.checkExtract(4, "Cannot extract ushort");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ushort();
        }
        return (Short)this.value;
    }

    public void insert_long(int i) {
        this.value = new Integer(i);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
    }

    public int extract_long() {
        this.checkExtract(3, "Cannot extract long");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_long();
        }
        return (Integer)this.value;
    }

    public void insert_ulong(int i) {
        this.value = new Integer(i);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulong);
    }

    public int extract_ulong() {
        this.checkExtract(5, "Cannot extract ulong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulong();
        }
        return (Integer)this.value;
    }

    public void insert_longlong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
    }

    public long extract_longlong() {
        this.checkExtract(23, "Cannot extract longlong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_longlong();
        }
        return (Long)this.value;
    }

    public void insert_ulonglong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulonglong);
    }

    public long extract_ulonglong() {
        this.checkExtract(24, "Cannot extract ulonglong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulonglong();
        }
        return (Long)this.value;
    }

    public void insert_float(float f) {
        this.value = new Float(f);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
    }

    public float extract_float() {
        this.checkExtract(6, "Cannot extract float");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_float();
        }
        return ((Float)this.value).floatValue();
    }

    public void insert_double(double d) {
        this.value = new Double(d);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
    }

    public double extract_double() {
        this.checkExtract(7, "Cannot extract double");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_double();
        }
        return (Double)this.value;
    }

    public void insert_boolean(boolean b) {
        this.value = b ? Boolean.TRUE : Boolean.FALSE;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
    }

    public boolean extract_boolean() {
        this.checkExtract(8, "Cannot extract boolean");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_boolean();
        }
        return (Boolean)this.value;
    }

    public void insert_char(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_char);
    }

    public char extract_char() {
        this.checkExtract(9, "Cannot extract char");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_char();
        }
        return ((Character)this.value).charValue();
    }

    public void insert_wchar(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
    }

    public char extract_wchar() {
        this.checkExtract(26, "Cannot extract wchar");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_wchar();
        }
        return ((Character)this.value).charValue();
    }

    public void insert_octet(byte b) {
        this.value = new Byte(b);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
    }

    public byte extract_octet() {
        this.checkExtract(10, "Cannot extract octet");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_octet();
        }
        return (Byte)this.value;
    }

    public void insert_any(org.omg.CORBA.Any a) {
        this.value = a;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_any);
    }

    public org.omg.CORBA.Any extract_any() {
        this.checkExtract(11, "Cannot extract any");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_any();
        }
        return (org.omg.CORBA.Any)this.value;
    }

    public void insert_TypeCode(org.omg.CORBA.TypeCode tc) {
        this.value = tc;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_TypeCode);
    }

    public org.omg.CORBA.TypeCode extract_TypeCode() {
        this.checkExtract(12, "Cannot extract TypeCode");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_TypeCode();
        }
        return (org.omg.CORBA.TypeCode)this.value;
    }

    public void insert_string(String s) {
        this.value = s;
        this.typeCode = this.orb.create_string_tc(0);
    }

    public String extract_string() {
        this.checkExtract(18, "Cannot extract string");
        return this.value.toString();
    }

    public void insert_wstring(String s) {
        this.value = s;
        this.typeCode = this.orb.create_wstring_tc(0);
    }

    public String extract_wstring() {
        this.checkExtract(27, "Cannot extract wstring");
        return this.value.toString();
    }

    public void insert_fixed(BigDecimal _value) {
        this.value = _value;
        this.typeCode = new FixedHolder(_value)._type();
    }

    public void insert_fixed(BigDecimal _value, org.omg.CORBA.TypeCode type) {
        try {
            String val = _value.toString();
            int extra = _value.scale() - type.fixed_scale();
            if (extra > 0) {
                val = val.substring(0, val.length() - extra);
            } else if (extra < 0) {
                StringBuffer sb = new StringBuffer(val);
                if (val.indexOf(46) == -1) {
                    sb.append(".");
                }
                for (int i = extra; i < 0; ++i) {
                    sb.append("0");
                }
                val = sb.toString();
            }
            _value = new BigDecimal(val);
            FixedHolder holder = new FixedHolder(_value);
            org.omg.CORBA.TypeCode tc = holder._type();
            if (tc.fixed_digits() > type.fixed_digits()) {
                throw new BAD_TYPECODE();
            }
        }
        catch (BadKind bk) {
            throw new BAD_TYPECODE();
        }
        this.value = _value;
        this.typeCode = type;
    }

    public BigDecimal extract_fixed() {
        this.checkExtract(28, "Cannot extract fixed");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_fixed();
        }
        return (BigDecimal)this.value;
    }

    public void insert_Object(Object o) {
        this.value = o;
        String typeId = null;
        String name = "";
        if (this.value == null) {
            typeId = "IDL:omg.org/CORBA/Object:1.0";
            name = "Object";
        } else {
            typeId = ((ObjectImpl)o)._ids()[0];
            if (typeId.startsWith("IDL:")) {
                name = typeId.substring(4, typeId.lastIndexOf(58));
                name = name.substring(name.lastIndexOf(47) + 1);
            } else if (typeId.startsWith("RMI:")) {
                name = typeId.substring(4, typeId.lastIndexOf(58));
                name = name.substring(name.lastIndexOf(46) + 1);
            } else {
                throw new BAD_PARAM("Unknown repository id format");
            }
        }
        this.typeCode = this.orb.create_interface_tc(typeId, name);
    }

    public void insert_Object(Object o, org.omg.CORBA.TypeCode type) {
        if (type.kind().value() != 14) {
            this.tc_error("Illegal, non-object TypeCode!");
        }
        this.value = o;
        this.typeCode = type;
    }

    public Object extract_Object() {
        this.checkExtract(14, "Cannot extract object");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_Object();
        }
        return (Object)this.value;
    }

    public java.lang.Object extract_objref() {
        this.checkExtract(14, "Cannot extract object");
        return this.value;
    }

    public void insert_Principal(Principal p) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public Principal extract_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public void insert_Streamable(Streamable s) {
        this.value = s;
        this.typeCode = s._type();
    }

    public Streamable extract_Streamable() throws BAD_INV_ORDER {
        try {
            return (Streamable)this.value;
        }
        catch (ClassCastException cce) {
            throw new BAD_INV_ORDER();
        }
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        int kind = this.typeCode.kind().value();
        if (kind != 29 && kind != 30 && kind != 32 && kind != 0) {
            this.tc_error("Cannot extract value!");
        }
        return (Serializable)this.value;
    }

    public void insert_Value(Serializable value) {
        if (value != null) {
            this.value = value;
            this.typeCode = TypeCode.create_tc(value.getClass());
        } else {
            this.value = null;
            this.typeCode = new TypeCode(0);
        }
    }

    public void insert_Value(Serializable value, org.omg.CORBA.TypeCode type) throws MARSHAL {
        this.value = value;
        this.typeCode = type;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        return (CDROutputStream)this.value;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.value instanceof CDROutputStream) {
            return new CDRInputStream(this.orb, ((CDROutputStream)this.value).getBufferCopy());
        }
        CDROutputStream out = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        this.write_value(out);
        return new CDRInputStream(this.orb, out.getBufferCopy());
    }

    public void read_value(org.omg.CORBA.portable.InputStream input, org.omg.CORBA.TypeCode type) throws MARSHAL {
        if (type == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        this.typeCode = type;
        int kind = type.kind().value();
        switch (kind) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.insert_short(input.read_short());
                break;
            }
            case 3: {
                this.insert_long(input.read_long());
                break;
            }
            case 23: {
                this.insert_longlong(input.read_longlong());
                break;
            }
            case 4: {
                this.insert_ushort(input.read_ushort());
                break;
            }
            case 5: {
                this.insert_ulong(input.read_ulong());
                break;
            }
            case 24: {
                this.insert_ulonglong(input.read_ulonglong());
                break;
            }
            case 6: {
                this.insert_float(input.read_float());
                break;
            }
            case 7: {
                this.insert_double(input.read_double());
                break;
            }
            case 28: {
                try {
                    BigDecimal fixed = input.read_fixed();
                    short scale = type.fixed_scale();
                    this.insert_fixed(fixed.movePointLeft(scale), type);
                }
                catch (BadKind bk) {}
                break;
            }
            case 8: {
                this.insert_boolean(input.read_boolean());
                break;
            }
            case 9: {
                this.insert_char(input.read_char());
                break;
            }
            case 26: {
                this.insert_wchar(input.read_wchar());
                break;
            }
            case 10: {
                this.insert_octet(input.read_octet());
                break;
            }
            case 11: {
                this.insert_any(input.read_any());
                break;
            }
            case 12: {
                this.insert_TypeCode(input.read_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                this.insert_Object(input.read_Object());
                break;
            }
            case 18: {
                this.insert_string(input.read_string());
                break;
            }
            case 27: {
                this.insert_wstring(input.read_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
                ((CDROutputStream)this.value).write_value(type, input);
                break;
            }
            case 29: 
            case 30: {
                this.insert_Value(((InputStream)input).read_value(), type);
                break;
            }
            case 32: {
                java.lang.Object obj = ((InputStream)input).read_abstract_interface();
                if (obj instanceof Object) {
                    this.insert_Object((Object)obj);
                    break;
                }
                this.insert_Value((Serializable)obj);
                break;
            }
            default: {
                throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
            }
        }
    }

    public void write_value(org.omg.CORBA.portable.OutputStream output) {
        int kind = this.typeCode.kind().value();
        switch (kind) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                output.write_short(this.extract_short());
                break;
            }
            case 3: {
                output.write_long(this.extract_long());
                break;
            }
            case 23: {
                output.write_longlong(this.extract_longlong());
                break;
            }
            case 4: {
                output.write_ushort(this.extract_ushort());
                break;
            }
            case 5: {
                output.write_ulong(this.extract_ulong());
                break;
            }
            case 24: {
                output.write_ulonglong(this.extract_ulonglong());
                break;
            }
            case 6: {
                output.write_float(this.extract_float());
                break;
            }
            case 7: {
                output.write_double(this.extract_double());
                break;
            }
            case 28: {
                output.write_fixed(this.extract_fixed());
                break;
            }
            case 8: {
                output.write_boolean(this.extract_boolean());
                break;
            }
            case 9: {
                output.write_char(this.extract_char());
                break;
            }
            case 26: {
                output.write_wchar(this.extract_wchar());
                break;
            }
            case 10: {
                output.write_octet(this.extract_octet());
                break;
            }
            case 11: {
                output.write_any(this.extract_any());
                break;
            }
            case 12: {
                output.write_TypeCode(this.extract_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                output.write_Object(this.extract_Object());
                break;
            }
            case 18: {
                output.write_string(this.extract_string());
                break;
            }
            case 27: {
                output.write_wstring(this.extract_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (this.value instanceof Streamable) {
                    Streamable s = (Streamable)this.value;
                    s._write(output);
                    break;
                }
                if (!(this.value instanceof org.omg.CORBA.portable.OutputStream)) break;
                org.omg.CORBA.ORB toUse = this.orb;
                if (!(toUse instanceof ORB)) {
                    this.checkStreamClass(output);
                    toUse = ((CDROutputStream)output).orb();
                }
                this.checkStreamClass((org.omg.CORBA.portable.OutputStream)this.value);
                CDROutputStream os = (CDROutputStream)this.value;
                CDRInputStream in = new CDRInputStream(toUse, os.getBufferCopy());
                in.read_value(this.typeCode, output);
                break;
            }
            case 29: 
            case 30: {
                ((OutputStream)output).write_value((Serializable)this.value);
                break;
            }
            case 32: {
                ((OutputStream)output).write_abstract_interface(this.value);
                break;
            }
            default: {
                throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
            }
        }
    }

    public void insert_void() {
        this.value = null;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_void);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, java.lang.Object value) {
        this.insert_object(typeCode, null, value);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.ORB orb, java.lang.Object value) {
        this.typeCode = typeCode;
        if (orb != null) {
            this.orb = orb;
        }
        this.value = value;
    }

    private void checkStreamClass(org.omg.CORBA.portable.OutputStream stream) {
        if (!(stream instanceof CDROutputStream)) {
            if (Debug.isDebugEnabled()) {
                Debug.output("Output class not CDROutputStream " + stream.getClass().getName());
            }
            throw new INTERNAL("Output class not CDROutputStream " + stream.getClass().getName());
        }
    }
}

