/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.ServerRequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.ETF.Connection;
import org.omg.ETF.Factories;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._HandleLocalBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter
extends _HandleLocalBase {
    private final Logger logger;
    private final List listeners = new ArrayList();
    private final MessageReceptorPool receptor_pool;
    private final RequestListener request_listener;
    private final ReplyListener reply_listener;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;

    public BasicAdapter(ORB orb, POA rootPOA, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) throws INITIALIZE {
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
        this.logger = Debug.getNamedLogger("jacorb.orb.basic");
        int maxIdleThreads = Environment.getIntPropertyWithDefault("jacorb.connection.server.max_idle_receptor_threads", 5);
        int maxThreads = Environment.getIntPropertyWithDefault("jacorb.connection.server.max_receptor_threads", 1000);
        this.receptor_pool = new MessageReceptorPool("ServerMessageReceptor", maxThreads, maxIdleThreads);
        this.request_listener = new ServerRequestListener(orb, rootPOA);
        this.reply_listener = new NoBiDirServerReplyListener();
        Iterator i = this.getListenerFactories().iterator();
        while (i.hasNext()) {
            Factories f = (Factories)i.next();
            Listener l = f.create_listener(null, 0, (short)0);
            l.set_handle(this);
            this.listeners.add(l);
        }
        i = this.listeners.iterator();
        while (i.hasNext()) {
            ((Listener)i.next()).listen();
        }
    }

    public void renewSSLServerSockets() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof IIOPListener)) continue;
            ((IIOPListener)o).renewSSLServerSocket();
        }
    }

    private List getListenerFactories() {
        ArrayList<Factories> result = new ArrayList<Factories>();
        List tags = Environment.getListProperty("jacorb.transport.server.listeners");
        if (tags.isEmpty()) {
            result.addAll(this.transport_manager.getFactoriesList());
        } else {
            Iterator i = tags.iterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                int tag = -1;
                try {
                    tag = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("could not parse profile tag for listener: " + s + " (should have been a number)");
                }
                Factories f = this.transport_manager.getFactories(tag);
                if (f == null) {
                    throw new RuntimeException("could not find Factories for profile tag: " + tag);
                }
                result.add(f);
            }
        }
        return result;
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public List getEndpointProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            Listener l = (Listener)i.next();
            result.add(l.endpoint());
        }
        return result;
    }

    private IIOPListener getIIOPListener() {
        if (this.listeners.size() == 1) {
            Listener l = (Listener)this.listeners.get(0);
            if (l instanceof IIOPListener) {
                return (IIOPListener)l;
            }
            return null;
        }
        return null;
    }

    public int getPort() {
        IIOPListener l = this.getIIOPListener();
        if (l != null) {
            IIOPProfile profile = (IIOPProfile)l.endpoint();
            return profile.getAddress().getPort();
        }
        throw new RuntimeException("Cannot find server port for non-IIOP transport");
    }

    public int getSSLPort() {
        IIOPListener l = this.getIIOPListener();
        if (l != null) {
            IIOPProfile profile = (IIOPProfile)l.endpoint();
            return profile.getSSLPort();
        }
        throw new RuntimeException("Non-IIOP transport does not have an SSL port");
    }

    public boolean hasSSLListener() {
        return this.getSSLPort() != -1;
    }

    public String getAddress() {
        IIOPListener l = this.getIIOPListener();
        if (l != null) {
            IIOPProfile profile = (IIOPProfile)l.endpoint();
            return Environment.getDnsEnable() ? profile.getAddress().getHostname() : profile.getAddress().getIP();
        }
        throw new RuntimeException("Cannot find server address for non-IIOP transport");
    }

    public synchronized void deliverRequest(ServerRequest request, POA poa) {
        block10: {
            org.jacorb.poa.POA tmp_poa = (org.jacorb.poa.POA)poa;
            String[] scopes = request.remainingPOAName();
            try {
                for (int i = 0; i < scopes.length - 1; ++i) {
                    if (scopes[i].equals("")) {
                        request.setRemainingPOAName(null);
                        break;
                    }
                    try {
                        tmp_poa = tmp_poa._getChildPOA(scopes[i]);
                        continue;
                    }
                    catch (ParentIsHolding p) {
                        String[] rest_of_name = new String[scopes.length - i];
                        for (int j = 0; j < i; ++j) {
                            rest_of_name[j] = scopes[j + i];
                        }
                        request.setRemainingPOAName(rest_of_name);
                        break;
                    }
                }
                if (tmp_poa == null) {
                    throw new INTERNAL("Request POA null!");
                }
                tmp_poa._invoke(request);
            }
            catch (WrongAdapter wa) {
                request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                request.reply();
            }
            catch (SystemException one) {
                request.setSystemException(one);
                request.reply();
            }
            catch (Throwable th) {
                request.setSystemException(new UNKNOWN(th.toString()));
                request.reply();
                if (!this.logger.isDebugEnabled()) break block10;
                this.logger.debug("Caught exception delivering request", th);
            }
        }
    }

    public void return_result(ServerRequest request) {
        request.reply();
    }

    public void stopListeners() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((Listener)i.next()).destroy();
        }
        this.receptor_pool.shutdown();
    }

    public boolean add_input(Connection conn) {
        ServerGIOPConnection giopConnection = this.giop_connection_manager.createServerGIOPConnection(conn.get_server_profile(), conn, this.request_listener, this.reply_listener);
        this.receptor_pool.connectionCreated(giopConnection);
        return true;
    }

    public void closed_by_peer(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public void signal_data_available(Connection conn) {
        throw new NO_IMPLEMENT();
    }
}

