/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import org.jacorb.util.Environment;

public abstract class PortRangeFactory {
    protected int portMin = 0;
    protected int portMax = 0;

    public PortRangeFactory(String minProp, String maxProp) {
        this.portMin = this.getPortProperty(minProp);
        this.portMax = this.getPortProperty(maxProp);
        if (this.portMin > this.portMax) {
            throw new RuntimeException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    private int getPortProperty(String name) {
        int port;
        String val = Environment.getProperty(name);
        if (val == null || val.length() == 0) {
            throw new RuntimeException("PortRangeFactory: " + name + " property not set");
        }
        try {
            port = Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("PortRangeFactory: " + name + " invalid port number");
        }
        if (port < 0) {
            port += 65536;
        }
        if (port <= 0 || port > 65535) {
            throw new RuntimeException("PortRangeFactory: " + name + " invalid port number");
        }
        return port;
    }
}

