/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class SocketFactoryManager {
    private static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SERVER_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private static final String TCP_LISTENER = "jacorb.net.tcp_listener";
    private static final String SSL_LISTENER = "jacorb.security.ssl.ssl_listener";
    private static SocketFactory socketFactory;
    private static SocketFactory sslSocketFactory;
    private static ServerSocketFactory serverSocketFactory;
    private static SSLServerSocketFactory sslServerSocketFactory;
    private static Logger logger;
    private static TCPConnectionListener tcpListener;
    private static SSLSessionListener sslListener;
    private static ORB orb;

    public static synchronized void initialiseSocketFactories(ORB _orb) {
        String portNo;
        orb = _orb;
        String className = Environment.getProperty(FACTORY_PROP);
        socketFactory = className == null || className.length() == 0 ? ((portNo = Environment.getProperty("jacorb.net.socket_factory.port.min")) != null && portNo.length() > 0 ? new PortRangeSocketFactory() : new DefaultSocketFactory()) : SocketFactoryManager.getFactory(className);
        if (Environment.getSupportSSL()) {
            String s = Environment.getProperty("jacorb.ssl.socket_factory");
            if (s == null || s.length() == 0) {
                throw new INITIALIZE("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class ssl = Environment.classForName(s);
                Constructor constr = ssl.getConstructor(ORB.class);
                sslSocketFactory = (SocketFactory)constr.newInstance(orb);
                if (logger.isDebugEnabled()) {
                    logger.debug("Created SSLSocketFactory instance from class " + s);
                }
            }
            catch (InvocationTargetException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL socket factory invocation failure", e.getTargetException());
                }
                throw new INITIALIZE("SSL support is on, but there was an invocation failure with the ssl socket factory: " + e.getTargetException());
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL socket factory instantiation failure", e);
                }
                throw new INITIALIZE("SSL support is on, but the ssl socket factory can't be instantiated: " + e);
            }
        }
    }

    public static SocketFactory getSocketFactory() {
        if (socketFactory == null) {
            throw new INTERNAL("Socket factory is null");
        }
        return socketFactory;
    }

    public static SocketFactory getSSLSocketFactory() {
        if (sslSocketFactory == null) {
            throw new INTERNAL("SSL Socket factory is null");
        }
        return sslSocketFactory;
    }

    public static synchronized ServerSocketFactory getServerSocketFactory() {
        if (serverSocketFactory != null) {
            return serverSocketFactory;
        }
        String className = Environment.getProperty(SERVER_FACTORY_PROP);
        serverSocketFactory = className == null || className.length() == 0 ? new DefaultServerSocketFactory() : SocketFactoryManager.getServerFactory(className);
        return serverSocketFactory;
    }

    public static synchronized SSLServerSocketFactory getSSLServerSocketFactory() {
        if (sslServerSocketFactory == null && Environment.getSupportSSL()) {
            String className = Environment.getProperty("jacorb.ssl.server_socket_factory");
            if (className == null || className.length() == 0) {
                throw new INITIALIZE("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
            }
            Object factory = SocketFactoryManager.getFactoryObject(className);
            if (!(factory instanceof SSLServerSocketFactory)) {
                throw new INITIALIZE("Custom factory " + className + " does not implement SSLServerSocketFactory");
            }
            sslServerSocketFactory = (SSLServerSocketFactory)factory;
        }
        return sslServerSocketFactory;
    }

    public static TCPConnectionListener getTCPListener() {
        return tcpListener;
    }

    public static SSLSessionListener getSSLListener() {
        return sslListener;
    }

    private static SocketFactory getFactory(String className) {
        Object factory = SocketFactoryManager.getFactoryObject(className);
        if (factory instanceof SocketFactory) {
            return (SocketFactory)factory;
        }
        throw new INITIALIZE("Custom factory " + className + " does not implement SocketFactory");
    }

    private static ServerSocketFactory getServerFactory(String className) {
        Object factory = SocketFactoryManager.getFactoryObject(className);
        if (factory instanceof ServerSocketFactory) {
            return (ServerSocketFactory)factory;
        }
        throw new INITIALIZE("Custom factory " + className + " does not implement ServerSocketFactory");
    }

    private static Object getFactoryObject(String className) {
        Object factory;
        Constructor ctor = null;
        try {
            Class sfClass = Environment.classForName(className);
            if (orb != null) {
                try {
                    ctor = sfClass.getConstructor(ORB.class);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            factory = ctor != null ? ctor.newInstance(orb) : sfClass.newInstance();
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage());
            }
            throw new INITIALIZE("Failed to create custom socket factory: " + className);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SocketFactoryManager: created " + factory.getClass().getName());
        }
        return factory;
    }

    static {
        logger = Debug.getNamedLogger("jacorb.orb.factory");
        tcpListener = (TCPConnectionListener)Environment.getObjectProperty(TCP_LISTENER);
        sslListener = (SSLSessionListener)Environment.getObjectProperty(SSL_LISTENER);
    }
}

