/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jacorb.orb.giop.BTCConverter;
import org.jacorb.orb.giop.CTBConverter;
import org.jacorb.util.Debug;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF16 = 65801;
    public static final int UTF8 = 0x5010001;
    private static int TCS = -1;
    private static Map ctb;
    private static Map btc;

    public static String csName(int cs) {
        switch (cs) {
            case 65537: {
                return "ISO8859_1";
            }
            case 65801: {
                return "UTF16";
            }
            case 0x5010001: {
                return "UTF8";
            }
        }
        return "Unknown TCS: " + Integer.toHexString(cs);
    }

    public static int getTCSDefault() {
        if (TCS == -1) {
            OutputStreamWriter defaultStream = new OutputStreamWriter(new ByteArrayOutputStream());
            String sysenc = defaultStream.getEncoding();
            try {
                defaultStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (sysenc.equals("ISO8859_1")) {
                TCS = 65537;
            } else if (sysenc.equals("UTF8")) {
                TCS = 0x5010001;
            } else {
                Debug.output(2, "Warning - unknown codeset (" + sysenc + ") - defaulting to ISO-8859-1");
                TCS = 65537;
            }
            if (Debug.isDebugEnabled()) {
                Debug.output(3, "TCS set to " + CodeSet.csName(TCS));
            }
        }
        return TCS;
    }

    public static int getTCSWDefault() {
        return 65801;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getTCSDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    public static int selectTCSW(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getTCSWDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    private static int selectCodeSet(CodeSetComponent cs_component, int native_cs) {
        if (cs_component.native_code_set == native_cs) {
            return native_cs;
        }
        for (int i = 0; i < cs_component.conversion_code_sets.length; ++i) {
            if (cs_component.conversion_code_sets[i] != native_cs) continue;
            return native_cs;
        }
        return -1;
    }

    public static CTBConverter getCTBConverter(int encoding) {
        CTBConverter result = null;
        if (ctb == null) {
            ctb = new HashMap(2, 0.5f);
        } else {
            result = (CTBConverter)ctb.get(CodeSet.csName(encoding));
        }
        if (result == null) {
            result = new CTBConverter(CodeSet.csName(encoding));
            ctb.put(CodeSet.csName(encoding), result);
        }
        return result;
    }

    public static BTCConverter getBTCConverter(int encoding) {
        BTCConverter result = null;
        if (btc == null) {
            btc = new HashMap(2, 0.5f);
        } else {
            result = (BTCConverter)btc.get(CodeSet.csName(encoding));
        }
        if (result == null) {
            result = new BTCConverter(CodeSet.csName(encoding));
            btc.put(CodeSet.csName(encoding), result);
        }
        return result;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0 && (args[0].equals("-h") || !args[0].equals("-a"))) {
            System.out.println("Usage: org.jacorb.orb.connection.CodeSet [-a]");
            System.exit(1);
        }
        Properties props = System.getProperties();
        String osName = (String)props.get("os.name");
        System.out.println("Operating system name: " + osName);
        System.out.println("Operating system version: " + props.get("os.version"));
        System.out.println("Operating system architecture: " + props.get("os.arch"));
        System.out.println("User region: " + System.getProperty("user.region"));
        System.out.println("JVM: " + props.get("java.vm.version"));
        System.out.println("JacORB: 2.1.3.1, 27-May-2005");
        System.out.println("System file encoding property: " + System.getProperty("file.encoding"));
        String defaultIOEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Cannonical encoding: " + defaultIOEncoding);
        if (osName.toLowerCase().indexOf("windows") == -1 && args != null && args.length == 1 && args[0].equals("-a")) {
            String line;
            BufferedReader buffer;
            Process locale;
            System.out.println("Locale is:");
            try {
                locale = Runtime.getRuntime().exec("locale");
                buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                while ((line = buffer.readLine()) != null) {
                    System.out.println("    " + line);
                }
                buffer.close();
            }
            catch (IOException e) {
                System.err.println("Caught exception " + e);
            }
            System.out.println("All available locales are:");
            try {
                locale = Runtime.getRuntime().exec("locale -a");
                buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                while ((line = buffer.readLine()) != null) {
                    System.out.println("        " + line);
                }
                buffer.close();
            }
            catch (IOException e) {
                System.err.println("Caught exception " + e);
            }
        }
    }
}

