/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.diop.DIOPFactories;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.util.Environment;
import org.omg.ETF.Factories;

public class TransportManager {
    private ProfileSelector profileSelector = null;
    private Map factoriesMap = null;
    private List factoriesList = null;

    public TransportManager(ORB orb) {
        SocketFactoryManager.initialiseSocketFactories(orb);
    }

    public ProfileSelector getProfileSelector() {
        if (this.profileSelector == null) {
            this.profileSelector = (ProfileSelector)Environment.getObjectProperty("jacorb.transport.client.selector");
            if (this.profileSelector == null) {
                this.profileSelector = new DefaultProfileSelector();
            }
        }
        return this.profileSelector;
    }

    public void setProfileSelector(ProfileSelector selector) {
        this.profileSelector = selector;
    }

    public Factories getFactories(int tag) {
        if (tag == 1413566212) {
            return DIOPFactories.getDIOPFactory();
        }
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(new Integer(tag));
    }

    public List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        List classNames = Environment.getListProperty("jacorb.transport.factories");
        if (classNames.isEmpty()) {
            classNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Factories f = this.instantiateFactories(className);
            this.factoriesMap.put(new Integer(f.profile_tag()), f);
            this.factoriesList.add(f);
        }
    }

    private Factories instantiateFactories(String className) {
        try {
            Class c = Environment.classForName(className);
            return (Factories)c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate Factories class " + className + ", exception: " + e);
        }
    }
}

