/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.LoggerFactory;
import org.omg.CORBA.INITIALIZE;

public class Environment {
    private static Properties configurationProperties;
    private static Map untrimmedPrefixProps;
    private static Map trimmedPrefixProps;
    private static final String propertiesFile1 = ".jacorb_properties";
    private static final String propertiesFile2 = "jacorb.properties";
    private static final String jacorbPrefix = "jacorb.";
    private static final String poaPrefix = "jacorb.poa.";
    private static final String imrPrefix = "jacorb.imr.";
    private static LoggerFactory loggerFactory;
    private static Logger logger;
    private static final String loggerFactoryClzName = "org.jacorb.util.LogKitLoggerFactory";
    private static Class identityHashMapClass;
    private static int _client_pending_reply_timeout;
    private static int _clientIdleTimeout;
    private static int _retries;
    private static long _retry_interval;
    private static int maxManagedBufSize;
    private static int compactTypecodes;
    private static boolean cacheTypecodes;
    private static boolean laxBooleanEncoding;
    private static boolean _disableClientOrbPolicies;
    private static boolean _cometInteropFix;
    private static boolean _codeSet;
    private static boolean _ignoreComponentInfo;
    private static boolean _multibyteCharArray;
    private static boolean _locate_on_bind;
    private static boolean _use_imr;
    private static boolean _use_imr_endpoint;
    private static boolean _is_imr;
    private static boolean _cache_references;
    private static String _logFileName;
    private static long _max_log_size;
    private static boolean append;
    private static long _current_log_size;
    private static boolean _useIndirection;
    private static int _aliveness_policy;
    private static int _active_server_timeout;
    private static boolean _monitoring_on;
    private static int _thread_pool_max;
    private static int _thread_pool_min;
    private static boolean _thread_pool_shared;
    private static int _queue_max;
    private static int _queue_min;
    private static boolean _queue_wait;
    private static boolean _use_appligator_for_applets;
    private static boolean _use_appligator_for_applications;
    public static URL URL;
    private static byte[] _impl_name;
    private static byte[] _server_id;
    private static String _impl_name_str;
    private static String _server_id_str;
    private static boolean _strict_check_on_tc_creation;
    private static boolean _retry_on_failure;
    private static Vector orb_initializers;
    private static boolean _dnsEnable;
    private static boolean _supportSSL;
    private static boolean _clientKeepAlive;

    public static void init() {
        try {
            _server_id = null;
            _server_id_str = null;
            orb_initializers = null;
            configurationProperties = new Properties();
            String home = System.getProperty("user.home");
            String sep = System.getProperty("file.separator");
            String lib = System.getProperty("java.home");
            try {
                Environment.loadProperties(lib + sep + "lib" + sep + propertiesFile1);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Environment.loadProperties(lib + sep + "lib" + sep + propertiesFile2);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Environment.loadProperties(home + sep + propertiesFile1);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Environment.loadProperties(home + sep + propertiesFile2);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                URL url = null;
                url = ClassLoader.getSystemResource(propertiesFile1);
                if (url == null) {
                    url = ClassLoader.getSystemResource(propertiesFile2);
                }
                if (url != null) {
                    configurationProperties.load(url.openStream());
                    System.out.println("[configuration loaded from classpath resource " + url + "]");
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            String customPropertyFileNames = System.getProperty("custom.props");
            if (customPropertyFileNames != null) {
                try {
                    StringTokenizer strtok = new StringTokenizer(customPropertyFileNames, ",");
                    while (strtok.hasMoreTokens()) {
                        String fileName = strtok.nextToken();
                        Environment.loadProperties(fileName);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            configurationProperties.putAll((Map<?, ?>)System.getProperties());
            Environment.readValues();
        }
        catch (SecurityException secex) {
            System.out.println("Could not read local jacorb properties.");
        }
    }

    private static void loadProperties(String fileName) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(fileName));
        configurationProperties.load(bin);
        bin.close();
        System.out.println("[configuration loaded from " + fileName + "]");
    }

    public static void addProperties(Properties otherProperties) {
        orb_initializers = null;
        if (configurationProperties == null) {
            configurationProperties = new Properties();
        }
        if (otherProperties != null) {
            configurationProperties.putAll((Map<?, ?>)otherProperties);
            Environment.readValues();
        }
        Environment.initLogging();
    }

    private static void readValues() {
        _retries = Environment.getIntPropertyWithDefault("jacorb.retries", 5);
        _retry_interval = Environment.getIntPropertyWithDefault("jacorb.retry_interval", 500);
        _client_pending_reply_timeout = Environment.getIntPropertyWithDefault("jacorb.connection.client.pending_reply_timeout", 0);
        _clientIdleTimeout = Environment.getIntPropertyWithDefault("jacorb.connection.client.idle_timeout", 0);
        maxManagedBufSize = Environment.getIntPropertyWithDefault("jacorb.maxManagedBufSize", 18);
        compactTypecodes = Environment.getIntPropertyWithDefault("jacorb.compactTypecodes", 0);
        cacheTypecodes = Environment.isPropertyOn("jacorb.cacheTypecodes");
        laxBooleanEncoding = Environment.isPropertyOn("jacorb.interop.lax_boolean_encoding");
        _codeSet = Environment.isPropertyOn("jacorb.codeSet");
        _ignoreComponentInfo = Environment.isPropertyOn("jacorb.ignoreComponentInfoProfiles");
        _cometInteropFix = Environment.isPropertyOn("jacorb.interop.comet");
        _disableClientOrbPolicies = Environment.isPropertyOn("jacorb.disableClientOrbPolicies");
        _multibyteCharArray = Environment.isPropertyOn("jacorb.multibyteCharArray");
        _locate_on_bind = Environment.isPropertyOn("jacorb.locate_on_bind");
        _cache_references = Environment.isPropertyOn("jacorb.reference_caching");
        _monitoring_on = Environment.isPropertyOn("jacorb.poa.monitoring");
        _use_imr = Environment.hasProperty("ORBUseImR") ? Environment.isPropertyOn("ORBUseImR") : Environment.isPropertyOn("jacorb.use_imr");
        _use_imr_endpoint = Environment.isPropertyOn("jacorb.use_imr", "on");
        _aliveness_policy = Environment.getIntPropertyWithDefault("jacorb.imr.aliveness_policy", 3);
        _active_server_timeout = Environment.getIntPropertyWithDefault("jacorb.imr.active_server_timeout", 0);
        _thread_pool_max = Environment.getIntPropertyWithDefault("jacorb.poa.thread_pool_max", 20);
        _thread_pool_min = Environment.getIntPropertyWithDefault("jacorb.poa.thread_pool_min", 5);
        _thread_pool_shared = Environment.isPropertyOn("jacorb.poa.thread_pool_shared");
        _queue_max = Environment.getIntPropertyWithDefault("jacorb.poa.queue_max", 100);
        _queue_min = Environment.getIntPropertyWithDefault("jacorb.poa.queue_min", 10);
        _queue_wait = Environment.isPropertyOn("jacorb.poa.queue_wait");
        _use_appligator_for_applets = Environment.isPropertyOn("jacorb.use_appligator_for_applets");
        _use_appligator_for_applications = Environment.isPropertyOn("jacorb.use_appligator_for_applications");
        _impl_name = configurationProperties.containsKey("jacorb.implname") && configurationProperties.getProperty("jacorb.implname").length() > 0 ? configurationProperties.getProperty("jacorb.implname").getBytes() : (byte[])null;
        _impl_name_str = configurationProperties.containsKey("jacorb.implname") ? configurationProperties.getProperty("jacorb.implname") : "";
        _strict_check_on_tc_creation = Environment.isPropertyOn("jacorb.interop.strict_check_on_tc_creation", "on");
        _retry_on_failure = Environment.isPropertyOn("jacorb.connection.client.retry_on_failure");
        _useIndirection = !Environment.isPropertyOn("jacorb.interop.indirection_encoding_disable");
        _dnsEnable = Environment.isPropertyOn("jacorb.dns.enable");
        _supportSSL = Environment.isPropertyOn("jacorb.security.support_ssl");
        _clientKeepAlive = Environment.isPropertyOn("jacorb.connection.client.keepalive");
    }

    private static void initLogging() {
        String prevLog = null;
        if (_logFileName != null) {
            prevLog = _logFileName;
        }
        if (configurationProperties.getProperty("logfile") != null) {
            _logFileName = configurationProperties.getProperty("logfile");
        } else if (configurationProperties.getProperty("jacorb.logfile") != null) {
            _logFileName = configurationProperties.getProperty("jacorb.logfile");
        }
        String size = configurationProperties.getProperty("jacorb.logfile.maxLogSize");
        if (size != null) {
            _max_log_size = Integer.parseInt(size);
        }
        if (_logFileName != null && !_logFileName.equals("") && _logFileName.endsWith("$implname")) {
            _logFileName = _logFileName.substring(0, _logFileName.length() - 9);
            String conf1 = configurationProperties.getProperty("implname");
            String conf2 = configurationProperties.getProperty("jacorb.implname");
            if (conf1 != null && conf1.length() > 0) {
                _logFileName = _logFileName + configurationProperties.getProperty("implname");
            } else if (conf2 != null && conf2.length() > 0) {
                _logFileName = _logFileName + configurationProperties.getProperty("jacorb.implname");
            } else {
                _logFileName = _logFileName + new String(Environment.serverId());
                _logFileName = _logFileName + ".log";
            }
        }
        if (logger != null) {
            Environment.setProperty("jacorb.logfile.append", "on");
        }
        if (prevLog != null && !prevLog.equals(_logFileName)) {
            try {
                File prevFile = new File(prevLog);
                if (prevFile.exists()) {
                    FileOutputStream fos = new FileOutputStream(prevLog, true);
                    byte[] bytes = ("Changing log file to " + _logFileName).getBytes();
                    fos.write(bytes);
                    fos.flush();
                    fos.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Change from " + prevLog + " to " + _logFileName);
            }
        }
        String clzName = Environment.getProperty("jacorb.log.loggerFactory");
        Class loggerFactoryClz = null;
        try {
            loggerFactoryClz = clzName != null ? Environment.classForName(clzName) : Environment.classForName(loggerFactoryClzName);
            loggerFactory = (LoggerFactory)loggerFactoryClz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (loggerFactory == null) {
            System.err.println("Configuration Error, could not create logger!");
        }
        if (_logFileName != null && _logFileName.length() > 0) {
            try {
                loggerFactory.setDefaultLogFile(_logFileName, _max_log_size);
                logger = loggerFactory.getNamedLogger("jacorb", _logFileName, _max_log_size);
            }
            catch (IOException e) {
                logger = loggerFactory.getNamedRootLogger("jacorb");
                if (logger.isErrorEnabled()) {
                    logger.error("Could not create logger with file target: " + _logFileName + ", falling back to console log!");
                }
            }
        } else {
            logger = loggerFactory.getNamedRootLogger("jacorb");
            if (logger.isDebugEnabled()) {
                logger.debug("No file target specified for logger - falling back to console log!");
            }
        }
    }

    public static final boolean getStrictCheckOnTypecodeCreation() {
        return _strict_check_on_tc_creation;
    }

    public static final boolean isMonitoringOn() {
        return _monitoring_on;
    }

    public static final Logger getLogger() {
        if (logger == null) {
            Environment.initLogging();
        }
        return logger;
    }

    public static final long maxLogSize() {
        return _max_log_size;
    }

    public static final long currentLogSize() {
        return _current_log_size;
    }

    public static final int clientPendingReplyTimeout() {
        return _client_pending_reply_timeout;
    }

    public static final int getClientIdleTimeout() {
        return _clientIdleTimeout;
    }

    public static final int noOfRetries() {
        return _retries;
    }

    public static final boolean locateOnBind() {
        return _locate_on_bind;
    }

    public static final boolean cacheReferences() {
        return _cache_references;
    }

    public static final boolean queueWait() {
        return _queue_wait;
    }

    public static final int queueMin() {
        return _queue_min;
    }

    public static final int queueMax() {
        return _queue_max;
    }

    public static final long retryInterval() {
        return _retry_interval;
    }

    public static final boolean useImR() {
        return _use_imr;
    }

    public static final void useImR(boolean use) {
        _use_imr = use;
    }

    public static final boolean isImR() {
        return _is_imr;
    }

    public static final void isImR(boolean is) {
        _is_imr = is;
        if (_use_imr && is) {
            _use_imr = false;
        }
    }

    public static final boolean useImREndpoint() {
        return _use_imr_endpoint;
    }

    public static final int threadPoolMax() {
        return Math.max(1, Math.max(_thread_pool_max, _thread_pool_min));
    }

    public static final int threadPoolMin() {
        return Math.max(1, _thread_pool_min);
    }

    public static final boolean threadPoolShared() {
        return _thread_pool_shared;
    }

    public static final byte[] implName() {
        return _impl_name;
    }

    public static final String implNameStr() {
        return _impl_name_str;
    }

    public static boolean disableClientOrbPolicies() {
        return _disableClientOrbPolicies;
    }

    public static final boolean useAppligator(boolean amIanApplet) {
        if (amIanApplet) {
            return _use_appligator_for_applets;
        }
        return _use_appligator_for_applications;
    }

    public static int getMaxManagedBufSize() {
        return maxManagedBufSize;
    }

    public static int getCompactTypecodes() {
        return compactTypecodes;
    }

    public static boolean getCacheTypecodes() {
        return cacheTypecodes;
    }

    public static boolean getLaxBooleanEncoding() {
        return laxBooleanEncoding;
    }

    public static boolean getUseIndirection() {
        return _useIndirection;
    }

    public static boolean getCometInteropFix() {
        return _cometInteropFix;
    }

    public static boolean getCodeSetsActive() {
        if (_ignoreComponentInfo && _codeSet) {
            if (Environment.getLogger().isDebugEnabled()) {
                Environment.getLogger().debug("Codesets enabled but ignoreComponentInfo is enabled which overrides.");
            }
            return false;
        }
        return _codeSet;
    }

    public static boolean getIgnoreComponentInfo() {
        return _ignoreComponentInfo;
    }

    public static boolean getMultibyteCharArray() {
        return _multibyteCharArray;
    }

    public static int getAlivenessPolicy() {
        return _aliveness_policy;
    }

    public static int getActiveServerTimeout() {
        return _active_server_timeout;
    }

    public static String imrProxyHost() {
        return configurationProperties.getProperty("jacorb.imr.ior_proxy_host");
    }

    public static int imrProxyPort() {
        return Environment.getIntPropertyWithDefault("jacorb.imr.ior_proxy_port", -1);
    }

    public static String iorProxyHost() {
        return configurationProperties.getProperty("jacorb.ior_proxy_host");
    }

    public static int iorProxyPort() {
        return Environment.getIntPropertyWithDefault("jacorb.ior_proxy_port", -1);
    }

    public static int giopMinorVersion() {
        return Environment.getIntPropertyWithDefault("jacorb.giop_minor_version", 2);
    }

    public static boolean giopAdd_1_0_Profiles() {
        return Environment.isPropertyOn("jacorb.giop.add_1_0_profiles");
    }

    public static final boolean retryOnFailure() {
        return _retry_on_failure;
    }

    public static boolean getDnsEnable() {
        return _dnsEnable;
    }

    public static boolean getSupportSSL() {
        return _supportSSL;
    }

    public static boolean getClientKeepAlive() {
        return _clientKeepAlive;
    }

    public static String getProperty(String key) {
        return configurationProperties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return configurationProperties.getProperty(key, def);
    }

    public static boolean isPropertyOn(String key) {
        return Environment.isPropertyOn(key, "off");
    }

    public static boolean isPropertyOn(String key, String def) {
        String s = configurationProperties.getProperty(key, def);
        return "on".equals(s);
    }

    public static long getLongProperty(String key, int base, long def) {
        String s = configurationProperties.getProperty(key);
        try {
            return Long.parseLong(s, base);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public static long getLongProperty(String key, int base) {
        String s = configurationProperties.getProperty(key);
        try {
            return Long.parseLong(s, base);
        }
        catch (NumberFormatException nfe) {
            throw new INITIALIZE("Unable to create long from string >>" + s + "<<. " + "Please check property \"" + key + '\"');
        }
    }

    public static int getIntProperty(String key, int base) {
        String s = configurationProperties.getProperty(key);
        if (s != null && s.length() > 0) {
            try {
                return Integer.parseInt(s, base);
            }
            catch (NumberFormatException nfe) {
                throw new INITIALIZE("Unable to create int from string >>" + s + "<<. " + "Please check property \"" + key + '\"');
            }
        }
        return 0;
    }

    public static int getIntPropertyWithDefault(String key, int def) {
        String s = configurationProperties.getProperty(key);
        if (s != null && s.length() > 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new INITIALIZE("Unable to create int from string >>" + s + "<<. " + "Please check property \"" + key + '\"');
            }
        }
        return def;
    }

    public static Object getObjectProperty(String key) {
        String s = configurationProperties.getProperty(key);
        if (s != null && s.length() > 0) {
            try {
                Class c = Environment.classForName(s);
                return c.newInstance();
            }
            catch (Exception e) {
                throw new INITIALIZE("Unable to build class from key >" + key + "<: " + e);
            }
        }
        return null;
    }

    public static List getListProperty(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String value = configurationProperties.getProperty(key);
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().trim());
            }
        }
        return result;
    }

    public static boolean hasProperty(String key) {
        return configurationProperties.containsKey(key);
    }

    public static void setProperty(String key, String value) {
        configurationProperties.put(key, value);
    }

    public static String[] getPropertyValueList(String key) {
        String list = configurationProperties.getProperty(key);
        if (list == null) {
            return new String[0];
        }
        StringTokenizer t = new StringTokenizer(list, ",");
        Vector<String> v = new Vector<String>();
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public static final void readFromURL(URL _url) {
        URL = _url;
        System.out.println("Reading properties from url:" + URL.toString());
        try {
            configurationProperties = new Properties();
            configurationProperties.load(new BufferedInputStream(URL.openStream()));
        }
        catch (Exception e) {
            System.out.println("Could not read properties from URL, reason: " + e.toString());
        }
        Environment.readValues();
    }

    public static final String serverIdStr() {
        if (_server_id_str == null) {
            _server_id_str = String.valueOf((long)(Math.random() * 9.999999999E9));
        }
        return _server_id_str;
    }

    public static final byte[] serverId() {
        if (_server_id == null) {
            if (_server_id_str == null) {
                Environment.serverIdStr();
            }
            _server_id = _server_id_str.getBytes();
        }
        return _server_id;
    }

    public static Vector getORBInitializers() {
        if (orb_initializers == null) {
            Enumeration<?> prop_names = configurationProperties.propertyNames();
            orb_initializers = new Vector();
            String initializer_prefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
            while (prop_names.hasMoreElements()) {
                String prop = (String)prop_names.nextElement();
                if (!prop.startsWith(initializer_prefix)) continue;
                String name = configurationProperties.getProperty(prop);
                if ((name == null || name.length() == 0) && prop.length() > initializer_prefix.length()) {
                    name = prop.substring(initializer_prefix.length());
                }
                if (name == null) continue;
                try {
                    orb_initializers.addElement(Environment.classForName(name).newInstance());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Build ORBInitializer: " + name);
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Unable to build ORBInitializer from >>" + name + "<<", e);
                    }
                    if (!Environment.isPropertyOn("jacorb.orb_initializer.fail_on_error")) continue;
                    throw new INITIALIZE("Failed to build ORBInitializer class (" + name + ") for property " + prop + ": " + e);
                }
            }
        }
        return orb_initializers;
    }

    public static Hashtable getProperties(String prefix) {
        return Environment.getProperties(prefix, false);
    }

    public static Hashtable getProperties(String prefix, boolean trim) {
        if (trim && trimmedPrefixProps.containsKey(prefix)) {
            return (Hashtable)trimmedPrefixProps.get(prefix);
        }
        if (!trim && untrimmedPrefixProps.containsKey(prefix)) {
            return (Hashtable)untrimmedPrefixProps.get(prefix);
        }
        Enumeration<?> prop_names = configurationProperties.propertyNames();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        while (prop_names.hasMoreElements()) {
            String name = (String)prop_names.nextElement();
            if (!name.startsWith(prefix)) continue;
            if (trim) {
                properties.put(name.substring(prefix.length() + 1), configurationProperties.getProperty(name));
                continue;
            }
            properties.put(name, configurationProperties.getProperty(name));
        }
        if (trim) {
            trimmedPrefixProps.put(prefix, properties);
        } else {
            untrimmedPrefixProps.put(prefix, properties);
        }
        return properties;
    }

    public static Class classForName(String name) throws ClassNotFoundException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static LoggerFactory getLoggerFactory() {
        if (logger == null) {
            Environment.initLogging();
        }
        return loggerFactory;
    }

    public static Map createIdentityHashMap() {
        if (identityHashMapClass == null) {
            try {
                identityHashMapClass = Environment.classForName("java.util.IdentityHashMap");
            }
            catch (ClassNotFoundException ex) {
                try {
                    identityHashMapClass = Environment.classForName("org.jacorb.util.IdentityHashMap");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
        try {
            return (Map)identityHashMapClass.newInstance();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc.toString());
        }
    }

    static {
        untrimmedPrefixProps = new HashMap();
        trimmedPrefixProps = new HashMap();
        loggerFactory = null;
        logger = null;
        identityHashMapClass = null;
        _client_pending_reply_timeout = 0;
        _retries = 10;
        _retry_interval = 700L;
        maxManagedBufSize = 18;
        compactTypecodes = 0;
        cacheTypecodes = false;
        laxBooleanEncoding = false;
        _disableClientOrbPolicies = false;
        _cometInteropFix = false;
        _codeSet = false;
        _multibyteCharArray = false;
        _locate_on_bind = false;
        _use_imr = false;
        _use_imr_endpoint = true;
        _is_imr = false;
        _cache_references = false;
        _logFileName = null;
        _max_log_size = 0L;
        append = false;
        _current_log_size = 0L;
        _useIndirection = false;
        _monitoring_on = false;
        _thread_pool_max = 20;
        _thread_pool_min = 10;
        _thread_pool_shared = false;
        _queue_max = 100;
        _queue_min = 10;
        _queue_wait = false;
        _use_appligator_for_applets = true;
        _use_appligator_for_applications = false;
        URL = null;
        _impl_name = null;
        _server_id = null;
        _impl_name_str = null;
        _server_id_str = null;
        _retry_on_failure = false;
        orb_initializers = null;
        Environment.init();
    }
}

