/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModel;
import cerent.cms.model.ModelUpdateType;

public class ModelUpdate {
    private IModel model;
    private Integer updateType;

    public ModelUpdate(IModel iModel, Integer n) {
        this.model = iModel;
        this.updateType = n;
    }

    public IModel getModel() {
        return this.model;
    }

    public Integer getUpdateType() {
        return this.updateType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (this.updateType == null) {
            stringBuffer.append("null");
        } else {
            int n = this.updateType;
            if (n == ModelUpdateType.CHANGED) {
                stringBuffer.append("CHANGED");
            } else if (n == ModelUpdateType.DELETED) {
                stringBuffer.append("DELETED");
            } else if (n == ModelUpdateType.ADDED) {
                stringBuffer.append("ADDED");
            } else if (n == ModelUpdateType.REBOOT) {
                stringBuffer.append("REBOOT");
            } else if (n == ModelUpdateType.LOGOUT) {
                stringBuffer.append("LOGOUT");
            } else if (n == ModelUpdateType.INIT_NEEDED) {
                stringBuffer.append("INIT_NEEDED");
            } else if (n == ModelUpdateType.SYSTEM_TIME_CHANGED) {
                stringBuffer.append("SYSTEM_TIME_CHANGED");
            }
            stringBuffer.append('(');
            stringBuffer.append(this.updateType);
            stringBuffer.append(')');
        }
        stringBuffer.append(' ');
        try {
            stringBuffer.append(this.model.toString());
        }
        catch (Exception exception) {
            String string = this.model.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

