/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.KDebug;
import cerent.util.TDMTerminology;

public class PortHelper {
    private static final String RPR_EAST = "RPR East";
    private static final String RPR_WEST = "RPR West";
    private static final KDebug db = new KDebug("PortHelper");

    public static String getPortNumString(INodeModel iNodeModel, int n) {
        String string;
        block5: {
            string = "";
            if (iNodeModel == null || n == 0) {
                return string;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    if (iEntityModel instanceof IPortModel) {
                        string = PortHelper.getPortNumString((IPortModel)iEntityModel);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return string;
    }

    public static String getPortNumString(IPortModel iPortModel) {
        return PortHelper.getPortNumString(iPortModel, '-');
    }

    public static String getPortNumString(IPortModel iPortModel, char c) {
        if (Feature.provides(iPortModel.getNodeModel(), Feature.EXP_PORT_NUM)) {
            return PortHelper.getConcatenatedString(iPortModel.getPortNum(), c);
        }
        return Integer.toString(iPortModel.getPort());
    }

    public static String getConcatenatedString(int[] nArray) {
        return PortHelper.getConcatenatedString(nArray, '-');
    }

    public static String getConcatenatedString(int[] nArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getPortTypeString(IEntityModel iEntityModel) {
        return PortHelper.getPortTypeString(iEntityModel.getNodeModel(), iEntityModel.getEqType());
    }

    public static String getPortTypeString(INodeModel iNodeModel, int n) {
        String string = EqTypeHelper.eqTypeToName(iNodeModel.getTDMTerminology(), n);
        int n2 = string.indexOf("_VT_MAPPED");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf("_PORT")) > 0) {
            string = string.substring(0, n2);
        }
        if (n == 166 || n == 165 || n == 104 || n == 105) {
            n2 = string.indexOf("_");
            if (n2 > 0) {
                string = string.substring(n2 + 1, string.length());
            }
        } else if (n == 230) {
            string = "ETHER";
        } else if (n == 231) {
            string = "POS";
        }
        return string;
    }

    public static String getPortNumAndTypeString(IPortModel iPortModel, boolean bl, boolean bl2) {
        String string;
        INodeModel iNodeModel = iPortModel.getNodeModel();
        String string2 = string = PortHelper.getPortNumString(iPortModel);
        if (Feature.provides(iNodeModel, Feature.EXP_PORT_NUM) && iPortModel.isMutable()) {
            int n = iPortModel.getEqType();
            String string3 = PortHelper.getPortTypeString(iNodeModel, n);
            int[] nArray = iPortModel.getPortNum();
            string2 = !(bl2 || n != 34 && n != 68) ? PortHelper.getExpPortType(iPortModel.getModuleModel().getEqType(), nArray, string3) : (Feature.provides(iNodeModel, Feature.RPR_802_17) && n == 105 && iPortModel.inRPRMode() ? (nArray[0] == 0 ? RPR_EAST : RPR_WEST) : (bl ? (iPortModel.isPortNumUnique() ? string : string3 + "-" + string) : string + " (" + string3 + ")"));
        }
        return string2;
    }

    private static String getExpPortType(int n, int[] nArray, String string) {
        String string2 = null;
        if (n == 234) {
            if (nArray.length == 1) {
                switch ((nArray[0] - 1) / 28) {
                    case 0: {
                        string2 = "(1-28)";
                        break;
                    }
                    case 1: {
                        string2 = "(29-56)";
                        break;
                    }
                    case 2: {
                        string2 = "(57-84)";
                    }
                }
            } else {
                db.println("Unexpected port number for DS1 port on WBE-84!");
            }
        }
        return string2 != null ? string + string2 : string;
    }

    public static String getTDMPortTypeString(INodeModel iNodeModel, int n) {
        String string = null;
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        switch (n) {
            case 28: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(0);
                break;
            }
            case 29: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(1);
                break;
            }
            case 30: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(2);
                break;
            }
            case 61: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(3);
                break;
            }
            default: {
                string = PortHelper.getPortTypeString(iNodeModel, n);
            }
        }
        return string;
    }

    public static String getFormattedPortAlias(IPortModel iPortModel) {
        String string;
        block5: {
            string = null;
            try {
                String string2;
                IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                if (iInterfaceModel != null && (string2 = iInterfaceModel.getAlias()).length() > 0) {
                    string = " \"" + string2 + "\"";
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (db.on()) {
                    KDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block5;
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return string == null ? "" : string;
    }
}

