/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractLoNum;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SdhAu4LoNum
extends AbstractLoNum {
    private int vc3 = 0;
    private int tug2 = 0;
    private int vc11 = 0;
    private int vc12 = 0;
    private int grpNum = 0;

    public SdhAu4LoNum(int n, int n2, int n3, int n4) {
        super(n4);
        this.tug2 = n2;
        int n5 = 0;
        int n6 = 0;
        if (n4 == 2) {
            n5 = n3;
        } else if (n4 == 3) {
            n6 = n3;
        }
        this.init(n, n2, n5, n6);
    }

    public SdhAu4LoNum(int n, int n2, int n3, int n4, int n5) {
        super(n5);
        this.init(n, n2, n3, n4);
    }

    public void init(int n, int n2, int n3, int n4) {
        this.vc3 = n;
        this.tug2 = n2;
        this.vc11 = n3;
        this.vc12 = n4;
        this.grpNum = this.type == 1 ? (n - 1) * 7 + 1 : (n - 1) * 7 + n2;
        this.validate();
    }

    public static int GetGroupNumByType(int n, int n2) {
        return AbstractLoNum.GetGroupNum(n, SdhAu4LoNum.NumOfGroups(n2));
    }

    public static int GetNumInGroupByType(int n, int n2) {
        return AbstractLoNum.GetNumInGroup(n, SdhAu4LoNum.NumOfGroups(n2));
    }

    public int getFramingType() {
        return 1;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)object;
            if (this.vc3 != sdhAu4LoNum.vc3) {
                return this.vc3 - sdhAu4LoNum.vc3;
            }
            if (this.tug2 != sdhAu4LoNum.tug2) {
                return this.tug2 - sdhAu4LoNum.tug2;
            }
            if (this.vc12 != sdhAu4LoNum.vc12) {
                return this.vc12 - sdhAu4LoNum.vc12;
            }
            return this.vc11 - sdhAu4LoNum.vc11;
        }
        return n;
    }

    public String prettyString() {
        return "SDH AU4 Number (" + SdhAu4LoNum.GetTypeString(this.getType()) + "): vc3=" + this.vc3 + ",tug2=" + this.tug2 + ",vc11=" + this.vc11 + ",vc12=" + this.vc12;
    }

    public static boolean isValid(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 1: {
                return n > 0 && n <= 3 && n2 == 1 && n3 == 0 && n4 == 0;
            }
            case 2: {
                return n > 0 && n <= 3 && n2 > 0 && n2 <= 7 && n3 > 0 && n3 <= 4 && n4 == 0;
            }
            case 3: {
                return n > 0 && n <= 3 && n2 > 0 && n2 <= 7 && n3 == 0 && n4 > 0 && n4 <= 3;
            }
        }
        return false;
    }

    private void validate() {
        if (!SdhAu4LoNum.isValid(this.vc3, this.tug2, this.vc11, this.vc12, this.type)) {
            throw new IllegalArgumentException("This SDH-AU4 number is invalid: " + this.prettyString());
        }
    }

    public int getGroupNum() {
        return this.grpNum;
    }

    public static int _GetGroupNum(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return (n2 - 1) * 7 + 1;
            }
            case 2: 
            case 3: {
                return (n2 - 1) * 7 + n3;
            }
        }
        throw new IllegalArgumentException("Should not be here");
    }

    public int getNumInGroup() {
        return SdhAu4LoNum._GetNumInGroup(this.type, this.vc11, this.vc12);
    }

    public static int _GetNumInGroup(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return n2;
            }
            case 3: {
                return n3;
            }
        }
        throw new IllegalArgumentException("Should not be here");
    }

    public int getLoVal() {
        return SdhAu4LoNum.GetLoVal(this.getGroupNum(), this.getNumInGroup(), this.numOfGroups());
    }

    public static int NumOfGroups(int n) {
        int n2 = SdhAu4LoNum.NumOfGroups();
        return n != 1 ? n2 : n2 + 1 - 7;
    }

    public static int NumOfGroups() {
        return 21;
    }

    public static int numOfGroups(int n) {
        return SdhAu4LoNum.NumOfGroups(n);
    }

    public int numOfGroups() {
        return SdhAu4LoNum.numOfGroups(this.type);
    }

    public static int LastTug2Group(int n) {
        return n == 1 ? 1 : AbstractLoNum.LastTug2Group(n);
    }

    public int lastTug2Group() {
        return SdhAu4LoNum.LastTug2Group(this.type);
    }

    public int _getTug2OrVtGroupNum() {
        return this.tug2;
    }

    public int groupSize() {
        return SdhAu4LoNum.GroupSize(this.type);
    }

    public int _numOfGroups() {
        return 21;
    }

    public static int GroupSize(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        throw new IllegalArgumentException("illegal LO type");
    }

    public int getGroupIncrementSize() {
        return this.type == 1 ? 7 : super.getGroupIncrementSize();
    }

    public boolean isVc11Num() {
        return this.type == 2;
    }

    public boolean isVc12Num() {
        return this.type == 3;
    }

    public boolean isVc3Num() {
        return this.type == 1;
    }

    public int getVc3() {
        return this.vc3;
    }

    public int getTug2() {
        return this.tug2;
    }

    public int getVc11() {
        return this.vc11;
    }

    public int getVc12() {
        return this.vc12;
    }

    public int getVc11_12() {
        if (!this.isVc11Num() && !this.isVc12Num()) {
            throw new IllegalStateException("Can only call this method for VC11/VC12 LO");
        }
        return this.isVc11Num() ? this.getVc11() : this.getVc12();
    }

    public int getMaxVc11_12NumInTug2() {
        if (!this.isVc11Num() && !this.isVc12Num()) {
            throw new IllegalStateException("Can only call this method for VC11/VC12 LO");
        }
        return this.isVc11Num() ? 4 : 3;
    }

    public static SdhAu4LoNum buildSdhAu4LoNum(int n, int n2) {
        return SdhAu4LoNum.buildSdhAu4LoNum(SdhAu4LoNum.GetGroupNum(n, SdhAu4LoNum.numOfGroups(n2)), SdhAu4LoNum.GetNumInGroup(n, SdhAu4LoNum.numOfGroups(n2)), n2);
    }

    public static SdhAu4LoNum buildSdhAu4LoNum(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n4 = (n - 1) / 7 + 1;
        if (n3 == 2 || n3 == 3 || n3 == 1) {
            n5 = (n - 1) % 7 + 1;
        }
        if (n3 == 2) {
            n6 = n2;
        } else if (n3 == 3) {
            n7 = n2;
        }
        return new SdhAu4LoNum(n4, n5, n6 == 0 ? n7 : n6, n3);
    }

    public static SdhAu4LoNum buildSdhAu4LoNum(int n, int n2, int n3, int n4) {
        return new SdhAu4LoNum(n, n2, n3, n4);
    }

    public static List getAllLoNumsByCircuitSize(ILoNum iLoNum, int n, Comparator comparator) {
        int n2 = -1;
        switch (n) {
            case 9: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ckt size!");
            }
        }
        return SdhAu4LoNum.getAllLoNums(iLoNum, n2, comparator);
    }

    public static List getAllLoNums(ILoNum iLoNum, int n, Comparator comparator) {
        if (iLoNum != null && iLoNum.getFramingType() != 1) {
            throw new IllegalArgumentException("Invalid ILoNum constraint!");
        }
        ArrayList<SdhAu4LoNum> arrayList = new ArrayList<SdhAu4LoNum>();
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        int n2 = 3;
        int n3 = 3;
        boolean bl = false;
        block0 : switch (n) {
            case 1: {
                for (int i = 1; i <= n2; ++i) {
                    SdhAu4LoNum sdhAu4LoNum = new SdhAu4LoNum(i, 1, 0, 1);
                    if (abstractLoNum != null && comparator.compare(sdhAu4LoNum, abstractLoNum) > 0) break block0;
                    arrayList.add(new SdhAu4LoNum(i, 1, 0, 1));
                }
                break;
            }
            case 2: {
                n3 = 4;
            }
            case 3: {
                for (int i = 1; i <= n2 && !bl; ++i) {
                    for (int j = 1; j <= n3 && !bl; ++j) {
                        for (int k = 1; k <= 7 && !bl; ++k) {
                            SdhAu4LoNum sdhAu4LoNum = new SdhAu4LoNum(i, k, j, n);
                            boolean bl2 = bl = abstractLoNum != null && comparator.compare(sdhAu4LoNum, abstractLoNum) > 0;
                            if (bl) continue;
                            arrayList.add(sdhAu4LoNum);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type!");
            }
        }
        return arrayList;
    }

    public static ILoNum getFirstLoNum(int n) {
        switch (n) {
            case 1: {
                return new SdhAu4LoNum(1, 0, 0, 1);
            }
            case 2: {
                return new SdhAu4LoNum(1, 1, 1, 2);
            }
            case 3: {
                return new SdhAu4LoNum(1, 1, 1, 3);
            }
        }
        throw new IllegalArgumentException("Invalid type!");
    }

    public int getNumVc3() {
        return 3;
    }

    public boolean isFirstElementInVc3() {
        return this.getType() == 1 || this.getTug2() == 1 && this.getVc11_12() == 1;
    }

    public boolean isLastElementInVc3() {
        return this.getType() == 1 || this.getTug2() == 7 && this.getVc11_12() == this.getMaxVc11_12NumInTug2();
    }
}

