/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SemaphoreCollection {
    private static HashMap semaphoreMap;
    private static SemaphoreCollection instance;
    public static SemaphoreDumpDebug db;

    private SemaphoreCollection() {
        semaphoreMap = new HashMap();
    }

    public static SemaphoreCollection instance() {
        return instance;
    }

    private void init(Object object, int n) throws IllegalArgumentException {
        if (semaphoreMap.get(object) != null) {
            throw new IllegalArgumentException("Semaphore with id: " + object + " and initilal number of tokens equal to" + ((Semaphore)semaphoreMap.get(object)).getInitialNumOfTokens());
        }
        Semaphore semaphore = new Semaphore(object, n);
        semaphoreMap.put(object, semaphore);
    }

    public static synchronized void initialize(Object object, int n) throws IllegalArgumentException {
        SemaphoreCollection.instance().init(object, n);
    }

    public static void acquire(Object object) throws InterruptedException, IllegalArgumentException {
        try {
            ((Semaphore)semaphoreMap.get(object)).acquire();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The semaphore with id: " + object + " does not exist.");
        }
    }

    public static void release(Object object) throws IllegalArgumentException {
        try {
            ((Semaphore)semaphoreMap.get(object)).release();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The semaphore with id: " + object + " does not exist.");
        }
    }

    static {
        instance = new SemaphoreCollection();
        db = new SemaphoreDumpDebug("Semaphore");
    }

    public static class SemaphoreDumpDebug
    extends KDebug
    implements IDebugDiag {
        public SemaphoreDumpDebug(String string) {
            super(string);
        }

        public final void dump() {
            Set set = semaphoreMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                Semaphore semaphore = (Semaphore)semaphoreMap.get(iterator.next());
                this.println("\n*************************************************");
                this.println("The Semaphore Id is :" + semaphore.getSemId() + "--The initialNumOfTokens is:" + semaphore.getInitialNumOfTokens() + "--Tokens left are:" + semaphore.getTokens());
                Set set2 = semaphore.getMapOfThreadsGottenToken().keySet();
                this.print("--The list of threads gotten tokens is:");
                Object object2 = set2.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    this.print(object + ":Time: " + (Long)semaphore.getMapOfThreadsGottenToken().get(object) + "; ");
                }
                object2 = semaphore.getMapOfThreadsWaitingForToken().keySet();
                this.print("--The list of threads waiting for token is:");
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    this.print(e + ":Time: " + (Long)semaphore.getMapOfThreadsWaitingForToken().get(e) + "; ");
                }
                this.println("\n*************************************************");
            }
        }

        public final void dumpDiag() {
            this.dump();
        }
    }

    class Semaphore {
        private Object semId;
        private int initialNumOfTokens;
        private int tokensLeft;
        private HashMap mapOfThreadsWaitingForToken = new HashMap();
        private HashMap mapOfThreadsGottenToken = new HashMap();

        public Semaphore(Object object, int n) {
            this.semId = object;
            this.initialNumOfTokens = n;
            this.tokensLeft = n;
        }

        public synchronized void acquire() throws InterruptedException {
            Thread thread = Thread.currentThread();
            if (db.on()) {
                db.print("acquire() The current thread is: " + thread + "--The Semaphore Id is : " + this.semId + "--The initialNumOfTokens is : " + this.initialNumOfTokens);
            }
            while (this.tokensLeft <= 0) {
                if (!this.mapOfThreadsWaitingForToken.containsKey(thread)) {
                    this.mapOfThreadsWaitingForToken.put(thread, new Long(System.currentTimeMillis()));
                }
                this.wait();
            }
            --this.tokensLeft;
            if (db.on()) {
                db.println("--Tokens left are: " + this.tokensLeft);
            }
            this.mapOfThreadsGottenToken.put(thread, new Long(System.currentTimeMillis()));
            this.mapOfThreadsWaitingForToken.remove(thread);
        }

        public synchronized void release() {
            Thread thread = Thread.currentThread();
            if (db.on()) {
                db.print("release()  The current thread is: " + thread + "--The Semaphore Id is : " + this.semId + "--The initialNumOfTokens is : " + this.initialNumOfTokens);
            }
            if (this.tokensLeft < this.initialNumOfTokens) {
                ++this.tokensLeft;
                this.mapOfThreadsGottenToken.remove(thread);
                this.notify();
            }
            if (db.on()) {
                db.println("--Tokens left are: " + this.tokensLeft);
            }
        }

        public Object getSemId() {
            return this.semId;
        }

        public int getInitialNumOfTokens() {
            return this.initialNumOfTokens;
        }

        public int getTokens() {
            return this.tokensLeft;
        }

        public HashMap getMapOfThreadsWaitingForToken() {
            return this.mapOfThreadsWaitingForToken;
        }

        public HashMap getMapOfThreadsGottenToken() {
            return this.mapOfThreadsGottenToken;
        }
    }
}

