/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.util.SDHTDMTerminology;
import cerent.util.SONETTDMTerminology;
import java.io.Serializable;

public abstract class TDMTerminology
implements Serializable {
    static final String MissingTerm_ = "";
    public static final int STS_1 = 0;
    public static final int STM_0 = 0;
    public static final int ST_VC_3 = 0;
    public static final int STS_3C = 1;
    public static final int STM_1 = 1;
    public static final int ST_VC_4 = 1;
    public static final int VC_4 = 0;
    public static final int VC_3 = 1;
    public static final int VC_2 = 2;
    public static final int VT_6 = 2;
    public static final int VC_12 = 3;
    public static final int VT_2 = 3;
    public static final int VC_11 = 4;
    public static final int VT_15 = 4;
    public static final int VT_GROUP = 0;
    public static final int VC_GROUP = 0;
    public static final int TUG_3 = 0;
    public static final int TUG_2 = 1;
    public static final int TU_12 = 2;
    public static final int TU_2 = 3;
    public static final int OC3 = 0;
    public static final int OC12 = 1;
    public static final int OC48 = 2;
    public static final int OC192 = 3;
    public static final int XCVT = 4;
    public static final int DS1 = 5;
    public static final int DS1N = 6;
    public static final int DS3 = 7;
    public static final int DS3N = 8;
    public static final int DS3I = 9;
    public static final int DS3IN = 10;
    public static final int OC12_STM4_4PORT = 11;
    public static final int OC3_STM1_8PORT = 12;
    public static final int STM1E = 13;
    public static final int OC48_16 = 14;
    public static final int OC192_4 = 15;
    public static final int OC192_XFP = 16;
    public static final int DS1I = 17;
    public static final int XCVXC = 18;
    public static final int LAST_CARD_INDEX = 18;
    public static final int FC = 0;
    public static final int CV = 1;
    public static final int ES = 2;
    public static final int SES = 3;
    public static final int SEFS = 4;
    public static final int BBE = 5;
    public static final int ESR = 6;
    public static final int SESR = 7;
    public static final int BBER = 8;
    public static final int UAS = 9;
    public static final int PPJC_PDET = 10;
    public static final int NPJC_PDET = 11;
    public static final int PPJC_PGEN = 12;
    public static final int NPJC_PGEN = 13;
    public static final int PSC = 14;
    public static final int PSD = 15;
    public static final int PSC_W = 16;
    public static final int PSD_W = 17;
    public static final int PSC_S = 18;
    public static final int PSD_S = 19;
    public static final int PSC_R = 20;
    public static final int PSD_R = 21;
    public static final int LOSS = 22;
    public static final int AIS = 23;
    public static final int SAS = 24;
    public static final int LBC = 25;
    public static final int OPT = 26;
    public static final int OPR = 27;
    public static final int PJC_DIFF = 28;
    public static final int PJCS_PDET = 29;
    public static final int PJCS_PGEN = 30;
    public static final int PM_S = 0;
    public static final int PM_L = 1;
    public static final int PM_LFE = 2;
    public static final int PM_P = 3;
    public static final int PM_PFE = 4;
    public static final int PM_V = 5;
    public static final int PM_VFE = 6;
    public static final int PM_EL = 7;
    public static final int PM_ELFE = 8;
    public static final int PM_EP = 9;
    public static final int PM_EPFE = 10;
    public static final int PM_PHYS = 11;
    public static final int PM_EP_PBIT = 12;
    public static final int PM_EP_CPBIT = 13;
    public static final int STS = 0;
    public static final int VT = 1;
    public static final int LINE = 2;
    public static final int SECTION = 3;
    public static final int TDM_TYPE = 4;
    public static final int TUNNEL_TERM = 5;
    public static final int LAP = 6;
    public static final int AU4 = 7;
    public static final int DCC_TERM = 8;
    public static final int PDIP = 9;
    public static final int LDCC_TERM = 10;
    public static final int UPSR = 0;
    public static final int BLSR = 1;
    public static final int LAPS = 2;
    public static final int JBZS = 0;
    public static final int B8ZS = 1;
    public static final int HDB3 = 2;
    public static final int AMI = 3;
    public static final int ZBTSI = 4;
    public static final int B6ZS = 5;
    public static final int B3ZS = 6;
    public static final int ESF = 0;
    public static final int D4 = 1;
    public static final int OPTICAL = 0;
    public static final int ELECTRICAL = 1;
    public static final int ETHERNET = 2;
    public static final int DWDM = 3;
    public static final int OADM = 4;
    public static final int OSC = 5;
    public static final int AMPLI = 6;
    public static final int MD = 7;
    public static final int F_DWDM = 0;
    public static final int IS = 0;
    public static final int OOS_DSBLD = 1;
    public static final int OOS_MT = 2;
    public static final int IS_AINS = 3;
    public static final int OOS_OOG = 4;
    public static final int OOS_DSBLD_PARTIAL = 0;
    public static final int OOS_MT_PARTIAL = 1;
    public static final int IS_AINS_PARTIAL = 2;
    public static final int IS_PARTIAL = 3;
    protected static TDMTerminology DefaultTerminology_ = null;
    protected String[] GeneralTerms_ = null;
    protected String[] FrameTerms_ = null;
    protected String[] VirtualContainerTerms_ = null;
    protected String[] VGroupTerms_ = null;
    protected String[] CardNames_ = null;
    protected String[] PmStats_ = null;
    protected String[] PmStatTypes_ = null;
    protected String[] RingTerms_ = null;
    protected String[] PhysicalLinkTerms_ = null;
    protected String[] LineCoding_ = null;
    protected String[] LineType_ = null;
    protected String[] LinkPhysicalType_ = null;
    protected String[] AddCardType_ = null;
    protected String[] AddFamilyType_ = null;
    protected String[] AdminStateTerms_ = null;
    protected String[] ServiceStateTerms_ = null;
    protected String[] PrimaryStateTerms_ = null;
    protected String[] NetPartialAdminStateTerms_ = null;
    protected String[] NonStandardServiceStateTerms = null;
    public static int[] circuitTypes = null;
    public static int highOrderCircuitType = -1;
    public static int lowOrderCircuitType = -1;
    public static int tunnelCircuitType = -1;
    public static int ethernetCircuitType = -1;
    public static int loAggCircuitType = -1;
    public static int[] circuitSizes = null;
    public static int[] highOrderCircuitSizes = null;
    public static int[] lowOrderCircuitSizes = null;
    public static int baseHighOrderCircuitSize = -1;
    public static int tunnelCircuitSize = -1;
    public static int ethernetCircuitSize = -1;
    public static int loAggCircuitSize = -1;
    protected String ethernetTerm = null;

    protected TDMTerminology() {
    }

    public static TDMTerminology getDefault() {
        TDMTerminology tDMTerminology = DefaultTerminology_;
        if (tDMTerminology == null) {
            tDMTerminology = SONETTDMTerminology.instance();
        }
        return tDMTerminology;
    }

    public static void setDefault(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            throw new IllegalArgumentException("TDMTerminology should not be set to null!");
        }
        if (DefaultTerminology_ == null) {
            DefaultTerminology_ = tDMTerminology;
            DefaultTerminology_.staticInitialize();
        } else if (tDMTerminology != DefaultTerminology_) {
            throw new IllegalStateException("The network is not all SONET or all SDH network!");
        }
    }

    protected abstract void initialize();

    protected abstract void staticInitialize();

    public static boolean isSonetEnvironment() {
        return TDMTerminology.getDefault() instanceof SONETTDMTerminology;
    }

    public static boolean isSdhEnvironment() {
        return TDMTerminology.getDefault() instanceof SDHTDMTerminology;
    }

    String getFrameTerm(int n) throws IllegalArgumentException {
        if (this.FrameTerms_ == null) {
            throw new IllegalArgumentException("Frame term support is missing");
        }
        return this.FrameTerms_[n];
    }

    public String getVirtualContainerTerm(int n) throws IllegalArgumentException {
        if (this.VirtualContainerTerms_ == null) {
            throw new IllegalArgumentException("Virtual container term support is missing");
        }
        return this.VirtualContainerTerms_[n];
    }

    String getVGroupTerm(int n) throws IllegalArgumentException {
        if (this.VGroupTerms_ == null) {
            throw new IllegalArgumentException("Virtual container term support is missing");
        }
        return this.VGroupTerms_[n];
    }

    public int getEqTypeFromIndex(int n) {
        switch (n) {
            case 0: {
                return 9;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 60;
            }
            case 4: {
                return 43;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 66;
            }
            case 10: {
                return 67;
            }
            case 11: {
                return 85;
            }
        }
        return -1;
    }

    public int getLastCardIndex() {
        return 18;
    }

    public String getCardName(int n) throws IllegalArgumentException {
        if (this.CardNames_ == null) {
            throw new IllegalArgumentException("Card Name term support is missing");
        }
        if (this.CardNames_.length != 19) {
            throw new IllegalArgumentException("Card Name term support is invalid,  count " + this.CardNames_.length);
        }
        if (n < 0 || n > 18) {
            throw new IllegalArgumentException("Card Name index " + n + " is invalid");
        }
        return this.CardNames_[n];
    }

    public String getPmStat(int n) throws IllegalArgumentException {
        if (this.PmStats_ == null) {
            throw new IllegalArgumentException("Pm Stat term support is missing");
        }
        return this.PmStats_[n];
    }

    public String getEqType(int n) {
        return null;
    }

    public String getPmStatType(int n) throws IllegalArgumentException {
        if (this.PmStatTypes_ == null) {
            throw new IllegalArgumentException("Pm Stat Type term support is missing");
        }
        return this.PmStatTypes_[n];
    }

    public abstract String createPmColumnName(int var1, int var2);

    public String getGeneralTerms(int n) {
        if (this.GeneralTerms_ == null) {
            return "ErrorNoGeneralTermAvail";
        }
        return this.GeneralTerms_[n];
    }

    public String getRingTerms(int n) {
        if (this.RingTerms_ == null) {
            return "ErrorNoRingTermAvail";
        }
        return this.RingTerms_[n];
    }

    public String getLineCoding(int n) {
        if (this.LineCoding_ == null) {
            return "ErrorNoLineCoding";
        }
        return this.LineCoding_[n];
    }

    public String getLineType(int n) {
        if (this.LineType_ == null) {
            return "ErrorNoLineType";
        }
        return this.LineType_[n];
    }

    public String getTermForPhysicalLink(int n) {
        String string = "OC???";
        if (this.PhysicalLinkTerms_ != null) {
            string = this.PhysicalLinkTerms_[n];
        }
        return string;
    }

    public String getTermForAddCard(int n) {
        String string = "!ERROR!";
        if (this.AddCardType_ != null) {
            string = this.AddCardType_[n];
        }
        return string;
    }

    public String getTermForAddFamilyCard(int n) {
        String string = "!ERROR!";
        if (this.AddFamilyType_ != null) {
            string = this.AddFamilyType_[n];
        }
        return string;
    }

    public String getTermForAdminState(int n) {
        String string = "!ERROR!";
        if (this.AdminStateTerms_ != null) {
            string = this.AdminStateTerms_[n];
        }
        return string;
    }

    public String getTermForPartialAdminState(int n) {
        String string = "!ERROR!";
        if (this.NetPartialAdminStateTerms_ != null) {
            string = this.NetPartialAdminStateTerms_[n];
        }
        return string;
    }

    public String getTermForServiceState(int n) {
        String string = "!ERROR!";
        if (this.ServiceStateTerms_ != null) {
            string = n == -1 ? "UNKNOWN" : (n >= 100 ? this.NonStandardServiceStateTerms[n - 100] : this.ServiceStateTerms_[n]);
        }
        return string;
    }

    public String getTermForPrimaryState(int n) {
        String string = "!ERROR!";
        if (this.PrimaryStateTerms_ != null) {
            string = this.PrimaryStateTerms_[n];
        }
        return string;
    }

    public static int getHoCircuitType() {
        return TDMTerminology.isSonetEnvironment() ? 1 : 4;
    }

    public static int getLoCircuitType() {
        return TDMTerminology.isSonetEnvironment() ? 2 : 5;
    }

    public static int getTunnelCircuitType() {
        return TDMTerminology.isSonetEnvironment() ? 3 : 6;
    }

    public static boolean isHoCircuitType(int n) {
        ICircuitType iCircuitType = CircuitType.getCircuitType(n);
        return iCircuitType == null ? false : iCircuitType.isHoCircuitType();
    }

    public static boolean isLoCircuitType(int n) {
        ICircuitType iCircuitType = CircuitType.getCircuitType(n);
        return iCircuitType == null ? false : iCircuitType.isLoCircuitType();
    }

    public static boolean isTunnelCircuitType(int n) {
        ICircuitType iCircuitType = CircuitType.getCircuitType(n);
        return iCircuitType == null ? false : iCircuitType.isTunnelCircuitType();
    }

    public boolean isLoCircuitSize(int n) {
        int n2 = TDMTerminology.isSonetEnvironment() ? 0 : 1;
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize(n);
        return iCircuitSize == null ? false : iCircuitSize.isLo(n2);
    }

    public static int getTunnelCircuitSize() {
        return TDMTerminology.isSonetEnvironment() ? 1 : 12;
    }

    public static int size2widthOfVtCircuit(int n) {
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize(n);
        if (iCircuitSize != null) {
            return iCircuitSize.size2widthOfLoCircuit();
        }
        throw new IllegalArgumentException("unknown ckt size " + n);
    }

    public static int width2sizeOfVtCircuit(int n) {
        ICircuitSize iCircuitSize = CircuitSize.width2sizeOfLoCircuit(n);
        return iCircuitSize.getEnum();
    }

    public String getCircuitTypeString(ICircuitType iCircuitType) {
        return iCircuitType.isEthernetCircuitType() ? this.getEthernetTypeTerm() : iCircuitType.getProtocolIndepCktTypeStr();
    }

    public String getCircuitTypeShortString(ICircuitType iCircuitType) {
        return iCircuitType.isEthernetCircuitType() ? this.getEthernetTypeTerm() : iCircuitType.getProtocolIndepCktTypeShortStr();
    }

    public String getEthernetTypeTerm() {
        if (this.ethernetTerm != null) {
            return this.ethernetTerm;
        }
        String string = MissingTerm_;
        return string;
    }

    public abstract String getBackplaneTerm(boolean var1);

    public String getLinkPhysicalTypeTerm(int n) {
        try {
            return this.LinkPhysicalType_[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("unknown link physical type: " + n);
        }
    }
}

