/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.Preferences;
import cerent.util.gui.UFileChooser;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class PersistentFileChooser {
    public static final byte MASK_ALLOW_FILES = 1;
    public static final byte MASK_ALLOW_SAVE = 2;
    public static final byte MASK_DONT_CREATE_FILE = 4;
    private LinkedList mruList = new LinkedList();
    private String propPrefix = "";
    private String propName = "";

    public PersistentFileChooser(String string, String string2) {
        this.propPrefix = string;
        this.propName = string2;
        String[] stringArray = null;
        try {
            stringArray = Preferences.instance().getPropertyArray(this.propPrefix, this.propName, new String[0]);
        }
        catch (Exception exception) {
            stringArray = new String[]{};
        }
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.mruList.add(stringArray[i]);
            }
        }
    }

    public String[] getFileNames() {
        return this.mruList.toArray(new String[0]);
    }

    public void setFileNames(String[] stringArray) {
        Preferences.instance().setPropertyArray(this.propPrefix, this.propName, stringArray);
    }

    public void addFileName(String string) {
        this.addFileName(string, false);
    }

    public void addFileName(String string, boolean bl) {
        if (this.mruList.isEmpty() || !string.equals(this.mruList.getFirst())) {
            Iterator iterator = this.mruList.iterator();
            while (iterator.hasNext()) {
                if (!string.equals(iterator.next())) continue;
                iterator.remove();
            }
            this.mruList.addFirst(string);
        }
        if (bl) {
            this.setFileNames(this.getFileNames());
        }
    }

    public void removeFileName(String string) {
        this.mruList.remove(string);
        this.setFileNames(this.getFileNames());
    }

    public File showFileChooser(Component component, boolean bl, FileFilter fileFilter) {
        if (bl) {
            return this.showFileChooser(component, (byte)2, fileFilter);
        }
        return this.showFileChooser(component, (byte)0, fileFilter);
    }

    public File showFileChooser(Component component, byte by, FileFilter fileFilter) {
        File file = null;
        if (!this.mruList.isEmpty()) {
            file = new File((String)this.mruList.getFirst());
        }
        if (file != null && !file.isDirectory() && (file = file.getParentFile()) != null && !file.isDirectory()) {
            file = null;
        }
        UFileChooser uFileChooser = new UFileChooser(file);
        if (fileFilter != null) {
            uFileChooser.setFileFilter(fileFilter);
        }
        int n = (by & 2) == 2 ? uFileChooser.showSaveDialog(component) : uFileChooser.showOpenDialog(component);
        file = n == 0 ? uFileChooser.getSelectedFile() : null;
        return file;
    }
}

