/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.IGroupableTblColumnModel;
import cerent.cms.ui.IUiToolkit;
import cerent.util.gui.AbstractTableWriter;
import cerent.util.gui.TableModelAdapter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JTable;

public class TableCSVWriter
extends AbstractTableWriter {
    protected String _delimiter = ",";
    protected String _delimiterReplacement = ";";
    protected String _lineDelimiter = "\r\n";
    protected String _emptyStringRepresentation = "";

    public void setDelimiter(String string) {
        this._delimiter = string;
    }

    public void setDelimiterReplacement(String string) {
        this._delimiterReplacement = string;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setLineDelimiter(String string) {
        this._lineDelimiter = string;
    }

    public String getLineDelimiter() {
        return this._lineDelimiter;
    }

    public void setEmptyStringRepresentation(String string) {
        this._emptyStringRepresentation = string;
    }

    public String getEmptyStringRepresentation() {
        return this._emptyStringRepresentation;
    }

    public TableCSVWriter(IUiToolkit iUiToolkit, JTable jTable, boolean bl, TableModelAdapter tableModelAdapter, String string, String string2) {
        super(iUiToolkit, jTable, bl, tableModelAdapter, string, string2);
        if (bl) {
            ((TableModelAdapter)this.fTableModel).setDefaultString(this._emptyStringRepresentation);
        }
    }

    public TableCSVWriter(IUiToolkit iUiToolkit, JTable jTable, boolean bl, String string) {
        this(iUiToolkit, jTable, bl, null, string, null);
    }

    public void writeFile(String string) {
        try {
            int n;
            this.fFileWriter = new FileWriter(string);
            String string2 = "";
            int n2 = this.fTableModel.getRowCount();
            int n3 = this.fTableModel.getColumnCount();
            boolean bl = false;
            IGroupableTblColumnModel iGroupableTblColumnModel = null;
            if (this.fTable.getColumnModel() instanceof IGroupableTblColumnModel) {
                iGroupableTblColumnModel = (IGroupableTblColumnModel)((Object)this.fTable.getColumnModel());
                bl = true;
            }
            if (n3 > 0) {
                String string3;
                int n4;
                if (this.fOutputTitle != null) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (n4 == 0) {
                            this.writeText(this.fOutputTitle);
                        }
                        string2 = n4 == n3 - 1 ? this._lineDelimiter : this._delimiter;
                        this.writeText(string2);
                    }
                }
                if (this.fOutputSubTitle != null && this.fOutputSubTitle.trim().length() > 0) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (n4 == 0) {
                            this.writeText(this.fOutputSubTitle);
                        }
                        string2 = n4 == n3 - 1 ? this._lineDelimiter : this._delimiter;
                        this.writeText(string2);
                    }
                }
                if (bl) {
                    String string4 = iGroupableTblColumnModel.getColumnGroupName(0).indexOf(44) == -1 ? iGroupableTblColumnModel.getColumnGroupName(0) : iGroupableTblColumnModel.getColumnGroupName(0).replace(',', ' ');
                    string3 = iGroupableTblColumnModel.getColumnGroupName(1).indexOf(44) == -1 ? iGroupableTblColumnModel.getColumnGroupName(1) : iGroupableTblColumnModel.getColumnGroupName(1).replace(',', ' ');
                    String string5 = this._delimiter.equals("\t") ? this._delimiter : this._delimiter + this._delimiter + this._delimiter + this._delimiter;
                    String string6 = this._delimiter + string4 + string5 + string3 + string5 + this._lineDelimiter;
                    this.writeText(string6);
                }
                for (n = 0; n < n3; ++n) {
                    string2 = string3 = this.fTableModel.getColumnName(n);
                    this.writeText(string2);
                    string2 = n == n3 - 1 ? this._lineDelimiter : this._delimiter;
                    this.writeText(string2);
                }
            }
            if (n2 > 0 && n3 > 0) {
                for (n = 0; n < n2; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        string2 = this.fTableModel.getValueAt(n, i).toString();
                        this.writeText(this.cleanString(string2));
                        string2 = i == n3 - 1 ? this._lineDelimiter : this._delimiter;
                        this.writeText(string2);
                    }
                }
            }
            this.close();
        }
        catch (IOException iOException) {
            this.displayError("Error writing to " + string + ": " + iOException.getMessage());
        }
    }

    private String cleanString(String string) {
        int n = string.length();
        boolean bl = this.isNumber(string);
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this._delimiter.charAt(0) && !bl) {
                c = this._delimiterReplacement.charAt(0);
            }
            if (c == this._delimiter.charAt(0)) continue;
            if (!Character.isWhitespace(c) || c == ' ' || c == '\t') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        if (n > 0) {
            string2 = " " + string2;
        }
        return string2;
    }

    private boolean isNumber(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this._delimiter.charAt(0)) continue;
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString();
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (Exception exception) {
            try {
                Long.parseLong(string);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }
}

