/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.IGroupableTblColumnModel;
import cerent.util.DebugManager;
import cerent.util.gui.TableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableContentPrinter
implements Printable {
    static final int kRowHeight = 20;
    static final int kDefaultColumnWidth = 80;
    JTable fTable = null;
    TableModel fTableModel = null;
    TableColumnModel fTableColumnModel = null;
    String fOutputTitle;
    int fNumberOfRows = 0;
    int fNumberOfPages = 0;
    int fNumberOfRowsPerPage = 0;
    double fTableContentWidth = 0.0;
    double fTableContentHeight = 0.0;
    double fImageableWidth = 0.0;
    double fImageableHeight = 0.0;
    JLabel fHeaderTextLabel = null;
    JLabel fCellTextLabel = null;
    Font fFont = null;
    double fScale = 1.0;
    boolean fForceLandscapePrint = true;

    public TableContentPrinter(JTable jTable, boolean bl, String string) {
        this(jTable, bl, string, null);
    }

    public TableContentPrinter(JTable jTable, boolean bl, String string, TableModelAdapter tableModelAdapter) {
        this.fTable = jTable;
        this.fTableColumnModel = this.fTable.getColumnModel();
        this.fOutputTitle = string;
        if (bl) {
            this.fTableModel = tableModelAdapter == null ? new TableModelAdapter(jTable.getModel(), jTable) : tableModelAdapter;
            ((TableModelAdapter)this.fTableModel).setDefaultString(" ");
        } else {
            this.fTableModel = jTable.getModel();
        }
        this.fFont = new Font("Monospaced", 0, 10);
        this.fHeaderTextLabel = new JLabel();
        this.fCellTextLabel = new JLabel();
    }

    public TableContentPrinter(JTable jTable) {
        this(jTable, true, "");
    }

    public void forceLandscape(boolean bl) {
        this.fForceLandscapePrint = bl;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                DebugManager.printStackTrace((Throwable)printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        boolean bl = false;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.fFont);
        if (this.fForceLandscapePrint) {
            pageFormat.setOrientation(0);
        }
        int n2 = graphics2D.getFontMetrics().getHeight();
        int n3 = graphics2D.getFontMetrics().getDescent();
        int n4 = 2 * n2;
        int n5 = n2;
        this.fImageableWidth = pageFormat.getImageableWidth();
        this.fImageableHeight = pageFormat.getImageableHeight();
        this.fTableContentHeight = this.fImageableHeight - (double)(n4 + n5);
        this.fTableContentWidth = pageFormat.getImageableWidth();
        double d = this.fTable.getColumnModel().getTotalColumnWidth();
        if (d >= this.fTableContentWidth) {
            this.fScale = this.fTableContentWidth / d;
        }
        if (this.fScale < 0.3) {
            bl = true;
        }
        if (bl) {
            int n6;
            int n7 = this.fTableModel.getColumnCount();
            int[] nArray = new int[n7];
            int[] nArray2 = new int[n7];
            int n8 = 0;
            double d2 = 0.0;
            TableColumn tableColumn = null;
            for (int i = 0; i < n7; ++i) {
                try {
                    tableColumn = this.fTableColumnModel.getColumn(i);
                    n8 = tableColumn.getWidth();
                }
                catch (Exception exception) {
                    n8 = 80;
                }
                nArray[i] = n8;
                d2 += (double)n8;
            }
            d = d2;
            double d3 = 0.0;
            double d4 = 0.5 * d;
            int n9 = n7;
            boolean bl2 = false;
            for (int i = 0; !bl2 && i < n7; ++i) {
                if (!((d3 += (double)nArray[i]) > d4)) continue;
                n9 = i;
                bl2 = true;
            }
            int n10 = 0;
            double d5 = 1.0;
            int n11 = 0;
            double d6 = 1.0;
            for (n6 = 0; n6 < n9; ++n6) {
                n10 += nArray[n6];
            }
            for (n6 = n9; n6 < n7; ++n6) {
                n11 += nArray[n6];
            }
            d5 = n10 == 0 ? 1.0 : this.fTableContentWidth / (double)n10;
            d6 = n11 == 0 ? 1.0 : this.fTableContentWidth / (double)n11;
            this.fScale = d5;
            if (d5 > d6) {
                this.fScale = d6;
            }
            this.fNumberOfRowsPerPage = (int)(this.fTableContentHeight / 20.0 / this.fScale);
            this.fNumberOfRows = this.fTable.getRowCount();
            this.fNumberOfPages = 2 * (1 + this.fNumberOfRows / this.fNumberOfRowsPerPage);
            if (n >= this.fNumberOfPages) {
                return 1;
            }
            n6 = n / 2;
            graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
            this.writePageHeader(graphics2D, this.fOutputTitle);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY() + (double)n5);
            graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
            graphics2D.scale(this.fScale, this.fScale);
            int n12 = 0;
            int n13 = 0;
            int n14 = n % 2;
            boolean bl3 = false;
            if (n14 == 1) {
                bl3 = true;
            }
            if (!bl3) {
                int n15;
                for (n15 = 0; n15 < n9; ++n15) {
                    String string = this.fTableModel.getColumnName(n15);
                    this.writeHeaderElement(graphics2D, string, nArray[n15], n12, n13);
                    n12 += nArray[n15];
                }
                n15 = n6 * this.fNumberOfRowsPerPage;
                int n16 = n15 + this.fNumberOfRowsPerPage;
                if (n16 > this.fNumberOfRows) {
                    n16 = this.fNumberOfRows;
                }
                n13 += 20;
                for (int i = n15; i < n16; ++i) {
                    n12 = 0;
                    for (int j = 0; j < n9; ++j) {
                        String string = this.fTableModel.getValueAt(i, j).toString();
                        n8 = nArray[j];
                        this.writeTableCell(graphics2D, string, n8, n12, n13);
                        n12 += n8;
                    }
                    n13 += 20;
                }
            } else {
                int n17;
                for (n17 = n9; n17 < n7; ++n17) {
                    String string = this.fTableModel.getColumnName(n17);
                    this.writeHeaderElement(graphics2D, string, nArray[n17], n12, n13);
                    n12 += nArray[n17];
                }
                n13 = 0;
                n17 = n6 * this.fNumberOfRowsPerPage;
                int n18 = n17 + this.fNumberOfRowsPerPage;
                if (n18 > this.fNumberOfRows) {
                    n18 = this.fNumberOfRows;
                }
                n13 += 20;
                for (int i = n17; i < n18; ++i) {
                    n12 = 0;
                    for (int j = n9; j < n7; ++j) {
                        String string = this.fTableModel.getValueAt(i, j).toString();
                        n8 = nArray[j];
                        this.writeTableCell(graphics2D, string, n8, n12, n13);
                        n12 += n8;
                    }
                    n13 += 20;
                }
            }
            this.writeFooter(graphics2D, "Page: " + (n6 + 1) + " of " + this.fNumberOfPages / 2);
        } else {
            int n19;
            this.fNumberOfRowsPerPage = (int)(this.fTableContentHeight / 20.0 / this.fScale);
            this.fNumberOfRows = this.fTable.getRowCount();
            this.fNumberOfPages = 1 + this.fNumberOfRows / this.fNumberOfRowsPerPage;
            if (n >= this.fNumberOfPages) {
                return 1;
            }
            graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
            this.writePageHeader(graphics2D, this.fOutputTitle);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY() + (double)n5);
            graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
            graphics2D.scale(this.fScale, this.fScale);
            int n20 = this.fTableModel.getColumnCount();
            int n21 = 0;
            int n22 = 0;
            int[] nArray = new int[n20];
            int[] nArray3 = new int[n20];
            TableColumn tableColumn = null;
            int n23 = 0;
            boolean bl4 = false;
            IGroupableTblColumnModel iGroupableTblColumnModel = null;
            if (this.fTable.getColumnModel() instanceof IGroupableTblColumnModel) {
                iGroupableTblColumnModel = (IGroupableTblColumnModel)((Object)this.fTable.getColumnModel());
                bl4 = true;
            }
            if (bl4) {
                String string = " ";
                tableColumn = iGroupableTblColumnModel.getColumn(0);
                n23 = tableColumn.getWidth();
                this.writeHeaderElement(graphics2D, string, n23, n21, n22);
                n21 += n23;
                string = iGroupableTblColumnModel.getColumnGroupName(0);
                this.writeHeaderElement(graphics2D, string, n23 *= 4, n21, n22);
                string = iGroupableTblColumnModel.getColumnGroupName(1);
                this.writeHeaderElement(graphics2D, string, n23, n21 += n23, n22);
                n22 += 20;
                n21 = 0;
            }
            for (n19 = 0; n19 < n20; ++n19) {
                try {
                    tableColumn = this.fTableColumnModel.getColumn(n19);
                    n23 = tableColumn.getWidth();
                }
                catch (Exception exception) {
                    n23 = 80;
                }
                nArray[n19] = n23;
                nArray3[n19] = tableColumn.getModelIndex();
                String string = this.fTableModel.getColumnName(n19);
                this.writeHeaderElement(graphics2D, string, n23, n21, n22);
                n21 += n23;
            }
            n19 = n * this.fNumberOfRowsPerPage;
            int n24 = n19 + this.fNumberOfRowsPerPage;
            if (n24 > this.fNumberOfRows) {
                n24 = this.fNumberOfRows;
            }
            n22 += 20;
            for (int i = n19; i < n24; ++i) {
                n21 = 0;
                for (int j = 0; j < n20; ++j) {
                    String string = this.fTableModel.getValueAt(i, j).toString();
                    n23 = nArray[j];
                    this.writeTableCell(graphics2D, string, n23, n21, n22);
                    n21 += n23;
                }
                n22 += 20;
            }
            this.writeFooter(graphics2D, "Page: " + (n + 1) + " of " + this.fNumberOfPages);
        }
        return 0;
    }

    protected void writeFooter(Graphics2D graphics2D, String string) {
        int n = string.length();
        int n2 = (int)(this.fImageableWidth / 2.0 - 35.0);
        int n3 = (int)(this.fTableContentHeight + 20.0);
        graphics2D.scale(1.0 / this.fScale, 1.0 / this.fScale);
        graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
        graphics2D.drawString(string, n2, n3);
    }

    protected void writePageHeader(Graphics2D graphics2D, String string) {
        int n = string.length();
        int n2 = graphics2D.getFontMetrics().getHeight();
        int n3 = (int)((this.fImageableWidth - (double)n - 1.0) / 2.0);
        int n4 = 30 + n2;
        graphics2D.setClip(0, 0, (int)this.fImageableWidth, (int)this.fImageableHeight);
        graphics2D.drawString(string, n3, n4);
    }

    protected void writeHeaderElement(Graphics2D graphics2D, String string, int n, double d, double d2) {
        Graphics2D graphics2D2 = graphics2D;
        this.fHeaderTextLabel.setBounds(0, 0, n, 20);
        this.fHeaderTextLabel.setBackground(Color.lightGray);
        this.fHeaderTextLabel.setOpaque(true);
        this.fHeaderTextLabel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.fHeaderTextLabel.setHorizontalAlignment(0);
        this.fHeaderTextLabel.setFont(this.fFont);
        this.fHeaderTextLabel.setText(string);
        graphics2D2.translate(d, d2);
        graphics2D2.setClip(-1, -1, n + 1, 21);
        this.fHeaderTextLabel.paint(graphics2D2);
        graphics2D2.translate(-d, -d2);
    }

    protected void writeTableCell(Graphics2D graphics2D, String string, int n, double d, double d2) {
        Graphics2D graphics2D2 = graphics2D;
        this.fCellTextLabel.setBounds(0, 0, n, 20);
        this.fCellTextLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.fCellTextLabel.setFont(this.fFont);
        this.fCellTextLabel.setText(string);
        graphics2D2.translate(d, d2);
        graphics2D2.setClip(-1, -1, n + 1, 21);
        this.fCellTextLabel.paint(graphics2D2);
        graphics2D2.translate(-d, -d2);
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    public int calcPages() {
        boolean bl = false;
        PageFormat pageFormat = new PageFormat();
        Graphics graphics = this.fTable.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.fFont);
        if (this.fForceLandscapePrint) {
            pageFormat.setOrientation(0);
        }
        int n = graphics2D.getFontMetrics().getHeight();
        int n2 = graphics2D.getFontMetrics().getDescent();
        int n3 = 2 * n;
        int n4 = n;
        this.fImageableWidth = pageFormat.getImageableWidth();
        this.fImageableHeight = pageFormat.getImageableHeight();
        this.fTableContentHeight = this.fImageableHeight - (double)(n3 + n4);
        this.fTableContentWidth = pageFormat.getImageableWidth();
        double d = this.fTable.getColumnModel().getTotalColumnWidth();
        if (d >= this.fTableContentWidth) {
            this.fScale = this.fTableContentWidth / d;
        }
        if (this.fScale < 0.3) {
            bl = true;
        }
        if (bl) {
            int n5;
            int n6 = this.fTableModel.getColumnCount();
            int[] nArray = new int[n6];
            int[] nArray2 = new int[n6];
            int n7 = 0;
            double d2 = 0.0;
            TableColumn tableColumn = null;
            for (int i = 0; i < n6; ++i) {
                try {
                    tableColumn = this.fTableColumnModel.getColumn(i);
                    n7 = tableColumn.getWidth();
                }
                catch (Exception exception) {
                    n7 = 80;
                }
                nArray[i] = n7;
                d2 += (double)n7;
            }
            d = d2;
            double d3 = 0.0;
            double d4 = 0.5 * d;
            int n8 = n6;
            boolean bl2 = false;
            for (int i = 0; !bl2 && i < n6; ++i) {
                if (!((d3 += (double)nArray[i]) > d4)) continue;
                n8 = i;
                bl2 = true;
            }
            int n9 = 0;
            double d5 = 1.0;
            int n10 = 0;
            double d6 = 1.0;
            for (n5 = 0; n5 < n8; ++n5) {
                n9 += nArray[n5];
            }
            for (n5 = n8; n5 < n6; ++n5) {
                n10 += nArray[n5];
            }
            d5 = n9 == 0 ? 1.0 : this.fTableContentWidth / (double)n9;
            d6 = n10 == 0 ? 1.0 : this.fTableContentWidth / (double)n10;
            this.fScale = d5;
            if (d5 > d6) {
                this.fScale = d6;
            }
            this.fNumberOfRowsPerPage = (int)(this.fTableContentHeight / 20.0 / this.fScale);
            this.fNumberOfRows = this.fTable.getRowCount();
            this.fNumberOfPages = 2 * (1 + this.fNumberOfRows / this.fNumberOfRowsPerPage);
        } else {
            this.fNumberOfRowsPerPage = (int)(this.fTableContentHeight / 20.0 / this.fScale);
            this.fNumberOfRows = this.fTable.getRowCount();
            this.fNumberOfPages = 1 + this.fNumberOfRows / this.fNumberOfRowsPerPage;
        }
        return this.fNumberOfPages;
    }
}

