/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

import cerent.util.gui.MultiLineLabelUI;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JobProgressDialog
extends JDialog
implements ActionListener,
IJobProgressControl {
    private static final String CANCEL = "Cancel";
    private JButton cancelButton;
    private JProgressBar progressBar;
    private IJobControl job = null;
    private JLabel label;
    private String lblText;
    private Timer incTimer;
    private int p;

    public JobProgressDialog(Frame frame, String string, String string2) {
        super(frame, string, false);
        this.init(frame, string2, false, 0);
    }

    public JobProgressDialog(Frame frame, String string, String string2, boolean bl) {
        super(frame, string, bl);
        this.init(frame, string2, false, 0);
    }

    public JobProgressDialog(Frame frame, String string, String string2, boolean bl, boolean bl2) {
        super(frame, string, bl);
        this.init(frame, string2, bl2, 0);
    }

    public JobProgressDialog(Frame frame, String string, String string2, boolean bl, boolean bl2, int n) {
        super(frame, string, bl);
        this.init(frame, string2, bl2, n);
    }

    private void init(Frame frame, String string, boolean bl, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label = new JLabel(string);
        this.label.setUI(new MultiLineLabelUI());
        jPanel.add(this.label);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        if (bl) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    JobProgressDialog.this.onCancel();
                }
            });
            JPanel jPanel2 = new JPanel();
            this.cancelButton = new JButton(CANCEL);
            this.cancelButton.addActionListener(this);
            jPanel2.add(this.cancelButton);
            jPanel2.add(this.progressBar);
            jPanel.add(jPanel2);
        } else {
            jPanel.add(this.progressBar);
        }
        if (n > 0) {
            this.setAnimatedTime(n);
        }
        this.setContentPane(jPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.incTimer) {
            int n = this.progressBar.getValue() + 10;
            this.setPercentCompleted(n > 100 ? 0 : n);
        } else {
            this.onCancel();
        }
    }

    public void setJob(IJobControl iJobControl) {
        this.job = iJobControl;
    }

    public void onCancel() {
        if (this.job != null) {
            this.cancelButton.setEnabled(false);
            this.setProgressText("Canceling, please wait...");
            this.job.abortJob();
        }
    }

    private void setAnimatedTime(int n) {
        if (n == 0) {
            return;
        }
        if (this.incTimer != null) {
            this.incTimer.stop();
        }
        this.incTimer = new Timer(n, this);
        this.progressBar.setStringPainted(false);
        this.incTimer.start();
    }

    public void setPercentCompleted(int n) {
        if (this.p == n) {
            return;
        }
        this.p = n;
        if (this.p > 100) {
            this.p = 100;
        } else if (this.p < 0) {
            this.p = 0;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (JobProgressDialog.this.cancelButton != null && JobProgressDialog.this.p == 100) {
                        JobProgressDialog.this.cancelButton.setEnabled(false);
                    }
                    JobProgressDialog.this.progressBar.setValue(JobProgressDialog.this.p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setProgressText(String string) {
        this.lblText = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JobProgressDialog.this.label.setText(JobProgressDialog.this.lblText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void dispose() {
        if (this.incTimer != null) {
            this.incTimer.stop();
        }
        super.dispose();
    }
}

