/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.terminal;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.terminal.ConnectionException;
import cerent.util.terminal.DataWriteException;
import cerent.util.terminal.IDataProcessor;
import cerent.util.terminal.IReaderThread;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class SshReaderThread
implements IReaderThread {
    private boolean connected = false;
    private IDataProcessor client = null;
    private JSch jsch = null;
    private Session session = null;
    private Channel channel = null;
    private InputStream is = null;
    private OutputStream os = null;
    private Thread server = null;
    private boolean keepAlive = false;

    public void connect(String string, int n, String string2, String string3, IDataProcessor iDataProcessor) throws ConnectionException {
        this.connect(string, n, string2, string3, iDataProcessor, false);
    }

    public void connect(String string, int n, String string2, String string3, IDataProcessor iDataProcessor, boolean bl) throws ConnectionException {
        if (string == null) {
            throw new IllegalArgumentException("host may not be null");
        }
        if (iDataProcessor == null) {
            throw new IllegalArgumentException("client may not be null");
        }
        this.client = iDataProcessor;
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.jsch = new JSch();
        try {
            this.session = this.jsch.getSession(string2, string, n);
            this.session.setUserInfo(new SshUserInfo(string3));
            this.session.setSocketFactory(new SshSocketFactory());
            this.keepAlive = bl;
            this.session.connect();
            this.channel = this.session.openChannel("shell");
            this.channel.connect();
            this.is = this.channel.getInputStream();
            this.os = this.channel.getOutputStream();
            this.server = new Thread((Runnable)this, "SshReaderThread - " + string + ":" + n);
            this.server.start();
            this.setConnected();
        }
        catch (JSchException jSchException) {
            throw new ConnectionException(jSchException);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException);
        }
    }

    public void disconnect() throws ConnectionException {
        this.channel.disconnect();
        this.session.disconnect();
        this.clearConnected();
    }

    private synchronized void setConnected() {
        this.connected = true;
    }

    private synchronized void clearConnected() {
        this.connected = false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public void write(String string) throws DataWriteException {
        this.write(string.getBytes());
    }

    public void write(byte[] byArray) throws DataWriteException {
        if (!this.isConnected()) {
            throw new DataWriteException("No connection present");
        }
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            throw new DataWriteException(iOException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws DataWriteException {
        if (!this.isConnected()) {
            throw new DataWriteException("No connection present");
        }
        try {
            this.os.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DataWriteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[4096];
        if (this.is == null) {
            this.clearConnected();
        }
        while (this.isConnected()) {
            try {
                int n = this.is.read(byArray);
                if (this.client != null && this.isConnected() && n > 0) {
                    this.client.incomingData(byArray, n, byArray, 0, this);
                    continue;
                }
                if (n != -1) continue;
                this.clearConnected();
            }
            catch (IOException iOException) {
                this.clearConnected();
            }
        }
        try {
            this.disconnect();
        }
        catch (ConnectionException connectionException) {
        }
        finally {
            this.client.terminated(this);
        }
        this.server = null;
    }

    private class SshSocketFactory
    implements SocketFactory {
        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            Socket socket = CtcProxyFactory.connect((String)string, (int)n).getSocket();
            socket.setKeepAlive(SshReaderThread.this.keepAlive);
            socket.setSoTimeout(0);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }
    }

    private class SshUserInfo
    implements UserInfo {
        private String password;

        public SshUserInfo(String string) {
            this.password = string;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public void showMessage(String string) {
        }
    }
}

