/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.HelpMaintDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HelpMgr {
    public static final String USER_MANUALS = "User Manuals";
    private static KDebug db = new KDebug("HelpMgr");
    private static final String MSG_INVALID_HELP_DIR = "Unable to locate CTC Help sub-system";
    private static final String CSH_TITLE = "Context Sensitive Help";
    private static final String HELP_DIR = "help";
    private static final String PROP_GEN_PATH = "ctc";
    private static final String PROP_DOC_ROOT = "document.root";
    private static final String INDEX_PAGE = "index.html";
    private static final String REMOVE = "Remove...";
    private static final String BOOK_PATH = "BookPath";
    private static Preferences preferences = Preferences.instance();
    private static String docRootDir;
    private static DefaultHelpBroker hb;
    private static boolean helpInstalled;
    private static int platform;
    private static ActionObserver actionObserver;

    public static int getCSHPlatform() {
        return platform;
    }

    public static void setCSHPlatform(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Platform must be defined in ICSHelpConst");
        }
        platform = n;
    }

    public static void removeHelpDocDir(String string) throws Exception {
        try {
            File file = new File(HelpMgr.getHelpDirPath() + File.separator + string);
            if (file.isDirectory()) {
                if (HelpMgr.db.on) {
                    db.println("deleting " + file.getCanonicalPath());
                }
                HelpMgr.recursiveRemove(file);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            throw exception;
        }
    }

    private static void recursiveRemove(File file) throws Exception {
        try {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    HelpMgr.recursiveRemove(new File(file.getCanonicalPath() + File.separator + stringArray[i]));
                }
            }
            file.delete();
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            throw exception;
        }
    }

    public static String getHelpSystemRootPath() throws Exception {
        if (!helpInstalled) {
            throw new Exception(MSG_INVALID_HELP_DIR);
        }
        return docRootDir;
    }

    private static String getHelpDirPath() throws Exception {
        if (!helpInstalled) {
            throw new Exception(MSG_INVALID_HELP_DIR);
        }
        return docRootDir + File.separator + HELP_DIR;
    }

    public static boolean isHelpInstalled() {
        return helpInstalled;
    }

    public static boolean isHelpDocDir(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '_') continue;
            ++n;
        }
        try {
            File file = new File(HelpMgr.getHelpDirPath() + File.separator + string);
            return file.isDirectory() && n == 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static TreeMap getHelpDocDirs() {
        TreeMap<String, String> treeMap;
        block4: {
            treeMap = new TreeMap<String, String>();
            try {
                File file = new File(HelpMgr.getHelpDirPath());
                if (file.isDirectory()) {
                    String[] stringArray = file.list();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (!HelpMgr.isHelpDocDir(string)) continue;
                        treeMap.put(HelpMgr.getHelpDocDirName(string), string);
                    }
                }
            }
            catch (Exception exception) {
                if (!HelpMgr.db.on) break block4;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return treeMap;
    }

    private static TreeMap getHelpTree() {
        TreeMap treeMap;
        block6: {
            treeMap = new TreeMap();
            try {
                File file = new File(HelpMgr.getHelpDirPath());
                if (!file.isDirectory()) break block6;
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    TreeMap<String, String> treeMap2;
                    String string;
                    block7: {
                        string = stringArray[i];
                        if (!HelpMgr.isHelpDocDir(string)) continue;
                        treeMap2 = new TreeMap<String, String>();
                        try {
                            File file2 = new File(HelpMgr.getHelpDirPath() + File.separator + string);
                            String[] stringArray2 = file2.list();
                            for (int j = 0; j < stringArray2.length; ++j) {
                                String string2 = stringArray2[j];
                                if (string2.indexOf("PDF") == -1 && string2.indexOf("pdf") == -1) continue;
                                String string3 = file2.getCanonicalPath() + File.separator + string2;
                                treeMap2.put(HelpMgr.getBookName(string, string2), string3);
                            }
                        }
                        catch (Exception exception) {
                            if (!HelpMgr.db.on) break block7;
                            KDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    if (treeMap2.size() <= 0) continue;
                    treeMap.put(string, treeMap2);
                }
            }
            catch (Exception exception) {
                if (!HelpMgr.db.on) break block6;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return treeMap;
    }

    public static JMenuItem getHelpMenu() {
        JMenuItem jMenuItem;
        TreeMap treeMap = HelpMgr.getHelpTree();
        if (treeMap.size() == 0) {
            jMenuItem = new JMenuItem(USER_MANUALS);
            jMenuItem.addActionListener(actionObserver);
        } else {
            Object object;
            jMenuItem = new JMenu(USER_MANUALS);
            Set set = treeMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                JMenu jMenu = new JMenu(HelpMgr.getHelpDocDirName((String)object));
                jMenuItem.add(jMenu);
                TreeMap treeMap2 = (TreeMap)treeMap.get(object);
                if (treeMap2 == null) continue;
                Set set2 = treeMap2.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    String string2 = (String)treeMap2.get(string);
                    JMenuItem jMenuItem2 = new JMenuItem(string);
                    jMenuItem2.addActionListener(actionObserver);
                    jMenuItem2.putClientProperty(BOOK_PATH, string2);
                    jMenu.add(jMenuItem2);
                    if (!db.on()) continue;
                    db.println("book=" + string + " path=" + string2);
                }
            }
            if (treeMap.size() > 0) {
                ((JMenu)jMenuItem).addSeparator();
            }
            object = new JMenuItem(REMOVE);
            ((AbstractButton)object).addActionListener(actionObserver);
            jMenuItem.add((Component)object);
        }
        jMenuItem.setMnemonic(77);
        return jMenuItem;
    }

    private static String getHelpDocDirName(String string) {
        String string2;
        block3: {
            string2 = string;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                String string3 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                string2 = "ONS " + string3.toUpperCase() + " Release " + n + "." + n2;
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("getHelpDocDirName: helpDocDirName=" + string2);
        }
        return string2;
    }

    private static String getBookName(String string, String string2) {
        String string3 = string2;
        String string4 = string.toLowerCase();
        String string5 = string2.toLowerCase();
        if (string5.indexOf(string4) != -1) {
            string3 = "Online Guide";
        } else {
            int n = string2.indexOf(46);
            if (n != -1) {
                string2 = string2.substring(0, n);
                string3 = string2.replace('_', ' ');
            }
        }
        if (db.on()) {
            db.println("getBookName: displayName=" + string3);
        }
        return string3;
    }

    public static void launchCSHelp(HelpSet helpSet, Window window, String string) {
        if (hb == null) {
            KErrorMsg.displayError(null, (EID)KEMC.EID_HELP_BROKER_CREATION_FAILURE);
            return;
        }
        if (helpSet == null) {
            KErrorMsg.displayError(null, (EID)KEMC.EID_HELPID_NOT_FOUND_PARAM_1, (Object)string);
            return;
        }
        try {
            Map map = helpSet.getLocalMap();
            if (!map.isValidID(string, helpSet)) {
                String string2 = KErrorMsg.getString((EID)KEMC.EID_HELPID_NOT_FOUND_PARAM_1, (Object)string);
                CerentDialog.errorDialog(null, string2);
                return;
            }
            Map.ID iD = Map.ID.create((String)string, (HelpSet)helpSet);
            URL uRL = map.getURLFromID(iD);
            if (db.on()) {
                db.println("helpID=" + string + " URL=" + uRL);
            }
            Enumeration enumeration = map.getIDs(uRL);
            while (enumeration.hasMoreElements()) {
                Map.ID iD2 = (Map.ID)enumeration.nextElement();
                URL uRL2 = map.getURLFromID(iD2);
                if (uRL2 == null || iD2.id == null || iD2.id.equals(string) || !uRL.toExternalForm().equals(uRL2.toExternalForm())) continue;
                if (db.on()) {
                    db.println("helpID changed to " + iD2.id + " for TOC highlighting");
                }
                string = iD2.id;
                break;
            }
            hb.setHelpSet(helpSet);
            if (window != null) {
                hb.setActivationWindow(window);
            }
            hb.setCurrentID(string);
            hb.setDisplayed(true);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            String string3 = KErrorMsg.getString((EID)KEMC.EID_HELP_BROKER_CREATION_FAILURE);
            CerentDialog.errorDialog(null, string3);
        }
    }

    private static boolean launchPDF(String string) {
        String string2 = System.getProperty("os.name");
        try {
            if (string2.startsWith("Win")) {
                String string3 = "rundll32 url.dll,FileProtocolHandler " + string;
                Process process = Runtime.getRuntime().exec(string3);
            } else {
                String string4 = "acroread " + string;
                Process process = Runtime.getRuntime().exec(string4);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
        return true;
    }

    static {
        helpInstalled = true;
        platform = 1;
        actionObserver = new ActionObserver();
        docRootDir = preferences.getProperty(PROP_GEN_PATH, PROP_DOC_ROOT, "");
        if (docRootDir == null || docRootDir.length() == 0) {
            helpInstalled = false;
        }
        try {
            hb = new DefaultHelpBroker();
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            String string = KErrorMsg.getString((EID)KEMC.EID_HELP_BROKER_CREATION_FAILURE);
            CerentDialog.errorDialog(null, string);
        }
    }

    static class ActionObserver
    implements ActionListener {
        ActionObserver() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals(HelpMgr.USER_MANUALS)) {
                String string2 = KErrorMsg.getString((EID)KEMC.EID_HELP_MANUAL_ERROR);
                JOptionPane.showMessageDialog(null, string2, "Error", 0);
            } else if (string.equals(HelpMgr.REMOVE)) {
                new HelpMaintDialog(null);
            } else {
                String string3 = (String)((JMenuItem)object).getClientProperty(HelpMgr.BOOK_PATH);
                if (string3 != null) {
                    if (db.on()) {
                        db.println("PDF file path=" + string3);
                    }
                    if (!HelpMgr.launchPDF(string3)) {
                        String string4 = KErrorMsg.getString((EID)KEMC.EID_ACROBAT_READER_REQUIRED);
                        JOptionPane.showMessageDialog(null, string4, "Error", 0);
                    }
                }
            }
        }
    }
}

