/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.TDMTerminology;
import java.util.Arrays;

public class SDHTDMTerminology
extends TDMTerminology {
    String[] FrameTerms_ = new String[]{"", "STM 1"};
    String[] VirtualContainerTerms_ = new String[]{"VC-4", "VC-3", "VC-2", "VC-12", "VC-11"};
    String[] VGroupTerms_ = new String[]{"VT GROUP", "VC GROUP"};
    String[] CardNames_ = new String[]{"STM1", "STM4", "STM16", "STM64", "XCVXL", "E1", "E1N", "E3", "E3N", "DS3I", "DS3IN", "STM4_4", "STM1_8", "STM1E", "STM16_16", "STM64_4", "STM64XFP", "DS1I", "XCVXC"};
    String[] PmStats_ = new String[]{"FC", "EB", "ES", "SES", "OFS", "BBE", "ESR", "SESR", "BBER", "UAS", "PPJC-PDET", "NPJC-PDET", "PPJC-PGEN", "NPJC-PGEN", "PSC", "PSD", "PSC-W", "PSD-W", "PSC-S", "PSD-S", "PSC-R", "PSD-R", "LOSS", "AISS", "SAS", "LBC", "OPT", "OPR", "PJCDIFF", "PJCS-PDET", "PJCS-PGEN"};
    String[] PmStatTypes_ = new String[]{"RS", "MS", "MSFE", "HP", "HPFE", "LP", "LPFE", "L", "LFE", "HP", "PFE", "", "HP", "HP"};
    String[] GeneralTerms_ = new String[]{"VC4", "VC LO", "Multiplex Section", "Regeneration Section", "SDH", "VCT", "VCA", "AU4/VC4", "RS-DCC", "PDI", "MS-DCC"};
    String[] RingTerms_ = new String[]{"SNCP", "MS-SPRing", "MSP-LINEAR"};
    String[] PhysicalLinkTerms_ = new String[]{"STM1", "STM4", "STM16", "STM64"};
    String[] LineCoding_ = new String[]{"JBZS", "B8ZS", "HDB3", "AMI", "ZBTSI", "B6ZS", "B3ZS"};
    String[] LinkPhysicalType_ = new String[]{"STM1", "STM4", "STM16", "STM64"};
    String[] AddCardType_ = new String[]{"STMn", "DSn/En", "Ethernet", "nXP", "OADM", "OSC", "AMPLI", "MD"};
    String[] AddFamilyType_ = new String[]{"DWDM"};
    String[] AdminStateTerms_ = new String[]{"unlocked", "locked, disabled", "locked, maintenance", "unlocked, automaticInService", "locked, outOfGroup"};
    String[] ServiceStateTerms_ = new String[]{"unlocked-enabled", "unlocked-disabled, automaticInService", "locked-enabled, disabled", "locked-enabled, maintenance", "locked-enabled, loopback & maintenance", "unlocked-disabled, automaticInService & mismatchOfEquipment", "unlocked-disabled, automaticInService & softwareDownload", "unlocked-disabled, automaticInService & notInstalled", "unlocked-disabled, mismatchOfEquipment", "unlocked-disabled, softwareDownload", "unlocked-disabled, notInstalled", "locked-disabled, mismatchOfEquipment & maintenance", "locked-disabled, mismatchOfEquipment & unassigned", "locked-disabled, maintenance & notInstalled", "locked-disabled, maintenance & softwareDownload", "locked-disabled, unassigned", "locked-disabled, unassigned & notInstalled", "locked-enabled, disabled & outOfGroup", "locked-enabled, maintenance & outOfGroup", "locked-enabled, loopback & maintenance & outOfGroup", "locked-enabled, failed & maintenance", "locked-enabled, failed & loopback & maintenance", "unlocked-disabled, failed", "unlocked-disabled, automaticInService & failed", "unlocked-disabled, failed & outOfGroup", "locked-disabled, failed & maintenance", "locked-disabled, failed & loopback & maintenance", "locked-disabled, failed & maintenance & outOfGroup", "locked-disabled, failed & loopback & maintenance & outOfGroup", "unlocked-disabled, automaticInService & failed & outOfGroup"};
    private String[] NonStandardServiceStateTerms_ = new String[]{"Up", "Down", "unlocked", "locked", "locked, disabled", "unlocked-disabled"};
    String[] PrimaryStateTerms_ = new String[]{"unlocked", "locked", "locked[Partial]", "locked, outOfGroup", "locked, outOfGroup[Partial]"};
    String[] NetPartialAdminStateTerms_ = new String[]{"locked, disabled-PARTIAL", "locked, maintenance-PARTIAL", "unlocked, automaticInService-PARTIAL", "unlocked-PARTIAL"};
    public int[] circuitTypes = new int[]{0, 4, 5, 6, 8};
    public int highOrderCircuitType = 4;
    public int lowOrderCircuitType = 5;
    public int tunnelCircuitType = 6;
    public int ethernetCircuitType = 0;
    public int loAggCircuitType = 8;
    public int[] circuitSizes = new int[]{9, 10, 11, 12, 13, 14, 15, 28, 16, 26, 17, 18};
    public int[] highOrderCircuitSizes = new int[]{12, 13, 14, 15, 28, 16, 26, 17, 18};
    public int[] lowOrderCircuitSizes = new int[]{9, 10, 11};
    public int baseHighOrderCircuitSize = 12;
    public int tunnelCircuitSize = 12;
    public int ethernetCircuitSize = 12;
    public int loAggCircuitSize = 12;
    protected static SDHTDMTerminology singleton_ = new SDHTDMTerminology();

    public static SDHTDMTerminology instance() {
        return singleton_;
    }

    protected SDHTDMTerminology() {
        this.initialize();
    }

    protected void initialize() {
        ((TDMTerminology)this).FrameTerms_ = this.FrameTerms_;
        ((TDMTerminology)this).VirtualContainerTerms_ = this.VirtualContainerTerms_;
        ((TDMTerminology)this).VGroupTerms_ = this.VGroupTerms_;
        ((TDMTerminology)this).CardNames_ = this.CardNames_;
        ((TDMTerminology)this).PmStats_ = this.PmStats_;
        ((TDMTerminology)this).PmStatTypes_ = this.PmStatTypes_;
        ((TDMTerminology)this).GeneralTerms_ = this.GeneralTerms_;
        ((TDMTerminology)this).RingTerms_ = this.RingTerms_;
        ((TDMTerminology)this).PhysicalLinkTerms_ = this.PhysicalLinkTerms_;
        ((TDMTerminology)this).LineCoding_ = this.LineCoding_;
        ((TDMTerminology)this).LinkPhysicalType_ = this.LinkPhysicalType_;
        ((TDMTerminology)this).AddCardType_ = this.AddCardType_;
        ((TDMTerminology)this).AddFamilyType_ = this.AddFamilyType_;
        ((TDMTerminology)this).ServiceStateTerms_ = this.ServiceStateTerms_;
        ((TDMTerminology)this).PrimaryStateTerms_ = this.PrimaryStateTerms_;
        ((TDMTerminology)this).AdminStateTerms_ = this.AdminStateTerms_;
        ((TDMTerminology)this).NetPartialAdminStateTerms_ = this.NetPartialAdminStateTerms_;
        this.NonStandardServiceStateTerms = this.NonStandardServiceStateTerms_;
        this.ethernetTerm = "HOP";
    }

    protected void staticInitialize() {
        Arrays.sort(this.circuitTypes);
        Arrays.sort(this.circuitSizes);
        Arrays.sort(this.highOrderCircuitSizes);
        Arrays.sort(this.lowOrderCircuitSizes);
        TDMTerminology.circuitTypes = this.circuitTypes;
        TDMTerminology.highOrderCircuitType = this.highOrderCircuitType;
        TDMTerminology.lowOrderCircuitType = this.lowOrderCircuitType;
        TDMTerminology.tunnelCircuitType = this.tunnelCircuitType;
        TDMTerminology.ethernetCircuitType = this.ethernetCircuitType;
        TDMTerminology.loAggCircuitType = this.loAggCircuitType;
        TDMTerminology.circuitSizes = this.circuitSizes;
        TDMTerminology.highOrderCircuitSizes = this.highOrderCircuitSizes;
        TDMTerminology.lowOrderCircuitSizes = this.lowOrderCircuitSizes;
        TDMTerminology.baseHighOrderCircuitSize = this.baseHighOrderCircuitSize;
        TDMTerminology.tunnelCircuitSize = this.tunnelCircuitSize;
        TDMTerminology.ethernetCircuitSize = this.ethernetCircuitSize;
        TDMTerminology.loAggCircuitSize = this.loAggCircuitSize;
        this.ethernetTerm = "HOP";
    }

    public String createPmColumnName(int n, int n2) {
        String string;
        try {
            string = this.getPmStatType(n) == "" ? this.getPmStat(n2) : this.getPmStatType(n) + "-" + this.getPmStat(n2);
        }
        catch (Exception exception) {
            string = "EMPTY";
        }
        return string;
    }

    public String getEqType(int n) {
        String string = null;
        switch (n) {
            case 9: {
                string = "STM1";
                break;
            }
            case 106: {
                string = "STM1_8";
                break;
            }
            case 10: {
                string = "STM4";
                break;
            }
            case 85: {
                string = "STM4_4";
                break;
            }
            case 11: {
                string = "STM16";
                break;
            }
            case 87: {
                string = "STM16_16";
                break;
            }
            case 60: {
                string = "STM64";
                break;
            }
            case 86: {
                string = "STM64_4";
                break;
            }
            case 28: {
                string = "STM1_PORT";
                break;
            }
            case 29: {
                string = "STM4_PORT";
                break;
            }
            case 30: {
                string = "STM16_PORT";
                break;
            }
            case 61: {
                string = "STM64_PORT";
            }
        }
        return string;
    }

    public String getBackplaneTerm(boolean bl) {
        String string = "MIC-C/T/P";
        return string;
    }
}

