/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.ICircuitSize;
import cerent.util.AbstractLoNum;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.List;

public class SonetLoNum
extends AbstractLoNum {
    int vtNum;
    int vtGroupNum;
    int vtNumInGroup;

    public SonetLoNum(int n) {
        this(n, CircuitSize.SIZE_VT_1_5);
    }

    public SonetLoNum(int n, ICircuitSize iCircuitSize) {
        super(SonetLoNum.GetType(iCircuitSize.getEnum()));
        this.init(n);
    }

    public static int GetGroupNum(int n) {
        return SonetLoNum.GetGroupNum(n, SonetLoNum.NumOfGroups());
    }

    public static int GetNumInGroup(int n) {
        return SonetLoNum.GetNumInGroup(n, SonetLoNum.NumOfGroups());
    }

    public SonetLoNum(int n, int n2) {
        this(n, n2, CircuitSize.SIZE_VT_1_5);
    }

    public SonetLoNum(int n, int n2, ICircuitSize iCircuitSize) {
        super(SonetLoNum.GetType(iCircuitSize.getEnum()));
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        int n3 = SonetLoNum.GetLoVal(n, n2, this.numOfGroups());
        this.init(n3, n, n2);
    }

    private void init(int n) {
        int n2 = SonetLoNum.GetGroupNum(n);
        int n3 = SonetLoNum.GetNumInGroup(n);
        this.init(n, n2, n3);
    }

    private void init(int n, int n2, int n3) {
        this.vtNum = n;
        this.vtGroupNum = n2;
        this.vtNumInGroup = n3;
        this.validate();
    }

    public static boolean isValid(int n, int n2) {
        return SonetLoNum.isValid(n, n2, 0);
    }

    public static boolean isValid(int n, int n2, int n3) {
        return n > 0 && n <= 7 && n2 > 0 && (n3 == 0 ? n2 <= 4 : n2 <= 3);
    }

    private void validate() {
        if (!SonetLoNum.isValid(this.vtGroupNum, this.vtNumInGroup, this.type)) {
            throw new IllegalStateException("This Sonet VT number is invalid " + this.prettyString());
        }
    }

    public int groupSize() {
        return SonetLoNum.GroupSize(this.type);
    }

    public static int GroupSize() {
        return SonetLoNum.GroupSize(0);
    }

    public static int GroupSize(int n) {
        return n == 0 ? 4 : 3;
    }

    public static int NumOfGroups() {
        return 7;
    }

    public int numOfGroups() {
        return SonetLoNum.NumOfGroups();
    }

    public int getFramingType() {
        return 0;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            SonetLoNum sonetLoNum = (SonetLoNum)object;
            if (this.type != sonetLoNum.type) {
                return this.type - sonetLoNum.type;
            }
            if (this.vtGroupNum != sonetLoNum.vtGroupNum) {
                return this.vtGroupNum - sonetLoNum.vtGroupNum;
            }
            return this.vtNumInGroup - sonetLoNum.vtNumInGroup;
        }
        return n;
    }

    public String prettyString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sonet VT Number (" + this.vtNum);
        stringBuffer.append(SonetLoNum.GetTypeString(this.getType()) + "): ");
        stringBuffer.append("vtGroupNum=" + this.vtGroupNum);
        stringBuffer.append(",vtNumInGroup=" + this.vtNumInGroup);
        return stringBuffer.toString();
    }

    public int getLoVal() {
        return this.vtNum;
    }

    public int getGroupNum() {
        return SonetLoNum._GetGroupNum(this.vtGroupNum);
    }

    public static int _GetGroupNum(int n) {
        return n;
    }

    public int getNumInGroup() {
        return SonetLoNum._GetNumInGroup(this.vtNumInGroup);
    }

    public static int _GetNumInGroup(int n) {
        return n;
    }

    public int getVtNum() {
        return this.vtNum;
    }

    public int getVtGroupNum() {
        return this.vtGroupNum;
    }

    public int getVtNumInGroup() {
        return this.vtNumInGroup;
    }

    public boolean isVt1_5Num() {
        return this.type == 0;
    }

    public boolean isVt2Num() {
        return this.type == 4;
    }

    public static List getAllLoNums(ILoNum iLoNum, int n) {
        return SonetLoNum.getAllLoNumsByCircuitSize(iLoNum, SonetLoNum.GetCorrespondingCircuitSize(n));
    }

    public static List getAllLoNumsByCircuitSize(ILoNum iLoNum, int n) {
        if (iLoNum != null && iLoNum.getFramingType() != 0) {
            throw new IllegalArgumentException("Invalid ILoNum constraint!");
        }
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize(n);
        switch (n) {
            case 0: 
            case 30: {
                ArrayList<SonetLoNum> arrayList = new ArrayList<SonetLoNum>();
                AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
                int n2 = SonetLoNum.GetType(n);
                int n3 = abstractLoNum == null ? SonetLoNum.NumOfGroups() : abstractLoNum.getGroupNum();
                int n4 = abstractLoNum == null ? SonetLoNum.GroupSize(n2) : abstractLoNum.getNumInGroup();
                for (int i = 1; i <= n3; ++i) {
                    for (int j = 1; j <= n4; ++j) {
                        arrayList.add(new SonetLoNum(i, j, iCircuitSize));
                    }
                }
                return arrayList;
            }
        }
        throw new IllegalArgumentException("Invalid ckt size!");
    }

    public static ILoNum getFirstLoNum(int n) {
        switch (n) {
            case 0: {
                return new SonetLoNum(1, 1, CircuitSize.SIZE_VT_1_5);
            }
            case 4: {
                return new SonetLoNum(1, 1, CircuitSize.SIZE_VT_2);
            }
        }
        throw new IllegalArgumentException("Invalid type!");
    }
}

