/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.BusEvent;
import cerent.util.KDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DefaultStatusItem
implements Observer,
ActionListener {
    private static final KDebug db = new KDebug("DefaultStatusItem");
    private static final int DELAY = 500;
    private Timer blinkTimer = new Timer(500, this);
    private JComponent component;

    public DefaultStatusItem(JComponent jComponent) {
        this.component = jComponent;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getStatusName() {
        if (this.component instanceof JLabel) {
            return ((JLabel)this.component).getText();
        }
        if (this.component instanceof AbstractButton) {
            return ((AbstractButton)this.component).getText();
        }
        return this.component.getName();
    }

    public void blink(boolean bl) {
        if (bl) {
            this.blinkTimer.start();
        } else {
            this.blinkTimer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = this.component.getForeground();
        Color color2 = this.component.getBackground();
        this.component.setForeground(color2);
        this.component.setOpaque(true);
        this.component.setBackground(color);
    }

    public synchronized void update(Observable observable, Object object) {
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            String string = (String)busEvent.getSource();
            Object object2 = busEvent.getEvent();
            if (string == null && object2 == null) {
                if (db.on()) {
                    db.println("busEvent source or event is null");
                }
                return;
            }
            if (db.on()) {
                db.println("busEvent source=" + string + ", event=" + object2);
            }
            if (object2 instanceof Integer) {
                if (db.on()) {
                    db.println("Setting status for " + this.getStatusName() + " to " + object2);
                }
                this.setItemState((Integer)object2);
            } else if (object2 instanceof Boolean) {
                if (db.on()) {
                    db.println("Setting blink mode for " + this.getStatusName() + " to " + object2);
                }
                this.blink((Boolean)object2);
            } else if (db.on()) {
                db.println("Unknown event");
            }
        }
    }

    public void setItemState(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateLabelState(n);
            Dimension dimension = this.component.getSize();
            this.component.paintImmediately(0, 0, dimension.width, dimension.height);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            DefaultStatusItem.this.updateLabelState(n);
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block2;
                            db;
                            KDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
            });
        }
    }

    private void updateLabelState(int n) {
        switch (n) {
            default: {
                this.component.setForeground(Color.gray);
                this.component.setOpaque(true);
                this.component.setBackground(Color.lightGray);
                break;
            }
            case 2: {
                this.component.setForeground(Color.black);
                this.component.setOpaque(true);
                this.component.setBackground(Color.lightGray);
                break;
            }
            case 1: {
                this.component.setForeground(Color.black);
                this.component.setOpaque(true);
                this.component.setBackground(Color.green);
            }
        }
    }
}

