/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.SortDirectionIconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DetailedDialog
extends UDialog
implements ActionListener,
Runnable {
    private JTextArea jta;
    private JLabel iconLabel;
    private JPanel contentPane;
    private JPanel mainPane;
    private JPanel detailsPane;
    private JTextArea detailsArea;
    private JButton bClose;
    private JButton bDetails;
    private boolean detailsOn = false;
    private boolean needToggle = false;
    private boolean needRepacking = false;
    private LinkedList detailsList = new LinkedList();
    private static final int PREF_WIDTH = 400;
    private static final int PREF_HEIGHT = 200;
    private static final Dimension PREF_DETAILS = new Dimension(400, 200);
    private static final Dimension PREF_PANE = new Dimension(400, 25);

    public static DetailedDialog instance(Frame frame, String string) {
        return new DetailedDialog(frame, string);
    }

    public static DetailedDialog instance(Dialog dialog, String string) {
        return new DetailedDialog(dialog, string);
    }

    private DetailedDialog(Frame frame, String string) {
        super(frame, string, true);
        this.setLocationRelativeTo(frame);
        this.setResizable(true);
    }

    private DetailedDialog(Dialog dialog, String string) {
        super(dialog, string, true);
        this.setLocationRelativeTo(dialog);
        this.setResizable(true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.contentPane = jPanel;
        this.detailsPane = this.createDetailsPane();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        this.mainPane = new JPanel(borderLayout);
        jPanel.add((Component)this.mainPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.bClose = new JButton("OK");
        this.bClose.addActionListener(this);
        this.bDetails = new JButton();
        this.updateDetailsButton();
        this.bDetails.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(this.bClose);
        jPanel2.add(this.bDetails);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.detailsPane.setVisible(false);
        jPanel.add((Component)this.detailsPane, gridBagConstraints);
    }

    public void setContents(JPanel jPanel) {
        this.mainPane.add(jPanel);
        this.needRepacking = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void setText(String string, ImageIcon imageIcon) {
        Font font;
        if (imageIcon == null) {
            font = new JLabel().getFont();
        } else {
            if (this.iconLabel == null) {
                JPanel jPanel = new JPanel(new BorderLayout());
                this.iconLabel = new JLabel(imageIcon);
                jPanel.add((Component)this.iconLabel, "North");
                this.mainPane.add((Component)jPanel, "West");
            } else {
                this.iconLabel.setIcon(imageIcon);
            }
            font = this.iconLabel.getFont();
        }
        if (this.jta == null) {
            this.jta = new JTextArea(string);
            this.jta.setEditable(false);
            this.jta.setLineWrap(true);
            this.jta.setWrapStyleWord(true);
            this.jta.setBackground(this.mainPane.getBackground());
            this.jta.setFont(font);
            this.mainPane.add((Component)this.jta, "Center");
        } else {
            this.jta.setText(string);
        }
        this.pack();
        this.needRepacking = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            this.detailsList.add(string);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    private JPanel createDetailsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.detailsArea = new JTextArea();
        this.detailsArea.setEditable(false);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.setTabSize(3);
        jPanel.add((Component)new UScrollPane(this.detailsArea), "Center");
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jPanel;
    }

    private void toggleDetails() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.detailsOn = !this.detailsOn;
            this.detailsPane.setPreferredSize(new Dimension(this.contentPane.getWidth(), 200));
            this.detailsPane.setVisible(this.detailsOn);
            this.updateDetailsButton();
            this.pack();
            this.needRepacking = false;
            this.needToggle = false;
        } else {
            this.needToggle = true;
            SwingUtilities.invokeLater(this);
        }
    }

    private void updateDetailsButton() {
        this.bDetails.setIcon(SortDirectionIconFactory.getIcon(this.detailsOn));
        if (this.detailsOn) {
            this.bDetails.setText("Hide Details");
        } else {
            this.bDetails.setText("Show Details");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            if (actionEvent.getSource() == this.bDetails) {
                this.toggleDetails();
            } else if (actionEvent.getSource() == this.bClose) {
                this.hide();
            }
        }
    }

    public void showDetails() {
        if (!this.detailsOn) {
            this.toggleDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            Iterator iterator = this.detailsList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.detailsArea.append(string);
                bl = true;
            }
            this.detailsList.clear();
        }
        if (bl) {
            this.detailsArea.paintImmediately(this.detailsArea.getBounds());
            this.contentPane.repaint();
        }
        if (this.needToggle) {
            this.toggleDetails();
        }
        if (this.needRepacking) {
            this.pack();
            this.needRepacking = false;
        }
    }
}

