/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DetailedLog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DetailedLogPane
extends JPanel
implements Runnable {
    private JTree tree;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
    private DefaultTreeModel model;
    private boolean timestamp = false;
    static final Icon ICON_INFO = WindowHelper.getIcon(DetailedLogPane.class, "/images/icons/informational16.gif");
    static final Icon ICON_WARNING = WindowHelper.getIcon(DetailedLogPane.class, "/images/icons/warning16.gif");
    static final Icon ICON_ERROR = WindowHelper.getIcon(DetailedLogPane.class, "/images/icons/errorb16.gif");
    static final Icon[] ICON_ARRAY = new Icon[]{null, ICON_INFO, ICON_WARNING, ICON_ERROR};
    static final Icon ICON_EXC = WindowHelper.getIcon(DetailedLogPane.class, "/images/icons/lightening16.gif");
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private int hiWater = 250;
    private int loWater = 200;
    private boolean addToTop = false;
    private JScrollPane sp;
    private JViewport vp;

    public DetailedLogPane(DetailedLog detailedLog, boolean bl, boolean bl2) {
        super(new BorderLayout());
        if (detailedLog != null) {
            this.root.add(this.createTreeNode(detailedLog));
        }
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.sp = new UScrollPane(this.tree);
        this.add(this.sp);
        this.tree.setRootVisible(false);
        this.timestamp = bl;
        this.addToTop = bl2;
        this.tree.setCellRenderer(new DlRenderer(this.timestamp));
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setScrollsOnExpand(true);
        this.vp = this.sp.getViewport();
    }

    private DefaultMutableTreeNode getTreeNode(DetailedLog detailedLog) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; defaultMutableTreeNode == null && i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (defaultMutableTreeNode2.getUserObject() != detailedLog) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createTreeNode(DetailedLog detailedLog) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(detailedLog);
        return this.createTreeNodeChildren(defaultMutableTreeNode, detailedLog);
    }

    private DefaultMutableTreeNode createTreeNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, DetailedLog detailedLog) {
        Object object;
        Object object2;
        Exception exception = detailedLog.getException();
        if (exception != null) {
            object2 = new DefaultMutableTreeNode(exception);
            defaultMutableTreeNode.add((MutableTreeNode)object2);
            object = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)object));
            String string = ((StringWriter)object).toString();
            int n = string.indexOf(10);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = this.stripTrailingLF(string);
            ((DefaultMutableTreeNode)object2).add(new DefaultMutableTreeNode(string));
        }
        object2 = detailedLog.getChildren().iterator();
        while (object2.hasNext()) {
            object = (DetailedLog)object2.next();
            defaultMutableTreeNode.add(this.createTreeNode((DetailedLog)object));
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetailedLog(DetailedLog detailedLog, boolean bl) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.createTreeNode(detailedLog);
        if (detailedLog.getDesc() == null) {
            detailedLog.setDesc("");
        }
        Serializable serializable = this.model;
        synchronized (serializable) {
            n = this.addToTop ? 0 : this.root.getChildCount();
            this.model.insertNodeInto(defaultMutableTreeNode, this.root, n);
        }
        this.enforceThreshold();
        serializable = new TreePath(this.model.getPathToRoot(defaultMutableTreeNode));
        this.tree.makeVisible((TreePath)serializable);
        if (bl) {
            this.tree.scrollRowToVisible(n);
        }
    }

    public void updateDetailedLog(DetailedLog detailedLog, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(detailedLog);
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.removeAllChildren();
            this.createTreeNodeChildren(defaultMutableTreeNode, detailedLog);
            TreePath treePath = new TreePath(this.model.getPathToRoot(defaultMutableTreeNode));
            this.tree.makeVisible(treePath);
            if (bl) {
                this.tree.scrollPathToVisible(treePath);
            }
        }
        this.model.nodeChanged(defaultMutableTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.root = new DefaultMutableTreeNode("");
        DefaultTreeModel defaultTreeModel = this.model;
        synchronized (defaultTreeModel) {
            this.model.setRoot(this.root);
        }
    }

    public void setThreshold(int n, int n2) {
        if (this.hiWater < 0) {
            this.hiWater = 0;
        }
        if (n >= n2) {
            n = n2 / 2;
        } else if (this.loWater < 0) {
            this.loWater = 0;
        }
        this.hiWater = n2;
        this.loWater = n;
        this.enforceThreshold();
    }

    private void enforceThreshold() {
        if (this.hiWater > 0 && this.root.getChildCount() > this.hiWater) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DefaultTreeModel defaultTreeModel = this.model;
        synchronized (defaultTreeModel) {
            while (this.root.getChildCount() > this.loWater) {
                DefaultMutableTreeNode defaultMutableTreeNode = this.addToTop ? (DefaultMutableTreeNode)this.root.getLastChild() : (DefaultMutableTreeNode)this.root.getFirstChild();
                this.model.removeNodeFromParent(defaultMutableTreeNode);
            }
        }
    }

    public int getDlCount() {
        return this.root.getChildCount();
    }

    public List getDlList() {
        Enumeration<TreeNode> enumeration = this.root.children();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            linkedList.add(defaultMutableTreeNode.getUserObject());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeDetailedLog(DetailedLog detailedLog) {
        int n = -1;
        DefaultTreeModel defaultTreeModel = this.model;
        synchronized (defaultTreeModel) {
            int n2 = this.root.getChildCount();
            for (int i = 0; i < n2; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
                if (defaultMutableTreeNode.getUserObject() != detailedLog) continue;
                this.model.removeNodeFromParent(defaultMutableTreeNode);
                if (this.addToTop) {
                    n = i;
                    break;
                }
                n = n2 - i - 1;
                break;
            }
        }
        return n;
    }

    private String stripTrailingLF(String string) {
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) == '\n') {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String string, String string2, String string3, String string4, String string5) {
        byte by = 3;
        File file = PersistentFileChooserDialog.getFile(JOptionPane.getFrameForComponent(this), string, string2, by, string3, string4, 4);
        if (file != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileOutputStream(file, false));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                long l = System.currentTimeMillis();
                String string6 = simpleDateFormat.format(new Date(l));
                printWriter.println("######################################");
                printWriter.println("#   " + string6 + "              #");
                printWriter.println("######################################");
                if (string5 != null) {
                    printWriter.println();
                    printWriter.println(string5);
                    printWriter.println();
                }
                List list = this.getDlList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DetailedLog detailedLog = (DetailedLog)iterator.next();
                    printWriter.println();
                    printWriter.println(simpleDateFormat.format(new Date(detailedLog.getTime())) + " ----------------------------------------------------");
                    detailedLog.prettyPrint(printWriter);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Unable to save to " + file.getAbsolutePath() + "\n" + iOException.getMessage(), "Error Saving", 0);
            }
            finally {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    class DlRenderer
    extends DefaultTreeCellRenderer {
        private boolean time;

        public DlRenderer(boolean bl) {
            this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.time = bl;
            this.setUI(new MultiLineLabelUI());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Serializable serializable;
            Icon icon = null;
            if (object instanceof DefaultMutableTreeNode) {
                serializable = (DefaultMutableTreeNode)object;
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof DetailedLog) {
                    DetailedLog detailedLog = (DetailedLog)object2;
                    icon = ICON_ARRAY[detailedLog.getType()];
                    String string = detailedLog.getDesc();
                    string = DetailedLogPane.this.stripTrailingLF(string);
                    if (this.time && ((DefaultMutableTreeNode)serializable).getLevel() == 1) {
                        string = dateFormat.format(new Date(detailedLog.getTime())) + "   " + string;
                    }
                    object = string;
                } else if (object2 instanceof Exception) {
                    icon = ICON_EXC;
                    object = object2.toString();
                }
            }
            serializable = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            ((JLabel)serializable).setIcon(icon);
            return serializable;
        }
    }
}

