/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.IJobListener;
import cerent.util.job.JobInfo;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class JobGroup {
    private ArrayList jobInfoList = new ArrayList(0);
    private String name;
    private HashMap map = new HashMap();
    private IJobListener jobListener = null;
    private IJobGroupListener jobGroupListener = null;
    private Object userObject = null;

    public JobGroup(IJobControl iJobControl, IJobListener iJobListener, Object object) {
        this.jobListener = iJobListener;
        IJobControl[] iJobControlArray = new IJobControl[]{iJobControl};
        this.init(iJobControlArray, object);
    }

    public JobGroup(IJobControl[] iJobControlArray, IJobListener iJobListener, Object object) {
        this.jobListener = iJobListener;
        this.init(iJobControlArray, object);
    }

    public JobGroup(IJobControl[] iJobControlArray, IJobGroupListener iJobGroupListener, Object object) {
        this.jobGroupListener = iJobGroupListener;
        this.init(iJobControlArray, object);
    }

    public JobGroup(IJobControl[] iJobControlArray, IJobListener iJobListener, IJobGroupListener iJobGroupListener, Object object) {
        this.jobListener = iJobListener;
        this.jobGroupListener = iJobGroupListener;
        this.init(iJobControlArray, object);
    }

    private void init(IJobControl[] iJobControlArray, Object object) {
        this.userObject = object;
        for (int i = 0; i < iJobControlArray.length; ++i) {
            JobInfo jobInfo = new JobInfo(this, iJobControlArray[i]);
            this.jobInfoList.add(jobInfo);
            if (this.jobGroupListener == null) continue;
            this.map.put(jobInfo, jobInfo);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.jobInfoList.size();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public JobStatus[] getJobStatusList() {
        int n = 0;
        JobStatus[] jobStatusArray = new JobStatus[this.jobInfoList.size()];
        Iterator iterator = this.jobInfoList.iterator();
        while (iterator.hasNext()) {
            jobStatusArray[n++] = ((JobInfo)iterator.next()).getJobStatus();
        }
        return jobStatusArray;
    }

    public IJobControl[] getJobList() {
        int n = 0;
        IJobControl[] iJobControlArray = new IJobControl[this.jobInfoList.size()];
        Iterator iterator = this.jobInfoList.iterator();
        while (iterator.hasNext()) {
            iJobControlArray[n++] = ((JobInfo)iterator.next()).getJob();
        }
        return iJobControlArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobStatusChange(JobInfo jobInfo) {
        if (this.jobListener != null) {
            switch (jobInfo.getJobStatus().value()) {
                case 0: {
                    this.jobListener.jobWaiting(this, jobInfo.getJob(), jobInfo.getJobStatus(), this.getUserObject());
                    break;
                }
                case 1: {
                    this.jobListener.jobRunning(this, jobInfo.getJob(), jobInfo.getJobStatus(), this.getUserObject());
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.jobListener.jobFinished(this, jobInfo.getJob(), jobInfo.getJobStatus(), this.getUserObject());
                }
            }
        }
        if (this.jobGroupListener != null) {
            ArrayList arrayList = this.jobInfoList;
            synchronized (arrayList) {
                HashMap hashMap = this.map;
                synchronized (hashMap) {
                    if (this.map.size() > 0) {
                        JobStatus jobStatus = jobInfo.getJobStatus();
                        if (jobStatus.value() == 2 || jobStatus.value() == 3 || jobStatus.value() == 4) {
                            this.map.remove(jobInfo);
                        }
                        if (this.map.size() == 0) {
                            this.jobGroupListener.jobGroupFinished(this);
                        }
                    }
                }
            }
        }
    }

    JobInfo[] getJobInfoList() {
        return this.jobInfoList.toArray(new JobInfo[0]);
    }
}

