/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.RadarChartDraw;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;

public class AreaRadarChartDraw
extends RadarChartDraw {
    protected Point firstLast = null;
    JCLineStyle outlineStyle = null;
    protected MinMax xlim = null;
    protected MinMax ylim = null;
    protected AreaPolygon[] areaPolygon;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(this.xlim, this.ylim);
        boolean bl = this.yaxis.isLogarithmic();
        if (!this.cachePlotData && n3 == -1) {
            if (this.areaPolygon == null) {
                this.areaPolygon = new AreaPolygon[this.seriesList.size()];
            }
            return;
        }
        this.areaPolygon = new AreaPolygon[this.seriesList.size()];
        int n4 = n3 == -1 ? 0 : n3;
        int n5 = n3 == -1 ? this.seriesList.size() : n3 + 1;
        this.firstPoint = n = this.getFirstPoint(this.seriesList, n4, n5);
        this.lastPoint = n2 = this.getLastPoint(this.seriesList, n4, n5);
        Object var7_7 = null;
        int n6 = n4;
        while (n6 < n5) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                int n7 = n2 - n + 1;
                this.areaPolygon[n6] = new AreaPolygon();
                this.areaPolygon[n6].series = n6;
                double[] dArray = this.getYVals(chartDataViewSeries);
                double d = JCChartUtil.getRadarAngle(2, n7, 0, this.xaxis.isReversed());
                double d2 = dArray[n];
                if (bl && d2 <= 0.0) {
                    d2 = this.holeValue;
                }
                boolean bl2 = false;
                int n8 = n + 1;
                while (n8 <= n2) {
                    if (n8 < dArray.length) {
                        double d3 = JCChartUtil.getRadarAngle(2, n7, n8 - n, false);
                        double d4 = dArray[n8];
                        if (bl && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        bl2 = this.areaPolygonAddPoints(d, d2, d3, d4, n8, this.areaPolygon[n6], bl2);
                        d = d3;
                        d2 = d4;
                    }
                    ++n8;
                }
                if (this.areaPolygon[n6].poly.npoints == 0) {
                    this.areaPolygon[n6] = null;
                }
            }
            ++n6;
        }
    }

    protected int getFirstPoint(List list, int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = n;
        while (n4 < n2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n4);
            int n5 = chartDataViewSeries.getFirstPoint();
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    protected int getLastPoint(List list, int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = n;
        while (n4 < n2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n4);
            int n5 = chartDataViewSeries.getLastPoint();
            if (n5 < n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        double[] dArray = chartDataViewSeries.getY();
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = dArray[n] == this.holeValue || this.yaxis.isLogarithmic() && dArray[n] <= 0.0 ? Double.MAX_VALUE : dArray[n];
            ++n;
        }
        return dArray2;
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1, true);
    }

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        if (this.seriesList == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.areaPolygon == null) {
            return;
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        this.outlineStyle = this.dataObject.getOutlineStyle();
        int n3 = bl ? 0 : this.areaPolygon.length - 1;
        while (!bl ? n3 >= 0 : n3 < this.areaPolygon.length) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n3);
            }
            if (this.areaPolygon[n3] != null && (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3)).isVisible() && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                Rectangle rectangle2 = this.areaPolygon[n3].poly.getBounds();
                int n4 = this.calcFillOrientation(rectangle2, this.yaxis.origin.value, this.xaxis.reversed, this.yaxis.reversed);
                jCFillStyle.updateFillOrientation(rectangle2, n4);
                jCFillStyle.fillOutlinePolygon(graphics, this.areaPolygon[n3].poly, this.outlineStyle);
                jCFillStyle.resetFillOrientation();
                if (defineShape != null) {
                    this.defineAreaShapes(defineShape, graphics, jCFillStyle, this.areaPolygon[n3], chartDataViewSeries);
                }
                if (!this.cachePlotData) {
                    this.areaPolygon[n3] = null;
                }
            }
            n3 += bl ? 1 : -1;
        }
    }

    private Point getPixelPolar(double d, double d2) {
        return this.yaxis.toPixelPolar(d, d2, true);
    }

    private boolean areaPolygonAddPoints(double d, double d2, double d3, double d4, int n, AreaPolygon areaPolygon, boolean bl) {
        double d5 = d2;
        double d6 = d4;
        if (bl && d5 == this.holeValue) {
            double d7 = d5 = this.yaxis.isReversed() ? this.yaxis.max.value : this.yaxis.min.value;
        }
        if (d6 == this.holeValue) {
            d6 = this.yaxis.isReversed() ? this.yaxis.max.value : this.yaxis.min.value;
        }
        Point point = null;
        if (bl) {
            point = this.getPixelPolar(d3, d6);
            areaPolygon.poly.addPoint(point.x, point.y);
            areaPolygon.endPoint = n;
        } else {
            point = this.getPixelPolar(d, d5);
            areaPolygon.poly.addPoint(point.x, point.y);
            point = this.getPixelPolar(d3, d6);
            areaPolygon.poly.addPoint(point.x, point.y);
            areaPolygon.startPoint = n - 1;
            areaPolygon.endPoint = n;
        }
        return true;
    }

    protected int calcFillOrientation(Rectangle rectangle, double d, boolean bl, boolean bl2) {
        return 6;
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        Point point = null;
        point = !this.yaxis.isReversed() ? this.yaxis.toPixelPolar(0.0, this.yaxis.getMin(), true) : this.yaxis.toPixelPolar(0.0, this.yaxis.getMax(), true);
        int n = areaPolygon.startPoint;
        while (n <= areaPolygon.endPoint) {
            int n2 = n;
            int n3 = -1;
            n3 = n2 > areaPolygon.startPoint ? n2 - 1 : areaPolygon.endPoint;
            int n4 = -1;
            n4 = n2 < areaPolygon.endPoint ? n2 + 1 : areaPolygon.startPoint;
            Polygon polygon = null;
            int n5 = areaPolygon.poly.xpoints[n2];
            int n6 = areaPolygon.poly.ypoints[n2];
            if (n5 != point.x || n6 != point.y) {
                polygon = new Polygon();
                polygon.addPoint(point.x, point.y);
                int n7 = areaPolygon.poly.xpoints[n3];
                int n8 = areaPolygon.poly.ypoints[n3];
                if (n7 != point.x || n8 != point.y) {
                    n7 -= (int)((double)(n7 - n5) / 2.0);
                    n8 -= (int)((double)(n8 - n6) / 2.0);
                    polygon.addPoint(n7, n8);
                }
                polygon.addPoint(n5, n6);
                int n9 = areaPolygon.poly.xpoints[n4];
                int n10 = areaPolygon.poly.ypoints[n4];
                if (n9 != point.x || n10 != point.y) {
                    n9 += (int)((double)(n5 - n9) / 2.0);
                    n10 += (int)((double)(n6 - n10) / 2.0);
                    polygon.addPoint(n9, n10);
                }
            }
            if (polygon != null) {
                defineShape.beginShape(new JCDataIndex(n, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
            }
            ++n;
        }
    }

    public JCDataIndex pick(Point point, int n) {
        return this.pick(point, n, false);
    }

    public JCDataIndex pick(Point point, int n, boolean bl) {
        JCDataIndex jCDataIndex = null;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        JCDataCoord jCDataCoord = this.yaxis.toDataPolar(n2, n3);
        if (jCDataCoord.y > this.yaxis.max.value) {
            return jCDataIndex;
        }
        int n4 = bl ? 0 : this.areaPolygon.length - 1;
        n4 = bl ? 0 : this.areaPolygon.length - 1;
        while (!bl ? n4 >= 0 : n4 < this.areaPolygon.length) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n4);
            }
            if (this.areaPolygon[n4] != null && this.areaPolygon[n4].poly.contains(n2, n3)) {
                jCDataIndex = this.findClosestPointInSeries(n4, n, n2, n3, jCDataCoord);
                jCDataIndex.distance = 0;
                break;
            }
            n4 += bl ? 1 : -1;
        }
        if (bl ? n4 >= this.areaPolygon.length : n4 < 0) {
            switch (n) {
                case 1: 
                case 2: {
                    jCDataIndex = super.pick(point, n);
                    break;
                }
                default: {
                    jCDataIndex = this.pickPolygonXY(n2, n3, jCDataCoord);
                }
            }
        }
        return jCDataIndex;
    }

    private JCDataIndex pickPolygonXY(int n, int n2, JCDataCoord jCDataCoord) {
        JCDataIndex jCDataIndex = null;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.areaPolygon.length) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n4);
            }
            if (this.areaPolygon[n4] != null) {
                double d2 = JCChartUtil.getPolygonDistance(n, n2, this.areaPolygon[n4].poly);
                if (d2 < d) {
                    n3 = n4;
                    d = d2;
                }
                if (d2 == 0.0) break;
            }
            ++n4;
        }
        if (n3 >= 0) {
            jCDataIndex = this.findClosestPointInSeries(n3, 0, n, n2, jCDataCoord);
            jCDataIndex.distance = (int)d;
        }
        return jCDataIndex;
    }
}

