/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCDataIndex;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class JCDefaultChartLabelManager
implements JCChartLabelManager,
Serializable {
    public static final String ERRMSG_INVALID_LABEL_INDEX = "Invalid ChartLabel index";
    protected Vector labels = new Vector();
    protected Vector dwellLabels = null;
    protected JCChartLabel currentDwellLabel = null;
    protected Hashtable autoLabelListHashtable = new Hashtable();
    protected JCChart parentChart = null;

    public void setParentChart(JCChart jCChart) {
        this.parentChart = jCChart;
    }

    public JCChart getParentChart() {
        return this.parentChart;
    }

    public void paintConnectors(Graphics graphics) {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || jCChartLabel.component == null || !jCChartLabel.component.isShowing() || !jCChartLabel.isConnected() || !jCChartLabel.isDwellLabel()) continue;
            jCChartLabel.drawConnector(graphics);
        }
    }

    public void addChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.appendChartLabel(jCChartLabel);
        jCChartLabel.setChanged(true, 2);
    }

    protected void appendChartLabel(JCChartLabel jCChartLabel) {
        Changeable changeable;
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            changeable = (JCChartLabel)enumeration.nextElement();
            if (changeable == null || changeable != jCChartLabel) continue;
            return;
        }
        this.labels.addElement(jCChartLabel);
        changeable = this.getParentChart();
        if (!jCChartLabel.isDwellLabel() && changeable != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                ((Container)((Object)changeable)).add((Component)jCChartLabel.line, 0);
            }
            ((Container)((Object)changeable)).add((Component)jCChartLabel.component, 0);
        } else {
            this.addToDwellLabels(jCChartLabel);
        }
        jCChartLabel.setParentManager(this);
        JCDataIndex jCDataIndex = jCChartLabel.getDataIndex();
        if (jCDataIndex != null && jCDataIndex.getDataView() == null) {
            jCDataIndex.setDataView(((JCChart)changeable).getDataView(0));
        }
    }

    public void addToDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels != null && this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        if (jCChartLabel.isDwellLabel()) {
            if (this.dwellLabels == null) {
                this.dwellLabels = new Vector();
                JCChart jCChart = this.getParentChart();
                if (jCChart != null) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.registerComponent(jCChart);
                }
            }
            this.dwellLabels.addElement(jCChartLabel);
        }
    }

    public boolean locateCurrentDwellLabel(int n, int n2) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.dwellLabels != null && this.dwellLabels.size() != 0) {
            List list = jCChart.getDataView();
            if (list == null || list.size() <= 0) {
                this.currentDwellLabel = null;
                return false;
            }
            JCDataIndex[] jCDataIndexArray = new JCDataIndex[list.size()];
            Iterator iterator = list.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                jCDataIndexArray[n3] = jCChart.pick(new Point(n, n2), (ChartDataView)iterator.next());
                ++n3;
            }
            JCChartLabel jCChartLabel = null;
            int n4 = Integer.MAX_VALUE;
            Enumeration enumeration = this.dwellLabels.elements();
            while (enumeration.hasMoreElements()) {
                JCChartLabel jCChartLabel2 = (JCChartLabel)enumeration.nextElement();
                if (jCChartLabel2 == null) continue;
                JCDataIndex jCDataIndex = null;
                int n5 = list.indexOf(jCChartLabel2.getDataView());
                if (n5 >= 0) {
                    jCDataIndex = jCDataIndexArray[n5];
                }
                if (jCDataIndex == null || !jCChartLabel2.shouldPopupHere(jCDataIndex) || jCDataIndex.getDistance() > n4) continue;
                jCChartLabel = jCChartLabel2;
                n4 = jCDataIndex.getDistance();
            }
            if (jCChartLabel != null) {
                this.currentDwellLabel = jCChartLabel;
                return true;
            }
            this.currentDwellLabel = null;
            return false;
        }
        this.currentDwellLabel = null;
        return false;
    }

    public Point getCurrentDwellLabelAttachPoint() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getAttachPoint();
        }
        return null;
    }

    public JComponent getCurrentDwellLabelComponent() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getComponent();
        }
        return null;
    }

    public JCChartLabel getCurrentDwellLabel() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel;
        }
        return null;
    }

    public void removeChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.deleteChartLabel(jCChartLabel);
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    protected void deleteChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        JCChart jCChart = this.getParentChart();
        if (!jCChartLabel.isDwellLabel() && jCChart != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                jCChart.remove(jCChartLabel.line);
            }
            jCChart.remove(jCChartLabel.component);
        } else {
            this.removeFromDwellLabels(jCChartLabel);
        }
        this.labels.removeElement(jCChartLabel);
    }

    public void removeFromDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels == null || !this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        this.dwellLabels.removeElement(jCChartLabel);
        if (this.dwellLabels.size() == 0) {
            JCChart jCChart = this.getParentChart();
            if (jCChart != null) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.unregisterComponent(jCChart);
            }
            this.dwellLabels = null;
        }
    }

    public int getNumChartLabels() {
        int n = 0;
        try {
            if (this.labels != null) {
                n = this.labels.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void removeAllChartLabels() {
        Object object;
        Object object2;
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            object2 = this.labels.elements();
            while (object2.hasMoreElements()) {
                object = (JCChartLabel)object2.nextElement();
                if (((JCChartLabel)object).isConnected() && ((JCChartLabel)object).line != null) {
                    jCChart.remove(((JCChartLabel)object).line);
                }
                jCChart.remove(((JCChartLabel)object).component);
            }
        }
        this.labels.removeAllElements();
        if (this.dwellLabels != null) {
            this.dwellLabels.removeAllElements();
            this.dwellLabels = null;
        }
        if (jCChart != null) {
            object2 = jCChart.getDataView();
            object = object2.iterator();
            while (object.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)object.next();
                this.autoLabelListHashtable.remove(chartDataView);
                chartDataView.setAutoLabel(false);
            }
            jCChart.setChanged(true, 1);
        }
    }

    public JCChartLabel getChartLabels(int n) {
        if (n < 0 || n >= this.labels.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_LABEL_INDEX);
        }
        return (JCChartLabel)this.labels.elementAt(n);
    }

    public void setChartLabels(int n, JCChartLabel jCChartLabel) {
        if (n < 0 || n > this.labels.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_LABEL_INDEX);
        }
        JCChart jCChart = this.getParentChart();
        if (n < this.labels.size()) {
            if (jCChartLabel == null) {
                this.removeChartLabel((JCChartLabel)this.labels.elementAt(n));
            } else {
                if (!this.labels.contains(jCChartLabel)) {
                    this.removeFromDwellLabels((JCChartLabel)this.labels.elementAt(n));
                    if (jCChart != null) {
                        jCChart.remove(((JCChartLabel)this.labels.elementAt((int)n)).component);
                    }
                    this.labels.setElementAt(jCChartLabel, n);
                    if (!jCChartLabel.isDwellLabel() && jCChart != null) {
                        if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                            jCChart.add((Component)jCChartLabel.line, 0);
                        }
                        jCChart.add((Component)jCChartLabel.component, 0);
                    } else {
                        this.addToDwellLabels(jCChartLabel);
                    }
                }
                jCChartLabel.setParentManager(this);
            }
        } else {
            this.addChartLabel(jCChartLabel);
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    public List getChartLabels() {
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        return new Vector(this.labels);
    }

    public void setChartLabels(List list) {
        JCChart jCChart = this.getParentChart();
        if (this.labels != null && jCChart != null) {
            Enumeration enumeration = this.labels.elements();
            while (enumeration.hasMoreElements()) {
                jCChart.remove(((JCChartLabel)enumeration.nextElement()).component);
            }
        }
        this.labels = new Vector();
        boolean bl = false;
        if (jCChart != null) {
            bl = jCChart.isBatched();
            jCChart.setBatched(false);
        }
        if (list != null && list.size() > 0) {
            Object object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (JCChartLabel)iterator.next();
                this.labels.addElement(object);
                if (!((JCChartLabel)object).isDwellLabel() && jCChart != null) {
                    if (((JCChartLabel)object).isConnected() && ((JCChartLabel)object).line != null) {
                        jCChart.add((Component)((JCChartLabel)object).line, 0);
                    }
                    jCChart.add((Component)((JCChartLabel)object).component, 0);
                    continue;
                }
                this.addToDwellLabels((JCChartLabel)object);
            }
            object = list.iterator();
            while (object.hasNext()) {
                ((JCChartLabel)object.next()).setParentManager(this);
            }
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
            jCChart.setBatched(bl);
        }
    }

    public void markAllChartLabelsForRecalc() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null) continue;
            jCChartLabel.setChanged(true, 2, false);
        }
    }

    public void recalcChangedChartLabels() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || !jCChartLabel.getChanged(2)) continue;
            jCChartLabel.recalc();
        }
    }

    public JCChartLabel[][] getAutoLabelList(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return null;
        }
        return (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
    }

    public void generateAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        List list = chartDataView.getSeries();
        int n = list.size();
        JCChartLabel[][] jCChartLabelArrayArray = new JCChartLabel[n][];
        int n2 = 0;
        while (n2 < n) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n2);
            int n3 = chartDataViewSeries.maxIndex() + 1;
            if (chartDataViewSeries.getX() == null || chartDataViewSeries.getY() == null) {
                n3 = 0;
            }
            jCChartLabelArrayArray[n2] = new JCChartLabel[n3];
            int n4 = 0;
            while (n4 < n3) {
                if (jCChartLabelArray != null && n2 < jCChartLabelArray.length && jCChartLabelArray[n2] != null && n4 < jCChartLabelArray[n2].length) {
                    this.deleteChartLabel(jCChartLabelArray[n2][n4]);
                }
                jCChartLabelArrayArray[n2][n4] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n2, n4), chartDataViewSeries, n4);
                this.appendChartLabel(jCChartLabelArrayArray[n2][n4]);
                ++n4;
            }
            ++n2;
        }
        this.autoLabelListHashtable.put(chartDataView, jCChartLabelArrayArray);
    }

    protected JCChartLabel createAutoLabel(String string, ChartDataViewSeries chartDataViewSeries, int n) {
        JCChartLabel jCChartLabel = new JCChartLabel(string);
        jCChartLabel.setDataIndex(new JCDataIndex(n, chartDataViewSeries));
        jCChartLabel.setAttachMethod(3);
        jCChartLabel.setAnchor(10);
        jCChartLabel.component.setBorder(BorderFactory.createRaisedBevelBorder());
        jCChartLabel.setDataView(chartDataViewSeries.getParent());
        jCChartLabel.setOffset(new Point(0, -1));
        jCChartLabel.setDwellLabel(true);
        return jCChartLabel;
    }

    public String createAutoLabelText(ChartDataView chartDataView, int n, int n2) {
        Object object;
        ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(n);
        StringBuffer stringBuffer = new StringBuffer();
        double d = chartDataViewSeries.getX(n2);
        double d2 = chartDataViewSeries.getY(n2);
        String string = "" + d2;
        if (chartDataView.getYAxis().getLabelGenerator() != null) {
            object = chartDataView.getYAxis().getLabelGenerator().makeLabel(d2, chartDataView.getYAxis().getPrecision());
            string = object instanceof String ? (String)object : object.toString();
        }
        switch (chartDataView.getChartType()) {
            case 0: 
            case 1: {
                object = "" + d;
                if (chartDataView.getXAxis().getLabelGenerator() != null) {
                    object = (String)chartDataView.getXAxis().getLabelGenerator().makeLabel(d, chartDataView.getXAxis().getPrecision());
                }
                stringBuffer.append(" (");
                stringBuffer.append((String)object);
                stringBuffer.append(",");
                stringBuffer.append(string);
                stringBuffer.append(") ");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                break;
            }
            default: {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public void setAutoLabelText(ChartDataView chartDataView, int n, int n2) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray[n][n2] != null) {
            jCChartLabelArray[n][n2].setText(this.createAutoLabelText(chartDataView, n, n2));
        }
    }

    public void addAutoLabels(ChartDataView chartDataView, int n, int n2) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List list = chartDataView.getSeries();
        int n3 = list.size();
        if (n != -1 && n2 == -1) {
            int n4 = n;
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n3][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n4);
            if (jCChartLabelArray2.length > n4) {
                System.arraycopy(jCChartLabelArray2, n4 + 1, jCChartLabelArray, n4 + 1, n3 - n4 - 1);
            }
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n4);
            int n5 = chartDataViewSeries.maxIndex() + 1;
            jCChartLabelArray[n4] = new JCChartLabel[n5];
            int n6 = 0;
            while (n6 < n5) {
                jCChartLabelArray[n4][n6] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n4, n6), chartDataViewSeries, n6);
                this.appendChartLabel(jCChartLabelArray[n4][n6]);
                ++n6;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n2 != -1) {
            int n7 = n2;
            int n8 = 0;
            if (n != -1) {
                n3 = n + 1;
                n8 = n;
            }
            int n9 = n8;
            while (n9 < n3) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n9);
                int n10 = jCChartLabelArray[n9].length + 1;
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[n9];
                jCChartLabelArray[n9] = new JCChartLabel[n10];
                if (n7 != 0) {
                    System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[n9], 0, n7);
                }
                if (n7 != n10 - 1) {
                    System.arraycopy(jCChartLabelArray3, n7, jCChartLabelArray[n9], n7 + 1, n10 - n7 - 1);
                }
                jCChartLabelArray[n9][n7] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n9, n7), chartDataViewSeries, n7);
                this.appendChartLabel(jCChartLabelArray[n9][n7]);
                ++n9;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    public void removeAutoLabels(ChartDataView chartDataView, int n, int n2) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List list = chartDataView.getSeries();
        int n3 = list.size();
        if (n != -1 && n2 == -1) {
            int n4 = n;
            int n5 = jCChartLabelArray[n4].length;
            int n6 = 0;
            while (n6 < n5) {
                this.deleteChartLabel(jCChartLabelArray[n4][n6]);
                ++n6;
            }
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n3][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n4);
            if (jCChartLabelArray2.length > n4) {
                System.arraycopy(jCChartLabelArray2, n4 + 1, jCChartLabelArray, n4, n3 - n4);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n2 != -1) {
            int n7 = n2;
            int n8 = 0;
            if (n != -1) {
                n3 = n + 1;
                n8 = n;
            }
            int n9 = n8;
            while (n9 < n3) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n9);
                int n10 = jCChartLabelArray[n9].length;
                this.deleteChartLabel(jCChartLabelArray[n9][n7]);
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[n9];
                jCChartLabelArray[n9] = new JCChartLabel[n10 - 1];
                System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[n9], 0, n7);
                System.arraycopy(jCChartLabelArray3, n7 + 1, jCChartLabelArray[n9], n7, n10 - n7 - 1);
                ++n9;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    public void removeAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
        this.autoLabelListHashtable.remove(chartDataView);
        int n = 0;
        while (n < jCChartLabelArray2.length) {
            if (jCChartLabelArray2[n] != null) {
                int n2 = 0;
                while (n2 < jCChartLabelArray2[n].length) {
                    this.deleteChartLabel(jCChartLabelArray2[n][n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void clearAutoLabels(ChartDataView chartDataView) {
        this.autoLabelListHashtable.remove(chartDataView);
    }

    public void updateParent(int n) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if ((n & 2) > 0 || (n & 8) > 0) {
                jCChart.invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }
}

