/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.util.HashMap;

public class ConstExprEvaluator {
    protected static Operator[] operators = null;
    private Node node = null;
    private String expression = null;
    private HashMap variables = new HashMap();

    public ConstExprEvaluator() {
        this.init();
    }

    public ConstExprEvaluator(String s) {
        this.init();
        this.setExpression(s);
    }

    private void init() {
        if (operators == null) {
            this.initializeOperators();
        }
    }

    public void setExpression(String s) {
        this.expression = s;
    }

    public void reset() {
        this.node = null;
        this.expression = null;
        this.variables = new HashMap();
    }

    public Double getValue() {
        if (this.expression == null) {
            return null;
        }
        try {
            this.node = new Node(this.expression);
            return ConstExprEvaluator.evaluate(this.node);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Double evaluate(Node n) {
        if (n.hasOperator() && n.hasChild()) {
            if (n.getOperator().getType() == 1) {
                n.setValue(ConstExprEvaluator.evaluateExpression(n.getOperator(), ConstExprEvaluator.evaluate(n.getLeft()), null));
            } else if (n.getOperator().getType() == 2) {
                n.setValue(ConstExprEvaluator.evaluateExpression(n.getOperator(), ConstExprEvaluator.evaluate(n.getLeft()), ConstExprEvaluator.evaluate(n.getRight())));
            }
        }
        return n.getValue();
    }

    private static Double evaluateExpression(Operator o, Double f1, Double f2) {
        String op = o.getOperator();
        Double res = null;
        if ("+".equals(op)) {
            res = new Double(f1 + f2);
        } else if ("-".equals(op)) {
            res = new Double(f1 - f2);
        } else if ("*".equals(op)) {
            res = new Double(f1 * f2);
        } else if ("/".equals(op)) {
            res = new Double(f1 / f2);
        } else if ("%".equals(op)) {
            res = new Double(f1 % f2);
        } else if ("|".equals(op)) {
            res = new Double(Double.longBitsToDouble(Double.doubleToLongBits(f1) | Double.doubleToLongBits(f2)));
        } else if ("&".equals(op)) {
            res = new Double(Double.longBitsToDouble(Double.doubleToLongBits(f1) & Double.doubleToLongBits(f2)));
        } else if ("^".equals(op)) {
            res = new Double(Double.longBitsToDouble(Double.doubleToLongBits(f1) ^ Double.doubleToLongBits(f2)));
        } else if ("<<".equals(op)) {
            res = new Double(Double.longBitsToDouble(Double.doubleToLongBits(f1) << (int)Double.doubleToLongBits(f2)));
        } else if (">>".equals(op)) {
            res = new Double(Double.longBitsToDouble(Double.doubleToLongBits(f1) >> (int)Double.doubleToLongBits(f2)));
        }
        return res;
    }

    private void initializeOperators() {
        operators = new Operator[10];
        ConstExprEvaluator.operators[0] = new Operator("|", 2, 0);
        ConstExprEvaluator.operators[1] = new Operator("^", 2, 2);
        ConstExprEvaluator.operators[2] = new Operator("&", 2, 4);
        ConstExprEvaluator.operators[3] = new Operator(">>", 2, 6);
        ConstExprEvaluator.operators[4] = new Operator("<<", 2, 6);
        ConstExprEvaluator.operators[5] = new Operator("+", 2, 8);
        ConstExprEvaluator.operators[6] = new Operator("-", 2, 8);
        ConstExprEvaluator.operators[7] = new Operator("*", 2, 10);
        ConstExprEvaluator.operators[8] = new Operator("/", 2, 10);
        ConstExprEvaluator.operators[9] = new Operator("%", 2, 10);
    }

    public Double getVariable(String s) {
        return (Double)this.variables.get(s);
    }

    private Double getDouble(String s) {
        if (s == null) {
            return null;
        }
        Double res = null;
        try {
            res = new Double(Double.parseDouble(s));
        }
        catch (Exception e) {
            return this.getVariable(s);
        }
        return res;
    }

    protected Operator[] getOperators() {
        return operators;
    }

    protected class Node {
        public String nString = null;
        public Operator nOperator = null;
        public Node nLeft = null;
        public Node nRight = null;
        public Node nParent = null;
        public int nLevel = 0;
        public Double nValue = null;

        public Node(String s) throws Exception {
            this.init(null, s, 0);
        }

        public Node(Node parent, String s, int level) throws Exception {
            this.init(parent, s, level);
        }

        private void init(Node parent, String s, int level) throws Exception {
            s = this.removeIllegalCharacters(s);
            s = this.removeBrackets(s);
            if (this.checkBrackets(s = this.addZero(s)) != 0) {
                throw new Exception("Wrong number of brackets in [" + s + "]");
            }
            this.nParent = parent;
            this.nString = s;
            this.nValue = ConstExprEvaluator.this.getDouble(s);
            this.nLevel = level;
            int sLength = s.length();
            int inBrackets = 0;
            int startOperator = 0;
            for (int i = 0; i < sLength; ++i) {
                Operator o;
                if (s.charAt(i) == '(') {
                    ++inBrackets;
                    continue;
                }
                if (s.charAt(i) == ')') {
                    --inBrackets;
                    continue;
                }
                if (inBrackets != 0 || (o = this.getOperator(this.nString, i)) == null || this.nOperator != null && this.nOperator.getPriority() < o.getPriority()) continue;
                this.nOperator = o;
                startOperator = i;
            }
            if (this.nOperator != null) {
                if (startOperator == 0 && this.nOperator.getType() == 1) {
                    if (this.checkBrackets(s.substring(this.nOperator.getOperator().length())) == 0) {
                        this.nLeft = new Node(this, s.substring(this.nOperator.getOperator().length()), this.nLevel + 1);
                        this.nRight = null;
                        return;
                    }
                    throw new Exception("Error during parsing... missing brackets in [" + s + "]");
                }
                if (startOperator > 0 && this.nOperator.getType() == 2) {
                    this.nOperator = this.nOperator;
                    this.nLeft = new Node(this, s.substring(0, startOperator), this.nLevel + 1);
                    this.nRight = new Node(this, s.substring(startOperator + this.nOperator.getOperator().length()), this.nLevel + 1);
                }
            }
        }

        private Operator getOperator(String s, int start) {
            Operator[] operators = ConstExprEvaluator.this.getOperators();
            String temp = s.substring(start);
            temp = this.getNextWord(temp);
            for (int i = 0; i < operators.length; ++i) {
                if (!temp.startsWith(operators[i].getOperator())) continue;
                return operators[i];
            }
            return null;
        }

        private String getNextWord(String s) {
            int sLength = s.length();
            for (int i = 1; i < sLength; ++i) {
                char c = s.charAt(i);
                if (c <= 'z' && c >= 'a' || c <= '9' && c >= '0') continue;
                return s.substring(0, i);
            }
            return s;
        }

        protected int checkBrackets(String s) {
            int sLength = s.length();
            int inBracket = 0;
            for (int i = 0; i < sLength; ++i) {
                if (s.charAt(i) == '(' && inBracket >= 0) {
                    ++inBracket;
                    continue;
                }
                if (s.charAt(i) != ')') continue;
                --inBracket;
            }
            return inBracket;
        }

        protected String addZero(String s) {
            if (s.startsWith("+") || s.startsWith("-")) {
                int sLength = s.length();
                for (int i = 0; i < sLength; ++i) {
                    if (this.getOperator(s, i) == null) continue;
                    return "0" + s;
                }
            }
            return s;
        }

        protected boolean hasChild() {
            return this.nLeft != null || this.nRight != null;
        }

        protected boolean hasOperator() {
            return this.nOperator != null;
        }

        protected boolean hasLeft() {
            return this.nLeft != null;
        }

        protected Node getLeft() {
            return this.nLeft;
        }

        protected boolean hasRight() {
            return this.nRight != null;
        }

        protected Node getRight() {
            return this.nRight;
        }

        protected Operator getOperator() {
            return this.nOperator;
        }

        protected int getLevel() {
            return this.nLevel;
        }

        protected Double getValue() {
            return this.nValue;
        }

        protected void setValue(Double f) {
            this.nValue = f;
        }

        protected String getString() {
            return this.nString;
        }

        public String removeBrackets(String s) {
            String res = s;
            if (s.length() > 2 && res.startsWith("(") && res.endsWith(")") && this.checkBrackets(s.substring(1, s.length() - 1)) == 0) {
                res = res.substring(1, res.length() - 1);
            }
            if (res != s) {
                return this.removeBrackets(res);
            }
            return res;
        }

        public String removeIllegalCharacters(String s) {
            char[] illegalCharacters = new char[]{' '};
            String res = s;
            for (int j = 0; j < illegalCharacters.length; ++j) {
                int i = res.lastIndexOf(illegalCharacters[j], res.length());
                while (i != -1) {
                    String temp = res;
                    res = temp.substring(0, i);
                    res = res + temp.substring(i + 1);
                    i = res.lastIndexOf(illegalCharacters[j], s.length());
                }
            }
            return res;
        }
    }

    protected class Operator {
        private String op;
        private int type;
        private int priority;

        public Operator(String o, int t, int p) {
            this.op = o;
            this.type = t;
            this.priority = p;
        }

        public String getOperator() {
            return this.op;
        }

        public void setOperator(String o) {
            this.op = o;
        }

        public int getType() {
            return this.type;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

