/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.persistence.RepositoryData;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class FilePersistence {
    private File outputFile;
    protected Logger logger = Debug.getNamedLogger("jacorb.imr");

    public RepositoryData read() {
        ObjectInputStream ois;
        RepositoryData repData;
        block9: {
            String dataFile = Environment.getProperty("jacorb.imr.imr_data_file");
            repData = null;
            ois = null;
            if (dataFile != null) {
                File f = new File(dataFile);
                try {
                    if (f.exists()) {
                        ois = new ObjectInputStream(new FileInputStream(f));
                        repData = (RepositoryData)ois.readObject();
                        ois.close();
                    }
                    break block9;
                }
                catch (IOException ioe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: Unable to read ImR data file " + dataFile + "! ");
                    }
                    break block9;
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: ImR data file " + dataFile + " does not contain valid object" + "! ");
                    }
                    break block9;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("WARNING: ImR data file name not configured! ");
            }
        }
        if (repData == null) {
            repData = new RepositoryData();
        }
        ois = null;
        return repData;
    }

    public void write(RepositoryData repData) {
        block5: {
            if (this.outputFile == null) {
                String dataFile = Environment.getProperty("jacorb.imr.imr_data_file");
                if (dataFile == null && this.logger.isDebugEnabled()) {
                    this.logger.warn("WARNING: ImR data file name not configured creating \"data.dat\" in current directory, ");
                    dataFile = "data.dat";
                }
                this.outputFile = new File(dataFile);
                if (!this.outputFile.exists()) {
                    try {
                        this.outputFile.createNewFile();
                    }
                    catch (IOException ioe) {
                        if (!this.logger.isDebugEnabled()) break block5;
                        this.logger.error("Unable to create ImR data file " + dataFile, ioe);
                        System.exit(-1);
                    }
                }
            }
        }
        this.write(this.outputFile, repData);
    }

    public void backup(RepositoryData repData) {
        String dataFile = Environment.getProperty("jacorb.imr.imr_backup_file");
        boolean write = true;
        if (dataFile != null) {
            File f;
            block5: {
                f = new File(dataFile);
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    }
                    catch (IOException ioe) {
                        if (!this.logger.isDebugEnabled()) break block5;
                        this.logger.warn("Unable to create ImR backup data file " + dataFile, ioe);
                        write = false;
                    }
                }
            }
            if (write) {
                this.write(f, repData);
            }
        }
    }

    private void write(File file, RepositoryData repData) {
        ObjectOutputStream oos;
        block2: {
            oos = null;
            repData.lock.getLock(1);
            try {
                oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(repData);
                oos.flush();
                oos.close();
            }
            catch (IOException ioe) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Unable to write ImR data to file " + file.getName(), ioe);
            }
        }
        repData.lock.releaseLock(1);
        oos = null;
    }
}

