/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.ir.Contained;
import org.jacorb.ir.ContainerType;
import org.jacorb.ir.IRFilenameFilter;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.ModuleDef;
import org.jacorb.ir.RepositoryImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ContainerHelper;
import org.omg.CORBA.ContainerOperations;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ModuleDefPOATie;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;

public class Container
extends IRObject
implements ContainerOperations {
    protected IRObject delegator;
    protected Hashtable contained = new Hashtable();
    protected Hashtable containedLocals = new Hashtable();
    protected File my_dir = null;
    protected String path = null;
    protected String full_name = null;
    protected org.omg.CORBA.Container this_container;
    protected org.omg.CORBA.Container defined_in;
    protected Repository containing_repository;
    protected boolean defined = false;

    public Container(IRObject delegator, String path, String full_name) {
        this.delegator = delegator;
        this.path = path;
        this.full_name = full_name;
        this.my_dir = new File(path + fileSeparator + (full_name != null ? full_name : "").replace('.', fileSeparator));
        if (!this.my_dir.isDirectory()) {
            throw new INTF_REPOS("no directory : " + path + fileSeparator + full_name);
        }
        this.name = delegator.getName();
        Debug.output(2, "New Container full_name " + full_name + " name : " + this.name + " path: " + path);
    }

    void loadContents() {
        this.this_container = ContainerHelper.narrow(this.delegator.getReference());
        if (this.this_container == null) {
            throw new INTF_REPOS("no container !");
        }
        if (this.delegator instanceof Contained) {
            this.containing_repository = ((Contained)this.delegator).containing_repository();
            this.defined_in = ((Contained)this.delegator).defined_in();
        } else {
            this.containing_repository = RepositoryHelper.narrow(this.delegator.getReference());
            this.defined_in = this.containing_repository;
        }
        if (this.containing_repository == null) {
            throw new INTF_REPOS("no containing repository");
        }
        String[] classes = this.my_dir.list(new IRFilenameFilter(".class"));
        String[] dirs = this.my_dir.list(new IRFilenameFilter(null));
        if (classes != null) {
            String prefix = this.full_name != null ? this.full_name + '.' : "";
            for (int j = 0; j < classes.length; ++j) {
                try {
                    Debug.output(4, "Container " + this.name + " tries " + prefix + classes[j].substring(0, classes[j].indexOf(".class")));
                    Class<?> cl = RepositoryImpl.loader.loadClass(prefix + classes[j].substring(0, classes[j].indexOf(".class")));
                    Contained containedObject = Contained.createContained(cl, this.path, this.this_container, this.containing_repository);
                    if (containedObject == null) {
                        Debug.output(4, "Container: nothing created for " + cl.getClass().getName());
                        continue;
                    }
                    org.omg.CORBA.Contained containedRef = Contained.createContainedReference(containedObject);
                    containedRef.move(this.this_container, containedRef.name(), containedRef.version());
                    Debug.output(2, "Container " + prefix + " loads " + containedRef.name());
                    this.contained.put(containedRef.name(), containedRef);
                    this.containedLocals.put(containedRef.name(), containedObject);
                    if (!(containedObject instanceof ContainerType)) continue;
                    ((ContainerType)((Object)containedObject)).loadContents();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    Debug.output(3, e);
                    continue;
                }
                catch (Throwable e) {
                    Debug.output(3, e);
                }
            }
        }
        if (dirs != null) {
            for (int k = 0; k < dirs.length; ++k) {
                if (dirs[k].endsWith("Package")) continue;
                File f = new File(this.my_dir.getAbsolutePath() + fileSeparator + dirs[k]);
                try {
                    String[] classList = f.list();
                    if (classList == null || classList.length <= 0) continue;
                    Class<?> moduleClass = RepositoryImpl.loader.loadClass((this.full_name != null ? this.full_name + "." + dirs[k] : dirs[k]) + "." + "_" + dirs[k] + "Module");
                    ModuleDef m = new ModuleDef(this.path, (this.full_name != null ? this.full_name + '.' : "") + dirs[k], this.this_container, this.containing_repository);
                    org.omg.CORBA.ModuleDef moduleRef = ModuleDefHelper.narrow(RepositoryImpl.poa.servant_to_reference(new ModuleDefPOATie(m)));
                    m.setReference(moduleRef);
                    m.loadContents();
                    Debug.output(2, "Container " + this.full_name + " puts module " + dirs[k]);
                    m.move(this.this_container, m.name(), m.version());
                    this.contained.put(m.name(), moduleRef);
                    this.containedLocals.put(m.name(), m);
                    continue;
                }
                catch (ClassNotFoundException c) {
                    Debug.output(2, "No module meta data: " + c.getMessage());
                    Debug.output(4, c);
                    continue;
                }
                catch (Exception e) {
                    Debug.output(3, e);
                }
            }
        }
    }

    void define() {
        Debug.output(2, "Container " + this.full_name + " defining...");
        Enumeration e = this.containedLocals.elements();
        while (e.hasMoreElements()) {
            ((IRObject)e.nextElement()).define();
        }
        this.defined = true;
        Debug.output(2, "Container " + this.full_name + " defined");
    }

    public org.omg.CORBA.Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited) {
        if (!this.defined) {
            throw new INTF_REPOS("contents undefined");
        }
        Hashtable filtered = new Hashtable();
        if (limit_type.value() == 1) {
            filtered = this.contained;
        } else {
            Enumeration f = this.contained.keys();
            while (f.hasMoreElements()) {
                Object k = f.nextElement();
                org.omg.CORBA.Contained c = (org.omg.CORBA.Contained)this.contained.get(k);
                if (c.def_kind().value() != limit_type.value()) continue;
                filtered.put(k, c);
            }
        }
        Enumeration e = filtered.elements();
        org.omg.CORBA.Contained[] result = new org.omg.CORBA.Contained[filtered.size()];
        for (int i = 0; i < filtered.size(); ++i) {
            result[i] = (org.omg.CORBA.Contained)e.nextElement();
        }
        return result;
    }

    public org.omg.CORBA.Contained lookup(String scopedname) {
        String rest_of_name;
        String top_level_name;
        String name = scopedname.startsWith("::") ? scopedname.substring(2) : scopedname;
        if (name.indexOf("::") > 0) {
            top_level_name = name.substring(0, name.indexOf("::"));
            rest_of_name = name.substring(name.indexOf("::") + 2);
        } else {
            top_level_name = name;
            rest_of_name = null;
        }
        org.omg.CORBA.Contained top = (org.omg.CORBA.Contained)this.contained.get(top_level_name);
        if (top == null) {
            Debug.output(2, "Container " + this.name + " top " + top_level_name + " not found ");
            return null;
        }
        if (rest_of_name == null) {
            return top;
        }
        org.omg.CORBA.Container topContainer = ContainerHelper.narrow(top);
        if (topContainer != null) {
            return topContainer.lookup(rest_of_name);
        }
        Debug.output(2, "Container " + this.name + " " + scopedname + " not found, top " + top.getClass().getName());
        return null;
    }

    public org.omg.CORBA.Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited) {
        int i;
        if (levels_to_search == 0) {
            return null;
        }
        org.omg.CORBA.Contained[] c = this.contents(limit_type, exclude_inherited);
        Hashtable<org.omg.CORBA.Contained, String> found = new Hashtable<org.omg.CORBA.Contained, String>();
        for (i = 0; i < c.length; ++i) {
            if (!c[i].name().equals(search_name)) continue;
            found.put(c[i], "");
        }
        if (levels_to_search > 1 || levels_to_search == -1) {
            for (i = 0; i < c.length; ++i) {
                org.omg.CORBA.Contained[] tmp_seq;
                if (!(c[i] instanceof org.omg.CORBA.Container) || (tmp_seq = ((org.omg.CORBA.Container)((Object)c[i])).lookup_name(search_name, levels_to_search - 1, limit_type, exclude_inherited)) == null) continue;
                for (int j = 0; j < tmp_seq.length; ++j) {
                    found.put(tmp_seq[j], "");
                }
            }
        }
        org.omg.CORBA.Contained[] result = new org.omg.CORBA.Contained[found.size()];
        int idx = 0;
        Enumeration e = found.keys();
        while (e.hasMoreElements()) {
            result[idx++] = (org.omg.CORBA.Contained)e.nextElement();
        }
        return result;
    }

    public Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs) {
        return null;
    }

    public org.omg.CORBA.ModuleDef create_module(String id, String name, String version) {
        return null;
    }

    public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value) {
        return null;
    }

    public StructDef create_struct(String id, String name, String version, StructMember[] members) {
        return null;
    }

    public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members) {
        return null;
    }

    public EnumDef create_enum(String id, String name, String version, String[] members) {
        return null;
    }

    public AliasDef create_alias(String id, String name, String version, IDLType original_type) {
        return null;
    }

    public ExceptionDef create_exception(String id, String name, String version, StructMember[] member) {
        return null;
    }

    public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract) {
        return null;
    }

    public ValueBoxDef create_value_box(String id, String name, String version, IDLType type) {
        return null;
    }

    public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers) {
        return null;
    }

    public NativeDef create_native(String id, String name, String version) {
        return null;
    }

    public void destroy() {
    }
}

