/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Enumeration;
import org.jacorb.orb.ApplicationExceptionHelper;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;

public class ClientInterceptorHandler {
    private final ClientRequestInfoImpl info;

    public ClientInterceptorHandler(ClientInterceptorHandler original, ORB orb, RequestOutputStream ros, Object self, Delegate delegate, ParsedIOR piorOriginal, ClientConnection connection) {
        this.info = orb.hasClientRequestInterceptors() ? new ClientRequestInfoImpl(orb, original != null ? original.info : null, ros, self, delegate, piorOriginal, connection) : null;
    }

    public void handle_send_request() throws RemarshalException {
        if (this.info != null) {
            this.invokeInterceptors(this.info, (short)0);
            Enumeration ctx = this.info.getRequestServiceContexts();
            while (ctx.hasMoreElements()) {
                this.info.request_os.addServiceContext((ServiceContext)ctx.nextElement());
            }
        }
    }

    public void handle_location_forward(ReplyInputStream reply, Object forward_reference) throws RemarshalException {
        if (this.info != null) {
            this.info.setReplyStatus((short)3);
            this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
            this.info.setForwardReference(forward_reference);
            this.info.reply_is = reply;
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    public void handle_receive_reply(ReplyInputStream reply) throws RemarshalException {
        if (this.info != null) {
            ReplyHeader_1_2 header = reply.rep_hdr;
            if (header.reply_status.value() == 0) {
                this.info.setReplyStatus((short)0);
                this.info.setReplyServiceContexts(header.service_context);
                if (this.info.request_os.getRequest() == null) {
                    InterceptorManager manager = this.info.orb.getInterceptorManager();
                    this.info.setCurrent(manager.getCurrent());
                    this.info.reply_is = reply;
                    this.invokeInterceptors(this.info, (short)2);
                } else {
                    this.info.request_os.getRequest().setInfo(this.info);
                }
            }
        }
    }

    public void handle_receive_other(short reply_status) throws RemarshalException {
        if (this.info != null) {
            this.info.setReplyStatus(reply_status);
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    public void handle_receive_exception(SystemException ex) throws RemarshalException {
        this.handle_receive_exception(ex, null);
    }

    public void handle_receive_exception(SystemException ex, ReplyInputStream reply) throws RemarshalException {
        if (this.info != null) {
            SystemExceptionHelper.insert(this.info.received_exception, ex);
            try {
                this.info.received_exception_id = SystemExceptionHelper.type(ex).id();
            }
            catch (BadKind bk) {
                Debug.output(4, bk);
            }
            this.info.setReplyStatus((short)1);
            if (reply != null) {
                this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
                this.info.reply_is = reply;
            }
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    public void handle_receive_exception(ApplicationException ex, ReplyInputStream reply) throws RemarshalException {
        if (this.info != null) {
            this.info.received_exception_id = ex.getId();
            try {
                ApplicationExceptionHelper.insert(this.info.received_exception, ex);
            }
            catch (Exception e) {
                Debug.output(4, e);
                SystemExceptionHelper.insert(this.info.received_exception, new UNKNOWN(e.getMessage()));
            }
            this.info.setReplyStatus((short)2);
            try {
                reply.reset();
            }
            catch (Exception e) {
                Debug.output(2, e);
            }
            this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
            this.info.reply_is = reply;
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    private void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException {
        ClientInterceptorIterator intercept_iter = info.orb.getInterceptorManager().getClientIterator();
        try {
            intercept_iter.iterate(info, op);
        }
        catch (ForwardRequest fwd) {
            info.setForwardReference(fwd.forward);
            info.delegate.rebind(fwd.forward);
            throw new RemarshalException();
        }
        catch (UserException ue) {
            Debug.output(2, ue);
        }
    }
}

