/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.dns.DNSLookup;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress {
    private String hostname = null;
    private String ip = null;
    private final int port;

    public IIOPAddress(String host, int port) {
        if (IIOPAddress.isIP(host)) {
            this.ip = host;
        } else {
            this.hostname = host;
        }
        this.port = port < 0 ? port + 65536 : port;
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        return new IIOPAddress(host, port);
    }

    private static boolean isIP(String host) {
        int index = 0;
        int numberStart = 0;
        int length = host.length();
        int ch = 32;
        for (int i = 0; i < 4; ++i) {
            while (index < length && (ch = (int)host.charAt(index)) != 46) {
                if (ch < 48 || ch > 57) {
                    return false;
                }
                ++index;
            }
            if (index >= length && i == 3 && index - numberStart <= 3 && index - numberStart > 0) {
                return true;
            }
            if (ch != 46 || index - numberStart > 3 || index - numberStart <= 0) {
                return false;
            }
            numberStart = ++index;
        }
        return false;
    }

    public String getIP() {
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getByName(this.hostname).getHostAddress();
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException("could not resolve hostname: " + this.hostname);
            }
        }
        return this.ip;
    }

    public String getHostname() {
        if (this.hostname == null) {
            this.hostname = DNSLookup.inverseLookup(this.ip);
            if (this.hostname == null) {
                this.hostname = this.ip;
            }
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            IIOPAddress x = (IIOPAddress)other;
            if (this.port == x.port) {
                return this.getIP().equals(x.getIP());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getIP().hashCode() + this.port;
    }

    public String toString() {
        if (this.hostname != null) {
            return this.hostname + ":" + this.port;
        }
        return this.ip + ":" + this.port;
    }

    public byte[] toCDR() {
        CDROutputStream out = new CDROutputStream();
        out.beginEncapsulatedArray();
        out.write_string(this.ip);
        out.write_ushort((short)this.port);
        return out.getBufferCopy();
    }
}

